# Equipment State Indicator Type Code (2.9 - 1.0.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Equipment State Indicator Type Code (2.9 - 1.0.0)**

## CodeSystem: Equipment State Indicator Type Code (2.9 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/equipmentStateIndicator | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:EquipmentStateIndicator |
| *Other Identifiers:*OID:2.16.840.1.113883.18.444 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code sytem of cocepts that specify the type of measurement of the state of an automated laboratory instrument. Used in HL7 Version 2.x messaging in the INV segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Empty_2.16.840.1.113883.21.465](ValueSet-empty_2.16.840.1.113883.21.465.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "equipmentStateIndicator",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0942"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/equipmentStateIndicator",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.444"
    }
  ],
  "version" : "1.0.0",
  "name" : "EquipmentStateIndicator",
  "title" : "Equipment State Indicator Type Code (2.9 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code sytem of cocepts that specify the type of measurement of the state of an automated laboratory instrument. Used in HL7 Version 2.x messaging in the INV segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "EB",
      "display" : "Emergency input buffer current capacity",
      "definition" : "Current capacity of an emergency input specimen buffer",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "IB",
      "display" : "Input buffer current capacity",
      "definition" : "Current capacity of a regular input specimen buffer",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "IC",
      "display" : "Instrument current processing capacity",
      "definition" : "Current processing capacity of the instrument ",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "OB",
      "display" : "Output buffer current capacity",
      "definition" : "Current capacity of an output specimen buffer",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "TA",
      "display" : "Current test availability",
      "definition" : "Current test availability",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    }
  ]
}

```
