# Equipment State (2.9 - 1.2.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Equipment State (2.9 - 1.2.0)**

## CodeSystem: Equipment State (2.9 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/equipmentState | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:EquipmentState |
| *Other Identifiers:*OID:2.16.840.1.113883.18.223 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts that identify the status the equipment was in at the time the transaction was initiated. Used in HL7 Version 2.x messaging in the EQU segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSequipmentState](ValueSet-hl7VSequipmentState.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "equipmentState",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0365"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/equipmentState",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.223"
    }
  ],
  "version" : "1.2.0",
  "name" : "EquipmentState",
  "title" : "Equipment State (2.9 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that identify the status the equipment was in at the time the transaction was initiated.  Used in HL7 Version 2.x messaging in the EQU segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CL",
      "display" : "Clearing",
      "definition" : "Clearing",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CO",
      "display" : "Configuring",
      "definition" : "Configuring",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DI",
      "display" : "Diagnose",
      "definition" : "Diagnose",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "ES",
      "display" : "E-stopped",
      "definition" : "Error, remaining orders can be finished, new orders cannot be accepted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FL",
      "display" : "Failure",
      "definition" : "Failure, remaining orders are aborted, new orders cannot be accepted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "ID",
      "display" : "Idle",
      "definition" : "Successfully started, new orders can be accepted, currently no orders are present",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IN",
      "display" : "Initializing",
      "definition" : "Software is ready, hardware not yet",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LT",
      "display" : "Limited test menu",
      "definition" : "For diagnostic instruments: some test types are unavailable",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "MA",
      "display" : "Maintenance",
      "definition" : "Maintenance",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "OP",
      "display" : "Normal Operation",
      "definition" : "Successfully started, new orders can be accepted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "Pausing",
      "definition" : "Pausing",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PD",
      "display" : "Paused",
      "definition" : "User action is required to continue",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PU",
      "display" : "Powered Up",
      "definition" : "Software and hardware are not yet ready",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RS",
      "display" : "Ready to start",
      "definition" : "Software and hardware are ready, but user action is required to start",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "SD",
      "display" : "Shutting down",
      "definition" : "Shutting down",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "SS",
      "display" : "Sampling stopped",
      "definition" : "Sampling stopped",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "TS",
      "display" : "Transport stopped",
      "definition" : "Transport stopped",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "UNK",
      "display" : "Unknown",
      "definition" : "Unknown",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    }
  ]
}

```
