# Container Condition (2.9 - 1.0.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Container Condition (2.9 - 1.0.1)**

## CodeSystem: Container Condition (2.9 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/containerCondition | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:ContainerCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.353 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab. If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons. Used in the Specimen (SPM), Shipment (SHP) and Shipment Package (PAC) segments in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScontainerCondition](ValueSet-hl7VScontainerCondition.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "containerCondition",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0544"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/containerCondition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.353"
    }
  ],
  "version" : "1.0.1",
  "name" : "ContainerCondition",
  "title" : "Container Condition (2.9 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined  code system of concepts used to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab.  If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons.  Used in the Specimen (SPM), Shipment (SHP) and Shipment Package (PAC) segments in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CC",
      "display" : "Container Cracked",
      "definition" : "Container Cracked",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Container is cracked."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CL",
      "display" : "Container Leaking",
      "definition" : "Container Leaking",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Container is leaking"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CT",
      "display" : "Container Torn",
      "definition" : "Container Torn",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Container is torn"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "SB",
      "display" : "Seal Broken",
      "definition" : "Seal Broken",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Container seal is broken."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XAMB",
      "display" : "Not Ambient temperature",
      "definition" : "Not Ambient temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep at ambient (room) temperature, approximately 22 +/- 2 degrees C. Accidental refrigeration or freezing is of little consequence"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XC37",
      "display" : "Not Body temperature",
      "definition" : "Not Body temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep at body temperature: 36 - 38 degrees C."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XCAMB",
      "display" : "Not Critical ambient temperature",
      "definition" : "Not Critical ambient temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep critical ambient."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XCATM",
      "display" : "Exposed to Air",
      "definition" : "Exposed to Air",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Exposed to atmosphere."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XCFRZ",
      "display" : "Not Critical frozen temperature",
      "definition" : "Not Critical frozen temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep critical frozen"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XCREF",
      "display" : "Not Critical refrigerated temperature",
      "definition" : "Not Critical refrigerated temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep critical refrigerated."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XDFRZ",
      "display" : "Not Deep frozen",
      "definition" : "Not Deep frozen",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep deep frozen: -16 to -20 degree C."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XDRY",
      "display" : "Not Dry",
      "definition" : "Not Dry",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep in a dry environment."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XFRZ",
      "display" : "Not Frozen temperature",
      "definition" : "Not Frozen temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep at frozen temperature: -4 degrees C."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XMTLF",
      "display" : "Metal Exposed",
      "definition" : "Metal Exposed",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep container is free of heavy metals."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XNTR",
      "display" : "Not Liquid nitrogen",
      "definition" : "Not Liquid nitrogen",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep in liquid nitrogen."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XPRTL",
      "display" : "Not Protected from light",
      "definition" : "Not Protected from light",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to protect from light."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XPSA",
      "display" : "Shaken",
      "definition" : "Shaken",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Shaken."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XPSO",
      "display" : "Exposed to shock",
      "definition" : "Exposed to shock",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to protect from shock."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XREF",
      "display" : "Not Refrigerated temperature",
      "definition" : "Not Refrigerated temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep at refrigerated temperature: 4-8 degrees C."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XUFRZ",
      "display" : "Not Ultra frozen",
      "definition" : "Not Ultra frozen",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep ultra cold frozen: ~ -75 to -85 degree C. (ultra cold freezer is typically at temperature of dry ice)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "XUPR",
      "display" : "Not Upright",
      "definition" : "Not Upright",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Failed to keep upright."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    }
  ]
}

```
