# Communication Location (2.9 - 1.0.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Communication Location (2.9 - 1.0.1)**

## CodeSystem: Communication Location (2.9 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/communicationLocation | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:CommunicationLocation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.442 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the communication location. Used in HL7 Version 2.x messaging in the OMC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSVS-communicationLocation](ValueSet-hl7VSVS-communicationLocation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "communicationLocation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0939"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/communicationLocation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.442"
    }
  ],
  "version" : "1.0.1",
  "name" : "CommunicationLocation",
  "title" : "Communication Location (2.9 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the communication location.  Used in HL7 Version 2.x messaging in the OMC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "DG1-3",
      "display" : "Diagnosis Code",
      "definition" : "Diagnosis Code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "NK1-11",
      "display" : "Next of Kin / Associated Parties Job Code/Class",
      "definition" : "Next of Kin / Associated Parties Job Code/Class",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Used to convey patient's or next of kin's employment job class code"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "NK1-13",
      "display" : "Organization Name - NK1",
      "definition" : "Organization Name - NK1",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Next of kin's organization name"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "NK1-28",
      "display" : "Ethnic Group",
      "definition" : "Ethnic Group",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Next of kin's ethnicity"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "NK1-35",
      "display" : "Race",
      "definition" : "Race",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Next of kin's race"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OBR-13",
      "display" : "Relevant Clinical Information",
      "definition" : "Relevant Clinical Information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The purpose varies based on the AOE referencing this field."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OBR-16",
      "display" : "Ordering Provider",
      "definition" : "Ordering Provider",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OBR-49",
      "display" : "Result Handling",
      "definition" : "Result Handling",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This was used for call or fax results back"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OBR-OBX",
      "display" : "OBX segment following an OBR segment",
      "definition" : "OBX segment following an OBR segment",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "For responses related to the test order"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PID-11",
      "display" : "Patient Address",
      "definition" : "Patient Address",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Applies to patient"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PID-13",
      "display" : "Phone Number - Home",
      "definition" : "Phone Number - Home",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "deprecated field as of v2.7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PID-14",
      "display" : "Phone Number - Business",
      "definition" : "Phone Number - Business",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "deprecated field as of v2.7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PID-3",
      "display" : "Patient Identifier List",
      "definition" : "Patient Identifier List",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Applies to patient"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PID-40",
      "display" : "Phone Number",
      "definition" : "Phone Number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "New field in V2.7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PID-5",
      "display" : "Patient Name",
      "definition" : "Patient Name",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Applies to patient"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PID-6",
      "display" : "Mother's Maiden Name",
      "definition" : "Mother's Maiden Name",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Applies to patient"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PID-7",
      "display" : "Date/Time of Birth",
      "definition" : "Date/Time of Birth",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Applies to patient"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PRT-5",
      "display" : "Participation Person",
      "definition" : "Participation Person",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "SPM-4",
      "display" : "Specimen Type",
      "definition" : "Specimen Type",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "SPM-8",
      "display" : "Specimen Source Site",
      "definition" : "Specimen Source Site",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "SPM-OBX",
      "display" : "OBX segment following an SPM segment",
      "definition" : "OBX segment following an SPM segment",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "For responses related to the specimen"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    }
  ]
}

```
