# Blood Product Transfusion/Disposition Status (2.9 - 1.1.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Blood Product Transfusion/Disposition Status (2.9 - 1.1.0)**

## CodeSystem: Blood Product Transfusion/Disposition Status (2.9 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/bloodProductTransfusion-dispositionStatus | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:BloodProductTransfusion-dispositionStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.335 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the placer. For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been "transfused." Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSbloodProductTransfusion-dispositionStatus](ValueSet-hl7VSbloodProductTransfusion-dispositionStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "bloodProductTransfusion-dispositionStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0513"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/bloodProductTransfusion-dispositionStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.335"
    }
  ],
  "version" : "1.1.0",
  "name" : "BloodProductTransfusion-dispositionStatus",
  "title" : "Blood Product Transfusion/Disposition Status (2.9 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the placer.  For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been \"transfused.\"  Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "RA",
      "display" : "Returned unused and unlinked",
      "definition" : "Blood product was returned unused, because it is no longer needed.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-12-07"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RL",
      "display" : "Returned unused but linked",
      "definition" : "Blood product was returned unused, because it is not currently needed, but should remain linked to the patient for future use.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-12-07"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TI",
      "display" : "Transfusion Interrupted",
      "definition" : "Transfusion of the blood product was interrupted and considered ended; a reason for interruption is usually also reported.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This is not expected to be an end state; transfusion will either be ended or restarted."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "TR",
      "display" : "Transfusion Ended with Reactions",
      "definition" : "The blood product has been transfused and it caused an adverse reaction.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-12-07"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TS",
      "display" : "Transfusion Started",
      "definition" : "Transfusion of the blood product has been started and is in progress",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This code may be used for restart if interrupted as well."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "TX",
      "display" : "Transfusion Ended",
      "definition" : "The blood product has been transfused with a normal end to the transfusion.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-12-07"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "WA",
      "display" : "Wasted",
      "definition" : "The blood product is no longer viable.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
