# Auto-Dilution Type (2.9 - 1.0.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Auto-Dilution Type (2.9 - 1.0.0)**

## CodeSystem: Auto-Dilution Type (2.9 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/auto-DilutionType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Auto-DilutionType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.445 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of vendor-defined codes that specify the pre‑configured dilution to be applied on the instrument, which can be used instead of a numeric declaration. Used in Version 2 messaging in the TCD segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSauto-DilutionType](ValueSet-hl7VSauto-DilutionType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "auto-DilutionType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0945"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/auto-DilutionType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.445"
    }
  ],
  "version" : "1.0.0",
  "name" : "Auto-DilutionType",
  "title" : "Auto-Dilution Type (2.9 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of vendor-defined codes that specify the pre‑configured dilution to be applied on the instrument, which can be used instead of a numeric declaration.  Used in Version 2 messaging in the TCD segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "D1",
      "display" : "Dilution factor 1.23",
      "definition" : "Specimen pre-diluted by factor 1.23 applied on the instrument",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "corresponds to ^1^:^1.23 in TCD-2"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "D2",
      "display" : "Dilution factor 1.45",
      "definition" : "Specimen pre-diluted by factor 1.45 applied on the instrument",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "corresponds to ^1^:^1.45 in TCD-2"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "X2",
      "display" : "Dilution factor 2",
      "definition" : "Specimen pre-diluted by factor 2 applied on the instrument",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "corresponds to ^1^:^2 in TCD-2"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "X5",
      "display" : "Dilution factor 5",
      "definition" : "Specimen pre-diluted by factor 5 applied on the instrument",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "corresponds to ^1^:^5 in TCD-2"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    }
  ]
}

```
