# Mood Codes (2.9 - 1.0.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mood Codes (2.9 - 1.0.1)**

## CodeSystem: Mood Codes (2.9 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/actMood | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:ActMood |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1001 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmoodCodes](ValueSet-hl7VSmoodCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "actMood",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0725"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/actMood",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1001"
    }
  ],
  "version" : "1.0.1",
  "name" : "ActMood",
  "title" : "Mood Codes (2.9 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "APT",
      "display" : "Appointment",
      "definition" : "Appointment",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Planned act for specific time and place"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "ARQ",
      "display" : "Appointment Request",
      "definition" : "Appointment Request",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Request for Booking of an Appointment"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "EVN",
      "display" : "Event",
      "definition" : "Event",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Service actually happens or happened or is ongoing."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "EVN.CRT",
      "display" : "Event Criterion",
      "definition" : "Event Criterion",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Criterion applying to Events for another Service to be applied. \r\nThis is an Act Mood Predicate.\r\nSimilar uses of above moods may be defined.\r\nE.g. Use in Care Plans,"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "EXP",
      "display" : "Expectation",
      "definition" : "Expectation",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Expecting that something will occur independently of  deliberate intent. E.g. expect a patient will discard medications."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "INT",
      "display" : "Intent",
      "definition" : "Intent",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Plan to perform a service"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PRMS",
      "display" : "Promise",
      "definition" : "Promise",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "An intent to perform a service"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PRP",
      "display" : "Proposal",
      "definition" : "Proposal",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Non-mandated intent to perform an act"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "RQO",
      "display" : "Request-Order",
      "definition" : "Request-Order",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Request or Order for a service"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
