# Supply Risk Codes (2.9 - 1.0.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Supply Risk Codes (2.9 - 1.0.1)**

## CodeSystem: Supply Risk Codes (2.9 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/supplyRisk | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:SupplyRisk |
| *Other Identifiers:*OID:2.16.840.1.113883.18.410 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying any known or suspected hazard associated with this material item. Used in HL7 Version 2.x messaging in the ITM segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSsupplyRiskCodes](ValueSet-hl7VSsupplyRiskCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "supplyRisk",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0871"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/supplyRisk",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.410"
    }
  ],
  "version" : "1.0.1",
  "name" : "SupplyRisk",
  "title" : "Supply Risk Codes (2.9 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying any known or suspected hazard associated with this material item.  Used in HL7 Version 2.x messaging in the ITM segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "COR",
      "display" : "Corrosive",
      "definition" : "Corrosive",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Material is corrosive and may cause severe injury to skin, mucous membranes and eyes. Avoid any unprotected contact."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "EXP",
      "display" : "Explosive",
      "definition" : "Explosive",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Material is an explosive mixture.  Keep away from fire, sparks, and heat."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "FLA",
      "display" : "Flammable",
      "definition" : "Flammable",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Material is highly flammable and in certain mixtures (with air) may lead to explosions.  Keep away from fire, sparks and excessive heat."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "INJ",
      "display" : "Injury Hazard",
      "definition" : "Injury Hazard",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Material is solid and sharp (e.g., cannulas.)  Dispose in hard container."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "RAD",
      "display" : "Radioactive",
      "definition" : "Radioactive",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Material is a source for ionizing radiation and must be handled with special care to avoid injury of those who handle it and to avoid environmental hazards."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "TOX",
      "display" : "Toxic",
      "definition" : "Toxic",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Material is toxic to humans and/or animals.  Special care must be taken to avoid incorporation, even of small amounts."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "UNK",
      "display" : "Unknown",
      "definition" : "Unknown",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Material hazard level is unknown."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
