# Specimen Role (2.9 - 1.2.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen Role (2.9 - 1.2.0)**

## CodeSystem: Specimen Role (2.9 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenRole | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:SpecimenRole |
| *Other Identifiers:*OID:2.16.840.1.113883.18.227 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts that identify the role of a sample. Used in HL7 Version 2.x messaging in the Specimen (SPM) and Observation Request (OBR) segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSspecimenRole](ValueSet-hl7VSspecimenRole.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "specimenRole",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0369"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenRole",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.227"
    }
  ],
  "version" : "1.2.0",
  "name" : "SpecimenRole",
  "title" : "Specimen Role (2.9 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that identify the role of a sample.  Used in HL7 Version 2.x messaging in the Specimen (SPM) and Observation Request (OBR) segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "Blind Sample",
      "definition" : "Used to test the validity of the measurement process, where the composition of the sample is unknown except to the person submitting it.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Calibrator",
      "definition" : "Used for initial setting of calibration of the instrument.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Electronic QC",
      "definition" : "Used with manufactured reference providing signals that simulate QC results",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Filler Organization Proficiency",
      "definition" : "Specimen used for testing proficiency of the organization performing the testing (Filler).",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "G",
      "display" : "Group",
      "definition" : "Used when solid specimens consist of multiple individual elements that are not individually identified but can be separated again into the original specimens.  The identifiers of the original specimens may be tracked.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "Historical Specimen",
      "definition" : "This identifies a parent specimen to the specimen that is submitted for testing",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The order of specimen processing can be derived from the SPM-3 value in all SPM segments in the message.  More than one historical SPM can be submitted, each SPM describes one step in the derivation process of the specimen submitted for testing."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Pool",
      "definition" : "Used when aliquots of liquid individual specimens are combined to form a single specimen representing all of the components that are not individually identified.  The identifiers of the original specimens may be tracked.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Operator Proficiency",
      "definition" : "Specimen used for testing Operator Proficiency.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Patient",
      "definition" : "Used for any patient sample.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "If the component is not valued (blank) this represents the default meaning."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Q",
      "display" : "Control specimen",
      "definition" : "Used when specimen is the control specimen (either positive or negative).",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Replicate",
      "definition" : "Used when a patient sample is re-run as a control for a repeat test.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "Verifying Calibrator",
      "definition" : "Used for periodic calibration checks.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
