# Special Handling Code (2.9 - 1.1.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Special Handling Code (2.9 - 1.1.1)**

## CodeSystem: Special Handling Code (2.9 - 1.1.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/specialHandling | *Version*:1.1.1 |
| Active as of 2026-01-27 | *Computable Name*:SpecialHandling |
| *Other Identifiers:*OID:2.16.840.1.113883.18.234 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing. Used in HL7 Version 2.x messaging in the SPM, SAC, PAC and OM4 segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSspecialHandlingConsiderations](ValueSet-hl7VSspecialHandlingConsiderations.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "specialHandling",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0376"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/specialHandling",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.234"
    }
  ],
  "version" : "1.1.1",
  "name" : "SpecialHandling",
  "title" : "Special Handling Code (2.9 - 1.1.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing.  Used in HL7 Version 2.x messaging in the SPM, SAC, PAC and OM4 segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AMB",
      "display" : "Ambient temperature",
      "definition" : "Ambient temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Keep at ambient (room) temperature, approximately 22 ( 2 degrees C. Accidental refrigeration or freezing is of little consequence"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "C37",
      "display" : "Body temperature",
      "definition" : "Body temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Critical to keep at body temperature: 36 - 38( C."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CAMB",
      "display" : "Critical ambient temperature",
      "definition" : "Critical ambient temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Critical ambient - must not be refrigerated or frozen."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CATM",
      "display" : "Protect from air",
      "definition" : "Protect from air",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Critical. Do not expose to atmosphere. Do not uncap."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CFRZ",
      "display" : "Critical frozen temperature",
      "definition" : "Critical frozen temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Critical frozen - must not be allowed to thaw until immediately prior to testing"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CREF",
      "display" : "Critical refrigerated temperature",
      "definition" : "Critical refrigerated temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Critical refrigerated -  must not be allowed to freeze or warm until immediately prior to testing"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DFRZ",
      "display" : "Deep frozen",
      "definition" : "Deep frozen",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deep frozen: -16 to -20( C."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DRY",
      "display" : "Dry",
      "definition" : "Dry",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Keep in a dry environment."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FRZ",
      "display" : "Frozen temperature",
      "definition" : "Frozen temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Keep at frozen temperature: -4( C. Accidental thawing is of little consequence"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MTLF",
      "display" : "Metal Free",
      "definition" : "Metal Free",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Container is free of heavy metals including lead."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NTR",
      "display" : "Liquid nitrogen",
      "definition" : "Liquid nitrogen",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Keep in liquid nitrogen."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PRTL",
      "display" : "Protect from light",
      "definition" : "Protect from light",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Protect from light (e.g., wrap in aluminum foil)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PSA",
      "display" : "Do not shake",
      "definition" : "Do not shake",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Do not shake."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PSO",
      "display" : "No shock",
      "definition" : "No shock",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Protect from shock."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "REF",
      "display" : "Refrigerated temperature",
      "definition" : "Refrigerated temperature",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Keep at refrigerated temperature: 4-8( C. Accidental warming or freezing is of little consequence"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UFRZ",
      "display" : "Ultra frozen",
      "definition" : "Ultra frozen",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Ultra cold frozen: ~ -75 to -85( C. (ultra cold freezer is typically at temperature of dry ice)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UPR",
      "display" : "Upright",
      "definition" : "Upright",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Keep upright. Do not turn upside down."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
