# Service Request Relationship (2.9 - 1.0.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Service Request Relationship (2.9 - 1.0.1)**

## CodeSystem: Service Request Relationship (2.9 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/serviceRequestRelationship | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:ServiceRequestRelationship |
| *Other Identifiers:*OID:2.16.840.1.113883.18.330 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to specify an additional or alternate relationship between this service request and other service requests. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSserviceRequestRelationship](ValueSet-hl7VSserviceRequestRelationship.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "serviceRequestRelationship",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0506"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/serviceRequestRelationship",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.330"
    }
  ],
  "version" : "1.0.1",
  "name" : "ServiceRequestRelationship",
  "title" : "Service Request Relationship (2.9 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify an additional or alternate relationship between this service request and other service requests.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "Compound",
      "definition" : "Compound",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "A compound is an extempo order which may be made up of multiple drugs.  For example, many hospitals have a standard item called \"Magic Mouthwash\".  The item is ordered that way by the physician. The extempo items will contain multiple products, such as Maalox, Benadryl, Xylocaine, etc.  They will all be mixed together and will be dispensed in a single container."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Exclusive",
      "definition" : "Exclusive",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "An exclusive order is an order where only one of the multiple items should be administered at any one dosage time.  The nurse may chose between the alternatives, but should only give ONE of them.  An example would be: Phenergan 25 mg PO, IM or R q6h prn (orally, intramuscularly, or rectally every 6 hours as needed)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Nurse prerogative",
      "definition" : "Nurse prerogative",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Where a set of two or more orders exist and the Nurse, or other caregiver, has the prerogative to choose which order will be administered at a particular point in time.  For example,\r\n\tMilk of Magnesia PO 30 ml qhs (at bedtime)\r\n\tDulcolax Supp R @ hs prn\r\n\tColace 100 mg capsule PO bid \r\nThe nurse would be administering MOM, but may add the Colace and may also give the Dulcolax Supp as needed to promote and maintain regularity."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Simultaneous",
      "definition" : "Simultaneous",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "A simultaneous order is 2 or more drugs which are ordered to be given at the same time.  A common example of this would be Demerol and Phenergan (Phenergan is given with the Demerol to control the nausea that Demerol can cause).  The order could be: Demerol 50 mg IM with Phenergan 25 mg IM q4h prn (every 4 hours as needed)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Tapering",
      "definition" : "Tapering",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "A tapering order is one in which the same drug is used, but it has a declining dosage over a number of days.\r\nFor example, Decadron 0.5 mg is often ordered this way.  The order would look like this:\r\n\tDecadron 0.5 mg qid (four times a day) for 2 days, then\r\n\tDecadron 0.5 mg tid (three times a day) for 2 days, then\r\n\tDecadron 0.5 mg bid (twice a day) for 2 days, then\r\n\tDecadron 0.5 mg qd (daily) for 2 days, then stop."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
