# Root Cause (2.9 - 1.0.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Root Cause (2.9 - 1.0.1)**

## CodeSystem: Root Cause (2.9 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/rootCause | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:RootCause |
| *Other Identifiers:*OID:2.16.840.1.113883.18.421 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the root cause. Used in HL7 Version 2.x messaging in the OBX segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSrootCause](ValueSet-hl7VSrootCause.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "rootCause",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0914"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/rootCause",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.421"
    }
  ],
  "version" : "1.0.1",
  "name" : "RootCause",
  "title" : "Root Cause (2.9 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the root cause.  Used in HL7 Version 2.x messaging in the OBX segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AP",
      "display" : "Analysis Process",
      "definition" : "Analysis Process",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Enter (AP) when ANALYSIS PROCESS is the reason due to:\r\n• Product or supply failure (reagents, calibrators, QC material)\r\n• Equipment or instrumentation failure"
        },
        {
          "code" : "usage",
          "valueString" : "Enter (AP) when ANALYSIS PROCESS is the reason due to:\r\n• Product or supply failure (reagents, calibrators, QC material)\r\n• Equipment or instrumentation failure"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "IM",
      "display" : "Information Management",
      "definition" : "Information Management",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Enter (IM) when INFORMATION MANAGEMENT is the reason due to:\r\n• Database or Programming issues\r\n• Overriding of test results\r\n• Inaccurate calculations\r\n• Inaccurate flagging, reference ranges, units of measure\r\n• Incomplete/inaccurate transmission of test results\r\n• Other"
        },
        {
          "code" : "usage",
          "valueString" : "Enter (IM) when INFORMATION MANAGEMENT is the reason due to:\r\n• Database or Programming issues\r\n• Overriding of test results\r\n• Inaccurate calculations\r\n• Inaccurate flagging, reference ranges, units of measure\r\n• Incomplete/inaccurate transmission of test results\r\n• Other"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Laboratory",
      "definition" : "Laboratory",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Enter (L) when LABORATORY is the reason due to:<p>• Data Entry error<p>• Testing/Technical error<p>• Repeat testing causing change to test result"
        },
        {
          "code" : "usage",
          "valueString" : "Enter (L) when LABORATORY is the reason due to:\r\n• Data Entry error\r\n• Testing/Technical error\r\n• Repeat testing causing change to test result"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "NA",
      "display" : "Not Applicable",
      "definition" : "Not Applicable",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Enter (NA) when NOT-APPLICABLE is the reason due to:\r\n• If no revisions performed or \r\n• unable to determine reason for revision\r\nNote:  Do not use NA if result code status is not corrected (revised) or if a preliminary release of results with a correction (revision)"
        },
        {
          "code" : "usage",
          "valueString" : "Enter (NA) when NOT-APPLICABLE is the reason due to:\r\n• If no revisions performed or\r\n• unable to determine reason for revision\r\nNote: Do not use NA if result code status is not corrected (revised) or if a preliminary release of results with a correction (revision)"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "PD",
      "display" : "Placer Data",
      "definition" : "Placer Data",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Enter (PD) when new or changed PLACER DATA information is the reason due to:\r\n• Changed patient demographics or\r\n• Result code data provided by the client on the requisition or specimen manifest that will be entered during order entry (i.e. Previous Biopsy Date, Clinical Information, Source, etc...)"
        },
        {
          "code" : "usage",
          "valueString" : "Enter (PD) when new or changed PLACER DATA information is the reason due to:\r\n• Changed patient demographics or\r\n• Result code data provided by the client on the requisition or specimen manifest that will be entered during order entry (i.e. Previous Biopsy Date, Clinical Information, Source, etc...)"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    }
  ]
}

```
