# Relevant Clinicial Information (2.9 - 1.0.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Relevant Clinicial Information (2.9 - 1.0.0)**

## CodeSystem: Relevant Clinicial Information (2.9 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/relevantClincialInformation | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:RelevantClincialInformation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.422 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies. Used in HL7 Version 2.x messaging in the OBR segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSrelevantClincialInformation](ValueSet-hl7VSrelevantClincialInformation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "relevantClincialInformation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0916"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/relevantClincialInformation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.422"
    }
  ],
  "version" : "1.0.0",
  "name" : "RelevantClincialInformation",
  "title" : "Relevant Clinicial Information (2.9 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies. Used in HL7 Version 2.x messaging in the OBR segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "F",
      "display" : "Patient was fasting prior to the procedure.",
      "definition" : "Patient was fasting prior to the procedure.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7.1"
        }
      ]
    },
    {
      "code" : "FNA",
      "display" : "Fasting not asked of the patient at time of procedure.",
      "definition" : "Fasting not asked of the patient at time of procedure.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-11-24"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7.1"
        }
      ]
    },
    {
      "code" : "NF",
      "display" : "The patient indicated they did not fast prior to the procedure.",
      "definition" : "The patient indicated they did not fast prior to the procedure.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7.1"
        }
      ]
    },
    {
      "code" : "NG",
      "display" : "Not Given - Patient was not asked at the time of the procedure.",
      "definition" : "Not Given - Patient was not asked at the time of the procedure.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7.1"
        }
      ]
    }
  ]
}

```
