# Problem/Goal Action Code (2.9 - 1.1.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Problem/Goal Action Code (2.9 - 1.1.0)**

## CodeSystem: Problem/Goal Action Code (2.9 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/problem-goalAction | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:Problem-goalAction |
| *Other Identifiers:*OID:2.16.840.1.113883.18.3 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal. Used in HL7 Version 2.x messaging in the GOL, ROL, PRB and PTH segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSactionCode](ValueSet-hl7VSactionCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "problem-goalAction",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0287"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/problem-goalAction",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.3"
    }
  ],
  "version" : "1.1.0",
  "name" : "Problem-goalAction",
  "title" : "Problem/Goal Action Code (2.9 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal.  Used in HL7 Version 2.x messaging in the GOL, ROL, PRB and PTH segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AD",
      "display" : "ADD",
      "definition" : "ADD",
      "designation" : [
        {
          "language" : "de",
          "value" : "hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CO",
      "display" : "CORRECT",
      "definition" : "CORRECT",
      "designation" : [
        {
          "language" : "de",
          "value" : "ändern"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DE",
      "display" : "DELETE",
      "definition" : "DELETE",
      "designation" : [
        {
          "language" : "de",
          "value" : "löschen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "LINK",
      "definition" : "LINK",
      "designation" : [
        {
          "language" : "de",
          "value" : "verknüpfen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SP",
      "display" : "Used in Snapshot mode",
      "definition" : "Declares when segment falls under snapshot  mode handling, i.e. all elements that were previously sent will be sent, not just any changes",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Snapshot mode is the expected default; use this code to explicitly state that."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "UC",
      "display" : "UNCHANGED",
      "definition" : "UNCHANGED",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The UNCHANGED action code is used to signify to the applications programs that this particular segment includes no information to be modified.  It is supplied in order to identify the correct record for which the following modification is intended"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UN",
      "display" : "UNLINK",
      "definition" : "UNLINK",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verknüpfung auflösen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UP",
      "display" : "UPDATE",
      "definition" : "UPDATE",
      "designation" : [
        {
          "language" : "de",
          "value" : "ändern"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
