# Alternate Character Sets (2.9 - 1.4.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alternate Character Sets (2.9 - 1.4.1)**

## CodeSystem: Alternate Character Sets (2.9 - 1.4.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/alternateCharacterSets | *Version*:1.4.1 |
| Active as of 2026-01-27 | *Computable Name*:AlternateCharacterSets |
| *Other Identifiers:*OID:2.16.840.1.113883.18.116 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to specify the character set(s) in use. Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSalternateCharacterSets](ValueSet-hl7VSalternateCharacterSets.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "alternateCharacterSets",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0211"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/alternateCharacterSets",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.116"
    }
  ],
  "version" : "1.4.1",
  "name" : "AlternateCharacterSets",
  "title" : "Alternate Character Sets (2.9 - 1.4.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify the character set(s) in use.  Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "8859/1",
      "display" : "The printable characters from the ISO 8859/1 Character set",
      "definition" : "The printable characters from the ISO 8859/1 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/15",
      "display" : "The printable characters from the ISO 8859/15 (Latin-15)",
      "definition" : "The printable characters from the ISO 8859/15 (Latin-15)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "8859/2",
      "display" : "The printable characters from the ISO 8859/2 Character set",
      "definition" : "The printable characters from the ISO 8859/2 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/3",
      "display" : "The printable characters from the ISO 8859/3 Character set",
      "definition" : "The printable characters from the ISO 8859/3 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/4",
      "display" : "The printable characters from the ISO 8859/4 Character set",
      "definition" : "The printable characters from the ISO 8859/4 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/5",
      "display" : "The printable characters from the ISO 8859/5 Character set",
      "definition" : "The printable characters from the ISO 8859/5 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/6",
      "display" : "The printable characters from the ISO 8859/6 Character set",
      "definition" : "The printable characters from the ISO 8859/6 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/7",
      "display" : "The printable characters from the ISO 8859/7 Character set",
      "definition" : "The printable characters from the ISO 8859/7 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/8",
      "display" : "The printable characters from the ISO 8859/8 Character set",
      "definition" : "The printable characters from the ISO 8859/8 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/9",
      "display" : "The printable characters from the ISO 8859/9 Character set",
      "definition" : "The printable characters from the ISO 8859/9 Character set",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ASCII",
      "display" : "The printable 7-bit ASCII character set",
      "definition" : "The printable 7-bit ASCII character set",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This is the default if this field is omitted"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BIG-5",
      "display" : "Code for Taiwanese Character Set (BIG-5)",
      "definition" : "Code for Taiwanese Character Set (BIG-5)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Does not need an escape sequence.\r\n\r\nBIG-5 does not need an escape sequence. ASCII is a 7 bit character set, which means that the top bit of the byte is “0”. The parser knows that when the top bit of the byte is “0”, the character set is ASCII. When it is “1”, the following bytes should be handled as 2 bytes (or more). No escape technique is needed. However, since some servers do not correctly interpret when they receive a top bit “1”, it is advised, in internet RFC, to not use these kind of non-safe non-escape extension."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CNS 11643-1992",
      "display" : "Code for Taiwanese Character Set (CNS 11643-1992)",
      "definition" : "Code for Taiwanese Character Set (CNS 11643-1992)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Does not need an escape sequence."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GB 18030-2000",
      "display" : "Code for Chinese Character Set (GB 18030-2000)",
      "definition" : "Code for Chinese Character Set (GB 18030-2000)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Does not need an escape sequence."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ISO IR14",
      "display" : "Code for Information Exchange (one byte)(JIS X 0201-1976).",
      "definition" : "Code for Information Exchange (one byte)(JIS X 0201-1976).",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Note that the code contains a space, i.e., \"ISO IR14\"."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ISO IR159",
      "display" : "Code of the supplementary Japanese Graphic Character set for information interchange (JIS X 0212-1990).",
      "definition" : "Code of the supplementary Japanese Graphic Character set for information interchange (JIS X 0212-1990).",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Note that the code contains a space, i.e., \"ISO IR159\"."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ISO IR6",
      "display" : "ASCII graphic character set consisting of 94 characters.",
      "definition" : "ASCII graphic character set consisting of 94 characters.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "http://www.itscj.ipsj.or.jp/ISO-IR/006.pdf"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "ISO IR87",
      "display" : "Code for the Japanese Graphic Character set for information interchange (JIS X 0208-1990),",
      "definition" : "Code for the Japanese Graphic Character set for information interchange (JIS X 0208-1990),",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Note that the code contains a space, i.e., “ISO IR87”.\r\n\r\nThe JIS X 0208 needs an escape sequence. In Japan, the escape technique is ISO 2022. From basic ASCII, escape sequence “escape” $ B (in HEX, 1B 24 42) lets the parser know that following bytes should be handled 2-byte wise. Back to ASCII is 1B 28 42."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "JAS2020",
      "display" : "A subset of ISO2020 used for most Kanjii transmissions",
      "definition" : "A subset of ISO2020 used for most Kanjii transmissions",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-30"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "JIS X 0202",
      "display" : "ISO 2022 with escape sequences for Kanjii",
      "definition" : "ISO 2022 with escape sequences for Kanjii",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-30"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "KS X 1001",
      "display" : "Code for Korean Character Set (KS X 1001)",
      "definition" : "Code for Korean Character Set (KS X 1001)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UNICODE",
      "display" : "The world wide character standard from ISO/IEC 10646-1-1993",
      "definition" : "The world wide character standard from ISO/IEC 10646-1-1993",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated. Retained for backward compatibility only as v 2.5. Replaced by specific Unicode encoding codes."
        },
        {
          "code" : "usage",
          "valueString" : "Available from The Unicode Consortium, P.O. Box 700519, San Jose, CA  95170-0519.  See http://www.unicode.org/unicode/consortium/consort.html"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UNICODE UTF-16",
      "display" : "UCS Transformation Format, 16-bit form",
      "definition" : "UCS Transformation Format, 16-bit form",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "UTF-16 is identical to ISO/IEC 10646 UCS-2. Note that the code contains a space before UTF but not before and after the hyphen."
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2023-08-10"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UNICODE UTF-32",
      "display" : "UCS Transformation Format, 32-bit form",
      "definition" : "UCS Transformation Format, 32-bit form",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "UTF-32 is defined by Unicode Technical Report #19, and is an officially recognized encoding as of Unicode Version 3.1. UTF-32 is a proper subset of ISO/IEC 10646 UCS-4. Note that the code contains a space before UTF but not before and after the hyphen."
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2023-08-10"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UNICODE UTF-8",
      "display" : "UCS Transformation Format, 8-bit form",
      "definition" : "UCS Transformation Format, 8-bit form",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "UTF-8 is a variable-length encoding, each code value is represented by 1,2 or 3 bytes, depending on the code value. 7 bit ASCII is a proper subset of UTF-8. Note that the code contains a space before UTF but not before and after the hyphen. Since UTF-8 represents the full UNICODE character set, the following restriction apply to its use: \r\n1. UTF-8 must be the default encoding of the message, UTF-8 cannot be specified as an additional character set in MSH-18\r\n2. There are no other character sets allowed in a message where UTF-8 is the default encoding in the message.\r\nIn other words, UNICODE UTF-8 can only be specified as a single value in MSH-18\r\n3. A message encoded in UTF-8 must not use a Byte Order Mark (BOM)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
