# Address Type (2.9 - 1.5.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Address Type (2.9 - 1.5.1)**

## CodeSystem: Address Type (2.9 - 1.5.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/addressType | *Version*:1.5.1 |
| Active as of 2026-01-27 | *Computable Name*:AddressType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.101 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.x messaging in the XAD segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSaddressType](ValueSet-hl7VSaddressType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "addressType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0190"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/addressType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.101"
    }
  ],
  "version" : "1.5.1",
  "name" : "AddressType",
  "title" : "Address Type (2.9 - 1.5.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying types or kinds of addresses.  Used in HL7 Version 2.x messaging in the XAD segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "Firm/Business",
      "definition" : "Firm/Business",
      "designation" : [
        {
          "language" : "de",
          "value" : "Firma/Geschäft"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to an address specific to an organization, such as an insurance company or employer, versus an individual’s work location or place of employment. It would be specific to a firm or organization that has some sort of business relationship with the subject"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "BA",
      "display" : "Bad address",
      "definition" : "Bad address",
      "designation" : [
        {
          "language" : "de",
          "value" : "ungültige Adresse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BDL",
      "display" : "Birth delivery location  (address where birth occurred)",
      "definition" : "Birth delivery location  (address where birth occurred)",
      "designation" : [
        {
          "language" : "de",
          "value" : "genauer Geburtsort"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to the address where birth occurred."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BI",
      "display" : "Billing Address",
      "definition" : "Billing Address",
      "designation" : [
        {
          "language" : "de",
          "value" : "Rechnungsadresse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "May also be used for the validation/authorization of credit cards"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "BR",
      "display" : "Residence at birth (home address at time of birth)",
      "definition" : "Residence at birth (home address at time of birth)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wohnort zum Zeit­punkt der Geburt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to the home address at time of birth."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Current Or Temporary",
      "definition" : "Current Or Temporary",
      "designation" : [
        {
          "language" : "de",
          "value" : "Derzeitige Adresse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.16"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Country Of Origin",
      "definition" : "Country Of Origin",
      "designation" : [
        {
          "language" : "de",
          "value" : "Herkunftsland"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "Home",
      "definition" : "Home",
      "designation" : [
        {
          "language" : "de",
          "value" : "Privatadresse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to a residence or domicile, literally the place where the subject resides the majority of the time. Generally speaking most people will have a home address and it will represent their primary address. Home address is mutually exclusive of permanent address."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Legal Address",
      "definition" : "Legal Address",
      "designation" : [
        {
          "language" : "de",
          "value" : "registrierte Adresse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to a special case address specific to the status of a subject or legal action involving the subject. For example, prisoners being treated at a healthcare facility may have home addresses, but their status mandates an address specific to their place of incarceration. Statutes may require the health information specific to a ward of the state be sent to a legal guardian, the courts, or a state or municipal agency regardless of the ward’s physical location. In cases involving civil or criminal proceedings, a record may be flagged such that all correspondence is sent to any variety of legal entities."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Mailing",
      "definition" : "Mailing",
      "designation" : [
        {
          "language" : "de",
          "value" : "Postalische Adresse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.18"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Birth (nee) (birth address, not otherwise specified)",
      "definition" : "Birth (nee)  (birth address, not otherwise specified)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to the birth address, not otherwise specified"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Office/Business",
      "definition" : "Office/Business",
      "designation" : [
        {
          "language" : "de",
          "value" : "Büroadresse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to a work address specific to the subject."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Permanent",
      "definition" : "Permanent",
      "designation" : [
        {
          "language" : "de",
          "value" : "Dauernder Wohnsitz"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to a place where the residents know the subject and where correspondence addressed to the subject will eventually reach the subject regardless of their physical location. A permanent address generally reflects a tax jurisdiction.  Members of the military, flight attendants, and executives on rotational assignments are examples of those who typically maintain a permanent address. Although mutually exclusive of home address, in some instances, such as the executives mentioned above, it may be synonymous.  In such cases upon return from assignment this address would revert to the home address."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RH",
      "display" : "Registry home",
      "definition" : "Registry home. Refers to the information system, typically managed by a public health agency, that stores patient information such as immunization histories or cancer data, regardless of where the patient obtains services.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to the information system, typically managed by a public health agency that stores patient information such as immunization histories or cancer data, regardless of where the patient obtains services"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Service Location",
      "definition" : "Service Location",
      "designation" : [
        {
          "language" : "de",
          "value" : "Leistungsort"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Refers to the location in which service is rendered. This would be used if reimbursement is based on the location of the service (to take into account the cost of those services)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "SH",
      "display" : "Shipping Address",
      "definition" : "Shipping Address",
      "designation" : [
        {
          "language" : "de",
          "value" : "Versandadresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "TM",
      "display" : "Tube Address",
      "definition" : "Tube Address",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Pneumatic tube address (to which letters may be sent). A special transport system to transport small samples/containers and/or normal mail in small carriages on rail or in a tube.  (German Rohrpost)"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "Vacation",
      "definition" : "Vacation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Adresse des Ferienortes"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
