# Artifacts Summary - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [V2CodeSystem](StructureDefinition-V2CodeSystem.md) | Profile for CodeSystem instances generated in this guide. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Accept/Application Acknowledgment Conditions (2.8.2 - 1.0.0)](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md) | Concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. |
| [Access Restriction Reason Code (2.8.2 - 1.0.0)](ValueSet-hl7VSaccessRestrictionReasonCode.md) | Value Set of codes that specify the reason for the restricted access. |
| [Access Restriction Value (2.8.2 - 1.0.0)](ValueSet-hl7VSaccessRestrictionValue.md) | Value Set of codes that specify the information to which access is restricted. Note that the new codes as of November 2018 have been temporarily loaded into the underlying V2 code system pending availability of the currently unavailable new tooling, at which time this value set will be retired and a value set based on the HL7 V3 ActCode code system will be used instead for this table, and the rendered URL will be valid at terminology.hl7.org. |
| [Acknowledgment Code (2.8.2 - 1.2.0)](ValueSet-hl7VSacknowledgmentCode.md) | Concepts specifying acknowledgment codes used in Version 2.x message. For details of usage, see message processing rules in the published Standard. |
| [ActPriority (2.8.2 - 1.0.0)](ValueSet-hl7VSactpriority.md) | Value Set of codes specifying the priority for a shipment. |
| [Action Taken in Response to the Event (2.8.2 - 1.0.0)](ValueSet-hl7VSactionTakenInResponseToTheEvent.md) | Value Set of codes that define the action taken as a result of an event related to a product issue. |
| [Active/Inactive (2.8.2 - 1.0.0)](ValueSet-hl7VSactive-inactive.md) | Value Set of codes that specify whether a person is currently a valid staff member. |
| [Additive/Preservative (2.8.2 - 2.0.0)](ValueSet-hl7VSadditivePreservative.md) | Concepts specifying any additive introduced to the specimen before or at the time of collection. These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen. Used in Version 2 messaging in the SPM segment. |
| [Address Expiration Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSaddressExpirationReason.md) | Value Set of codes that specify the reason this address was marked as "ended". |
| [Address Type (2.8.2 - 1.5.0)](ValueSet-hl7VSaddressType.md) | Concepts specifying types or kinds of addresses. |
| [Address Usage (2.8.2 - 1.0.0)](ValueSet-hl7VSaddressUsage.md) | Value Set of codes that specify how an address is intended to be used. |
| [Adjustment Action (2.8.2 - 1.0.0)](ValueSet-hl7VSadjustmentAction.md) | Value Set of codes used to specify the action requested of a party that receives an adjustment. |
| [Adjustment Category Code (2.8.2 - 1.0.0)](ValueSet-hl7VSadjustmentCategoryCode.md) | Value Set of codes used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason. |
| [Administration Device (2.8.2 - 1.0.0)](ValueSet-hl7VSadministrationDevice.md) | Value Set of codes that specify the mechanical device used to aid in the administration of the drug or other treatment. Common examples are IV-sets of different types. |
| [Administration Method (2.8.2 - 1.0.0)](ValueSet-hl7VSadministrationMethod.md) | Value Set of codes that specify the specific method requested for the administration of the drug or treatment to the patient. |
| [Administrative Sex (2.8.2 - 1.0.0)](ValueSet-hl7VSadministrativeSex.md) | Concepts specifying a patient's sex for administrative purposes. |
| [Admission Level of Care Code (2.8.2 - 1.0.0)](ValueSet-hl7VSadmissionLevelOfCareCode.md) | Value Set of codes specifying the acuity level assigned to the patient at the time of admission. |
| [Admission Type (2.8.2 - 1.1.0)](ValueSet-hl7VSadmissionType.md) | Value Set of codes that specify the circumstances under which the patient was or will be admitted. |
| [Advanced Beneficiary Notice Code (2.8.2 - 1.0.0)](ValueSet-hl7VSadvancedBeneficiaryNoticeCode.md) | Status codes specifying a patient's or a patient's representative's consent for responsibility to pay for potentially uninsured services. Note that this set of codes is generally used in the US only. |
| [Alert Device Code (2.8.2 - 1.0.0)](ValueSet-hl7VSalertDeviceCode.md) | Value Set of codes specifying any type of allergy alert device the patient may be carrying or wearing. |
| [Alert Level (2.8.2 - 1.0.0)](ValueSet-hl7VSalertLevel.md) | Value Set of codes that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event). |
| [Allergen Type (2.8.2 - 1.1.0)](ValueSet-hl7VSallergyType.md) | Value Set of codes that specify classification of general allergy categories (drug, food, pollen, etc.). |
| [Allergy Clinical Status (2.8.2 - 1.0.0)](ValueSet-hl7VSallergyClinicalStatus.md) | Value Set of codes specifying the verification status for the allergy. |
| [Allergy Severity (2.8.2 - 1.1.0)](ValueSet-hl7VSallergySeverity.md) | Value Set of codes that specify the general severity of an allergy. |
| [Allow Substitution (2.8.2 - 1.0.0)](ValueSet-hl7VSallowSubstitution.md) | Value Set of codes that specify whether substitutions are allowed and, if so, the type of substitutions allowed. |
| [Allow Substitution Codes (2.8.2 - 1.1.0)](ValueSet-hl7VSallowSubstitutionCodes.md) | Value Set of codes that indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment. |
| [Alternate Character Set Handling Scheme (2.8.2 - 1.1.0)](ValueSet-hl7VSalternateCharacterSetHandlingScheme.md) | Concepts that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed. |
| [Alternate Character Sets (2.8.2 - 1.4.0)](ValueSet-hl7VSalternateCharacterSets.md) | Value Set of codes that identify one of a number of possible standard alternate character sets for a message, either single-byte or double-byte. |
| [Ambulatory Payment Classification Code (2.8.2 - 1.0.0)](ValueSet-hl7VSambulatoryPaymentClassificationCode.md) | Value Set of codes that specify the derived Ambulatory Payment Classification (APC) code. |
| [Ambulatory Status (2.8.2 - 1.0.0)](ValueSet-hl7VSambulatoryStatus.md) | Value Set of codes that specify permanent or transient handicapped conditions of a person. |
| [Amount Class (2.8.2 - 1.0.0)](ValueSet-hl7VSamountClass.md) | Value Set of codes that specify the amount quantity class. |
| [Amount Type (2.8.2 - 1.0.0)](ValueSet-hl7VSamountType.md) | Value Set of codes that specify amount quantity type. |
| [Analyte Repeat Status (2.8.2 - 1.0.0)](ValueSet-hl7VSanalyteRepeatStatus.md) | Value Set of codes identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex). The following are assumptions regarding the table values: Repeated without dilution — performed usually to confirm correctness of r |
| [Annotations (2.8.2 - 1.0.0)](ValueSet-hl7VSannotations.md) | Value Set of codes that specify the coded entry associated with a given point in time during the waveform recording. Note codes beyond 9903 may exist; extensions to this table may be done by incrementing the code value. |
| [Appointment Reason Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSappointmentReasonCodes.md) | Value Set of codes that describe the kind of appointment or the reason why an appointment has been scheduled. |
| [Appointment Type Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSappointmentTypeCodes.md) | Value Set of codes that an appointment request to describe the kind of appointment. |
| [Arm Stick (2.8.2 - 1.0.0)](ValueSet-hl7VSarmStick.md) | Value Set of codes specifying the arm(s) receiving a stick. |
| [Artificial Blood (2.8.2 - 1.0.0)](ValueSet-hl7VSartificialBlood.md) | Value Set of codes that identify the artificial blood identifier associated with the specimen. |
| [Assignment of Benefits (2.8.2 - 1.0.0)](ValueSet-hl7VSassignmentOfBenefits.md) | Value Set of codes which indicate whether an insured person agreed to assign the insurance benefits to a healthcare provider. If so, the insurance will pay the provider directly. |
| [Authorization Mode (2.8.2 - 1.0.0)](ValueSet-hl7VSauthorizationMode.md) | Concepts of forms of authorization a recorder may receive from the responsible practitioner to create or change an order. Used in Version 2 messaging for orders in the ORC segment. |
| [BP Observation Status Codes Interpretation (2.8.2 - 1.0.0)](ValueSet-hl7VSbpObservationStatusCodesInterpretation.md) | Value Set of codes that specify the interpretation for the blood product observation status codes. A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first c |
| [Bed Status (2.8.2 - 1.1.0)](ValueSet-hl7VSbedStatus.md) | Value Set of codes that specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. |
| [Blood Product Code (2.8.2 - 1.0.0)](ValueSet-hl7VSbloodProductCode.md) | Value Set of codes specifying the blood product code. |
| [Blood Product Dispense Status (2.8.2 - 1.0.0)](ValueSet-hl7VSbloodProductDispenseStatus.md) | Value Set of codes that specify the current status of the specified blood product as indicated by the filler or placer. For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it fir |
| [Blood Product Processing Requirements (2.8.2 - 1.0.0)](ValueSet-hl7VSbloodProductProcessingRequirements.md) | Value Set of codes that specify additional information about the blood component class associated with the Universal Service ID. The placer of the order can specify any required processing of the blood product that must be completed prior to t |
| [Blood Product Transfusion/Disposition Status (2.8.2 - 1.0.0)](ValueSet-hl7VSbloodProductTransfusion-dispositionStatus.md) | Value Set of codes that specify the current status of the specified blood product as indicated by the placer. For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood co |
| [Blood Unit Type (2.8.2 - 1.0.0)](ValueSet-hl7VSbloodUnitType.md) | Value Set of codes used to specify the type of blood unit |
| [Body Parts (2.8.2 - 1.1.0)](ValueSet-hl7VSbodyParts.md) | Value Set of codes that specify the part of the body. |
| [Body Site (2.8.2 - 1.2.0)](ValueSet-hl7VSadministriveSite.md) | Concepts that specify a body site from which a specimen is obtained. |
| [Body Site Modifier (2.8.2 - 1.0.0)](ValueSet-hl7VSbodySiteModifier.md) | Value Set of codes that specify the modifier for the body site. |
| [Bolus Type (2.8.2 - 1.0.0)](ValueSet-hl7VSbolusType.md) | Value Set of codes specifying a type of bolus. |
| [CCL Value (2.8.2 - 1.0.0)](ValueSet-hl7VScclValue.md) | Value Set of codes that specify the clinical complexity level (CCL) value for the determined diagnosis related group (DRG) for this diagnosis. |
| [CP Range Type (2.8.2 - 1.0.0)](ValueSet-hl7VSrangeType.md) | Value Set of codes that specify whether a composite price range is experssed as a flat rate or a percentage. |
| [CWE statuses (2.8.2 - 1.0.0)](ValueSet-hl7VScweStatuses.md) | Concepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended). These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in Version 2 messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype. |
| [Calendar Alignment (2.8.2 - 1.0.0)](ValueSet-hl7VScalendarAlignment.md) | Value Set of codes that specify an alignment of the repetition to a calendar (e.g., to distinguish every 30 days from "the 5th of every month"). |
| [Causality Observations (2.8.2 - 1.0.0)](ValueSet-hl7VScausalityObservations.md) | Value Set of codes that record event observations regarding what may have caused a product related event. |
| [Certificate Status (2.8.2 - 1.0.0)](ValueSet-hl7VScertificateStatus.md) | Value Set of codes that specify the status of the certificate held by a health professional. |
| [Certification Category Code (2.8.2 - 1.0.0)](ValueSet-hl7VScertificationCategoryCode.md) | Value Set of codes specifying the code for a certification category. |
| [Certification Patient Type (2.8.2 - 1.0.0)](ValueSet-hl7VSprecertificationPatientType.md) | Value Set of codes that specify the category or type of patient for which this certification is requested. |
| [Certification Status (2.8.2 - 1.0.0)](ValueSet-hl7VScertificationStatus.md) | Value Set of codes that specify the status of the practitioner's speciality certification. |
| [Certification Type Code (2.8.2 - 1.0.0)](ValueSet-hl7VScertificationTypeCode.md) | Value Set of codes specifying the code for a certification type. |
| [Charge On Indicator (2.8.2 - 1.0.0)](ValueSet-hl7VSchargeOnIndicator.md) | Value Set of codes that define the event upon which a charge should be generated. |
| [Charge Type (2.8.2 - 1.0.0)](ValueSet-hl7VSchargeType.md) | Value Set of codes that specify someone or something other than the patient to be billed for a service. |
| [Charge Type Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSchargeTypeReason.md) | Value Set of codes that specify the choice of, and providing the clinical rationale for, a selected charge type. |
| [Check Digit Scheme (2.8.2 - 1.3.0)](ValueSet-hl7VScheckDigitScheme.md) | Concepts used to identify the check digit scheme employed when a check digit is used in various HL7 Version 2.x datatypes. |
| [Coding System (2.8.2 - 1.8.0)](ValueSet-hl7VScodingSystem.md) | Names of coding systems. Each coding system is assigned a unique identifier, which is generally a short mnemonic derived from the full name of the coding system. |
| [Collection Event/Process Step Limit (2.8.2 - 1.0.0)](ValueSet-hl7VSVS-collectionEvent.md) | Value Set of codes specifying the limit for a collection event or process step. |
| [Command Response (2.8.2 - 1.0.1)](ValueSet-hl7VScommandResponse.md) | Value Set of codes identifying the response of the previously issued command. |
| [Comment Type (2.8.2 - 1.0.0)](ValueSet-hl7VScommentType.md) | Value Set of codes that identify the type of comment text being sent in the specific comment record. |
| [Communication Location (2.8.2 - 1.0.0)](ValueSet-hl7VSVS-communicationLocation.md) | Value Set of codes specifying a communication location. |
| [Completion Status (2.8.2 - 1.0.0)](ValueSet-hl7VScompletionStatus.md) | Status codes used in the workflow of treatment administration events. |
| [Computation Type (2.8.2 - 1.0.0)](ValueSet-hl7VScomputationType.md) | Value Set of codes that specify if the change is computed as a percent change or as an absolute change. |
| [Confidentiality (2.8.2 - 1.0.0)](ValueSet-hl7VSconfidentiality.md) | Value Set of codes specifying the confidentiality for a shipment. |
| [Confidentiality Code (2.8.2 - 1.0.0)](ValueSet-hl7VSconfidentialityCode.md) | Value Set of codes that specify the degree to which special confidentiality protection should be applied to the observation. |
| [Consent Bypass Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSconsentBypassReason.md) | Value Set of codes that specify the reason the subject's consent was not sought. |
| [Consent Disclosure Level (2.8.2 - 1.0.0)](ValueSet-hl7VSconsentDisclosureLevel.md) | Value Set of codes that specify how much information was disclosed to the subject as part of the informed consent process. |
| [Consent Mode (2.8.2 - 1.0.0)](ValueSet-hl7VSconsentMode.md) | Value Set of codes that specify the method in which a subject provides consent. |
| [Consent Non-Disclosure Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSconsentNon-disclosureReason.md) | Value Set of codes that specify a reason the subject did not receive full disclosure. |
| [Consent Status (2.8.2 - 1.0.0)](ValueSet-hl7VSconsentStatus.md) | Value Set of codes that specify whether the consent has been sought and granted. |
| [Consent Type (2.8.2 - 1.0.0)](ValueSet-hl7VSconsentType.md) | Value Set of codes that specify to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event. |
| [Contact Role (2.8.2 - 1.0.0)](ValueSet-hl7VScontactRole2.md) | Concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Built on the updated code system. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral. |
| [Container Condition (2.8.2 - 1.0.0)](ValueSet-hl7VScontainerCondition.md) | Value Set of codes that specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab. If the container is compromised in any way (seal broken, container |
| [Container Status (2.8.2 - 1.0.0)](ValueSet-hl7VScontainerStatus.md) | Value Set of codes that identify the status of the unique container in which the specimen resides at the time the transaction was initiated. |
| [Continuation Style Code (2.8.2 - 1.0.0)](ValueSet-hl7VScontinuationStyleCode.md) | Value Set of codes identifying whether it is a fragmented message or part of an interactive continuation message. |
| [Controlled Substance Schedule (2.8.2 - 1.0.0)](ValueSet-hl7VScontrolledSubstanceSchedule.md) | Value Set of codes that specify the class of the drug or other substance if its usage is controlled by legislation. |
| [Coordination of Benefits (2.8.2 - 1.0.0)](ValueSet-hl7VScoordinationOfBenefits.md) | Value Set of codes that specify whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient. |
| [Coverage Type (2.8.2 - 1.1.0)](ValueSet-hl7VScoverageType.md) | Note that this set of codes is used generally in the US only. |
| [Cumulative Dosage Limit UoM (2.8.2 - 1.0.0)](ValueSet-hl7VScumulativeDosageLimitUom.md) | Value Set of codes specifying the unit of measure (UoM) for the cumulative dosage limit. |
| [Cycle Type (2.8.2 - 1.0.0)](ValueSet-hl7VScycleType.md) | Value Set of codes that specify the type of cycle that is being executed. A cycle type is a specific sterilization method used for a specific type of supply item. |
| [Cyclic Entry/Exit Indicator (2.8.2 - 1.0.0)](ValueSet-hl7VScyclicEntryExitIndicator.md) | Value Set of codes that specify if this service request is the first or last service request in a cyclic series of service requests. |
| [DRG Diagnosis Determination Status (2.8.2 - 1.0.0)](ValueSet-hl7VSdrgDiagnosisDeterminationStatus.md) | Value Set of codes that specify the status of a diagnosis for a diagnosis related group (DRG) determination. |
| [DRG Grouping Status (2.8.2 - 1.0.0)](ValueSet-hl7VSdrgGroupingStatus.md) | Value Set of codes that specify the status of the use of the gender information for diagnosis related group (DRG) determination. |
| [DRG Procedure Determination Status (2.8.2 - 1.0.0)](ValueSet-hl7VSdrgProcedureDeterminationStatus.md) | Value Set of codes that specify the status of the use of this particular procedure for the diagnosis related group (DRG) determination. |
| [DRG Procedure Relevance (2.8.2 - 1.0.0)](ValueSet-hl7VSdrgProcedureRelevance.md) | Value Set of codes that specify the relevance of this particular procedure for the diagnosis related group (DRG) determination. |
| [DRG Status Financial Calculation (2.8.2 - 1.0.0)](ValueSet-hl7VSdrgStatusFinancialCalculation.md) | Value Set of codes that specify the status of the diagnosis related group (DRG) calculation regarding the financial aspects. |
| [DRG Status Patient (2.8.2 - 1.0.0)](ValueSet-hl7VSstatusPatient.md) | Value Set of codes that specify whether the length of stay is normal or respectively shorter or longer than normal. |
| [DRG Status Respiration Minutes (2.8.2 - 1.0.0)](ValueSet-hl7VSstatusRespirationMinutes.md) | Value Set of codes that specify the status of the use of the respiration minutes information for diagnosis related group (DRG) determination. |
| [Data Types (2.8.2 - 1.2.0)](ValueSet-hl7VSdataTypes.md) | Value Set of codes specifying the data type. |
| [Date Format (2.8.2 - 1.0.0)](ValueSet-hl7VSdateFormat.md) | Value Set of codes that specify the date format for a decontamination/sterilization instance. |
| [Day Type (2.8.2 - 1.0.0)](ValueSet-hl7VSdayType.md) | Value Set of codes that specify whether the days are denied, pending or approved. |
| [Days of the Week (2.8.2 - 1.0.0)](ValueSet-hl7VSdaysOfTheWeek.md) | Value Set of codes that identify the day(s) of the week when a location may be scheduled for appointments. |
| [Degree/License/Certificate (2.8.2 - 2.1.0)](ValueSet-hl7VSdegreeLicenseCertificate.md) | Concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging. Used in Version 2 messaging; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7. |
| [Denial or Rejection Code (2.8.2 - 1.0.0)](ValueSet-hl7VSdenialOrRejectionCode.md) | Value Set of codes that specify the OCE status of the line item. |
| [Derived Specimen (2.8.2 - 1.0.0)](ValueSet-hl7VSderivedSpecimen.md) | Value Set of codes that specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture). The pro |
| [Device Data State (2.8.2 - 1.0.0)](ValueSet-hl7VSdeviceDataState.md) | Value Set of codes that specify the state of the data as provided from a device. |
| [Device Status (2.8.2 - 1.0.0)](ValueSet-hl7VSdeviceStatus.md) | Value Set of codes that specify the state of a device. |
| [Diagnosis Classification (2.8.2 - 1.0.0)](ValueSet-hl7VSdiagnosisClassification.md) | Value Set of codes that classify whether a patient visit can be related to a diagnosis. |
| [Diagnosis Priority (2.8.2 - 1.0.0)](ValueSet-hl7VSdiagnosisPriority.md) | Concepts that identify the significance or priority of the diagnosis code. Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis. Used in the DG1 segment in Version 2 messaging. |
| [Diagnosis Type (2.8.2 - 1.0.0)](ValueSet-hl7VSdiagnosisType.md) | Concepts specifying a type of diagnosis being sent in HL7 Version 2.x messages. |
| [Diagnostic Service Section ID (2.8.2 - 1.5.0)](ValueSet-hl7VSdiagnosticServiceSectionId.md) | Concepts which specify a section of a diagnostic service where the observation may be performed. |
| [Diet Code Specification Type (2.8.2 - 1.0.0)](ValueSet-hl7VSdietType.md) | Value Set of codes that specify the type of diet. |
| [Disabled Person Code (2.8.2 - 1.0.0)](ValueSet-hl7VSdisabledPerson.md) | Value Set of codes that specify to which person the disability information relates in the message. For example, if the value is PT, the disability information relates to the patient. |
| [Dispense Method (2.8.2 - 1.0.0)](ValueSet-hl7VSdispenseMethod.md) | Value Set of codes that specify the method by which treatment is dispensed. |
| [Dispense Type (2.8.2 - 1.0.0)](ValueSet-hl7VSdispenseType.md) | Value Set of codes that specify the type of dispensing event that occurred. |
| [Document Availability Status (2.8.2 - 1.1.0)](ValueSet-hl7VSdocumentAvailabilityStatus.md) | Value Set of codes that define whether a patient document is appropriate or available for use in patient care. |
| [Document Completion Status (2.8.2 - 1.0.0)](ValueSet-hl7VSdocumentCompletionStatus.md) | Value Set of codes that record the state of a document in a workflow. |
| [Document Confidentiality Status (2.8.2 - 2.0.0)](ValueSet-hl7VSdocumentConfidentialityStatus.md) | Value Set of codes that specify the degree to which special confidentiality protection should be applied to information. The assignment of data elements to these categories is left to the discretion of the healthcare organization. |
| [Document Storage Status (2.8.2 - 1.0.0)](ValueSet-hl7VSdocumentStorageStatus.md) | Value Set of codes that describe the availability of a document in relation to the type of storage. |
| [Document Type (2.8.2 - 1.0.0)](ValueSet-hl7VSreportTypeCode.md) | Value Set of codes that identify the kind of patient document. |
| [Duration Categories (2.8.2 - 1.1.0)](ValueSet-hl7VSdurationCategories.md) | Value Set of codes that classify an observation definition as intended to measure a patient's state at a point in time. |
| [Eligibility Source (2.8.2 - 1.0.0)](ValueSet-hl7VSeligibilitySource.md) | Value Set of codes that specify the source of information about the insured's eligibility for benefits. |
| [Employment Status (2.8.2 - 2.0.0)](ValueSet-hl7VSemploymentStatus.md) | Value Set of codes that specify the guarantor's employment status. |
| [Encoding (2.8.2 - 1.0.0)](ValueSet-hl7VSencoding.md) | Concept identifying the type of IETF encoding used to represent successive octets of binary data as displayable ASCII characters. |
| [Equipment State (2.8.2 - 1.1.0)](ValueSet-hl7VSequipmentState.md) | Value Set of codes that identify the status the equipment was in at the time the transaction was initiated. |
| [Error Severity (2.8.2 - 1.1.0)](ValueSet-hl7VSerrorSeverity.md) | Concepts documenting the severity of an application error as reported during acknowledgment of messages. |
| [Escort Required (2.8.2 - 1.0.0)](ValueSet-hl7VSescortRequired.md) | Value Set of codes indicating whether a patient must be accompanied while travelling to a diagnostic service department. |
| [Event (2.8.2 - 1.10.0)](ValueSet-hl7VSevent.md) | Concepts specifying the trigger event for Version 2.x interface messages. |
| [Event Consequence (2.8.2 - 1.0.0)](ValueSet-hl7VSeventConsequence.md) | Value Set of codes that describe the impact of an event on a patient. |
| [Event Expected (2.8.2 - 1.0.0)](ValueSet-hl7VSeventExpected.md) | Value Set of codes that communicate whether an event has been judged to be expected or unexpected. |
| [Event Qualification (2.8.2 - 1.0.0)](ValueSet-hl7VSeventQualification.md) | Value Set of codes that qualify an event related to a product experience. |
| [Event Reason (2.8.2 - 1.3.0)](ValueSet-hl7VSeventReason.md) | Value Set of codes that specify the reason for an event. |
| [Event Related Period (2.8.2 - 1.0.0)](ValueSet-hl7VSeventRelatedPeriod.md) | Value Set of codes that specify a common (periodical) activity of daily living. |
| [Event Reported To (2.8.2 - 1.0.0)](ValueSet-hl7VSeventReportedTo.md) | Value Set of codes that identify the type of entity to which the event has been reported. |
| [Event Seriousness (2.8.2 - 1.0.0)](ValueSet-hl7VSeventSeriousness.md) | Value Set of codes that a sender to designate an event as serious or significant. |
| [Event Type (2.8.2 - 1.0.0)](ValueSet-hl7VSeventType.md) | Value Set of codes specifying the type of event of the message. |
| [Exclusive Test (2.8.2 - 1.0.0)](ValueSet-hl7VSexclusiveTest.md) | Concepts that define if a test should be a specific event with no other tests to be performed with this test, or not, or other special circumstances. |
| [Expanded Yes/no Indicator (2.8.2 - 1.0.0)](ValueSet-hl7VSexpandedYes-NoIndicator.md) | Value Set of codes that specify an expansion on the original Yes/No indicator table by including "flavors of null". It is intended to be applied to fields where the response is not limited to "yes" or "no". |
| [Extended Priority Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSextendedPriorityCodes.md) | Concepts describing the urgency of a request carried in an order. Used in Version 2 messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn). Many of the codes are widely recognized values used in healthcare settings in the english-speaking world. |
| [Facility Type (2.8.2 - 1.0.0)](ValueSet-hl7VSfacilityType.md) | Value Set of codes that specify the type of facility. |
| [File Level Event Code (2.8.2 - 1.0.0)](ValueSet-hl7VSfile-levelEventCode.md) | Concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. |
| [Filler Status Codes (2.8.2 - 1.2.0)](ValueSet-hl7VSfillerStatusCodes.md) | Value Set of codes that describe an appointment status from the perspective of the entity assigned to fulfill the appointment. |
| [Formulary Status (2.8.2 - 1.0.0)](ValueSet-hl7VSformularyStatus.md) | Value Set of codes that specify whether or not the pharmaceutical substance is part of the local formulary. |
| [Gestation Category Code (2.8.2 - 1.0.0)](ValueSet-hl7VSgestationCategoryCode.md) | Value Set of codes specifying the status of the birth in relation to the gestation |
| [Grouper Status (2.8.2 - 1.0.0)](ValueSet-hl7VSgrouperStatus.md) | Value Set of codes that specify the status of a grouper in general. |
| [Health Care Provider Area of Specialization (2.8.2 - 1.0.0)](ValueSet-hl7VShealthCareProviderAreaOfSpecialization.md) | Value Set of codes that specify the segment of the population that a health care provider chooses to service, a specific medical service, a specialization in treating a specific disease, or any other descriptive characteristic about a provider’s practic |
| [Health Care Provider Classification (2.8.2 - 1.0.0)](ValueSet-hl7VShealthCareProviderClassification.md) | Value Set of codes that specify the more specific service or occupation within the healthcare provider type of the practitioner at a specific organization unit. |
| [Health Care Provider Type Code (2.8.2 - 1.0.0)](ValueSet-hl7VShealthCareProviderTypeCode.md) | Value Set of codes that specify the major grouping of the service or occupation of a practitioner at a specific organization unit. |
| [Identifier Type (2.8.2 - 1.5.0)](ValueSet-hl7VSidentifierType.md) | Concepts specifying types of identififiers, as used in person and organization identification datatypes in HL7 Version 2 standards. |
| [Identity May Be Divulged (2.8.2 - 1.0.0)](ValueSet-hl7VSidentityMayBeDivulged.md) | Value Set of codes that define whether the primary observer has given permission for their identification information to be provided to a product manufacturer. |
| [Identity Reliability Code (2.8.2 - 1.0.0)](ValueSet-hl7VSidentityReliabilityCode.md) | Value Set of codes that specify the reliability of patient/person identifying data transmitted via a transaction. |
| [Immunization Registry Status (2.8.2 - 1.0.0)](ValueSet-hl7VSimmunizationRegistryStatus.md) | Immunization registry status codes of a patient. Used in Version 2 messaging in the PD1 segment. |
| [Inactive Reason Code (2.8.2 - 1.0.0)](ValueSet-hl7VSinactiveReasonCode.md) | Value Set of codes that specify the reason the staff member is inactive. |
| [Incident Type Code (2.8.2 - 1.0.0)](ValueSet-hl7VSincidentTypeCode.md) | Value Set of codes specifying a classification of the incident type. |
| [Indirect Exposure Mechanism (2.8.2 - 1.0.0)](ValueSet-hl7VSindirectExposureMechanism.md) | Value Set of codes that identify the mechanism of product transmission when the product has not been directly applied to the patient. |
| [Inform Person Code (2.8.2 - 1.0.0)](ValueSet-hl7VSinformPersonCode.md) | Value Set of codes that specify who (if anyone) shouldor should not be informed of an error. |
| [Institution Relationship Type (2.8.2 - 1.0.0)](ValueSet-hl7VSinstitutionRelationshipType.md) | Value Set of codes that specify the relationship the staff person has with the institution for whom he/she provides services. |
| [Intended Procedure Type (2.8.2 - 1.0.0)](ValueSet-hl7VSintendedProcedureType.md) | Value Set of codes specifying the type of intended procedure. |
| [Interpretation Codes (2.8.2 - 2.2.0)](ValueSet-hl7VSinterpretationCode.md) | A categorical assessment, providing a rough qualitative interpretation of the observation value, such as “normal”/ “abnormal”,”low” / “high”, “better” / “worse”, “susceptible” / “resistant”, “expected”/ “not expected”. The value set is intended to be for ANY use where coded representation of an interpretation is needed. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. Historically these values come from the laboratory domain, and these codes are extensively used. The value set binding is extensible, so codes outside the value set that are needed for interpretation concepts (i.e. particular meanings) that are not included in the value set can be used, and these new codes may also be added to the value set and published in a future version. |
| [Invocation Event (2.8.2 - 1.0.0)](ValueSet-hl7VSwhenToCharge.md) | Value Set of codes that specify codes for an event precipitating/triggering a charge activity. |
| [Invoice Control Code (2.8.2 - 1.0.0)](ValueSet-hl7VSinvoiceControlCode.md) | Value Set of codes that specify what invoice action is being performed by this message. |
| [Invoice Processing Results Status (2.8.2 - 1.0.0)](ValueSet-hl7VSinvoiceProcessingResultsStatus.md) | Value Set of codes used to specify the processing status for an Invoice Processing Result. |
| [Invoice Reason Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSinvoiceReasonCodes.md) | Value Set of codes that specify the reason for an invoice. |
| [Invoice Type (2.8.2 - 1.0.0)](ValueSet-hl7VSinvoiceType.md) | Value Set of codes that specify the type of invoice. |
| [Item Status (2.8.2 - 1.0.0)](ValueSet-hl7VSitemStatus.md) | Value Set of codes that specify the status (useful for reporting and item usage purposes) that applies to an item. |
| [Item Status Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSitemStatusCodes.md) | Value Set of codes that specify the state of an inventory item within the context of an inventory location. |
| [Item Type (2.8.2 - 1.0.0)](ValueSet-hl7VSitemType.md) | Value Set of codes that specify a classification of material items into like groups as defined and utilized within an operating room setting for charting procedures. |
| [Job Status (2.8.2 - 1.0.0)](ValueSet-hl7VSjobStatus.md) | Value Set of codes that specify a next of kin/associated party's job status. |
| [Jurisdictional Breadth (2.8.2 - 1.0.0)](ValueSet-hl7VSjurisdictionalBreadth.md) | Value Set of codes that specify the breadth/extent of the jurisdiction where the qualification is valid. |
| [Kind of Quantity (2.8.2 - 1.0.0)](ValueSet-hl7VSkindOfQuantity.md) | Value Set of codes that describe the underlying kind of property represented by an observation. The categories distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so |
| [Labor Calculation Type (2.8.2 - 1.0.0)](ValueSet-hl7VSlaborCalculationType.md) | Value Set of codes that specify the method used to calculate employee labor and measure employee productivity. |
| [Language Ability (2.8.2 - 1.0.0)](ValueSet-hl7VSlanguageAbility.md) | Value Set of codes that specify codes that indicate the ability that a Staff Member possesses with respect to the language. |
| [Language Proficiency (2.8.2 - 1.0.0)](ValueSet-hl7VSlanguageProficiency.md) | Value Set of codes which specify the level of knowledge a person possesses with respect to a language ability identified. |
| [Level of Care (2.8.2 - 1.0.0)](ValueSet-hl7VSlevelOfCare.md) | Value Set of codes that identify the level of care a patient may be afforded when assigned to this location definition. |
| [Limitation Type Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSVS-limitationTypeCode.md) | Value Set of codes specifying a type of limitation. |
| [Living Arrangement (2.8.2 - 1.1.0)](ValueSet-hl7VSlivingArrangement.md) | Concepts characterizing the situation that patient-associated parties live in at their residential address. |
| [Living Dependency (2.8.2 - 2.0.0)](ValueSet-hl7VSlivingDependency.md) | Value Set of codes identifying specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient's healthcare needs. |
| [Living Will Code (2.8.2 - 1.0.0)](ValueSet-hl7VSlivingWill.md) | Value Set of codes that specify whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility. If the patient does not have a living will, the value of this field indicates whether the |
| [Load Status (2.8.2 - 1.0.0)](ValueSet-hl7VSloadStatus.md) | Value Set of codes that specify the status of the information provided in a device sterilization or decontamination cycle. |
| [Local/Remote Control State (2.8.2 - 1.0.0)](ValueSet-hl7VSlocal-remoteControlState.md) | Value Set of codes that identify the current state of control associated with the equipment. Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state) |
| [Location Characteristic ID (2.8.2 - 1.0.0)](ValueSet-hl7VSlocationCharacteristicId.md) | Value Set of codes that specify an identifier code to show which characteristic is being communicated with the segment. |
| [Location Equipment (2.8.2 - 1.0.0)](ValueSet-hl7VSlocationEquipment.md) | Value Set of codes that identify the equipment available in a location definition identified as a room or bed. |
| [Location Relationship ID (2.8.2 - 1.0.0)](ValueSet-hl7VSlocationRelationshipId.md) | Value Set of codes that specify an identifier code to show which relationship is being communicated with the segment. |
| [Location Service Code (2.8.2 - 1.0.0)](ValueSet-hl7VSlocationServiceCode.md) | Value Set of codes specifying the types of services provided by the location. |
| [Lot Control (2.8.2 - 1.0.0)](ValueSet-hl7VSlotControl.md) | Value Set of codes that specify whether the sterilization load for a device is built in the sub-sterile area adjacent to an Operating Room or the Central Processing Department. |
| [MFN Record-level Error Return (2.8.2 - 1.0.0)](ValueSet-hl7VSmfnRecode-levelErrorReturn.md) | Concepts which code status values for requested master file record update operations. |
| [MIME Types (2.8.2 - 1.0.0)](ValueSet-hl7VSmimeTypes.md) | Value Set of codes specifying the general type of data. |
| [Mail Claim Party (2.8.2 - 1.0.0)](ValueSet-hl7VSmailClaimParty.md) | Value Set of codes that specify a party to which a claim should be mailed when claims are sent by mail. |
| [Manufacturers of Vaccines (code=MVX) (2.8.2 - 1.3.0)](ValueSet-PHVS_ManufacturersOfVaccinesMVX_CDC_NIP.md) | Value Set of codes that specify the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control. Note that the source of truth for these code values are maintained by the CDC, and the code system may be acce |
| [Marital Status (2.8.2 - 1.1.0)](ValueSet-hl7VSmaritalStatus.md) | Value Set of codes that specify a person's marital (civil/legal) status. |
| [Marketing Basis (2.8.2 - 1.0.0)](ValueSet-hl7VSmarketingBasis.md) | Value Set of codes that specify the basis for marketing approval. |
| [Master File Identifier Code (2.8.2 - 1.3.0)](ValueSet-hl7VSmasterFileIdentifierCode.md) | Concepts which are represented by codes identifying HL7Versions 2.x Master Files. |
| [Match Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSmatchReason.md) | Value Set of codes identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels. It |
| [Medical Role Executing Physician (2.8.2 - 1.0.0)](ValueSet-hl7VSmedicalRoleExecutingPhysician.md) | Value Set of codes specifying the role of the physician ("self-employed" or "employed"). |
| [Message Error Condition Codes (2.8.2 - 1.1.0)](ValueSet-hl7VSmessageErrorConditionCodes.md) | HL7 (communications) error codes, as transmitted in a message acknowledgement. |
| [Message Structure (2.8.2 - 7.3.0)](ValueSet-hl7VSmessageStructure.md) | HL7 abstract message structure codes. |
| [Message Type (2.8.2 - 1.8.0)](ValueSet-hl7VSmessageType.md) | Concepts which specify message types for HL7 Version 2.x messaging. |
| [Message Waiting Priority (2.8.2 - 1.0.0)](ValueSet-hl7VSmessageWaitingPriority.md) | Value Set of codes that specify how important the most important waiting mesasge is. For example, if there are 3 low priority messages, 1 medium priority message and 1 high priority message, the message waiting priority would be "high", because |
| [Military Rank/Grade (2.8.2 - 2.0.0)](ValueSet-hl7VSmilitaryRank-Grade.md) | Value Set of codes that specify the military rank/grade of the patient. Australia: https://en.wikipedia.org/wiki/Australian_Defence_Force_ranks Canada: http://www.forces.gc.ca/en/honours-history-badges-insignia/rank.page United States: published in t |
| [Military Service (2.8.2 - 1.1.0)](ValueSet-hl7VSmilitaryService.md) | Value Set of codes that specify the military branch. This field is defined by CMS or other regulatory agencies. |
| [Military Status (2.8.2 - 1.0.0)](ValueSet-hl7VSmilitaryStatus.md) | Value Set of codes that specify the military status of the patient. This field is defined by CMS or other regulatory agencies. |
| [Modality (2.8.2 - 1.0.0)](ValueSet-hl7VSmodality.md) | Value Set of codes that define the imaging apparatus expected to be used to acquire an observation. This table has been removed from the standard as of 2.7 in favor of table 0910. |
| [Mode of Arrival Code (2.8.2 - 1.0.0)](ValueSet-hl7VSmodeOfArrivalCode.md) | Value Set of codes specifying how the patient was brought to the healthcare facility. |
| [Modifier Edit Code (2.8.2 - 1.0.0)](ValueSet-hl7VSmodifierEditCode.md) | Value Set of codes that specify the edits of the modifiers for each line or HCPCS/CPT. |
| [Modify Indicator (2.8.2 - 1.0.0)](ValueSet-hl7VSmodifyIndicator.md) | Value Set of codes identifying whether the subscription is new or is being modified. |
| [Money or Percentage Indicator (2.8.2 - 1.0.0)](ValueSet-hl7VSpenaltyType.md) | Value Set of codes that specify whether the amount is currency or a percentage. |
| [Mood Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSmoodCodes.md) | Value Set of codes that specify the functional state of an order. |
| [Name Assembly Order (2.8.2 - 1.0.0)](ValueSet-hl7VSnameAssemblyOrder.md) | Value Set of codes specifying the preferred display order of the components of this person name. |
| [Name Type (2.8.2 - 1.1.0)](ValueSet-hl7VSnameType.md) | Concepts for types of names for persons. |
| [Name/Address Representation (2.8.2 - 1.0.0)](ValueSet-hl7VSname-addressRepresentation.md) | Value Set of codes that specify an indication of the representation provided by the data item. |
| [Nature of Abnormal Testing (2.8.2 - 1.1.0)](ValueSet-hl7VSnatureOfAbnormalTesting.md) | Value Set of codes that specify the nature of an abnormal test. |
| [Nature of Challenge (2.8.2 - 1.0.0)](ValueSet-hl7VSnatureOfChallenge.md) | Value Set of codes that further describe an observation definition that is characterized as a challenge observation. |
| [Nature of Service/Test/Observation (2.8.2 - 1.1.0)](ValueSet-hl7VSnatureOfServiceTestObservation.md) | Concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. |
| [Newborn Code (2.8.2 - 1.0.0)](ValueSet-hl7VSnewbornCode.md) | Value Set of codes specifying whether the baby was born in or out of the facility. |
| [Non-Subject Consenter Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSnon-subjectConsenterReason.md) | Value Set of codes that specify a reason consent was granted by a person other than the subject of the consent. |
| [Notify Clergy Code (2.8.2 - 1.0.0)](ValueSet-hl7VSnotifyClergyCode.md) | Value Set of codes that specify whether the clergy should be notified. |
| [OCE Edit Code (2.8.2 - 1.0.0)](ValueSet-hl7VSOCEEditCode.md) | Value Set of codes that specify the edits that result from processing the HCPCS/CPT procedures for a record after evaluating all the codes, revenue codes, and modifiers. |
| [Observation Result Handling (2.8.2 - 1.1.0)](ValueSet-hl7VSobservationResultHandling.md) | Concepts regarding the handling of a result. |
| [Observation Result Status Codes Interpretation (2.8.2 - 1.3.0)](ValueSet-hl7VSobservationResultStatus.md) | Concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. |
| [Observation Sub-Type (2.8.2 - 1.0.0)](ValueSet-hl7VSVS-observationSubtype.md) | Value Set of codes specifying an observation sub-type. |
| [Observation Type (2.8.2 - 1.0.0)](ValueSet-hl7VSVS-observationType.md) | Value Set of codes that specify types of observations to enable systems to distinguish between observations sent along with an order, versus observations sent as the result to an order. |
| [Order Control Codes (2.8.2 - 1.7.0)](ValueSet-hl7VSorderControl.md) | Concepts which are used to determine the function of the order segment. Depending on the message, the action specifies by one of these control codes may refer to an order or an individual service. |
| [Order Status (2.8.2 - 1.2.0)](ValueSet-hl7VSorderStatus.md) | Value Set of codes that specify the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is as |
| [Order Type (2.8.2 - 1.0.0)](ValueSet-hl7VSorderType.md) | Value Set of codes that specify whether the order is to be executed in an inpatient setting or an outpatient setting. |
| [Organ Donor Code (2.8.2 - 1.2.0)](ValueSet-hl7VSorganDonor.md) | Value Set of codes that specify whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization. |
| [Organizational Name Type (2.8.2 - 1.0.0)](ValueSet-hl7VSorganizationalNameType.md) | Concepts used to specify the type of name for an organization i.e., legal name, display name. |
| [Outlier Type (2.8.2 - 1.0.0)](ValueSet-hl7VSoutlierType.md) | Value Set of codes that specify the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid. |
| [Overall Claim Disposition Code (2.8.2 - 1.0.0)](ValueSet-hl7VSoverallClaimDispositionCode.md) | Value Set of codes specifying the final status of the claim. |
| [Override (2.8.2 - 1.0.0)](ValueSet-hl7VSoverride.md) | Value Set of codes that define whether a Charge Description Master description may be overridden or if it must be overridden. |
| [Override Type (2.8.2 - 1.0.0)](ValueSet-hl7VSoverrideType.md) | Value Set of codes that specify what type of override can be used to override the specific error identified. |
| [PCA Type (2.8.2 - 1.0.0)](ValueSet-hl7VSpcaType.md) | Value Set of codes specifying a type of PCA. |
| [Package (2.8.2 - 1.0.0)](ValueSet-hl7VSpackage.md) | Value Set of codes specifying the packaging unit in which this inventory supply item can be ordered or issued when purchased from the vendor in the related vendor segment. |
| [Packaging Status Code (2.8.2 - 1.0.0)](ValueSet-hl7VSpackagingStatusCode.md) | Value Set of codes that specify the packaging status of the service. |
| [Participant Organization Unit Type (2.8.2 - 1.0.0)](ValueSet-hl7VSorganizationUnitType.md) | Value Set of codes that specify the environment in which the provider acts in the role associated with the provider type, and inludes codes for venues outside of formal organized healthcare settings, such as Home. The provider environment is no |
| [Participation (2.8.2 - 1.2.0)](ValueSet-hl7VSparticipation.md) | Concepts that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.) |
| [Patient Class (2.8.2 - 1.2.0)](ValueSet-hl7VSpatientClass.md) | Concepts used by systems to categorize patients by sites. |
| [Patient Condition Code (2.8.2 - 1.0.0)](ValueSet-hl7VSpatientConditionCode.md) | Value Set of codes specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc. |
| [Patient Location Type (2.8.2 - 1.0.0)](ValueSet-hl7VSpatientLocationType.md) | Value Set of codes that identify the kind of location described in the location definition. |
| [Patient Outcome (2.8.2 - 1.0.0)](ValueSet-hl7VSpatientOutcome.md) | Value Set of codes that describe the overall state of a patient as a result of patient care. |
| [Patient Results Release Categorization Scheme (2.8.2 - 1.0.0)](ValueSet-hl7VSpatientResultsReleaseCategorizationScheme.md) | Value Set of codes specifying the scheme for the patient results release categorization. |
| [Patient's Relationship to Insured (2.8.2 - 1.0.0)](ValueSet-hl7VSpatient_sRelationshipToInsured.md) | Value Set of codes that specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies. |
| [Payee Relationship to Invoice (2.8.2 - 1.0.0)](ValueSet-hl7VSpayeeRelationshipToInvoice.md) | Value Set of codes used to specify the relationship to the invoice for Person Payee Types. |
| [Payee Type (2.8.2 - 1.0.0)](ValueSet-hl7VSpayeeType.md) | Value Set of codes that specify the type of payee (e.g., organization, person). |
| [Payment Adjustment Code (2.8.2 - 1.0.0)](ValueSet-hl7VSpaymentAdjustmentCode.md) | Value Set of codes that specify any payment adjustment due to drugs or medical devices. |
| [Payment Method Code (2.8.2 - 1.0.0)](ValueSet-hl7VSpaymentMethodCode.md) | Value Set of codes used to specify the method for the movement of payment. |
| [Person Location Type (2.8.2 - 1.0.0)](ValueSet-hl7VSpersonLocationType.md) | Value Set of codes that specify the categorization of the person's location. |
| [Pharmacy Order Types (2.8.2 - 1.0.0)](ValueSet-hl7VSpharmacyOrderTypes.md) | Value Set of codes that specify the general category of pharmacy order which may be used to determine the processing path the order will take. |
| [Phlebotomy Issue (2.8.2 - 1.0.0)](ValueSet-hl7VSphlebotomyIssue.md) | Value Set of codes specifying a phlebotomy issue. |
| [Phlebotomy Status (2.8.2 - 1.0.0)](ValueSet-hl7VSphlebotomyStatus.md) | Value Set of codes specifying the status of a phlebotomy. |
| [Policy Type (2.8.2 - 1.0.0)](ValueSet-hl7VSpolicyType.md) | Value Set of codes that specify the policy type. |
| [Practitioner ID Number Type (2.8.2 - 1.1.0)](ValueSet-hl7VSpractitionerIdNumberType.md) | Value Set of codes that specify the type of number used for the practitioner identification. |
| [Practitioner Organization Unit Type (2.8.2 - 2.0.0)](ValueSet-hl7VSorganizationUnitType-Org.md) | Value Set of codes that specify the classification of the organization unit. |
| [Precaution Code (2.8.2 - 1.0.0)](ValueSet-hl7VSprecautionCode.md) | Value Set of codes specifying non-clincal precautions that need to be taken with the patient. |
| [Preferred Method of Contact (2.8.2 - 1.1.1)](ValueSet-hl7VSpreferredMethodOfContrct.md) | Value Set of codes that specify which of a group of multiple phone numbers is the preferred method of contact for this person. |
| [Preferred Specimen/Attribute Status (2.8.2 - 1.0.0)](ValueSet-hl7VSpreferredSpecimen-AttributeStatus.md) | Concepts that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a particular specimen. |
| [Present On Admission (POA) Indicator (2.8.2 - 1.0.0)](ValueSet-hl7VSpresentOnAdmission_poa_Indicator.md) | Value Set of codes specifying the present on admission indicator for this particular diagnosis. |
| [Price Type (2.8.2 - 1.0.0)](ValueSet-hl7VSpriceType.md) | Value Set of codes that identify the intent for the dollar amount on a pricing transaction. |
| [Primary Key Value Type (2.8.2 - 1.1.0)](ValueSet-hl7VSprimaryKeyValueType.md) | Value Set of codes that specify the type for the master file record identifier. |
| [Primary Observer's Qualification (2.8.2 - 1.0.0)](ValueSet-hl7VSprimaryObserver_sQualification.md) | Value Set of codes that provide a general description of the kind of health care professional who provided the primary observation. |
| [Priority (2.8.2 - 1.2.0)](ValueSet-hl7VSpriority.md) | Value Set of codes that specify the allowed priorities for obtaining the specimen. |
| [Privacy Level (2.8.2 - 1.0.0)](ValueSet-hl7VSprivacyLevel.md) | Value Set of codes that identify the level of privacy a patient will be afforded when assigned to this location definition. |
| [Problem/Goal Action Code (2.8.2 - 1.0.1)](ValueSet-hl7VSactionCode.md) | Concepts used in Patient Care for the intent of a problem or goal. Used in Version 2 messaging in the GOL segment. |
| [Procedure DRG Type (2.8.2 - 1.0.0)](ValueSet-hl7VSprocedureDrgType.md) | Value Set of codes that specify a procedure's priority ranking relative to its DRG. |
| [Procedure Functional Type (2.8.2 - 1.0.0)](ValueSet-hl7VSprocedureFunctionalType.md) | Value Set of codes that classify a procedure. |
| [Procedure Priority (2.8.2 - 1.1.0)](ValueSet-hl7VSprocedurePriority.md) | Value Set of codes specifying a number that identifies the significance or priority of the procedure code. |
| [Process Interruption Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSprocessInterruptionReason.md) | Value Set of codes specifying the reason for a process interruption. |
| [Processing Consideration Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSprocessingConsiderationCodes.md) | Value Set of codes that specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer). |
| [Processing ID (2.8.2 - 1.0.0)](ValueSet-hl7VSprocessingId.md) | Value Set of codes that specify whether the message is part of a production, training or debugging system. |
| [Processing Mode (2.8.2 - 1.1.0)](ValueSet-hl7VSprocessingMode.md) | Concepts that indicate an archival process or an initial load process. |
| [Processing Priority (2.8.2 - 1.0.0)](ValueSet-hl7VSprocessingPriority.md) | Value Set of codes that specify one or more available priorities for performing the observation or test. |
| [Processing Type (2.8.2 - 1.0.0)](ValueSet-hl7VSprocessingType.md) | Value Set of codes identifying the processing type that applies to the test code. If this attribute is omitted, then regular production is the default. |
| [Product Source (2.8.2 - 1.0.0)](ValueSet-hl7VSproductSource.md) | Value Set of codes that describe the evaluation state of a product identified in an incident. |
| [Product/Service Status (2.8.2 - 1.0.0)](ValueSet-hl7VSproduct-serviceStatus.md) | Value Set of codes that specify the processing status for the Product/Service Code. |
| [Product/Services Clarification Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSproduct-servicesClarification.md) | Value Set of codes that specify the Product/Service Code. |
| [Production Class Code (2.8.2 - 1.0.0)](ValueSet-hl7VSproductionClassCode.md) | Value Set of codes specifying the code and/or text indicating the primary use for which the living subject was bred or grown. |
| [Protection Code (2.8.2 - 1.0.0)](ValueSet-hl7VSprotectionCode.md) | Value Set of codes that specify that an address needs to be treated with special care or sensitivity. |
| [Provider Adjustment Reason Code (2.8.2 - 1.0.0)](ValueSet-hl7VSproviderAdjustmentReasonCode.md) | Value Set of codes used to specify the reason for this adjustment. |
| [Provider Billing (2.8.2 - 1.0.0)](ValueSet-hl7VSproviderBilling.md) | Value Set of codes that specify how provider services are billed. |
| [Provider Role (2.8.2 - 1.2.0)](ValueSet-hl7VSproviderRole.md) | Value Set of codes that specify the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). |
| [Purge Status Code (2.8.2 - 1.0.0)](ValueSet-hl7VSpurgeStatus.md) | Value Set of codes that define the state of a visit relative to its place in a purge workflow. |
| [Quantity Limited Request (2.8.2 - 1.1.0)](ValueSet-hl7VSquantityLimitedRequest.md) | Concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. |
| [Quantity Method (2.8.2 - 1.0.0)](ValueSet-hl7VSquantityMethod.md) | Value Set of codes that specify the method by which the quantity distributed is measured. |
| [Query Priority (2.8.2 - 1.0.0)](ValueSet-hl7VSqueryPriority.md) | Concepts which specify a time frame in which a querry response is expected. |
| [Query Response Status (2.8.2 - 1.1.0)](ValueSet-hl7VSqueryResponseStatus.md) | Concepts defining precise response status concepts in support of HL7 Version 2 query messaging. |
| [RX Component Type (2.8.2 - 1.0.0)](ValueSet-hl7VSrxComponentType.md) | Value Set of codes that specify the RX component type. |
| [Record-level Event Code (2.8.2 - 1.0.0)](ValueSet-hl7VSmasterfileActionCode.md) | Concepts specifying an action for a master file record. Used in HL7 V2.x messaging in the MFE segment. |
| [Recreational Drug Use Code (2.8.2 - 1.0.0)](ValueSet-hl7VSrecreationalDrugUseCode.md) | Value Set of codes specifying what recreational drugs the patient uses. |
| [Referral Category (2.8.2 - 1.0.0)](ValueSet-hl7VSreferralCategory.md) | Value Set of codes that describe the patient care setting where a referral should take place. |
| [Referral Disposition (2.8.2 - 1.0.0)](ValueSet-hl7VSreferralDisposition.md) | Value Set of codes that identify the expected response from the healthcare professional receiving a referral. |
| [Referral Priority (2.8.2 - 1.0.0)](ValueSet-hl7VSreferralPriority.md) | Value Set of codes that designate the urgency of a referral. |
| [Referral Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSreferralReason.md) | Value Set of codes that specify the reason for which the referral will take place. |
| [Referral Status (2.8.2 - 1.0.0)](ValueSet-hl7VSreferralStatus.md) | Value Set of codes that define the state of a referral. |
| [Referral Type (2.8.2 - 1.0.0)](ValueSet-hl7VSreferralType.md) | Value Set of codes that identify the general category of healthcare professional desired to satisfy a referral. |
| [Reimbursement Action Code (2.8.2 - 1.0.0)](ValueSet-hl7VSreimbursementActionCode.md) | Value Set of codes that specify the action to be taken during reimbursement calculations. |
| [Reimbursement Type Code (2.8.2 - 1.0.0)](ValueSet-hl7VSreimbursementTypeCode.md) | Value Set of codes that specify the fee schedule reimbursement type applied to a line item. |
| [Relatedness Assessment (2.8.2 - 1.0.0)](ValueSet-hl7VSrelatednessAssessment.md) | Value Set of codes that provide an estimate of whether an issue with a product was the cause of an event. |
| [Relational Conjunction (2.8.2 - 1.0.0)](ValueSet-hl7VSrelationalConjunction.md) | Value Set of codes used with relational operator values to group more than one segment field name. |
| [Relational Operator (2.8.2 - 1.0.0)](ValueSet-hl7VSrelationalOperator.md) | Value Set of codes that define the relationship between HL7 segment field names identified in a query construct. |
| [Relationship (2.8.2 - 1.0.0)](ValueSet-hl7VSrelationship.md) | Concepts specifying an actual personal relationship that the next of kin/associated party has to a patient. Used in HL7 Version 2.x messaging in the NK1 segment. |
| [Relationship Modifier (2.8.2 - 1.0.0)](ValueSet-hl7VSrelationshipModifier.md) | Value Set of codes that an observation definition to describe the subject of an observation in relation to a patient. |
| [Relevant Clinicial Information (2.8.2 - 1.0.0)](ValueSet-hl7VSrelevantClincialInformation.md) | Value Set of codes that specify additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies. |
| [Religion (2.8.2 - 2.1.0)](ValueSet-hl7VSreligion2.md) | Value Set of codes that specify a person's religion. |
| [Remote Control Command (2.8.2 - 1.1.0)](ValueSet-hl7VSremoteControlCommand.md) | Value Set of codes that identify the comment the component is to initiate. |
| [Reorder Theory Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSreorderTheoryCodes.md) | Value Set of codes that specify the calculation method used to determine the resupply schedule. |
| [Repeat Pattern (2.8.2 - 1.1.0)](ValueSet-hl7VSrepeatPattern.md) | Value Set of codes that specify the interval between repeated services. See the Comment/Usage Note in the table below, as the table contains both precoordinated codes that may be used in an HL7 field or component and also explanatory patterns i |
| [Report Source (2.8.2 - 1.0.0)](ValueSet-hl7VSreportSource.md) | Value Set of codes that identify where a report sender learned about an event. |
| [Report Timing (2.8.2 - 1.0.0)](ValueSet-hl7VSreportTiming.md) | Value Set of codes that identify the time span of a report or the reason for a report sent to a regulatory agency. |
| [Reporting Priority (2.8.2 - 1.0.0)](ValueSet-hl7VSreportingPriority.md) | Value Set of codes that specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority. |
| [Response Flag (2.8.2 - 1.0.0)](ValueSet-hl7VSresponseFlag.md) | Value Set of codes allowing the placer (sending) application to determine the amount of information to be returned from the filler. |
| [Response Level (2.8.2 - 1.0.0)](ValueSet-hl7VSresponseLevel.md) | Concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message. Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions. |
| [Response Modality (2.8.2 - 1.0.0)](ValueSet-hl7VSresponseModality.md) | Value Set of codes identifying the timing and grouping of the response message(s). |
| [Result Status (2.8.2 - 1.2.0)](ValueSet-hl7VSresultStatus-Obr.md) | Concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Risk Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSriskCodes.md) | Value Set of codes that specify any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient. |
| [Risk Management Incident Code (2.8.2 - 1.0.0)](ValueSet-hl7VSriskManagementIncidentCode.md) | Value Set of codes specifying the incident that occurred during a patient's stay. |
| [Role Executing Physician (2.8.2 - 1.0.0)](ValueSet-hl7VSroleExecutingPhysician.md) | Value Set of codes specifying the account role of the physician, for example, only billing for the professional part, the technical part or both. |
| [Room Type (2.8.2 - 1.0.0)](ValueSet-hl7VSroomType.md) | Value Set of codes that specify the room type. |
| [Root Cause (2.8.2 - 1.0.0)](ValueSet-hl7VSrootCause.md) | Value Set of codes specifying a root cause. |
| [Route of Administration (2.8.2 - 3.0.3)](ValueSet-hl7VSrouteOfAdministration.md) | Value Set of codes that specify the route of administration. |
| [Security Check Scheme (2.8.2 - 1.0.0)](ValueSet-hl7VSsecurityCheckScheme.md) | Value Set of codes specifying the scheme for a security check. |
| [Segment Action Code (2.8.2 - 1.1.0)](ValueSet-hl7VSsegmentActionCode.md) | Concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in "action code mode" (a kind of update mode in the Standard). |
| [Segment Group (2.8.2 - 8.0.0)](ValueSet-hl7VSsegmentGroup.md) | Value Set of codes that specify the optional segment groups which are to be included in a response. |
| [Sensitivity to Causative Agent Code (2.8.2 - 1.1.0)](ValueSet-hl7VSsensitivityToCausativeAgentCode.md) | Value Set of codes specifying the reason the patient should not be exposed to a substance. |
| [Sequence Condition Code (2.8.2 - 1.0.0)](ValueSet-hl7VSsequenceConditionCode.md) | Value Set of codes that specify the relationship between the start/end of the related service request(s) and the current service request. |
| [Sequence/Results Flag (2.8.2 - 1.0.0)](ValueSet-hl7VSsequenceResultsFlag.md) | Value Set of codes that specify the sequencing relationship between the current service request and a related service request(s) specified in the same information model structure. |
| [Sequencing (2.8.2 - 1.0.0)](ValueSet-hl7VSsequencing.md) | Value Set of codes identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not. |
| [Service Request Relationship (2.8.2 - 1.0.0)](ValueSet-hl7VSserviceRequestRelationship.md) | Value Set of codes that specify an additional or alternate relationship between this service request and other service requests. |
| [Severity of Illness Code (2.8.2 - 1.0.0)](ValueSet-hl7VSseverityOfIllnessCode.md) | Value Set of codes specifying the severity ranking of a patient's illness. |
| [Shipment Status (2.8.2 - 1.0.0)](ValueSet-hl7VSshipmentStatus.md) | Value Set of codes specifying the status of a shipment. |
| [Side of body (2.8.2 - 1.0.0)](ValueSet-hl7VSsideOfBody.md) | Value Set of codes specifying the side of the body ("left" or "right"). |
| [Signatory's Relationship to Subject (2.8.2 - 1.0.0)](ValueSet-hl7VSsignatory_sRelationshipToSubject.md) | Value Set of codes that specify the relationship of the consenter to the subject. |
| [Signature Code (2.8.2 - 1.0.0)](ValueSet-hl7VSsignatureCode.md) | Concepts that indicate how a patient/subscriber authorization signature is obtained and how it is being retained by a provider. |
| [Source Type (2.8.2 - 1.0.0)](ValueSet-hl7VSnetworkSourceType.md) | Value Set of codes that indicate (in certain systems) whether a lower level source identifier is an initiate or accept type. |
| [Source of Comment (2.8.2 - 1.1.0)](ValueSet-hl7VSsourceOfComment.md) | Concepts which are used to specify the source of a comment, as used in HL7 Version 2.x messaging in the NTE segment. |
| [Special Handling Code (2.8.2 - 1.1.0)](ValueSet-hl7VSspecialHandlingConsiderations.md) | Concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing. Used in Version 2 messaging in the SPM segment. |
| [Specialty Type (2.8.2 - 1.0.0)](ValueSet-hl7VSspecialtyType.md) | Value Set of codes that identify the specialty of the care professional who is supported when using this location definition. |
| [Specimen Appropriateness (2.8.2 - 2.0.0)](ValueSet-hl7VSspecimenAppropriateness.md) | Value Set of codes that specify the suitability of the specimen for the particular planned use as determined by the filler. |
| [Specimen Child Role (2.8.2 - 1.0.0)](ValueSet-hl7VSspecimenChildRole.md) | Value Set of codes that specify for child specimens the relationship between this specimen and the parent specimen. |
| [Specimen Collection Method (2.8.2 - 1.0.0)](ValueSet-hl7VSspecimenCollectionMethod.md) | Concepts to document procedures or processes by which a specimen may be collected. This is one of two code systems that are used instead of table 0070 (code system xxxx) which conflated specimen types and specimen collection methods. Used in Version 2 messaging in the SPM segment. |
| [Specimen Component (2.8.2 - 1.0.0)](ValueSet-hl7VSspecimenComponent.md) | Value Set of codes that identify the specimen component, e.g., supernatant, sediment, etc. |
| [Specimen Condition (2.8.2 - 1.1.0)](ValueSet-hl7VSspecimenCondition.md) | Concepts of modes or states of being that describe the nature of a specimen. Used in Version 2 messaging in the SPM segment. |
| [Specimen Quality (2.8.2 - 1.0.0)](ValueSet-hl7VSspecimenQuality.md) | Value Set of codes that specify the degree or grade of excellence of the specimen at receipt. |
| [Specimen Reject Reason (2.8.2 - 1.0.0)](ValueSet-hl7VSspecimenRejectReason.md) | Reasons a specimen may be rejected for a specified observation/result/analysis. Used in Version 2 messaging in the SPM segment. |
| [Specimen Role (2.8.2 - 1.1.0)](ValueSet-hl7VSspecimenRole.md) | Value Set of codes that identify the role of a sample. |
| [Specimen Type (2.8.2 - 1.2.0)](ValueSet-hl7VSspecimenType.md) | Concepts that describe the precise nature of an entity that may be used as the source material for an observation. This is one of two code systems that are used instead of table 0070 (code system xxxx) which conflated specimen types and specimen collection methods. Used in Version 2 messaging in the SPM segment. |
| [Status Admission (2.8.2 - 1.0.0)](ValueSet-hl7VSstatusAdmission.md) | Value Set of codes that specify the admission status for the diagnosis related group (DRG) determination. |
| [Status Weight At Birth (2.8.2 - 1.0.0)](ValueSet-hl7VSstatusWeightAtBirth.md) | Value Set of codes that specify the status of the use of the weight at birth for diagnosis related group (DRG) determination. |
| [Status of Evaluation (2.8.2 - 1.0.0)](ValueSet-hl7VSstartOfEvaluation.md) | Value Set of codes that describes the status of product evaluation. |
| [Sterilization Type (2.8.2 - 1.0.0)](ValueSet-hl7VSsterilizationType.md) | Value Set of codes specifying the type of sterilization used for sterilizing the inventory supply item in the ITM segment. |
| [Student Status (2.8.2 - 1.0.0)](ValueSet-hl7VSstudentStatus.md) | Value Set of codes that designate whether a guarantor is a full or part time student. |
| [Substance Status (2.8.2 - 1.0.0)](ValueSet-hl7VSsubstanceStatus.md) | Value Set of codes identifying the status of the inventoried item. The status indicates the current status of the substance. |
| [Substance Type (2.8.2 - 1.0.1)](ValueSet-hl7VSsubstanceType.md) | Value Set of codes identifying the type of substance. |
| [Substitution Status (2.8.2 - 1.1.0)](ValueSet-hl7VSsubstitutionStatus.md) | Value Set of codes that specify the substitution status. |
| [Subtype of Referenced Data (2.8.2 - 1.2.1)](ValueSet-hl7VSsubtypeOfReferencedData.md) | A subset of the IANA media subtypes of binary data that are encoded in an ascii structure or stream. |
| [Supply Risk Codes (2.8.2 - 1.0.0)](ValueSet-hl7VSsupplyRiskCodes.md) | Value Set of codes specifying any known or suspected hazard associated with this material item. |
| [TQ Conjunction ID (2.8.2 - 1.1.0)](ValueSet-hl7VStqConjunctionId.md) | Value Set of codes that specify that a second timing specification is to follow using the repeat delimiter. |
| [Tax status (2.8.2 - 1.0.0)](ValueSet-hl7VStaxStatus.md) | Value Set of codes used to specify the tax status of a provider. |
| [Telecommunication Equipment Type (2.8.2 - 1.2.0)](ValueSet-hl7VStelecommunicationEquipmentType.md) | Concepts for specifying a type of telecommunication equipment. |
| [Telecommunication Expiration Reason (2.8.2 - 1.0.0)](ValueSet-hl7VStelecommunicationExpirationReason.md) | Value Set of codes specifying the reason this contact number/email was marked as "ended". |
| [Telecommunication Use Code (2.8.2 - 1.2.0)](ValueSet-hl7VStelecommunicationUseCode.md) | Concepts for specifying a specific use of a telecommunication number. |
| [Time Delay Post Challenge (2.8.2 - 1.0.0)](ValueSet-hl7VStimeDelayPostChallenge.md) | Value Set of codes that classify an observation definition as being a component of a challenge test. |
| [Time Selection Criteria Parameter Class Codes (2.8.2 - 1.1.0)](ValueSet-hl7VStimeSelectionCriteriaParameterClassCodes.md) | Value Set of codes that describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling. |
| [Tissue Type Code (2.8.2 - 1.0.0)](ValueSet-hl7VStissueTypeCode.md) | Value Set of codes that specify the type of tissue removed from a patient during a procedure. |
| [Transaction Type (2.8.2 - 1.1.0)](ValueSet-hl7VStransactionType.md) | Value Set of codes that specify a type of financial transaction. |
| [Transfer Type (2.8.2 - 1.0.0)](ValueSet-hl7VSdrgTransferType.md) | Value Set of codes that specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG's), for example, exempt or non-exempt. |
| [Transfusion Adverse Reaction (2.8.2 - 1.0.0)](ValueSet-hl7VStransfusionAdverseReaction.md) | Value Set of codes that specify the type of adverse reaction that the recipient of the blood product experienced. |
| [Transport Arranged (2.8.2 - 1.0.0)](ValueSet-hl7VStransportArranged.md) | Value Set of codes defining whether patient transportation preparations are in place. |
| [Transportation Mode (2.8.2 - 1.0.0)](ValueSet-hl7VStransportationMode.md) | Value Set of codes that specify how (or whether) to transport a patient, when applicable, for an ordered service. |
| [Tray Type (2.8.2 - 1.0.0)](ValueSet-hl7VStrayType.md) | Value Set of codes that specify the type of dietary tray. |
| [Treatment (2.8.2 - 1.0.0)](ValueSet-hl7VStreatment.md) | Value Set of codes that identify the specimen treatment performed during lab processing. |
| [Triage Code (2.8.2 - 1.0.0)](ValueSet-hl7VStriageCode.md) | Value Set of codes specifying a patient's prioritization within the context of this abstract. |
| [Type of Referenced Data (2.8.2 - 1.3.0)](ValueSet-hl7VStypeOfData.md) | Concepts declaring the general type of media data that is encoded. |
| [Universal ID Type (2.8.2 - 1.2.0)](ValueSet-hl7VSuniversalIdType.md) | Types of UID (Universal Identifiers). |
| [User Authentication Credential Type Code (2.8.2 - 1.0.0)](ValueSet-hl7VSuserAuthenticationCredentialTypeCode.md) | Value Set of codes that specify a type of user authentication credential. |
| [Vaccines Administered (2.8.2 - 1.5.0)](ValueSet-PHVS_VaccinesAdministeredCVX_CDC_NIP.md) | Value Set of codes that specify the administered vaccines. The values are maintained by the US Centers of Disease Control.. The code system is maintained by the CDC, and may be found at URL; https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.1 |
| [Version ID (2.8.2 - 1.12.0)](ValueSet-hl7VSversionControlTable.md) | Concepts which are used to identify an HL7 version in the Version 2.x family of published standards. |
| [Visit Indicator (2.8.2 - 1.0.0)](ValueSet-hl7VSvisitIndicator.md) | Value Set of codes that specify the level on which data are being sent. It is the indicator used to send data at two levels, visit and account. HL7 recommends sending an "A" or no value when the data in the message are at the account level or "V" to i |
| [Visit Priority Code (2.8.2 - 1.0.0)](ValueSet-hl7VSvisitPriorityCode.md) | Value Set of codes that define a relative level of urgency applied to a patient visit. |
| [Visit User Code (2.8.2 - 1.0.0)](ValueSet-hl7VSvisitUserCode.md) | Value Set of codes that specify categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis. |
| [Yes/No Indicator (2.8.2 - 1.0.0)](ValueSet-hl7VSyes-no-Indicator.md) | Codes specifying either Yes or No used in fields containing binary answers generally user-specified. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Accept/Application Acknowledgment Conditions (2.8.2 - 1.0.0)](CodeSystem-accept-applicationAcknowledgmentConditions.md) | HL7-defined code system of concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. Used in HL7 Versions 2 messaging in the MSH segment. |
| [Access Restriction Reason Code (2.8.2 - 1.0.0)](CodeSystem-accessRestrictionReason.md) | Code system of concepts specifying the reason for the restricted access. Used in HL7 Version 2.x messaging in the ARV segment. |
| [Access Restriction Value (2.8.2 - 1.0.0)](CodeSystem-accessRestrictionValue.md) | Code system of concepts specifying the information to which access is restricted. Used in HL7 Version 2.x messaging in the ARV segment. Note that these new codes as of November 2018 have been temporarily loaded into this V2 code system pending availability of the currently unavailable new tooling, at which time this code systrem will be retired and a value set of codes from the HL7 V3 ActCode code system will be used instead for this table. |
| [Acknowledgment Code (2.8.2 - 1.2.0)](CodeSystem-acknowledgmentCodes.md) | HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see message processing rules in the published Standard. Used in HL7 Version 2.x messaging in the MSA segment. |
| [ActPriority (2.8.2 - 1.0.0)](CodeSystem-actpriority.md) | HL7-defined code system of concepts specifying the priority for the shipment. Used in HL7 Version 2.x messaging in the SHP segment. |
| [Action Taken in Response to the Event (2.8.2 - 1.0.0)](CodeSystem-actionTakenInResponseToTheEvent.md) | HL7-defined code system of concepts used to define the action taken as a result of an event related to a product issue. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Active/Inactive (2.8.2 - 1.0.0)](CodeSystem-active-inactive.md) | HL7-defined code system of concepts specifying whether a person is currently a valid staff member. Used in HL7 Version 2.x messaging in the STF segment. |
| [Additive/Preservative (2.8.2 - 2.0.0)](CodeSystem-additivePreservative.md) | HL7-defined code system of concepts specifying any additive introduced to the specimen before or at the time of collection. These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen. Used in HL7 Version 2.x messaging in the SPM and SAC segments. |
| [Address Expiration Reason (2.8.2 - 1.0.0)](CodeSystem-addressExpirationReason.md) | Code system of concepts specifying the reason this address was marked as "ended". Used in HL7 Version 2.x messaging in the XAD segment. |
| [Address Type (2.8.2 - 1.5.0)](CodeSystem-addressType.md) | HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.x messaging in the XAD segment. |
| [Address Usage (2.8.2 - 1.0.0)](CodeSystem-addressUsage.md) | HL7-defined code system of concepts specifying how an address is intended to be used. Used in HL7 Version 2.x messaging in the XAD segment. |
| [Adjustment Action (2.8.2 - 1.0.0)](CodeSystem-adjustmentAction.md) | Code system of concepts used to specify the action requested of the party that receives an adjustment. Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging. |
| [Adjustment Category Code (2.8.2 - 1.0.0)](CodeSystem-adjustmentCategory.md) | Code system of concepts used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason. Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging. |
| [Administration Device (2.8.2 - 1.0.0)](CodeSystem-administrationDevice.md) | Code system of concepts which specify the mechanical device used to aid in the administration of the drug or other treatment. Common examples are IV-sets of different types. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Administration Method (2.8.2 - 1.0.0)](CodeSystem-administrationMethod.md) | Code system of concepts which specify the specific method requested for the administration of the drug or treatment to the patient. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Administrative Sex (2.8.2 - 1.0.0)](CodeSystem-administrativeSex.md) | Code system of concepts specifying a patient's sex for administrative purposes. Used in HL7 Version 2.x messages in the PID segment. |
| [Admission Level of Care Code (2.8.2 - 1.0.0)](CodeSystem-admissionLevelOfCare.md) | Code system of concepts specifying the acuity level assigned to the patient at the time of admission. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [Admission Type (2.8.2 - 1.1.0)](CodeSystem-admissionType.md) | Code system of concepts specifying the circumstances under which the patient was or will be admitted. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Advanced Beneficiary Notice Code (2.8.2 - 1.0.0)](CodeSystem-advancedBeneficiaryNotice.md) | Code system of concepts specifying the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service. Used in HL7 Version 2.x messaging in the ORC and FT1 segments. |
| [Alert Device Code (2.8.2 - 1.0.0)](CodeSystem-alertDevice.md) | Code system of concepts specifying any type of allergy alert device the patient may be carrying or wearing. Used in HL7 Version 2.x messaging in the IAM segment. |
| [Alert Level (2.8.2 - 1.0.0)](CodeSystem-alertLevel.md) | HL7-defined code system of concepts that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event). Used in the Equipment Detail (EQU) and Notification Detail (NDS) segments in HL7 Version 2.x messaging. |
| [Allergen Type (2.8.2 - 1.1.0)](CodeSystem-allergenType.md) | Code system of concepts speciying a classification of general allergy categories (drug, food, pollen, etc.). Used in HL7 Version 2.x messaging in the AL1 segment. |
| [Allergy Clinical Status (2.8.2 - 1.0.0)](CodeSystem-allergyClinicalStatus.md) | Code system of concepts specifying the verification status for the allergy. Used in HL7 Version 2.x messaging in the IAM segment. |
| [Allergy Severity (2.8.2 - 1.1.0)](CodeSystem-allergySeverity.md) | Code system of concepts which specify the general severity of an allergy. Used in HL7 Version 2.x messaging in the AL1 segment. |
| [Allow Substitution Codes (2.8.2 - 1.1.0)](CodeSystem-allowSubstitution.md) | Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the AIS and AIG segments. |
| [Alternate Character Set Handling Scheme (2.8.2 - 1.1.0)](CodeSystem-alternateCharacterSetHandlingScheme.md) | HL7-defined code system of concept that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Alternate Character Sets (2.8.2 - 1.4.0)](CodeSystem-alternateCharacterSets.md) | HL7-defined code system of concepts used to specify the character set(s) in use. Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment. |
| [Ambulatory Payment Classification Code (2.8.2 - 1.0.0)](CodeSystem-ambulatoryPaymentClassification.md) | Code system of concepts specifying the derived Ambulatory Payment Classification (APC) code. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [Ambulatory Status (2.8.2 - 1.0.0)](CodeSystem-ambulatoryStatus.md) | Code system of concepts specifying permanent or transient handicapped conditions of a person. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Amount Class (2.8.2 - 1.0.0)](CodeSystem-amountClass.md) | Code system of concepts specifying the amount quantity class. Used in HL7 Version 2.x messaging in the PTA segment. |
| [Amount Type (2.8.2 - 1.0.0)](CodeSystem-amountType.md) | Code system of concepts which specify amount quantity type. Used in HL7 Version 2.x messaging in the RMC segment. |
| [Analyte Repeat Status (2.8.2 - 1.0.0)](CodeSystem-analyteRepeatStatus.md) | HL7-defined code system of concepts identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex). The following are assumptions regarding the table values: Repeated without dilution — performed usually to confirm correctness of results (e.g., in case of results flagged as "Panic" or mechanical failures). Repeated with dilution — performed usually in the case the original result exceeded the measurement range (technical limits). Reflex test — this test is performed as the consequence of rules triggered based on other test result(s). Used in HL7 Version 2.x messaging in the Test Code Detail (TCD) segment. |
| [Annotations (2.8.2 - 1.0.0)](CodeSystem-annotations.md) | Code system of concepts specifying the coded entry associated with a given point in time during the waveform recording. Used in HL7 Version 2.x messaging in the Observation Result (OBX) Another Observation (ANO) segments. |
| [Appointment Reason Codes (2.8.2 - 1.0.0)](CodeSystem-appointmentReason.md) | Code system of concepts used to describe the kind of appointment or the reason why an appointment has been scheduled. Used in HL7 Version 2.x messaging in the ARQ segment. |
| [Appointment Type Codes (2.8.2 - 1.0.0)](CodeSystem-appointmentType.md) | Code system of concepts used in an appointment request to describe the kind of appointment. Used in HL7 Version 2.x messaging in the ARQ segment. |
| [Arm Stick (2.8.2 - 1.0.0)](CodeSystem-armStick.md) | HL7-defined code system of concepts specifying the arm(s) receiving the stick. Used in HL7 Version 2.x messaging in the DON segment. |
| [Artificial Blood (2.8.2 - 1.0.0)](CodeSystem-artificialBlood.md) | Code system of concepts that identify the artificial blood identifier associated with the specimen. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [Assignment of Benefits (2.8.2 - 1.0.0)](CodeSystem-assignmentOfBenefits.md) | Code system of concepts which indicate whether an insured person agreed to assign the insurance benefits to the healthcare provider. If so, the insurance will pay the provider directly. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [Authorization Mode (2.8.2 - 1.0.0)](CodeSystem-authorizationMode.md) | HL7-defined code system of concepts of forms of authorization a recorder may receive from the responsible practitioner to create or change an order. Used in HL7 Version 2.x messaging in the ORC segment. |
| [BP Observation Status Codes Interpretation (2.8.2 - 1.0.0)](CodeSystem-bpObservationStatusCodesInterpretation.md) | HL7-defined code system of concepts used to specify the interpretation for the blood product observation status codes. A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first cross-matched and a status message is sent, it would be considered preliminary. When the product is dispensed to the patient, that status would also be considered preliminary. However, once the product is transfused, the status would be considered final. Used in the Blood Product Dispense Status (BPX) and Blood Product Transfusion/Disposition (BTX) segments in HL7 Version 2.x messaging. |
| [Bed Status (2.8.2 - 1.1.0)](CodeSystem-bedStatus.md) | Code system of concepts which specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. Used in HL7 Version 2.x messaging in the DLD and PV1 segments. |
| [Blood Product Code (2.8.2 - 1.0.0)](CodeSystem-bloodProduct.md) | HL7-defined code system of concepts which specify a type of blood product. Used in HL7 Version 2 messaging in the BLC segment. |
| [Blood Product Dispense Status (2.8.2 - 1.0.0)](CodeSystem-bloodProductDispenseStatus.md) | HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the filler or placer. For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it first becomes linked to a patient and is ready to dispense. The placer system may use the Blood Product Dispense Status Message to request the transfusion service to dispense the product. When the blood product is delivered or issued to a patient, the status of the blood product would be changed to indicate that it has now been "dispensed". Used in the Blood Product Dispense Status (BPX) segment in HL7 Version 2.x messaging. |
| [Blood Product Processing Requirements (2.8.2 - 1.0.0)](CodeSystem-bloodProductProcessingRequirements.md) | Code system of concepts used to specify additional information about the blood component class associated with the Universal Service ID. The placer of the order can specify any required processing of the blood product that must be completed prior to transfusion to the intended recipient. Used in the Blood Product Order (BPO) segment in HL7 Version 2.x messaging. |
| [Blood Product Transfusion/Disposition Status (2.8.2 - 1.0.0)](CodeSystem-bloodProductTransfusion-dispositionStatus.md) | HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the placer. For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been "transfused." Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging. |
| [Blood Unit Type (2.8.2 - 1.0.0)](CodeSystem-bloodUnitType.md) | HL7-defined code system of concepts used to specify the type of blood unit. Used in the Blood Unit Information (BUI) segment in HL7 Version 2.x messaging. |
| [Body Parts (2.8.2 - 1.1.0)](CodeSystem-bodyParts.md) | HL7-defined code system of concepts specifying the part of the body. Used in HL7 Version 2 messaging in the RXR segment. |
| [Body Site (2.8.2 - 1.2.0)](CodeSystem-bodySite.md) | HL7-defined code system of concepts that specify a body site from which a specimen is obtained. Used in HL7 Version 2.x messaging in the OBX and CH7 segments. |
| [Body Site Modifier (2.8.2 - 1.0.0)](CodeSystem-bodySiteModifier.md) | HL7-defined code system of concepts specifying the modifier for the body site. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Bolus Type (2.8.2 - 1.0.0)](CodeSystem-bolusType.md) | HL7-defined code system of concepts specifying the type of bolus. Used in HL7 Version 2.x messaging in the RXV segment. |
| [CCL Value (2.8.2 - 1.0.0)](CodeSystem-cclValue.md) | Code system of concepts specifying the clinical complexity level (CCL) value for the determined diagnosis related group (DRG) for this diagnosis. US Realm. Used in HL7 Version 2.x messaging in the DG1 segment. |
| [CP Range Type (2.8.2 - 1.0.0)](CodeSystem-cpRangeType.md) | HL7-defined code system of concepts used to define a type of range used in composite pricing in financial transacxtions. Used in HL7 Version 2 messaging in the CP datatype. |
| [CWE statuses (2.8.2 - 1.0.0)](CodeSystem-cweStatuses.md) | HL7-defined code system of comcepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended). These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in HL7 Version 2.x messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype. |
| [Calendar Alignment (2.8.2 - 1.0.0)](CodeSystem-calendarAlignment.md) | HL7-defined code system of concepts used to specify an alignment of the repetition to a calendar (e.g., to distinguish every 30 days from "the 5th of every month"). Used in HL7 Version 2 messaging in the RPT segment. |
| [Causality Observations (2.8.2 - 1.0.0)](CodeSystem-causalityObservations.md) | HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Certificate Status (2.8.2 - 1.0.0)](CodeSystem-certificateStatus.md) | Code system of concepts specifying the status of the certificate held by the health professional. Used in HL7 Version 2 messaging in the CER segment. |
| [Certification Category Code (2.8.2 - 1.0.0)](CodeSystem-certificationCategory.md) | Code system of concepts specifying the code for the certification category. Used in HL7 Version 2.x messaging in the IN3 segment. |
| [Certification Patient Type (2.8.2 - 1.0.0)](CodeSystem-certificationPatientType.md) | Code system of concepts which specify the category or type of patient for which this certification is requested. Used in HL7 Version 2.x messaging in the ICD segment. |
| [Certification Status (2.8.2 - 1.0.0)](CodeSystem-certificationStatus.md) | HL7-defined code system of concepts used to specify the status of the practitioner's speciality certification. Used in HL7 Version 2.x messaging in the Specialty Description (SPD) value and Practitioner Detail (PRA) segment. |
| [Certification Type Code (2.8.2 - 1.0.0)](CodeSystem-certificationType.md) | Code system of concepts specifying the code for the certification type. Used in HL7 Version 2.x messaging in the IN3 segment. |
| [Charge On Indicator (2.8.2 - 1.0.0)](CodeSystem-chargeOnIndicator.md) | Code system of concepts used to define the event upon which a charge should be generated. Used in HL7 Version 2.x messaging in the PRC segment. |
| [Charge Type (2.8.2 - 1.0.0)](CodeSystem-chargeType.md) | HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service. Used in HL7 Version 2.x messaging in the BLG segment. |
| [Charge Type Reason (2.8.2 - 1.0.0)](CodeSystem-chargeTypeReason.md) | Code system of concepts specifying the choice of, and providing the clinical rationale for, a selected charge type. Used in HL7 Version 2.x messaging in the BLG segment. |
| [Check Digit Scheme (2.8.2 - 1.3.0)](CodeSystem-checkDigitScheme.md) | HL7-defined code system of concepts specifying the check digit scheme employed. Used in HL7 Version 2.x messaging in PPN, XCN and XON segments. |
| [Coding System (2.8.2 - 1.8.0)](CodeSystem-codingSystem.md) | HL7-defined code system of concepts specifying the coding system. This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm. Used in HL7 Version 2.x messaging in the CWE segment. |
| [Collection Event/Process Step Limit (2.8.2 - 1.0.0)](CodeSystem-collectionEvent.md) | HL7-defined code system of concepts specifying the limit for the collection event or process step. Used in HL7 Version 2.x messaging in the OMC segment. |
| [Command Response (2.8.2 - 1.0.1)](CodeSystem-commandResponse.md) | Code system of concepts identifying the response of the previously issued command. Used in HL7 Version 2.x messaging in the Equipment Command Response (ECR) and Interaction Status Detail (ISD) segments. |
| [Comment Type (2.8.2 - 1.0.0)](CodeSystem-commentType.md) | Code system of concepts that identify the type of comment text being sent in the specific comment record. Used in the Notes and Comments (NTE) segment in HL7 Version 2.x messaging. |
| [Communication Location (2.8.2 - 1.0.0)](CodeSystem-communicationLocation.md) | HL7-defined code system of concepts specifying the communication location. Used in HL7 Version 2.x messaging in the OMC segment. |
| [Completion Status (2.8.2 - 1.0.0)](CodeSystem-completionStatus.md) | HL7-defined code system of concepts specifying the status of the treatment administration event segment. Used in HL7 Version 2.x messaging in the Pharmacy Order Administration (RXA) segment. |
| [Computation Type (2.8.2 - 1.0.0)](CodeSystem-computationType.md) | HL7-defined code system of concepts used to specify if the change is computed as a percent change or as an absolute change. Used in the Delta (DLT) segment in HL7 Version 2.x messaging. |
| [Confidentiality (2.8.2 - 1.0.0)](CodeSystem-confidentiality.md) | HL7-defined code system of concepts specifying the confidentiality for the shipment. Used in HL7 Version 2.x messaging in the SHP segment. |
| [Confidentiality Code (2.8.2 - 1.0.0)](CodeSystem-confidentialityCodes.md) | Code system of concepts specifying the degree to which special confidentiality protection should be applied to the observation. Used in HL7 Version 2.x messaging in the OM1 and ORC segments. |
| [Consent Bypass Reason (2.8.2 - 1.0.0)](CodeSystem-consentBypassReason.md) | Code system of concepts specifying the reason the subject's consent was not sought. Used in HL7 Version 2.x messaging in the CON segment. |
| [Consent Disclosure Level (2.8.2 - 1.0.0)](CodeSystem-consentDisclosureLevel.md) | HL7-defined code system of concepts specifying how much information was disclosed to the subject as part of the informed consent process. Used in HL7 Version 2.x messaging in the CON segment. |
| [Consent Mode (2.8.2 - 1.0.0)](CodeSystem-consentMode.md) | HL7-defined code system of concepts specifying the method in which a subject provides consent. Used in HL7 Version 2.x messaging in the TXA and CON segments. |
| [Consent Non-Disclosure Reason (2.8.2 - 1.0.0)](CodeSystem-consentNon-disclosureReason.md) | Code system of concepts used to specify a reason the subject did not receive full disclosure. Used in the Consent (CON) segment in HL7 Version 2.x messaging. |
| [Consent Status (2.8.2 - 1.0.0)](CodeSystem-consentStatus.md) | HL7-code system of concepts specifying whether the consent has been sought and granted. Used in HL7 Version 2.x messaging in the TXA and CON segments. |
| [Consent Type (2.8.2 - 1.0.0)](CodeSystem-consentType.md) | Code system of concepts specifying to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event. Used in HL7 Version 2.x messaging in the TXA and CON segments. |
| [Contact Role (2.8.2 - 1.0.0)](CodeSystem-contactRole2.md) | Code system of concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral. Used in HL7 Version 2 messaging in the NK1 and CTD segments after 2.5, when it replace 2.16.840.1.113883.18.57. |
| [Container Condition (2.8.2 - 1.0.0)](CodeSystem-containerCondition.md) | HL7-defined code system of concepts used to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab. If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons. Used in the Specimen (SPM), Shipment (SHP) and Shipment Package (PAC) segments in HL7 Version 2.x messaging. |
| [Container Status (2.8.2 - 1.0.0)](CodeSystem-containerStatus.md) | HL7-defined code system of concepts that identify the status of the unique container in which the specimen resides at the time the transaction was initiated. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [Continuation Style Code (2.8.2 - 1.0.0)](CodeSystem-continuationStyle.md) | HL7-defined code system of concepts identifying whether it is a fragmented message or part of an interactive continuation message. Used in HL7 Version 2.x messaging in the Continuation Pointer (DSC) segment. |
| [Controlled Substance Schedule (2.8.2 - 1.0.0)](CodeSystem-controlledSubstanceSchedule.md) | Code system of concepts specifying the class of the drug or other substance if its usage is controlled by legislation. In the USA, such legislation includes the federal Controlled Substance Act (CSA) or a State Uniform Controlled Substance Act. Other countries should create their own versions of this table. Used in HL7 Version 2.x messaging in the RXE segment. The name of the table is taken from the Pharmacy Law Digest July 1988. |
| [Coordination of Benefits (2.8.2 - 1.0.0)](CodeSystem-coordinationOfBenefits.md) | Code system of concepts specifying whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [Coverage Type (2.8.2 - 1.1.0)](CodeSystem-coverageType.md) | Code system of concepts specifying the type of insurance coverage or what types of services are covered for the purposes of a billing system. For example, a physician billing system will only want to receive insurance information for plans that cover physician/professional charges. Used in HL7 Version 2.x messaging in the Insurance (IN1) segment. |
| [Cumulative Dosage Limit UoM (2.8.2 - 1.0.0)](CodeSystem-cumulativeDosageLimitUom.md) | Code system of concepts specifying the unit of measure (UoM) for the cumulative dosage limit. Used in HL7 Version 2.x messaging in the CDO segment. |
| [Cycle Type (2.8.2 - 1.0.0)](CodeSystem-cycleType.md) | Code system of concepts specifying the type of cycle that is being executed. A cycle type is a specific sterilization method used for a specific type of supply item. Used in HL7 Version 2.x messaging in the SCD segment. |
| [Cyclic Entry/Exit Indicator (2.8.2 - 1.0.0)](CodeSystem-cyclicEntryExitIndicator.md) | HL7-defined code system of concepts used to specify if this service request is the first or last service request in a cyclic series of service requests. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. |
| [DRG Diagnosis Determination Status (2.8.2 - 1.0.0)](CodeSystem-drgDiagnosisDeterminationStatus.md) | HL7-defined cCode system of concepts specifying the status of a diagnosis for a diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DG1 segment. |
| [DRG Grouping Status (2.8.2 - 1.0.0)](CodeSystem-drgGroupingStatus.md) | Code system of concepts specifying the status of the use of the gender information for diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [DRG Procedure Determination Status (2.8.2 - 1.0.0)](CodeSystem-drgProcedureDeterminationStatus.md) | Code system of concepts specifying the status of the use of this particular procedure for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the PR1 segment. |
| [DRG Procedure Relevance (2.8.2 - 1.0.0)](CodeSystem-drgProcedureRelevance.md) | Code system of concepts specifying the relevance of this particular procedure for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the PR1 segment. |
| [DRG Status Financial Calculation (2.8.2 - 1.0.0)](CodeSystem-drgStatusFinancialCalculation.md) | Code system of concepts specifying the status of the diagnosis related group (DRG) calculation regarding the financial aspects. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [DRG Status Patient (2.8.2 - 1.0.0)](CodeSystem-drgStatusPatient.md) | Code system of concepts specifying whether the length of stay is normal or respectively shorter or longer than normal. Used in HL7 Version 2.x messaging in the DRG segment. |
| [DRG Status Respiration Minutes (2.8.2 - 1.0.0)](CodeSystem-drgStatusRespirationMinutes.md) | Code system of concepts specifying the status of the use of the respiration minutes information for diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [Data Types (2.8.2 - 1.2.0)](CodeSystem-dataTypes.md) | HL7-defined code system of concepts specifying the format of the observation value in the Observation Result (OBX). Used in HL7 Version 2.x messaging in the OBX, OM1, OM3 and OMC segments. |
| [Date Format (2.8.2 - 1.0.0)](CodeSystem-dateFormat.md) | Code system of concepts that identify the date format for a decontamination/sterilization instance. Used in HL7 Version 2.x messaging in the SCP segment. |
| [Day Type (2.8.2 - 1.0.0)](CodeSystem-dayType.md) | Code system of concepts which specify whether the days are denied, pending or approved. Used in HL7 Version 2.x messaging in the DTN segment. |
| [Days of the Week (2.8.2 - 1.0.0)](CodeSystem-daysOfTheWeek.md) | HL7-defined code system of concepts used to identify the day(s) of the week when a location may be scheduled for appointments. Used in HL7 Version 2.x messaging in the UVC and LDP segments. |
| [Degree/License/Certificate (2.8.2 - 2.1.0)](CodeSystem-degreeLicenseCertificate.md) | Code system of concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging. Used in HL7 Version 2.x messaging in the CNN segment; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7. |
| [Denial or Rejection Code (2.8.2 - 1.0.0)](CodeSystem-denialOrRejectionType.md) | Code system of concepts specifying the OCE status of the line item. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [Derived Specimen (2.8.2 - 1.0.0)](CodeSystem-derivedSpecimen.md) | HL7-defined code system of concepts which specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture). The process also produces new "specimens" (e.g., pure culture of staphylococcus, and E. coli), and these are studied by a second order process (bacterial sensitivities). The parents (e.g., blood culture) and children (e.g., penicillin MIC) are identified in such cases. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [Device Data State (2.8.2 - 1.0.0)](CodeSystem-deviceDataState.md) | Code system of concepts that define the state of the data as provided from a device. Used in HL7 Version 2.x messaging in the SDD segment. |
| [Device Status (2.8.2 - 1.0.0)](CodeSystem-deviceStatus.md) | Code system of concepts that communicate the state of a device. Used in HL7 Version 2.x messaging in the SCD segment. |
| [Diagnosis Classification (2.8.2 - 1.0.0)](CodeSystem-diagnosisClassification.md) | Code system of concepts used to classify whether a patient visit can be related to a diagnosis. Used in HL7 Version 2.x messaging in the DG1 segment. |
| [Diagnosis Priority (2.8.2 - 1.0.0)](CodeSystem-diagnosisPriority.md) | Code system of concepts that identify the significance or priority of the diagnosis code. Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis. Used in the DG1 segment in HL7 Version 2.x messaging. The predefined codes are the most common, and just a starter set, as the codes are an unbounded list; additional ranked procedures may be signified by incrementing the code value as needed. |
| [Diagnosis Type (2.8.2 - 1.0.0)](CodeSystem-diagnosisType.md) | Code system of concepts specifying a type of diagnosis being sent. Used in HL7 Version 2.x messaging in the DG1 segment.. |
| [Diagnostic Service Section ID (2.8.2 - 1.5.0)](CodeSystem-diagnosticServiceSectionId.md) | HL7-defined code system of concepts which specify a section of a diagnostic service where the observation may be performed. Used in HL7 Version 2.x messaging in the OBR and OM4 segments. |
| [Diet Code Specification Type (2.8.2 - 1.0.0)](CodeSystem-dietCodeSpecificationType.md) | HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version 2.x messaging in the ODS segment. |
| [Disabled Person Code (2.8.2 - 1.0.0)](CodeSystem-disabilityInformationRelationship.md) | Code system of concepts used to specify to which person the disability information relates in the message. For example, if the value is PT, the disability information relates to the patient. Used in HL7 Version 2.x messaging in the Disability (DB1) segment. |
| [Dispense Method (2.8.2 - 1.0.0)](CodeSystem-dispenseMethod.md) | HL7-definde code system of concepts specifying the method by which treatment is dispensed. Used in HL7 Version 2.x messaging in the Pharmacy/Treatment Encoded order (RXE) and Pharmacy/Treatment dispense (RXD) segments. |
| [Dispense Type (2.8.2 - 1.0.0)](CodeSystem-dispenseType.md) | Code system of concepts specifying the type of dispensing event that occurred. Used in HL7 Version 2.x messaging in the RXD segment. |
| [Document Availability Status (2.8.2 - 1.1.0)](CodeSystem-documentAvailabilityStatus.md) | HL7-defined code system of concepts used to define whether a patient document is appropriate or available for use in patient care. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Document Completion Status (2.8.2 - 1.0.0)](CodeSystem-documentCompletionStatus.md) | HL7-defined code system of concepts used to record the state of a document in a workflow. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Document Confidentiality Status (2.8.2 - 2.0.0)](CodeSystem-documentConfidentialityStatus2.md) | HL7-defined code system of concetps used to identify the degree to which special confidentiality protection should be applied to this information. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Document Storage Status (2.8.2 - 1.0.0)](CodeSystem-documentStorageStatus.md) | HL7-defined code system of concepts used to describe the availability of a document in relation to the type of storage. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Document Type (2.8.2 - 1.0.0)](CodeSystem-documentType.md) | Code system of concepts used to identify the kind of patient document. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Duration Categories (2.8.2 - 1.1.0)](CodeSystem-durationCategories.md) | Code system of concepts used to classify an observation definition as intended to measure a patient's state at a point in time. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Eligibility Source (2.8.2 - 1.0.0)](CodeSystem-eligibilitySource.md) | Code system of concepts which specify the source of information about the insured's eligibility for benefits. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [Employment Status (2.8.2 - 2.0.0)](CodeSystem-employmentStatus.md) | HL7-defined code system of concepts which specify an employment status of a person. Used in HL7 Version 2 messaging in the GT1 segment. |
| [Encoding (2.8.2 - 1.0.0)](CodeSystem-encoding.md) | HL7-defined code system of concept identifying the type of encoding used to represent successive octets of binary data as displayable ASCII characters. These are defined by IETF; more information may be found at https://www.ietf.org/rfc/rfc1521.txt. Used in HL7 Version 2.x messaging in the ED datatypes. |
| [Equipment State (2.8.2 - 1.1.0)](CodeSystem-equipmentState.md) | HL7-defined code system of concepts that identify the status the equipment was in at the time the transaction was initiated. Used in HL7 Version 2.x messaging in the EQU segment. |
| [Error Severity (2.8.2 - 1.1.0)](CodeSystem-errorSeverity.md) | HL7-defined code system of concepts specifying the severity of an application error as reported during acknowledgment of messages. Knowing if something is Error, Warning or Information is intrinsic to how an application handles the content and the information flow. Used in HL7 Version 2.x messaging acknowledgment in the ERR segment. |
| [Escort Required (2.8.2 - 1.0.0)](CodeSystem-escortRequired.md) | HL7-defined code system of concepts defining whether patient transportation preparations are in place. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Event (2.8.2 - 1.10.0)](CodeSystem-event.md) | HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Event Consequence (2.8.2 - 1.0.0)](CodeSystem-eventConsequence.md) | HL7-defined code system of concepts used to describe the impact of an event on a patient. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Event Expected (2.8.2 - 1.0.0)](CodeSystem-eventExpected.md) | HL7-defined code system of concepts used to communicate whether an event has been judged to be expected or unexpected. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Event Qualification (2.8.2 - 1.0.0)](CodeSystem-eventQualification.md) | HL7-defined code system of concepts used to qualify an event related to a product experience. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Event Reason (2.8.2 - 1.3.0)](CodeSystem-eventReason.md) | Code system of concepts which specify the reason for an event. Used in HL7 Version 2.x messaging in the EVN segment. |
| [Event Related Period (2.8.2 - 1.0.0)](CodeSystem-eventRelatedPeriod.md) | HL7-defined code system of concepts specifying a common (periodical) activity of daily living. Used in HL7 Version 2 messaging in the RPT segment. |
| [Event Reported To (2.8.2 - 1.0.0)](CodeSystem-eventReportedTo.md) | HL7-defined code system of concepts used to identify the type of entity to which the even has been reported. Used in HL7 Version 2.x messaging in the PES segment. |
| [Event Seriousness (2.8.2 - 1.0.0)](CodeSystem-eventSeriousness.md) | HL7-defined code system of concepts used by a sender to designate an event as serious or significant. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Event Type (2.8.2 - 1.0.0)](CodeSystem-eventType.md) | HL7-defined code system of concepts specifying the type of event of the message. Used in HL7 Version 2.x messaging in the EQP segment. |
| [Exclusive Test (2.8.2 - 1.0.0)](CodeSystem-exclusiveTest.md) | HL7-defined code system of concepts that define if a test should be a specific event with no other tests to be performed with this test, or not, or other special circumstances. Used in HL7 Version 2.x messaging in Master Files (OM1 segment) to characterize observations in a master of such orderables. |
| [Expanded Yes/no Indicator (2.8.2 - 1.0.0)](CodeSystem-expandedYes-NoIndicator.md) | HL7-defined code system of concepts used to specify an expansion on the original Yes/No indicator table by including "flavors of null". It is intended to be applied to fields where the response is not limited to "yes" or "no". Used in numerous locations in HL7 Version 2.x messaging. |
| [Extended Priority Codes (2.8.2 - 1.0.0)](CodeSystem-extendedPriorityCodes.md) | Code system of concepts describing the urgency of a request carried in an order. Used in HL7 Version 2.x messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn). |
| [Facility Type (2.8.2 - 1.0.0)](CodeSystem-facilityType.md) | HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x messaging in the Facility (FAC) segment. |
| [File Level Event Code (2.8.2 - 1.0.0)](CodeSystem-file-levelEvent.md) | HL7-defined code system of concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. |
| [Filler Status Codes (2.8.2 - 1.2.0)](CodeSystem-fillerStatus.md) | Code system of concepts used to describe an appointment status from the perspective of the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the SCH segment. |
| [Formulary Status (2.8.2 - 1.0.0)](CodeSystem-formularyStatus.md) | HL7-defined code system of concepts specifying whether or not the pharmaceutical substance is part of the local formulary. Used in HL7 Version 2.x messaging in the RXE segment. |
| [Gestation Category Code (2.8.2 - 1.0.0)](CodeSystem-gestationCategory.md) | HL7-defined code system of concepts which specify the status of a birth in relation to the gestation. Used in HL7 Version 2 messaging in the ABS segment. |
| [Grouper Status (2.8.2 - 1.0.0)](CodeSystem-grouperStatus.md) | Code system of concepts specifying the status of a grouper in general. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [Health Care Provider Area of Specialization (2.8.2 - 1.0.0)](CodeSystem-healthCareProviderAreaOfSpecialization.md) | HL7-defined code system of concepts specifying the more specific service or occupation within the healthcare provider type of the practitioner at a specific organization unit. Used in HL7 Version 2.x messaging in the ORG segment. |
| [Health Care Provider Classification (2.8.2 - 1.0.0)](CodeSystem-healthCareProviderClassification.md) | HL7-defined code system of concepts specifying the more specific service or occupation within the healthcare provider type of the practitioner at a specific organization unit. Used in HL7 Version 2.x messaging in the ORG segment. |
| [Health Care Provider Type Code (2.8.2 - 1.0.0)](CodeSystem-healthCareProviderTypeCode.md) | HL7-defined code system of concepts specifying the major grouping of the service or occupation of the practitioner at a specific organization unit. Used in HL7 Version 2.x messaging in the ORG segment. |
| [Identifier Type (2.8.2 - 1.5.0)](CodeSystem-identifierType.md) | HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON. |
| [Identity May Be Divulged (2.8.2 - 1.0.0)](CodeSystem-identityMayBeDivulged.md) | HL7-defined code system of concepts used to define whether the primary observer has given permission for their identification information to be provided to a product manufacturer. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Identity Reliability Code (2.8.2 - 1.0.0)](CodeSystem-identityReliability.md) | Code system of concepts specifying the reliability of patient/person identifying data transmitted via a transaction. Used in HL7 Version 2.x messaging in the PID segment. |
| [Immunization Registry Status (2.8.2 - 1.0.0)](CodeSystem-immunizationRegistryStatus.md) | Code system of concepts specifying the immunization registry status of the patient. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [Inactive Reason Code (2.8.2 - 1.0.0)](CodeSystem-inactiveReason.md) | Code system of concepts specifying the reason the staff member is inactive. Used in HL7 Version 2 messaging in the STF segment. |
| [Incident Type Code (2.8.2 - 1.0.0)](CodeSystem-incidentType.md) | HL7-defined code system of concepts which specify a classification of types of incidents. Used in HL7 Version 2 messaging in the RMI segment. |
| [Indirect Exposure Mechanism (2.8.2 - 1.0.0)](CodeSystem-indirectExposureMechanism.md) | HL7-defined code system of concepts used to identify the mechanism of product transmission when the product has not been directly applied to the patient. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Inform Person Code (2.8.2 - 1.0.0)](CodeSystem-informInstructions.md) | Code system of concepts specifying who (if anyone) should or should not be informed of an error. Used in the Error (ERR) segment in HL7 Version 2.x messaging. |
| [Institution Relationship Type (2.8.2 - 1.0.0)](CodeSystem-institutionRelationshipType.md) | Code system of concepts specifying the relationship the staff person has with the institution for whom he/she provides services. Used in HL7 Version 2 messaging in the STF segment. |
| [Intended Procedure Type (2.8.2 - 1.0.0)](CodeSystem-intendedProcedureType.md) | HL7-defined code system of concepts specifying the type of intended procedure. Used in HL7 Version 2.x messaging in the DON segment. |
| [Interpretation Codes (2.8.2 - 2.2.0)](CodeSystem-observationInterpretation.md) | HL7-defined code system of concepts which specify a categorical assessment of an observation value. Used in HL7 Version 2.x messaging in the OBX segment. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. |
| [Invocation Event (2.8.2 - 1.0.0)](CodeSystem-invocationEvent.md) | HL7-defined code system of concepts which specify codes for an event precipitating/triggering a charge activity. Used in HL7 Version 2.x messaging in the CCD and BLG segments. |
| [Invoice Control Code (2.8.2 - 1.0.0)](CodeSystem-invoiceControl.md) | Code system of concepts used to specify what action is being performed by this message. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [Invoice Processing Results Status (2.8.2 - 1.0.0)](CodeSystem-invoiceProcessingResultsStatus.md) | Code system of concepts used to specify the processing status for an Invoice Processing Result. Used in the Invoice Processing Result (IPR) segment in HL7 Version 2.x messaging. |
| [Invoice Reason Codes (2.8.2 - 1.0.0)](CodeSystem-invoiceReason.md) | Code system of concepts used to specify the reason for this invoice. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [Invoice Type (2.8.2 - 1.0.0)](CodeSystem-invoiceType.md) | Code system of concepts used to specify the type of invoice. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [Item Status (2.8.2 - 1.0.0)](CodeSystem-itemStatus.md) | Code system of concepts specifying the status (useful for reporting and item usage purposes) that applies to an item. Used in HL7 Version 2.x messaging in the ITM segment. |
| [Item Type (2.8.2 - 1.0.0)](CodeSystem-itemType.md) | Code system of concepts specifying a classification of material items into like groups as defined and utilized within an operating room setting for charting procedures. Used in HL7 Version 2.x messaging in the ITM segment. |
| [Job Status (2.8.2 - 1.0.0)](CodeSystem-jobStatus.md) | HL7-defined code system of concepts specifying the next of kin/associated party's job status. Used in HL7 Version 2.x messaging in the Next of Kin/Associated Parties (NK1) segment. |
| [Jurisdictional Breadth (2.8.2 - 1.0.0)](CodeSystem-jurisdictionalBreadth.md) | Code system of concepts specifying the breadth/extent of the jurisdiction where the qualification is valid. Used in HL7 Version 2 messaging in the CER segment. |
| [Kind of Quantity (2.8.2 - 1.0.0)](CodeSystem-kindOfQuantity.md) | HL7 published code system of concepts that describe categories of an underlying kind of property represented by an observation. These are intended to distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth. These are discussed more fully in the LOINC Users’ Manual. These defined categories are derived from the approach described in 1995 edition of the IUPAC Silver Book. These distinctions are used in IUPAC and LOINC standard codes. Needs review by OO and HTA to determined if this is a value set built on LOINC part codes or some other external vocabulary. |
| [Labor Calculation Type (2.8.2 - 1.0.0)](CodeSystem-laborCalculationType.md) | Code system of concepts that identify the method used to calculate employee labor and measure employee productivity. Used in HL7 Version 2.x messaging in the SCP segment. |
| [Language Ability (2.8.2 - 1.0.0)](CodeSystem-languageAbility.md) | Code system of concepts which specify codes that indicate the ability that a Staff Member possesses with respect to the language. Used in HL7 Version 2.x messaging in the LAN segment. |
| [Language Proficiency (2.8.2 - 1.0.0)](CodeSystem-languageProficiency.md) | HL7-defined code system of concepts which specify a level of knowledge that a Staff Member possesses with respect to their language ability. Used in HL7 Version 2 messaging in the LAN segment. |
| [Level of Care (2.8.2 - 1.0.0)](CodeSystem-levelOfCare.md) | Code system of concepts used to identify the level of care a patient may be afforded when assigned to this location definition. Used in HL7 Version 2.x messaging in the LCH segment. |
| [Limitation Type Codes (2.8.2 - 1.0.0)](CodeSystem-limitationTypeCode.md) | HL7-defined code system of concepts specifying the type of limitation. Used in HL7 Version 2.x messaging in the DPS segment. |
| [Living Arrangement (2.8.2 - 1.1.0)](CodeSystem-livingArrangement.md) | Code system of concepts characterizing the situation that patient-associated parties live in at their residential address. Used in HL7 Version 2.x messaging in the NK1 and PD1 segments. |
| [Living Dependency (2.8.2 - 2.0.0)](CodeSystem-livingDependency2.md) | HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient’s healthcare needs. This information can be used for discharge planning. Examples might include Spouse Dependent, Medical Supervision Required, Small Children Dependent. Used in Version 2.s messaging in the NK1 segment. |
| [Living Will Code (2.8.2 - 1.0.0)](CodeSystem-livingWillCodes.md) | Code system of concepts specifying whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility. If the patient does not have a living will, the value of this field indicates whether the patient was provided information on living wills. Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments. |
| [Load Status (2.8.2 - 1.0.0)](CodeSystem-loadStatus.md) | Code system of concepts used to define the status of the information provided in a device sterilization or decontamination cycle. Used in HL7 Version 2.x messaging in the SDD segment. |
| [Local/Remote Control State (2.8.2 - 1.0.0)](CodeSystem-local-remoteControlState.md) | HL7-defined code system of concepts that identify the current state of control associated with the equipment. Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state). Used in the Equipment Detail (EQU) segment in HL7 Version 2.x messaging. |
| [Location Characteristic ID (2.8.2 - 1.0.0)](CodeSystem-locationCharacteristic.md) | Code system of concepts specifying an identifier code to show which characteristic is being communicated with the segment. Used in HL7 Version 2.x messaging in the Location Characteristic (LCH) segment. |
| [Location Equipment (2.8.2 - 1.0.0)](CodeSystem-locationEquipment.md) | Code system of concepts used to identify the equipment available in a location definition identified as a room or bed. Used in HL7 Version 2.x messaging in the LOC segment. |
| [Location Relationship ID (2.8.2 - 1.0.0)](CodeSystem-locationRelationship.md) | Code system of concepts specifying an identifier code to show which relationship is being communicated with the segment. Used in HL7 Version 2.x messaging in the Location Relationship (LRL) segment. |
| [Location Service Code (2.8.2 - 1.0.0)](CodeSystem-locationServiceType.md) | Code system of concepts specifying the types of services provided by the location. Used in HL7 Version 2.x messaging in the LOC segment. |
| [Lot Control (2.8.2 - 1.0.0)](CodeSystem-lotControl.md) | Code system of concepts that define whether the sterilization load for a device is built in the sub-sterile area adjacent to an Operating Room or the Central Processing Department. Used in HL7 Version 2.x messaging in the SCP segment. |
| [MFN Record-level Error Return (2.8.2 - 1.0.0)](CodeSystem-mfnRecord-levelErrorReturn.md) | Code system of concepts specifying the status of the requested update. Site-defined table, specific to each master file being updated via this transaction. Used in HL7 Version 2.x messaging in the MFA segment. |
| [MIME Types (2.8.2 - 1.0.0)](CodeSystem-mimeTypes.md) | Code system of concepts specifying the general type of data. Used in HL7 Version 2.x messaging in the RP and ED datatypes. |
| [Mail Claim Party (2.8.2 - 1.0.0)](CodeSystem-mailClaimParty.md) | Code system of concepts which specify a party to which a claim should be mailed when claims are sent by mail. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [Manufacturers of Vaccines (code=MVX) (2.8.2 - 1.3.0)](CodeSystem-PH_ManufacturersOfVaccinesMVX_CDC_NIP.md) | Table of codes specifying the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control. Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed at URL: https://phinvads.cdc.gov/vads/SearchCodeSystems_search.action?searchOptions.searchText=PH_ManufacturersOfVaccinesMVX_CDC_NIP. The value set is also maintained by the CDC, and may be accessed at URL: https://phinvads.cdc.gov/vads/SearchValueSets_search.action?searchOptions.searchText=PHVS_ManufacturersOfVaccinesMVX_CDC_NIP |
| [Marital Status (2.8.2 - 1.1.0)](CodeSystem-maritalStatus.md) | Code system of concepts specifying a person's marital (civil/legal) status. Used in HL7 Version 2.x messages in the PID segment. |
| [Marketing Basis (2.8.2 - 1.0.0)](CodeSystem-marketingBasis.md) | HL7-defined code system of concepts used to specify the basis for marketing approval. Used in HL7 Version 2.x messaging in the Product Detail Country (PDC) segment. |
| [Master File Identifier Code (2.8.2 - 1.3.0)](CodeSystem-masterFileIdentifierCodes.md) | HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files. Used in HL7 Version 2.x messaging in the MFI segment. |
| [Match Reason (2.8.2 - 1.0.0)](CodeSystem-matchReason.md) | Code system of concepts identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels. It provides a method for passing a descriptive indication of the reason a particular record was found. Used in HL7 Version 2.x messaging in the Query Response Instance (QRI) segment. |
| [Medical Role Executing Physician (2.8.2 - 1.0.0)](CodeSystem-medicalRoleExecutingPhysician.md) | Code system of concepts specifying the role of the physician ("self-employed" or "employed"). Used in HL7 Version 2.x messaging in the PSL segment. |
| [Message Error Condition Codes (2.8.2 - 1.1.0)](CodeSystem-messageErrorCondition.md) | HL7-defined code system of concepts specifying the HL7 (communications) error code. Used in the ERR segment in HL7 Version 2.x messaging. |
| [Message Structure (2.8.2 - 7.3.0)](CodeSystem-messageStructure.md) | HL7-defined code system of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Message Type (2.8.2 - 1.8.0)](CodeSystem-messageType.md) | HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Message Waiting Priority (2.8.2 - 1.0.0)](CodeSystem-messageWaitingPriority.md) | HL7-defined code system of concepts which specify the disposition of the patient at time of discharge (i.e., discharged to home, expired, etc.). Used in HL7 Version 2.x messaging in the MSA segment. |
| [Military Rank/Grade (2.8.2 - 2.0.0)](CodeSystem-militaryRank-Grade.md) | Code system of concepts which specify the military rank/grade of the patient. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [Military Service (2.8.2 - 1.1.0)](CodeSystem-militaryService.md) | Code system of concepts which specify the military branch. This field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [Military Status (2.8.2 - 1.0.0)](CodeSystem-militaryStatus.md) | Code system of concepts which specify the military status of the patient. This field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [Modality (2.8.2 - 1.0.0)](CodeSystem-modality.md) | Code system of concepts used to define the imaging apparatus expected to be used to acquire an observation. This table has been removed from the standard as of 2.7 in favor of table 0910. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Mode of Arrival Code (2.8.2 - 1.0.0)](CodeSystem-arrivalMode.md) | Code system of concepts specifying how the patient was brought to the healthcare facility. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [Modifier Edit Code (2.8.2 - 1.0.0)](CodeSystem-cms-OCEModifierEditCode-cs.md) | The OPPS functionality of the Integrated Outpatient Code Editor (I/OCE) software was developed for the implementation of the Medicare outpatient prospective payment system mandated by the 1997 Balanced Budget Act. CMS released the proposed OPPS rules using the Ambulatory Payment Classification (APC) system in the September 8, 1998 Federal Register. Final regulations were published in the April 7, 2000 Federal Register and the system became effective for Medicare on August 1, 2000. Used in HL7 Version 2.x messaging in the GP1 segment. The APC-based OPPS developed by CMS is the outpatient equivalent of the inpatient, DRG-based PPS. The APC system establishes groups of covered services so that the services within each group are comparable clinically and with respect to the use of resources. Hospitals are required to use HCPCS when billing for outpatient services. The OCE not only identifies individual errors but also indicates what actions should be taken and the reasons why these actions are necessary. In order to accommodate this functionality, the OCE is structured to return lists of edit numbers. This structure facilitates the linkage between the actions being taken, the reasons for the actions and the information on the claim (e.g., a specific diagnosis) that caused the action. In general, the OCE performs all functions that require specific reference to HCPCS codes, HCPCS modifiers and ICD-10-CM diagnosis codes (ICD-9-CM diagnosis codes for historical claims with From Dates prior to 10/1/2015). Since these coding systems are complex and annually updated, the centralization of the direct reference to these codes and modifiers in a single program reduces effort and reduces the chance of inconsistent processing. This is a CMS maintained list of edits: Please see the following for additional information: • https://www.cms.gov/Medicare/Coding/OutpatientCodeEdit/index.html • https://www.cms.gov/Medicare/Coding/OutpatientCodeEdit/Background.htmlC • https://www.cms.gov/Medicare/Coding/OutpatientCodeEdit/OCEQtrReleaseSpecs.html |
| [Modify Indicator (2.8.2 - 1.0.0)](CodeSystem-modifyIndicator.md) | HL7-defined code system of concepts identifying whether the subscription is new or is being modified. Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment. |
| [Money or Percentage Indicator (2.8.2 - 1.0.0)](CodeSystem-moneyOrPercentageIndicator.md) | HL7-defined code system of concepts which specify whether the amount is currency or a percentage. Used in HL7 Version 2.x messaging in the MOP segment. |
| [Mood Codes (2.8.2 - 1.0.0)](CodeSystem-moodCodes.md) | HL7-defined code system of concepts that represent the functional state of an order. Used in HL7 Version 2.x messaging in the RXO and OBX segments. |
| [Name Assembly Order (2.8.2 - 1.0.0)](CodeSystem-nameAssemblyOrder.md) | Code system of concepts specifying the preferred display order of the components of this person name. Used in HL7 Version 2.x messaging in the PPN, XCN and XPN segments. |
| [Name Type (2.8.2 - 1.1.0)](CodeSystem-nameType2.md) | HL7-defined code system of concepts for types of names for persons. Used in HL7 Version 2.x messaging in the XPN, PPN, XCN, PID and MRG segments. |
| [Name/Address Representation (2.8.2 - 1.0.0)](CodeSystem-name-addressRepresentation.md) | HL7-defined code system of concepts specifying an indication of the representation provided by the data item. Used in HL7 Version 2.x messaging in the PPN, XAD, XCN and XON segments. |
| [Nature of Abnormal Testing (2.8.2 - 1.1.0)](CodeSystem-natureOfAbnormalTesting.md) | HL7-defined code system of concepts specifying the nature of an abnormal test. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Nature of Challenge (2.8.2 - 1.0.0)](CodeSystem-natureOfChallenge.md) | HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Nature of Service/Test/Observation (2.8.2 - 1.1.0)](CodeSystem-natureOfServiceTestObservation.md) | Code system of concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Newborn Code (2.8.2 - 1.0.0)](CodeSystem-newbornType.md) | HL7-defined code system of concepts which specify whether the baby was born in or out of a specified facility. Used in HL7 Version 2 messaging in the ABS segment. |
| [Non-Subject Consenter Reason (2.8.2 - 1.0.0)](CodeSystem-non-subjectConsenterReason.md) | HL7-defined code system of concepts used to specify a reason consent was granted by a person other than the subject of the consent. Used in the Consent (CON) segment in HL7 Version 2.x messaging. |
| [Notify Clergy Code (2.8.2 - 1.0.0)](CodeSystem-clergyNotificationType.md) | Code system of concepts specifying whether the clergy should be notified. Used in HL7 Version 2 messaging in the PV2 segment. |
| [OCE Edit Code (2.8.2 - 1.0.0)](CodeSystem-cms-OCEEditCode-cs.md) | Code system of concepts specifying the action to be taken during reimbursement calculations. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [Observation Result Handling (2.8.2 - 1.1.0)](CodeSystem-observationResultHandling.md) | Code system of concepts regarding the handling of a result. For example, an order may specify that the result (e.g., an x-ray film) should be given to the patient for return to the requestor. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Observation Result Status Codes Interpretation (2.8.2 - 1.3.0)](CodeSystem-observationResultStatusCodesInterpretation.md) | HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Observation Sub-Type (2.8.2 - 1.0.0)](CodeSystem-observationSubtype.md) | HL7-defined code system of concepts specifying the observation sub-type. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Observation Type (2.8.2 - 1.0.0)](CodeSystem-observationType.md) | HL7-defined code system of concepts specifying types of observations to enable systems to distinguish between observations sent along with an order, versus observations sent as the result to an order. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Order Control Codes (2.8.2 - 1.7.0)](CodeSystem-orderControlCodes.md) | HL7-defined code system of concepts which are used to determine the function of the order segment. Depending on the message, the action specified by one of these control codes may refer to an order or an individual service. Used in Version 2.x messaging of orders in the ORC segment. |
| [Order Status (2.8.2 - 1.2.0)](CodeSystem-orderStatus.md) | HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent. Only the filler can originate these values. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Order Type (2.8.2 - 1.0.0)](CodeSystem-orderType.md) | HL7-defined code system of concepts specifying whether the order is to be executed in an inpatient setting or an outpatient setting. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Organ Donor Code (2.8.2 - 1.2.0)](CodeSystem-organDonorCodes.md) | Code system of concepts specifying whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization. Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments. |
| [Organizational Name Type (2.8.2 - 1.0.0)](CodeSystem-organizationalNameType.md) | Code system of concepts used to specify the type of name for an organization i.e., legal name, display name. Used in HL7 Version 2.x messaging in the XON and PD1 segments. |
| [Outlier Type (2.8.2 - 1.0.0)](CodeSystem-outlierType.md) | HL7-defined code system of concepts specifying the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid. Used in HL7 Vesrion 2.x messaghing in the DRG segment. |
| [Overall Claim Disposition Code (2.8.2 - 1.0.0)](CodeSystem-overallClaimDisposition.md) | Code system of concepts specifying the final status of the claim. Used in HL7 Version 2.x messaging in the GP1 segment. |
| [Override (2.8.2 - 1.0.0)](CodeSystem-override.md) | Code system of concepts used to define whether a Charge Description Master description may be overridden or if it must be overridden. Used in HL7 Version 2.x messaging in the CDM and PRC segments. |
| [Override Type (2.8.2 - 1.0.0)](CodeSystem-overrideType.md) | Code system of concepts used to specify what type of override can be used to override the specific error identified. Used in HL7 Version 2 messaging in the ERR and OVR segments. |
| [PCA Type (2.8.2 - 1.0.0)](CodeSystem-pcaType.md) | HL7-defined code system of concepts specifying the type of PCA. Used in HL7 Version 2.x messaging in the RXV segment. |
| [Package (2.8.2 - 1.0.0)](CodeSystem-package.md) | Code system of concepts specifying the packaging unit in which this inventory supply item can be ordered or issued when purchased from the vendor in the related vendor segment. Used in HL7 Version 2.x messaging in the PKG segment. |
| [Packaging Status Code (2.8.2 - 1.0.0)](CodeSystem-packagingStatus.md) | Code system of concepts specifying the packaging status of the service. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [Participation (2.8.2 - 1.2.0)](CodeSystem-participation.md) | HL7-defined code system of concepts that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). Used in HL7 Version 2.x messaging in the PRT segment. |
| [Patient Class (2.8.2 - 1.2.0)](CodeSystem-patientClass.md) | Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment. |
| [Patient Condition Code (2.8.2 - 1.0.0)](CodeSystem-patientCondition.md) | Code system of concepts specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [Patient Location Type (2.8.2 - 1.0.0)](CodeSystem-patientLocationType.md) | Code system of concepts used to identify the kind of location described in the location definition. Used in HL7 Version 2.x messaging in the LOC segment. |
| [Patient Outcome (2.8.2 - 1.0.0)](CodeSystem-patientOutcome.md) | HL7-defined code system of concepts used to describe the overall state of a patient as a result of patient care. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Patient Results Release Categorization Scheme (2.8.2 - 1.0.0)](CodeSystem-patientResultsReleaseCategorizationScheme.md) | HL7-defined code system of concepts specifying the scheme for the patient results release categorization. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Patient's Relationship to Insured (2.8.2 - 1.0.0)](CodeSystem-patientsRelationshipToInsured.md) | Code system of concepts used to specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the Insurance Additional Information (IN2) segment. |
| [Payee Relationship to Invoice (2.8.2 - 1.0.0)](CodeSystem-payeeRelationshipToInvoice.md) | Code system of concepts used to specify the relationship to the invoice for Person Payee Types. Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging. |
| [Payee Type (2.8.2 - 1.0.0)](CodeSystem-payeeType.md) | Code system of concepts used to specify the type of payee (e.g., organization, person). Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging. |
| [Payment Adjustment Code (2.8.2 - 1.0.0)](CodeSystem-paymentAdjustmentInformation.md) | Code system of concepts specifying any payment adjustment due to drugs or medical devices. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [Payment Method Code (2.8.2 - 1.0.0)](CodeSystem-paymentMethod.md) | Code system of concepts used to specify the method for the movement of payment. Used in the Payment Information (PMT) segment in HL7 Version 2.x messaging. |
| [Person Location Type (2.8.2 - 1.0.0)](CodeSystem-personLocationType.md) | Code system of concepts specifying the categorization of the person's location. Used in HL7 Version 2.x messaging datatypes that contain location identifiers such as Person Location (PL), Location with address variation (LA) and Name with date and location (NDL). |
| [Pharmacy Order Types (2.8.2 - 1.0.0)](CodeSystem-pharmacyOrderTypes.md) | HL7-defined code system of concepts specifying the general category of pharmacy order which may be used to determine the processing path the order will take. Used in HL7 Version 2.x messaging in the RXO, RXE, RXD, RXG and RXA segments. |
| [Phlebotomy Issue (2.8.2 - 1.0.0)](CodeSystem-phlebotomyIssue.md) | HL7-defined code system of concepts specifying the phlebotomy issue. Used in HL7 Version 2.x messaging in the DON segment. |
| [Phlebotomy Status (2.8.2 - 1.0.0)](CodeSystem-phlebotomyStatus.md) | HL7-defined code system of concepts specifying the status of the phlebotomy. Used in HL7 Version 2.x messaging in the DON segment. |
| [Policy Type (2.8.2 - 1.0.0)](CodeSystem-policyType.md) | Code system of concepts which specify the policy type. Used in HL7 Version 2.x messaging in the PTA segment. |
| [Practitioner ID Number Type (2.8.2 - 1.1.0)](CodeSystem-practitionerIdNumberType.md) | Code system of concepts used to specify the type of number used for the practitioner identification. Used in HL7 Version 2.x messaging in the Practitioner License or Other ID Number (PLN) value as well as the Provider Data (PRD) and Contact Data (CTD)segments. |
| [Practitioner Organization Unit Type (2.8.2 - 2.0.0)](CodeSystem-organizationUnitType.md) | Code system of concepts specifying the classification of the organization unit. Used in HL7 Version 2.x messaging in the ORG segment. |
| [Precaution Code (2.8.2 - 1.0.0)](CodeSystem-precaution.md) | Code system of concepts specifying non-clincal precautions that need to be taken with the patient. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [Preferred Method of Contact (2.8.2 - 1.1.1)](CodeSystem-preferredMethodOfContact.md) | HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the preferred method of contact for this person. Used in HL7 Version 2.x messaging in the STF, PRD, and CTD segments. |
| [Preferred Specimen/Attribute Status (2.8.2 - 1.0.0)](CodeSystem-preferredSpecimen-AttributeStatus.md) | HL7-defined code system of concepts that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a particular specimen. Used in HL7 Version 2.x messaging in Master Files (OM4 segment) to characterize information about specimens that are associated with certain observations. |
| [Present On Admission (POA) Indicator (2.8.2 - 1.0.0)](CodeSystem-nubc-PresentOnAdmission-cs.md) | National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 67, Present on Admission (POA) Indicator. Code identifying a diagnosis that was present at the time the order for inpatient admission occurs. POA indicator is assigned to all diagnoses as defined in Appendix I of the "ICD-9-CM Official Guidelines for Coding and Reporting" or "ICD-10-CM Official Guidelines for Coding and Reporting (appropriate to the ICD revision used). The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the DG1 segment. |
| [Price Type (2.8.2 - 1.0.0)](CodeSystem-priceType.md) | HL7-defined code system of concepts used to identify the intent for the dollar amount on a pricing transaction. Used in HL7 Version 2.x messaging in the CP datatype. |
| [Primary Key Value Type (2.8.2 - 1.1.0)](CodeSystem-primaryKeyValueType.md) | HL7-defined code system of concepts used to specify the type for the master file record identifier. Used in HL7 Version 2.x messaging in the Master File Entry (MFE) segment. |
| [Primary Observer's Qualification (2.8.2 - 1.0.0)](CodeSystem-primaryObserverQualification.md) | HL7-defined code system of concepts used to provide a general description of the kind of health care professional who provided the primary observation. Used in HL7 Version 2.x messaging in the PEO and PCR segments. |
| [Priority (2.8.2 - 1.2.0)](CodeSystem-priority.md) | HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [Privacy Level (2.8.2 - 1.0.0)](CodeSystem-privacyLevel.md) | Code system of concepts used to identify the level of privacy a patient will be afforded when assigned to this location definition. Used in HL7 Version 2.x messaging in the LCH segment. |
| [Problem/Goal Action Code (2.8.2 - 1.0.1)](CodeSystem-problem-goalAction.md) | HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal. Used in HL7 Version 2.x messaging in the GOL, ROL, PRB and PTH segments. |
| [Procedure DRG Type (2.8.2 - 1.0.0)](CodeSystem-procedureDrgType.md) | HL7-defined code system of concepts which specify a procedure’s priority ranking relative to its DRG. Used in HL7 Version 2 messaging in the PR1 segment. |
| [Procedure Functional Type (2.8.2 - 1.0.0)](CodeSystem-procedureFunctionalType.md) | Code system of concepts used to classify a procedure. Used in HL7 Version 2.x messaging in the PR1 segment. |
| [Procedure Priority (2.8.2 - 1.1.0)](CodeSystem-procedurePriority.md) | HL7-defined code system of concepts which specify the significance or priority of a procedure code. Used in HL7 Version 2 messaging in the PR1 segment. Note that this is a post-coordinated code system, where additional ordinal priorities are created by incrementing the numericinteger code value as needed. Only the first 2 ordinal values are predefined in the code system. |
| [Process Interruption Reason (2.8.2 - 1.0.0)](CodeSystem-processInterruptionReason.md) | HL7-defined code system of concepts specifying the reason for the process interruption. Used in HL7 Version 2.x messaging in the DON segment. |
| [Processing Consideration Codes (2.8.2 - 1.0.0)](CodeSystem-processingConsideration.md) | Code system of concepts used to specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer). Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging. |
| [Processing ID (2.8.2 - 1.0.0)](CodeSystem-processingId.md) | HL7-defined code system of concepts which specify whether the message is part of a production, training or debugging system. Used in HL7 Version 2.x messaging in the PT datatype. |
| [Processing Mode (2.8.2 - 1.1.0)](CodeSystem-processingMode.md) | HL7-defined code system of concepts that indicate an archival process or an initial load process. Used in HL7 Version 2.x messaging in the PT datatype. |
| [Processing Priority (2.8.2 - 1.0.0)](CodeSystem-processingPriority.md) | HL7-defined code system of concepts which specify one or more available priorities for performing the observation or test. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Processing Type (2.8.2 - 1.0.0)](CodeSystem-processingType.md) | HL7-defined code system of concepts identifying the processing type that applies to the test code. If this attribute is omitted, then regular production is the default. Used in HL7 Version 2.x messaging in the Test Code Configuration (TCC) segment. |
| [Product Source (2.8.2 - 1.0.0)](CodeSystem-productSource.md) | HL7-defined code system of concepts used to describe the evaluation state of a product identified in an incident. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Product/Service Status (2.8.2 - 1.0.0)](CodeSystem-product-serviceStatus.md) | Code system of concepts used to specify the processing status for the Product/Service Code. Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging. |
| [Product/Services Clarification Codes (2.8.2 - 1.0.0)](CodeSystem-product-servicesClarification.md) | Code system of concepts used to specify the Product/Service Code. Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging. |
| [Production Class Code (2.8.2 - 1.0.0)](CodeSystem-productionClass.md) | Code system of concepts specifying the code and/or text indicating the primary use for which the living subject was bred or grown. Used in HL7 Version 2.x messaging in the PID segment. |
| [Protection Code (2.8.2 - 1.0.0)](CodeSystem-protection.md) | Code system of concepts specifying that an address needs to be treated with special care or sensitivity. Used in HL7 Version 2.x messaging in the XAD and XTN segments. |
| [Provider Adjustment Reason Code (2.8.2 - 1.0.0)](CodeSystem-providerAdjustmentReason.md) | Code system of concepts used to specify the reason for this adjustment. Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging. |
| [Provider Billing (2.8.2 - 1.0.0)](CodeSystem-providerBilling.md) | HL7-defined code system of concepts specifying how provider services are billed. Used in HL7 Version 2.x messaging in the PRA segment. |
| [Provider Role (2.8.2 - 1.2.0)](CodeSystem-providerRole.md) | Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). Used in HL7 Version 2.x messaging in the ROL segment. |
| [Purge Status Code (2.8.2 - 1.0.0)](CodeSystem-purgeStatus.md) | Code system of concepts used to define the state of a visit relative to its place in a purge workflow. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [Quantity Limited Request (2.8.2 - 1.1.0)](CodeSystem-quantityLimitedRequest.md) | HL7-defined code system of concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. Used in HL7 Version 2.x messaging in the RCP segment. |
| [Quantity Method (2.8.2 - 1.0.0)](CodeSystem-quantityMethod.md) | HL7-defined code system of concepts used to specify the method by which the quantity distributed is measured. Used in HL7 Version 2.x messaging in the Product Summary Header (PSH) segment. |
| [Query Priority (2.8.2 - 1.0.0)](CodeSystem-queryPriority.md) | HL7-defined code system of concepts which specify a time frame in which a querry response is expected. Used in HL7 Verson 2.x messaging in the RCP segment. |
| [Query Response Status (2.8.2 - 1.1.0)](CodeSystem-queryResponseStatus.md) | HL7-defined code system of concepts defining precise response status concepts in support of HL7 Version 2 query messaging. It is commonly used to indicate no data is found that matches the query parameters, but no error. Used in HL7 Version 2.x messaging in the QAK segment. |
| [RX Component Type (2.8.2 - 1.0.0)](CodeSystem-rxComponentType.md) | HL7-defined code system of concepts which specify the RX component type. Used in HL7 Version 2.x messaging in the RXC segment. |
| [Record-level Event Code (2.8.2 - 1.0.0)](CodeSystem-masterfileActionCode.md) | HL7-defined code system of concepts specifying an action for a master file record. Used in HL7 Version 2.x messaging in the MFE segment. |
| [Recreational Drug Use Code (2.8.2 - 1.0.0)](CodeSystem-recreationalDrugType.md) | Code system of concepts specifying what recreational drugs the patient uses. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [Referral Category (2.8.2 - 1.0.0)](CodeSystem-referralCategory.md) | Code system of concepts used to describe the patient care setting where a referral should take place. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Referral Disposition (2.8.2 - 1.0.0)](CodeSystem-referralDisposition.md) | Code system of concepts used to identify the expected response from the healthcare professional receiving a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Referral Priority (2.8.2 - 1.0.0)](CodeSystem-referralPriority.md) | Code system of concepts used to designate the urgency of a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Referral Reason (2.8.2 - 1.0.0)](CodeSystem-referralReason.md) | Code system of concepts used to specify the reason for which the referral will take place. Used in HL7 Version 2.x messaging in the Referral Information (RF1) segment. |
| [Referral Status (2.8.2 - 1.0.0)](CodeSystem-referralStatus.md) | Code system of concepts used to define the state of a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Referral Type (2.8.2 - 1.0.0)](CodeSystem-referralType.md) | Code system of concepts used to identify the general category of healthcare professional desired to satisfy a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Reimbursement Action Code (2.8.2 - 1.0.0)](CodeSystem-reimbursementAction.md) | Code specifying the action to be taken during reimbursement calculations. In the US, this field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [Reimbursement Type Code (2.8.2 - 1.0.0)](CodeSystem-reimbursementType.md) | Code system of concepts specifying the fee schedule reimbursement type applied to the line item. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [Relatedness Assessment (2.8.2 - 1.0.0)](CodeSystem-relatednessAssessment.md) | HL7-defined code system of concepts used to provide an estimate of whether an issue with a product was the cause of an event. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Relational Conjunction (2.8.2 - 1.0.0)](CodeSystem-relationalConjunction.md) | HL7-defined code system of concepts used with relationalOperator values to group more than one segment field name. Used in HL7 Version 2.x messaging in the QSC segment. |
| [Relational Operator (2.8.2 - 1.0.0)](CodeSystem-relationalOperator.md) | HL7-defined code system of concepts used to define the relationship between HL7 segment field names identified in a query construct. Used in HL7 Version 2.x messaging in the QSC segment. |
| [Relationship (2.8.2 - 1.0.0)](CodeSystem-relationship.md) | HL7-defined code system of concepts specifying an actual personal relationship that the next of kin/associated party has to a patient. Used in HL7 Version 2.x messaging in the NK1 and IN1 segments. |
| [Relationship Modifier (2.8.2 - 1.0.0)](CodeSystem-relationshipModifier.md) | HL7-defined code system of concepts used in an observation definition to describe the subject of an observation in relation to a patient. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Relevant Clinicial Information (2.8.2 - 1.0.0)](CodeSystem-relevantClincialInformation.md) | Code system of concepts specifying additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Religion (2.8.2 - 2.1.0)](CodeSystem-religion2.md) | Code system of concepts specifying a person's religion. Used in HL7 Version 2.x messaging in the PID segment. |
| [Remote Control Command (2.8.2 - 1.1.0)](CodeSystem-remoteControlCommand.md) | Code system of concepts that identify the comment the component is to initiate. Used in the Equipment Command (ECD) and Interaction Status Detail (ISD) segments in HL7 Version 2.x messaging. |
| [Reorder Theory Codes (2.8.2 - 1.0.0)](CodeSystem-reorderTheory.md) | Code system of concepts that identify the calculation method used to determine the resupply schedule. Used in HL7 Version 2.x messaging in the IVT segment. |
| [Repeat Pattern (2.8.2 - 1.1.0)](CodeSystem-repeatPattern.md) | Code system of concepts used to specify the interval between repeated services. Used in HL7 Version 2.x messaging in the RI datatype and RPT segment. |
| [Report Source (2.8.2 - 1.0.0)](CodeSystem-reportSource.md) | HL7-defined code system of concepts used to identify where a report sender learned about an event. Used in HL7 Version 2.x messaging in the PES segment. |
| [Report Timing (2.8.2 - 1.0.0)](CodeSystem-reportTiming.md) | HL7-defined code system of concepts used to identify the time span of a report or the reason for a report sent to a regulatory agency. Used in HL7 Version 2.x messaging in the PES segment. |
| [Reporting Priority (2.8.2 - 1.0.0)](CodeSystem-reportingPriority.md) | HL7-defined code system of concepts which specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Response Flag (2.8.2 - 1.0.0)](CodeSystem-responseFlag.md) | HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Response Level (2.8.2 - 1.0.0)](CodeSystem-responseLevel.md) | HL7-defined code system of concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message. Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions. Used in HL7 Version 2.x messaging in the MFI segment. |
| [Response Modality (2.8.2 - 1.0.0)](CodeSystem-responseModality.md) | HL7-defined code system of concepts identifying the timing and grouping of the response message(s). Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment. |
| [Result Status (2.8.2 - 1.2.0)](CodeSystem-resultStatus.md) | HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Risk Codes (2.8.2 - 1.0.0)](CodeSystem-risks.md) | Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient. Used in HL7 Version 2.x messaging in the SPM and PAC segments. |
| [Risk Management Incident Code (2.8.2 - 1.0.0)](CodeSystem-riskManagementIncident.md) | HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s stay. Used in HL7 Version 2 messaging in the RMI segment. |
| [Role Executing Physician (2.8.2 - 1.0.0)](CodeSystem-roleExecutingPhysician.md) | Code system of concepts specifying the account role of the physician, for example, only billing for the professional part, the technical part or both. Used in HL7 Version 2.x messaging in the PSL segment. |
| [Room Type (2.8.2 - 1.0.0)](CodeSystem-roomType.md) | Code system of concepts which specify the room type. Used in HL7 Version 2.x messaging in the RMC segment. |
| [Root Cause (2.8.2 - 1.0.0)](CodeSystem-rootCause.md) | Code system of concepts specifying the root cause. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Route of Administration (2.8.2 - 3.0.3)](CodeSystem-routeOfAdministration.md) | Code system of concepts which specify the route of administration. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Security Check Scheme (2.8.2 - 1.0.0)](CodeSystem-securityCheckScheme.md) | HL7-defined code system of concepts specifying the scheme for the security check. Used in HL7 Version 2.x messaging in the CX datatypes and PPN and XCN segments. |
| [Segment Action Code (2.8.2 - 1.1.0)](CodeSystem-segmentAction.md) | HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in "action code mode" (a kind of update mode in the Standard). Used in HL7 Version 2.x messaging in the RXA, RXV, LCH, IAM, ARV, IN1 and OH1 segments. |
| [Segment Group (2.8.2 - 8.0.0)](CodeSystem-segmentGroup.md) | HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response. This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included. Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment. |
| [Sensitivity to Causative Agent Code (2.8.2 - 1.1.0)](CodeSystem-sensitivityToCausativeAgent.md) | Code system of concepts specifying the reason the patient should not be exposed to a substance. Used in HL7 Version 2.x messaging in the IAM segment. |
| [Sequence Condition Code (2.8.2 - 1.0.0)](CodeSystem-sequenceCondition.md) | HL7-defined code system of concepts used to specify the relationship between the start/end of the related service request(s) (from TQ2-3, TQ2-4 or TQ2-5) and the current service request from ORC-2, 3 or 4. Used in HL7 Version 2.x messaging in the TQ2 segment. |
| [Sequence/Results Flag (2.8.2 - 1.0.0)](CodeSystem-sequenceResultsFlag.md) | HL7-defined code system of concepts used to specify the sequencing relationship between the current service request and the related service request(s) specified in this TQ2 segment. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. |
| [Sequencing (2.8.2 - 1.0.0)](CodeSystem-sequencing.md) | HL7-defined code system of concepts identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not. Used in HL7 Version 2.x messaging in the Sort Order (SRT) value. |
| [Service Request Relationship (2.8.2 - 1.0.0)](CodeSystem-serviceRequestRelationship.md) | HL7-defined code system of concepts used to specify an additional or alternate relationship between this service request and other service requests. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. |
| [Severity of Illness Code (2.8.2 - 1.0.0)](CodeSystem-severityOfIllness.md) | HL7-defined code system of concepts which specify the ranking of a patient’s illness. Used in HL7 Version 2 messaging in the ABS segment. |
| [Shipment Status (2.8.2 - 1.0.0)](CodeSystem-shipmentStatus.md) | HL7-defined code system of concepts specifying the status of the shipment. Used in HL7 Version 2.x messaging in the SHP segment. |
| [Side of body (2.8.2 - 1.0.0)](CodeSystem-sideOfBody.md) | Code system of concepts specifying the side of the body ("left" or "right"). Used in HL7 Version 2.x messaging in the PSL segment. |
| [Signatory's Relationship to Subject (2.8.2 - 1.0.0)](CodeSystem-signatorysRelationshipToSubject.md) | Code system of concepts specifying the relationship of the consenter to the subject. Used in HL7 Version 2 messaging in the CON segment. |
| [Signature Code (2.8.2 - 1.0.0)](CodeSystem-signatureType.md) | Code system of concepts that indicate how a patient/subscriber authorization signature is obtained and how it is being retained by a provider. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [Source Type (2.8.2 - 1.0.0)](CodeSystem-sourceType.md) | HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x messaging in the Facility (FAC) segment. |
| [Source of Comment (2.8.2 - 1.1.0)](CodeSystem-sourceOfComment.md) | HL7-defined code system of concepts which are used to specify the source of a comment. Used in HL7 Version 2.x messaging in the NTE segment. |
| [Special Handling Code (2.8.2 - 1.1.0)](CodeSystem-specialHandling.md) | Code system of concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing. Used in HL7 Version 2.x messaging in the SPM, SAC, PAC and OM4 segments. |
| [Specialty Type (2.8.2 - 1.0.0)](CodeSystem-specialtyType.md) | Code system of concepts used to identify the specialty of the care professional who is supported when using this location definition. Used in HL7 Version 2.x messaging in the LDP segment. |
| [Specimen Action Code (2.8.2 - 2.1.0)](CodeSystem-specimenAction.md) | HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). Used in HL7 Version 2.x messaging in the OBR segment. |
| [Specimen Appropriateness (2.8.2 - 2.0.0)](CodeSystem-specimenAppropriateness.md) | Code system of concepts specifying the suitability of the specimen for the particular planned use as determined by the filler. Used in HL7 Version 2.x messaging in the SPM segment. |
| [Specimen Child Role (2.8.2 - 1.0.0)](CodeSystem-specimenChildRole.md) | HL7-defined code system of concepts specifying for child specimens the relationship between this specimen and the parent specimen. Used in HL7 Version 2.x messaging in the SPM segment. |
| [Specimen Collection Method (2.8.2 - 1.0.0)](CodeSystem-specimenCollectionMethod.md) | HL7-defined code system of concepts specifying the specimen collection method. Used in HL7 Version 2.x messaging in the SPM segment. |
| [Specimen Component (2.8.2 - 1.0.0)](CodeSystem-specimenComponent.md) | Code system of concepts that identify the specimen component, e.g., supernatant, sediment, etc. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [Specimen Condition (2.8.2 - 1.1.0)](CodeSystem-specimenCondition.md) | Code system of concepts specifying a mode or state of being that describes the nature of the specimen. Used in HL7 Version 2.x messaging in the SPM segment. |
| [Specimen Quality (2.8.2 - 1.0.0)](CodeSystem-specimenQuality.md) | Code system of concepts specifying the degree or grade of excellence of the specimen at receipt. Used in HL7 Version 2.x messaging in the SPM segment. |
| [Specimen Reject Reason (2.8.2 - 1.0.0)](CodeSystem-specimenRejectReason.md) | HL7-defined code system of reasons a specimen may be rejected for a specified observation/result/analysis. Used in HL7 Version 2.x messaging in the SPM segment. |
| [Specimen Role (2.8.2 - 1.1.0)](CodeSystem-specimenRole.md) | HL7-defined code system of concepts that identify the role of a sample. Used in HL7 Version 2.x messaging in the Specimen (SPM) and Observation Request (OBR) segments. |
| [Specimen Type (2.8.2 - 1.2.0)](CodeSystem-specimenType.md) | HL7-defined code system of concepts that describe the precise nature of an entity that may be used as the source material for an observation. This is one of two code systems that are used instead of table 0070 (code system 2.16.840.1.113883.18.28) which conflated specimen types and specimen collection methods. Used in HL7 Version 2.x messaging in the SPM segment. |
| [Status Admission (2.8.2 - 1.0.0)](CodeSystem-drgstatusAdmission.md) | Code system of concepts specifying the admission status for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [Status Weight At Birth (2.8.2 - 1.0.0)](CodeSystem-drgstatusWeightAtBirth.md) | Code system of concepts specifying the status of the use of the weight at birth for diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [Status of Evaluation (2.8.2 - 1.0.0)](CodeSystem-statusOfEvaluation.md) | HL7-defined code system of concepts that describes the status of product evaluation. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Sterilization Type (2.8.2 - 1.0.0)](CodeSystem-sterilizationType.md) | Code system of concepts specifying the type of sterilization used for sterilizing the inventory supply item in the ITM segment. Used in HL7 Version 2.x messaging in the STZ segment. |
| [Student Status (2.8.2 - 1.0.0)](CodeSystem-studentStatus.md) | Code system of concepts used to designate whether a guarantor is a full or part time student. Used in HL7 Version 2.x messaging in the GT1, NK1 and PD1 segments. |
| [Substance Status (2.8.2 - 1.0.0)](CodeSystem-substanceStatus.md) | HL7-defined code system of concepts identifying the status of the inventoried item. The status indicates the current status of the substance. Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment. |
| [Substance Type (2.8.2 - 1.0.1)](CodeSystem-substanceType.md) | HL7-defined code system of concepts identifying the type of substance. Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment. |
| [Substitution Status (2.8.2 - 1.1.0)](CodeSystem-substitutionStatus.md) | HL7-defined code system of concepts which specify the substitution status. Used in HL7 Version 2.x messaging in the RXE, RXD, and RXG segments. |
| [Subtype of Referenced Data (2.8.2 - 1.2.1)](CodeSystem-subtypeOfReferencedData.md) | Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream. Used in Version 2 messaging ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes. More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml. |
| [Supply Risk Codes (2.8.2 - 1.0.0)](CodeSystem-supplyRisk.md) | Code system of concepts specifying any known or suspected hazard associated with this material item. Used in HL7 Version 2.x messaging in the ITM segment. |
| [TQ Conjunction ID (2.8.2 - 1.1.0)](CodeSystem-tqConjunctionId.md) | HL7-defined code system of concepts specifying that a second timing specification is to follow using the repeat delimiter. Used in HL7 Version 2.x messaging in the TQ1 segment. |
| [Tax status (2.8.2 - 1.0.0)](CodeSystem-taxStatus.md) | Code system of concepts used to specify the tax status of the provider. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [Telecommunication Equipment Type (2.8.2 - 1.2.0)](CodeSystem-telecommunicationEquipmentType.md) | HL7-defined code system of concepts for specifying a type of telecommunication equipment. Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified. Used in HL7 Version 2.x messaging in the XTN segment. |
| [Telecommunication Expiration Reason (2.8.2 - 1.0.0)](CodeSystem-telecommunicationExpirationReason.md) | Code system of concepts specifying the reason this contact number/email was marked as "ended". Used in HL7 Version 2.x messaging in the XTN segment. |
| [Telecommunication Use Code (2.8.2 - 1.2.0)](CodeSystem-telecommunicationUse.md) | HL7-defined code system of concepts for specifying a specific use of a telecommunication number. Best practice is to use this concept whenever a telecommunication number or access string is specified. Used in HL7 Version 2.x messaging in the XTN segment. |
| [Time Delay Post Challenge (2.8.2 - 1.0.0)](CodeSystem-timeDelayPostChallenge.md) | HL7-defined code system of concepts used to classify an observation definition as being a component of a challenge test. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Time Selection Criteria Parameter Class Codes (2.8.2 - 1.1.0)](CodeSystem-timeSelectionCriteriaParameterClass.md) | Code system of concepts used to describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling. Used in HL7 Version 2.x messaging in the SCV and APR segments. |
| [Tissue Type Code (2.8.2 - 1.0.0)](CodeSystem-tissueType.md) | HL7-defined code system of concepts which specify a type of tissue removed from a patient during a procedure. Used in HL7 Version 2 messaging in the PR1 segment. |
| [Transaction Type (2.8.2 - 1.1.0)](CodeSystem-transactionType.md) | Code system of concepts specifying a type of financial transaction. Used in HL7 Version 2.x messaging in the FT1 segment. |
| [Transfer Type (2.8.2 - 1.0.0)](CodeSystem-drgTransferType.md) | HL7-defined code system of concepts which specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG’s), for example, exempt or non-exempt. Used in HL7 Version 2 messaging in the DRG segment. |
| [Transfusion Adverse Reaction (2.8.2 - 1.0.0)](CodeSystem-transfusionAdverseReaction.md) | Code system of concepts used to specify the type of adverse reaction that the recipient of the blood product experienced. Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging. |
| [Transport Arranged (2.8.2 - 1.0.0)](CodeSystem-transportArranged.md) | HL7-defined code system of concepts defining whether patient transportation preparations are in place. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Transportation Mode (2.8.2 - 1.0.0)](CodeSystem-transportationMode.md) | HL7-defined code system of concepts which specify how (or whether) to transport a patient, when applicable, for an ordered service. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Tray Type (2.8.2 - 1.0.0)](CodeSystem-trayType.md) | HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version 2.x messaging in the ODT segment. |
| [Treatment (2.8.2 - 1.0.0)](CodeSystem-treatment.md) | Code system of concepts that identify the specimen treatment performed during lab processing. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [Triage Code (2.8.2 - 1.0.0)](CodeSystem-triageType.md) | HL7-defined code system of concepts which specify a patient’s prioritization within the context of a transmitted abstract. Used in HL7 Version 2 messaging in the ABS segment. |
| [Type of Referenced Data (2.8.2 - 1.3.0)](CodeSystem-typeOfReferencedData.md) | HL7-defined code system of concepts declaring the general type of media data that is encoded. Used in v2.5.1 interfaces and earlier, and replaced with the full set of IANA media types as a standard coding system for this after HL7 version 2.6 (see value set 2.16.840.1.113883.21.425 hl7VS-mimeTypes for HL7 table 0834 built on MIME types). More information may be found at http://www.iana.org/assignments/media-types/media-types.xhtml |
| [Universal ID Type (2.8.2 - 1.2.0)](CodeSystem-universalIdType.md) | HL7-defined code system of types of UID (Universal Identifiers). Used in HL7 Version 2.x messaging HD and EI datatypes. |
| [User Authentication Credential Type Code (2.8.2 - 1.0.0)](CodeSystem-userAuthenticationCredentialType.md) | HL7-defined code system of concepts specifying a type of user authentication credential. Used in HL7 Version 2.x messaging in the UAC segment. |
| [Vaccines Administered (2.8.2 - 1.5.0)](CodeSystem-PH_VaccinesAdministeredCVX_CDC_NIP.md) | Table of codes specifying the administered vaccines. The values are maintained by the US Centers of Disease Control. The code system is maintained by the CDC, and may be found at URL; https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.292 The value set is maintained by the CDC and may be found at URL: https://phinvads.cdc.gov/vads/ViewValueSet.action?id=ABDEE003-77C3-48E7-B941-EBF92B6B81FC |
| [Version ID (2.8.2 - 1.12.0)](CodeSystem-versionId.md) | HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards. Used in HL7 Version 2.x messaging in the VID segment. |
| [Visit Indicator (2.8.2 - 1.0.0)](CodeSystem-visitIndicator.md) | Code system of concepts specifying the level on which data are being sent. It is the indicator used to send data at two levels, visit and account. HL7 recommends sending an "A" or no value when the data in the message are at the account level or "V" to indicate that the data sent in the message are at the visit level. Used in HL7 Version 2.x messaging in the Patient Visit (PV1) segment. |
| [Visit Priority Code (2.8.2 - 1.0.0)](CodeSystem-visitPriority.md) | Code system of concepts used to define a relative level of urgency applied to a patient visit. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [Visit User Code (2.8.2 - 1.0.0)](CodeSystem-visitUserCodes.md) | Code system of concepts which specify categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis. Used in HL7 Version 2.x messaging in the PV2 segment. |

