# Sensitivity to Causative Agent Code (2.8.2 - 1.1.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sensitivity to Causative Agent Code (2.8.2 - 1.1.0)**

## CodeSystem: Sensitivity to Causative Agent Code (2.8.2 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/sensitivityToCausativeAgent | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:SensitivityToCausativeAgent |
| *Other Identifiers:*OID:2.16.840.1.113883.18.277 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the reason the patient should not be exposed to a substance. Used in HL7 Version 2.x messaging in the IAM segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSsensitivityToCausativeAgentCode](ValueSet-hl7VSsensitivityToCausativeAgentCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "sensitivityToCausativeAgent",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0436"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/sensitivityToCausativeAgent",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.277"
    }
  ],
  "version" : "1.1.0",
  "name" : "SensitivityToCausativeAgent",
  "title" : "Sensitivity to Causative Agent Code (2.8.2 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the reason the patient should not be exposed to a substance.  Used in HL7 Version 2.x messaging in the IAM segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VShl7VSsensitivityToCausativeAgentCode"
        }
      ],
      "code" : "parent",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#parent",
      "description" : "parent",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AD",
      "display" : "Adverse Reaction (Not otherwise classified)",
      "definition" : "Adverse Reaction (Not otherwise classified)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AL",
      "display" : "Allergy",
      "definition" : "Allergy",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CT",
      "display" : "Contraindication",
      "definition" : "Contraindication",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IN",
      "display" : "Intolerance",
      "definition" : "Intolerance",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SE",
      "display" : "Side Effect",
      "definition" : "Side Effect",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    }
  ]
}

```
