# Result Status (2.8.2 - 1.2.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Result Status (2.8.2 - 1.2.0)**

## CodeSystem: Result Status (2.8.2 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/resultStatus | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:ResultStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.51 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSresultStatus-Obr](ValueSet-hl7VSresultStatus-Obr.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "resultStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0123"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/resultStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.51"
    }
  ],
  "version" : "1.2.0",
  "name" : "ResultStatus",
  "title" : "Result Status (2.8.2 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify a status of results for an order.  Used in HL7 Version 2.x messaging in the OBR segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Some, but not all, results available",
      "definition" : "Some, but not all, results available",
      "designation" : [
        {
          "language" : "de",
          "value" : "einige, aber nicht alle Ergebnisse verfügbar"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Correction to results",
      "definition" : "Correction to results",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ergebniskorrektur"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Final results; results stored and verified.  Can only be changed with a corrected result.",
      "definition" : "Final results; results stored and verified.  Can only be changed with a corrected result.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Endergebnis - Auftrag erledigt, Ergebnisse validiert"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "No results available; specimen received, procedure incomplete",
      "definition" : "No results available; specimen received, procedure incomplete",
      "designation" : [
        {
          "language" : "de",
          "value" : "Keine Ergebnisse - Probe liegt vor, Untersuchung unvollständig"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Order received; specimen not yet received",
      "definition" : "Order received; specimen not yet received",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag erhalten - Probe steht noch aus"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Preliminary: A verified early result is available, final results not yet obtained",
      "definition" : "Preliminary: A verified early result is available, final results not yet obtained",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vorläufig - Validiertes Zwischenergebnis liegt vor, aber noch keine endgültigen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Results stored; not yet verified",
      "definition" : "Results stored; not yet verified",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ergebnisse gespeichert, aber noch nicht validiert"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "No results available; procedure scheduled, but not done",
      "definition" : "No results available; procedure scheduled, but not done",
      "designation" : [
        {
          "language" : "de",
          "value" : "Keine Ergebnisse - Untersuchung eingeplant, aber noch nicht durchgeführt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "X",
      "display" : "No results available; Order canceled.",
      "definition" : "No results available; Order canceled.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Keine Ergebnisse - Auftrag storniert"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "Y",
      "display" : "No order on record for this test.  (Used only on queries)",
      "definition" : "No order on record for this test.  (Used only on queries)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kein Auftrag zu dieser Untersuchung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "Z",
      "display" : "No record of this patient. (Used only on queries)",
      "definition" : "No record of this patient. (Used only on queries)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Keine Daten über diesen Patienten"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
