# Interpretation Codes (2.8.2 - 2.2.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Interpretation Codes (2.8.2 - 2.2.0)**

## CodeSystem: Interpretation Codes (2.8.2 - 2.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/observationInterpretation | *Version*:2.2.0 |
| Active as of 2026-01-27 | *Computable Name*:ObservationInterpretation |
| *Other Identifiers:*OID:2.16.840.1.113883.5.83 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify a categorical assessment of an observation value. Used in HL7 Version 2.x messaging in the OBX segment. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSinterpretationCode](ValueSet-hl7VSinterpretationCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "observationInterpretation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0078"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/observationInterpretation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.83"
    }
  ],
  "version" : "2.2.0",
  "name" : "ObservationInterpretation",
  "title" : "Interpretation Codes (2.8.2 - 2.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify a categorical assessment of an observation value.  Used in HL7 Version 2.x messaging in the OBX segment.\r\nNotes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "<",
      "display" : "Off scale low",
      "definition" : "Off scale low",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : ">",
      "display" : "Off scale high",
      "definition" : "Off scale high",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "A",
      "display" : "Abnormal",
      "definition" : "Abnormal",
      "designation" : [
        {
          "language" : "de",
          "value" : "anormal"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "AA",
      "display" : "Critically abnormal",
      "definition" : "Critically abnormal",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "AC",
      "display" : "Anti-complementary substances present",
      "definition" : "Anti-complementary substances present",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "B",
      "display" : "Better",
      "definition" : "Better (use when direction not relevant)",
      "designation" : [
        {
          "language" : "de",
          "value" : "besser"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-08-02"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Significant change down",
      "definition" : "Significant change down",
      "designation" : [
        {
          "language" : "de",
          "value" : "Deutlicher Trend nach unten"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "DET",
      "display" : "Detected",
      "definition" : "Detected",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "High",
      "definition" : "High",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "HH",
      "display" : "Critically high",
      "definition" : "Critically high",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "HM",
      "display" : "Hold for Medical Review",
      "definition" : "Hold for Medical Review",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "HU",
      "display" : "Very high",
      "definition" : "Very high",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Intermediate",
      "definition" : "Intermediate",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "IE",
      "display" : "Insufficient evidence",
      "definition" : "Insufficient evidence",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        }
      ]
    },
    {
      "code" : "IND",
      "display" : "Indeterminate",
      "definition" : "Indeterminate",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Low",
      "definition" : "Low",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "LL",
      "display" : "Critically low",
      "definition" : "Critically low",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "LU",
      "display" : "Very low",
      "definition" : "Very low",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        }
      ]
    },
    {
      "code" : "MS",
      "display" : "Moderately susceptible",
      "definition" : "Moderately susceptible. Indicates for microbiology susceptibilities only.",
      "designation" : [
        {
          "language" : "de",
          "value" : "mäßig empfindlich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Normal",
      "definition" : "Normal",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ND",
      "display" : "Not Detected",
      "definition" : "Not Detected",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NEG",
      "display" : "Negative",
      "definition" : "Negative",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NR",
      "display" : "Non-reactive",
      "definition" : "Non-reactive",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NS",
      "display" : "Non-susceptible",
      "definition" : "Non-susceptible",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        }
      ]
    },
    {
      "code" : "OBX",
      "display" : "Interpretation qualifiers in separate OBX segments",
      "definition" : "Interpretation qualifiers in separate OBX segments",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "POS",
      "display" : "Positive",
      "definition" : "Positive",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "QCF",
      "display" : "Quality Control Failure",
      "definition" : "Quality Control Failure",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Resistant",
      "definition" : "Resistant",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RR",
      "display" : "Reactive",
      "definition" : "Reactive",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Susceptible",
      "definition" : "Susceptible",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "SDD",
      "display" : "Susceptible",
      "definition" : "Susceptible-dose dependent",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        }
      ]
    },
    {
      "code" : "SYN-R",
      "display" : "Synergy - resistant",
      "definition" : "Synergy - resistant",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        }
      ]
    },
    {
      "code" : "SYN-S",
      "display" : "Synergy - susceptible",
      "definition" : "Synergy - susceptible",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        }
      ]
    },
    {
      "code" : "TOX",
      "display" : "Cytotoxic substance present",
      "definition" : "Cytotoxic substance present",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Significant change up",
      "definition" : "Significant change up",
      "designation" : [
        {
          "language" : "de",
          "value" : "Deutlicher Trend nach oben"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "VS",
      "display" : "Very susceptible",
      "definition" : "Very susceptible. Indicates for microbiology susceptibilities only.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sehr empfindlich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-08-02"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "W",
      "display" : "Worse",
      "definition" : "Worse",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verschlechterung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "WR",
      "display" : "Weakly reactive",
      "definition" : "Weakly reactive",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "null",
      "display" : "No range defined, or normal ranges don't apply",
      "definition" : "No range defined, or normal ranges don't apply",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kein Referenzbereich / Referenzbereich nicht anwendbar"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
