# Nature of Challenge (2.8.2 - 1.0.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nature of Challenge (2.8.2 - 1.0.0)**

## CodeSystem: Nature of Challenge (2.8.2 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/natureOfChallenge | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:NatureOfChallenge |
| *Other Identifiers:*OID:2.16.840.1.113883.18.152 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation. Used in HL7 Version 2.x messaging in the OM1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSnatureOfChallenge](ValueSet-hl7VSnatureOfChallenge.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "natureOfChallenge",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0257"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/natureOfChallenge",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.152"
    }
  ],
  "version" : "1.0.0",
  "name" : "NatureOfChallenge",
  "title" : "Nature of Challenge (2.8.2 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation.  Used in HL7 Version 2.x messaging in the OM1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CFST",
      "display" : "Fasting (no calorie intake) for the period specified in the time component of the term, e.g., 1H POST CFST",
      "definition" : "Fasting (no calorie intake) for the period specified in the time component of the term, e.g., 1H POST CFST",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EXCZ",
      "display" : "Exercise undertaken as challenge",
      "definition" : "Exercise undertaken as challenge (can be quantified)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "can be quantified"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "FFST",
      "display" : "No fluid intake for the period specified in the time component of the term",
      "definition" : "No fluid intake for the period specified in the time component of the term",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
