# Coding System (2.8.2 - 1.8.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coding System (2.8.2 - 1.8.0)**

## CodeSystem: Coding System (2.8.2 - 1.8.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/codingSystem | *Version*:1.8.0 |
| Active as of 2026-01-27 | *Computable Name*:CodingSystem |
| *Other Identifiers:*OID:2.16.840.1.113883.18.247 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the coding system. This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm. Used in HL7 Version 2.x messaging in the CWE segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScodingSystem](ValueSet-hl7VScodingSystem.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "codingSystem",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0396"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/codingSystem",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.247"
    }
  ],
  "version" : "1.8.0",
  "name" : "CodingSystem",
  "title" : "Coding System (2.8.2 - 1.8.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the coding system.  This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm.  Used in HL7 Version 2.x messaging in the CWE segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "category",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#category",
      "description" : "category",
      "type" : "string"
    },
    {
      "code" : "country",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#country",
      "description" : "country",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "99zzz",
      "display" : "Local general code where z is an alphanumeric character",
      "definition" : "Local general code where z is an alphanumeric character",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ACR",
      "display" : "American College of Radiology finding codes",
      "definition" : "American College of Radiology finding codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ACTCODE",
      "display" : "Table of HL7 Version 3 ActCode values",
      "definition" : "Table of HL7 Version 3 ActCode values",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ACTRELSS",
      "display" : "Used to indicate that the target of the relationship will be a filtered subset of the total related set of targets.\r\nUsed when there is a need to limit the number of components to the first, the last, the next, the total, the average or some other filtere",
      "definition" : "Used to indicate that the target of the relationship will be a filtered subset of the total related set of targets.\r\nUsed when there is a need to limit the number of components to the first, the last, the next, the total, the average or some other filtere",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ALPHAID2006",
      "display" : "German Alpha-ID v2006",
      "definition" : "German Alpha-ID v2006",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ALPHAID2007",
      "display" : "German Alpha-ID v2007",
      "definition" : "German Alpha-ID v2007",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ALPHAID2008",
      "display" : "German Alpha-ID v2008",
      "definition" : "German Alpha-ID v2008",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ALPHAID2009",
      "display" : "German Alpha-ID v2009",
      "definition" : "German Alpha-ID v2009",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ALPHAID2010",
      "display" : "German Alpha-ID v2010",
      "definition" : "German Alpha-ID v2010",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ALPHAID2011",
      "display" : "German Alpha-ID v2011",
      "definition" : "German Alpha-ID v2011",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ALPHAID2012",
      "display" : "German Alpha-ID v2012",
      "definition" : "German Alpha-ID v2012",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "ALPHAID2013",
      "display" : "German Alpha-ID v2013",
      "definition" : "German Alpha-ID v2013",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "ALPHAID2014",
      "display" : "German Alpha-ID v2014",
      "definition" : "German Alpha-ID v2014",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "ALPHAID2015",
      "display" : "German Alpha-ID v2015",
      "definition" : "German Alpha-ID v2015",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ALPHAID2016",
      "display" : "German Alpha-ID v2016",
      "definition" : "German Alpha-ID v2016",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "AMTv2",
      "display" : "Australian Medicines Terminology (v2)",
      "definition" : "Australian Medicines Terminology (v2)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ANS+",
      "display" : "HL7 set of units of measure",
      "definition" : "HL7 set of units of measure",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ART",
      "display" : "WHO Adverse Reaction Terms",
      "definition" : "WHO Adverse Reaction Terms",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AS4",
      "display" : "ASTM E1238/ E1467 Universal",
      "definition" : "ASTM E1238/ E1467 Universal",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AS4E",
      "display" : "AS4 Neurophysiology Codes",
      "definition" : "AS4 Neurophysiology Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ATC",
      "display" : "American Type Culture Collection",
      "definition" : "American Type Culture Collection",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C4",
      "display" : "CPT-4",
      "definition" : "CPT-4",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C5",
      "display" : "CPT-5",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Not currently being worked on, no proposed release date at this time.  American Medical Association, P.O. Box 10946, Chicago IL  60610."
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CAPECC",
      "display" : "College of American Pathologists Electronic Cancer Checklist",
      "definition" : "College of American Pathologists Electronic Cancer Checklist",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CAS",
      "display" : "Chemical abstract codes",
      "definition" : "Chemical abstract codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CCC",
      "display" : "Clinical Care Classification system",
      "definition" : "Clinical Care Classification system",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "CD2",
      "display" : "CDT-2 Codes",
      "definition" : "CDT-2 Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CDCA",
      "display" : "CDC Analyte Codes",
      "definition" : "CDC Analyte Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "country",
          "valueString" : "US"
        }
      ]
    },
    {
      "code" : "CDCEDACUITY",
      "display" : "CDC Emergency Department Acuity",
      "definition" : "CDC Emergency Department Acuity",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "US"
        }
      ]
    },
    {
      "code" : "CDCM",
      "display" : "CDC Methods/Instruments Codes",
      "definition" : "CDC Methods/Instruments Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "country",
          "valueString" : "US"
        }
      ]
    },
    {
      "code" : "CDCNHSN",
      "display" : "CDC National Healthcare Safety Network Codes",
      "definition" : "CDC National Healthcare Safety Network Codes",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "CDCOBS",
      "display" : "CDC BioSense RT observations (Census) - CDC",
      "definition" : "CDC BioSense RT observations (Census) - CDC",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "US"
        }
      ]
    },
    {
      "code" : "CDCPHINVS",
      "display" : "CDC PHIN Vocabulary Coding System",
      "definition" : "CDC PHIN Vocabulary Coding System",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "US"
        }
      ]
    },
    {
      "code" : "CDCREC",
      "display" : "Race & Ethnicity - CDC",
      "definition" : "Race & Ethnicity - CDC",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "US"
        }
      ]
    },
    {
      "code" : "CDS",
      "display" : "CDC Surveillance",
      "definition" : "CDC Surveillance",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CE",
      "display" : "CEN ECG diagnostic codes",
      "definition" : "CEN ECG diagnostic codes",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CLP",
      "display" : "CLIP",
      "definition" : "CLIP",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CPTM",
      "display" : "CPT Modifier Code",
      "definition" : "CPT Modifier Code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CST",
      "display" : "COSTART",
      "definition" : "COSTART",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CVX",
      "display" : "CDC Vaccine Codes",
      "definition" : "CDC Vaccine Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DCL",
      "display" : "DICOM Class Label",
      "definition" : "DICOM Class Label",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DCM",
      "display" : "DICOM Controlled Terminology",
      "definition" : "DICOM Controlled Terminology",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DQL",
      "display" : "DICOM Query Label",
      "definition" : "DICOM Query Label",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "EUCLIDES",
      "definition" : "EUCLIDES",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E5",
      "display" : "Euclides  quantity codes",
      "definition" : "Euclides  quantity codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E6",
      "display" : "Euclides Lab method codes",
      "definition" : "Euclides Lab method codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E7",
      "display" : "Euclides Lab equipment codes",
      "definition" : "Euclides Lab equipment codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EDLEVEL",
      "display" : "Education Level",
      "definition" : "Education Level",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ENTITYCODE",
      "display" : "Entity Code",
      "definition" : "Entity Code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ENTITYHDLG",
      "display" : "Entity Handling Code",
      "definition" : "Entity Handling Code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ENZC",
      "display" : "Enzyme Codes",
      "definition" : "Enzyme Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EPASRS",
      "display" : "EPA SRS",
      "definition" : "EPA SRS",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "FDAUDI",
      "display" : "FDA Unique Device Identifier",
      "definition" : "FDA Unique Device Identifier",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "FDAUNII",
      "display" : "Unique Ingredient Identifier (UNII)",
      "definition" : "Unique Ingredient Identifier (UNII)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "FDDC",
      "display" : "First DataBank Drug Codes",
      "definition" : "First DataBank Drug Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FDDX",
      "display" : "First DataBank Diagnostic Codes",
      "definition" : "First DataBank Diagnostic Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FDK",
      "display" : "FDA K10",
      "definition" : "FDA K10",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FIPS5_2",
      "display" : "FIPS 5-2 (State)",
      "definition" : "FIPS 5-2 (State)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "FIPS6_4",
      "display" : "FIPS 6-4 (County)",
      "definition" : "FIPS 6-4 (County)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "GDRG2004",
      "display" : "G-DRG German DRG Codes v2004",
      "definition" : "G-DRG German DRG Codes v2004",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GDRG2005",
      "display" : "G-DRG German DRG Codes v2005",
      "definition" : "G-DRG German DRG Codes v2005",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GDRG2006",
      "display" : "G-DRG German DRG Codes v2006",
      "definition" : "G-DRG German DRG Codes v2006",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GDRG2007",
      "display" : "G-DRG German DRG Codes v2007",
      "definition" : "G-DRG German DRG Codes v2007",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GDRG2008",
      "display" : "G-DRG German DRG Codes v2008",
      "definition" : "G-DRG German DRG Codes v2008",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GDRG2009",
      "display" : "G-DRG German DRG Codes v2009",
      "definition" : "G-DRG German DRG Codes v2009",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "GDRG2010",
      "display" : "G-DRG German DRG Codes v2010",
      "definition" : "G-DRG German DRG Codes v2010",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Handbook for DRGs 2010."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GDRG2011",
      "display" : "G-DRG German DRG Codes v2011",
      "definition" : "G-DRG German DRG Codes v2011",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Handbook for DRGs 2011."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GDRG2012",
      "display" : "G-DRG German DRG Codes v2012",
      "definition" : "G-DRG German DRG Codes v2012",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Handbook for DRGs 2012."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GDRG2013",
      "display" : "G-DRG German DRG Codes v2013",
      "definition" : "G-DRG German DRG Codes v2013",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Handbook for DRGs 2013."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GDRG2014",
      "display" : "G-DRG German DRG Codes v2014",
      "definition" : "G-DRG German DRG Codes v2014",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Handbook for DRGs 2014."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GDRG2015",
      "display" : "G-DRG German DRG Codes v2015",
      "definition" : "G-DRG German DRG Codes v2015",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Handbook for DRGs 2015."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "GDRG2016",
      "display" : "G-DRG German DRG Codes v2016",
      "definition" : "G-DRG German DRG Codes v2016",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Handbook for DRGs 2016."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "GMDC2004",
      "display" : "German Major Diagnostic Codes v2004",
      "definition" : "German Major Diagnostic Codes v2004",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GMDC2005",
      "display" : "German Major Diagnostic Codes v2005",
      "definition" : "German Major Diagnostic Codes v2005",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GMDC2006",
      "display" : "German Major Diagnostic Codes v2006",
      "definition" : "German Major Diagnostic Codes v2006",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GMDC2007",
      "display" : "German Major Diagnostic Codes v2007",
      "definition" : "German Major Diagnostic Codes v2007",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GMDC2008",
      "display" : "German Major Diagnostic Codes v2008",
      "definition" : "German Major Diagnostic Codes v2008",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GMDC2009",
      "display" : "German Major Diagnostic Codes v2009",
      "definition" : "German Major Diagnostic Codes v2009",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "GMDC2010",
      "display" : "German Major Diagnostic Codes v2010",
      "definition" : "German Major Diagnostic Codes v2010",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Major Diagnostic Codes version 2010."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GMDC2011",
      "display" : "German Major Diagnostic Codes v2011",
      "definition" : "German Major Diagnostic Codes v2011",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Major Diagnostic Codes version 2011."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GMDC2012",
      "display" : "German Major Diagnostic Codes v2012",
      "definition" : "German Major Diagnostic Codes v2012",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Major Diagnostic Codes version 2012."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GMDC2013",
      "display" : "German Major Diagnostic Codes v2013",
      "definition" : "German Major Diagnostic Codes v2013",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Major Diagnostic Codes version 2013."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GMDC2014",
      "display" : "German Major Diagnostic Codes v2014",
      "definition" : "German Major Diagnostic Codes v2014",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Major Diagnostic Codes version 2014."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GMDC2015",
      "display" : "German Major Diagnostic Codes v2015",
      "definition" : "German Major Diagnostic Codes v2015",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Major Diagnostic Codes version 2015."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "GMDC2016",
      "display" : "German Major Diagnostic Codes v2016",
      "definition" : "German Major Diagnostic Codes v2016",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "German Major Diagnostic Codes version 2016."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "GS1UDI",
      "display" : "GS1 Unique Device Identifier",
      "definition" : "GS1 Unique Device Identifier",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "HB",
      "display" : "HIBCC",
      "definition" : "HIBCC",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HCPCS",
      "display" : "CMS (formerly HCFA)  Common Procedure Coding System",
      "definition" : "CMS (formerly HCFA)  Common Procedure Coding System",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HCPT",
      "display" : "Health Care Provider Taxonomy",
      "definition" : "Health Care Provider Taxonomy",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HHC",
      "display" : "Home Health Care",
      "definition" : "Home Health Care",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HI",
      "display" : "Health Outcomes",
      "definition" : "Health Outcomes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HIBUDI",
      "display" : "HIBCC Unique Device Identifier",
      "definition" : "HIBCC Unique Device Identifier",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "HL7nnnn",
      "display" : "HL7 Defined Codes where nnnn is the HL7 table number",
      "definition" : "HL7 Defined Codes where nnnn is the HL7 table number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HOT",
      "display" : "Japanese Nationwide Medicine Code",
      "definition" : "Japanese Nationwide Medicine Code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HPC",
      "display" : "CMS (formerly HCFA )Procedure Codes (HCPCS)",
      "definition" : "CMS (formerly HCFA )Procedure Codes (HCPCS)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The HCPCS code is divided into three \"levels.\"  Level I includes the entire CPT-4 code by reference.  Level II includes the American Dental Association’s Current Dental Terminology (CDT-2) code by reference.  Level II also includes the genuine HCPCS codes, approved and maintained jointly by the Alpha-Numeric Editorial Panel, consisting of CMS, the Health Insurance Association of America, and the Blue Cross and Blue Shield Association. Level III are codes developed locally by Medicare carriers.  The HCPCS modifiers are divided into the same three levels, I being CPT-4 modifiers, II CDT-2 and genuine HCPCS modifiers, and III being locally agreed modifiers."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HSLOC",
      "display" : "Healthcare Service Location",
      "definition" : "Healthcare Service Location",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "I10",
      "display" : "ICD-10",
      "definition" : "ICD-10",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I10C",
      "display" : "International Classification of Diseases, 10th  Revision, Clinical Modification (ICD-10-CM)",
      "definition" : "International Classification of Diseases, 10th  Revision, Clinical Modification (ICD-10-CM)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "I10G2004",
      "display" : "ICD 10 Germany 2004",
      "definition" : "ICD 10 Germany 2004",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "I10G2005",
      "display" : "ICD 10 Germany 2005",
      "definition" : "ICD 10 Germany 2005",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "I10G2006",
      "display" : "ICD 10 Germany 2006",
      "definition" : "ICD 10 Germany 2006",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "I10P",
      "display" : "ICD-10  Procedure Codes",
      "definition" : "ICD-10  Procedure Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I9",
      "display" : "ICD9",
      "definition" : "ICD9",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I9C",
      "display" : "ICD-9CM",
      "definition" : "ICD-9CM",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I9CDX",
      "display" : "ICD-9CM Diagnosis codes",
      "definition" : "ICD-9CM Diagnosis codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "I9CP",
      "display" : "ICD-9CM Procedure codes",
      "definition" : "ICD-9CM Procedure codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "IBT",
      "display" : "ISBT",
      "definition" : "ISBT",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IBT0001",
      "display" : "ISBT 128 Standard transfusion/transplantation data items",
      "definition" : "ISBT 128 Standard transfusion/transplantation data items",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "IBTnnnn",
      "display" : "ISBT 128 codes where nnnn  specifies a specific table within ISBT 128.",
      "definition" : "ISBT 128 codes where nnnn  specifies a specific table within ISBT 128.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "IC2",
      "display" : "ICHPPC-2",
      "definition" : "ICHPPC-2",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ICCUDI",
      "display" : "ICCBBA Unique Device Identifier",
      "definition" : "ICCBBA Unique Device Identifier",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ICD10AM",
      "display" : "ICD-10 Australian modification",
      "definition" : "ICD-10 Australian modification",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ICD10CA",
      "display" : "ICD-10 Canada",
      "definition" : "ICD-10 Canada",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ICD10GM2007",
      "display" : "ICD 10 Germany v2007",
      "definition" : "ICD 10 Germany v2007",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2008",
      "display" : "ICD 10 Germany v2008",
      "definition" : "ICD 10 Germany v2008",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2009",
      "display" : "ICD 10 Germany v2009",
      "definition" : "ICD 10 Germany v2009",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2010",
      "display" : "ICD 10 Germany v2010",
      "definition" : "ICD 10 Germany v2010",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2011",
      "display" : "ICD 10 Germany v2011",
      "definition" : "ICD 10 Germany v2011",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2012",
      "display" : "ICD 10 Germany v2012",
      "definition" : "ICD 10 Germany v2012",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2013",
      "display" : "ICD 10 Germany v2013",
      "definition" : "ICD 10 Germany v2013",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2014",
      "display" : "ICD 10 Germany v2014",
      "definition" : "ICD 10 Germany v2014",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2015",
      "display" : "ICD 10 Germany v2015",
      "definition" : "ICD 10 Germany v2015",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICD10GM2016",
      "display" : "ICD 10 Germany v2016",
      "definition" : "ICD 10 Germany v2016",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "ICDO",
      "display" : "International Classification of Diseases for Oncology",
      "definition" : "International Classification of Diseases for Oncology",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ICDO2",
      "display" : "International Classification of Disease for Oncology Second Edition",
      "definition" : "International Classification of Disease for Oncology Second Edition",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "ICDO3",
      "display" : "International Classification of Disease for Oncology Third Edition",
      "definition" : "International Classification of Disease for Oncology Third Edition",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "ICF",
      "display" : "International Classification of Functioning, Disability and Health (ICF)",
      "definition" : "International Classification of Functioning, Disability and Health (ICF)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ICS",
      "display" : "ICCS",
      "definition" : "ICCS",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ICSD",
      "display" : "International Classification of Sleep Disorders",
      "definition" : "International Classification of Sleep Disorders",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IHELAW",
      "display" : "IHE Laboratory Analytical Workflow (LAW) Profile Codes.",
      "definition" : "IHE Laboratory Analytical Workflow (LAW) Profile Codes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ISO",
      "display" : "ISO 2955.83 (units of measure) with HL7 extensions",
      "definition" : "ISO 2955.83 (units of measure) with HL7 extensions",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ISO3166_1",
      "display" : "ISO 3166-1 Country Codes",
      "definition" : "ISO 3166-1 Country Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "ISO3166_2",
      "display" : "ISO 3166-2 Country subdivisions",
      "definition" : "ISO 3166-2 Country subdivisions",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "ISO4217",
      "display" : "ISO4217 Currency Codes",
      "definition" : "ISO4217 Currency Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "ISO639",
      "display" : "ISO 639 Language",
      "definition" : "ISO 639 Language",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "ISOnnnn",
      "display" : "ISO Defined Codes where nnnn is the ISO table number",
      "definition" : "ISO Defined Codes where nnnn is the ISO table number",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-11-24"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ITIS",
      "display" : "Integrated Taxonomic Information System",
      "definition" : "Integrated Taxonomic Information System",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "IUPC",
      "display" : "IUPAC/IFCC Component Codes",
      "definition" : "IUPAC/IFCC Component Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IUPP",
      "display" : "IUPAC/IFCC Property Codes",
      "definition" : "IUPAC/IFCC Property Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JC10",
      "display" : "JLAC/JSLM, nationwide laboratory code",
      "definition" : "JLAC/JSLM, nationwide laboratory code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "JC8",
      "display" : "Japanese Chemistry",
      "definition" : "Japanese Chemistry",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JJ1017",
      "display" : "Japanese Image Examination Cache",
      "definition" : "Japanese Image Examination Cache",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Local general code",
      "definition" : "Local general code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LANGUAL",
      "display" : "LanguaL",
      "definition" : "LanguaL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "LB",
      "display" : "Local billing code",
      "definition" : "Local billing code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LN",
      "display" : "Logical Observation Identifier Names and Codes (LOINCÂ®)",
      "definition" : "Logical Observation Identifier Names and Codes (LOINCÂ®)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MCD",
      "display" : "Medicaid",
      "definition" : "Medicaid",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MCR",
      "display" : "Medicare",
      "definition" : "Medicare",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MDC",
      "display" : "Medical Device Communication",
      "definition" : "Medical Device Communication",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "MDDX",
      "display" : "Medispan Diagnostic Codes",
      "definition" : "Medispan Diagnostic Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MEDC",
      "display" : "Medical Economics Drug Codes",
      "definition" : "Medical Economics Drug Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MEDIATYPE",
      "display" : "MIME Media Type IANA",
      "definition" : "MIME Media Type IANA",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "MEDR",
      "display" : "Medical Dictionary for Drug Regulatory Affairs (MEDDRA)",
      "definition" : "Medical Dictionary for Drug Regulatory Affairs (MEDDRA)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MEDX",
      "display" : "Medical Economics Diagnostic Codes",
      "definition" : "Medical Economics Diagnostic Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MGPI",
      "display" : "Medispan GPI",
      "definition" : "Medispan GPI",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MVX",
      "display" : "CDC Vaccine Manufacturer Codes",
      "definition" : "CDC Vaccine Manufacturer Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NAICS",
      "display" : "Industry (NAICS)",
      "definition" : "Industry (NAICS)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NCPDPnnnnsss",
      "display" : "NCPDP code list for data element nnnn [as used in segment sss]",
      "definition" : "NCPDP code list for data element nnnn [as used in segment sss]",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "NDA",
      "display" : "NANDA",
      "definition" : "NANDA",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NDC",
      "display" : "National drug codes",
      "definition" : "National drug codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NDFRT",
      "display" : "NDF-RT (Drug Classification)",
      "definition" : "NDF-RT (Drug Classification)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NIC",
      "display" : "Nursing Interventions Classification",
      "definition" : "Nursing Interventions Classification",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NIP001",
      "display" : "Source of Information (Immunization)",
      "definition" : "Source of Information (Immunization)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NIP002",
      "display" : "Substance refusal reason",
      "definition" : "Substance refusal reason",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NIP004",
      "display" : "Vaccination - Contraindications, Precautions, and Immunities",
      "definition" : "Vaccination - Contraindications, Precautions, and Immunities",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NIP007",
      "display" : "Vaccinated at location (facility)",
      "definition" : "Vaccinated at location (facility)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NIP008",
      "display" : "Vaccine purchased with (Type of funding)",
      "definition" : "Vaccine purchased with (Type of funding)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NIP009",
      "display" : "Reported adverse event previously",
      "definition" : "Reported adverse event previously",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NIP010",
      "display" : "VAERS Report type",
      "definition" : "VAERS Report type",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NND",
      "display" : "Notifiable Event (Disease/Condition) Code List",
      "definition" : "Notifiable Event (Disease/Condition) Code List",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "NPI",
      "display" : "National Provider Identifier",
      "definition" : "National Provider Identifier",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NUBC",
      "display" : "National Uniform Billing Committee",
      "definition" : "National Uniform Billing Committee",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NULLFL",
      "display" : "Null Flavor",
      "definition" : "Null Flavor",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "O301",
      "display" : "German Procedure Codes",
      "definition" : "German Procedure Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "O3012004",
      "display" : "OPS Germany v2004",
      "definition" : "OPS Germany v2004",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "O3012005",
      "display" : "OPS Germany v2005",
      "definition" : "OPS Germany v2005",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "O3012006",
      "display" : "OPS Germany v2006",
      "definition" : "OPS Germany v2006",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "OBSMETHOD",
      "display" : "Observation Method Code",
      "definition" : "Observation Method Code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OHA",
      "display" : "Omaha System",
      "definition" : "Omaha System",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OPS2007",
      "display" : "OPS Germany v2007",
      "definition" : "OPS Germany v2007",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "OPS2008",
      "display" : "OPS Germany v2008",
      "definition" : "OPS Germany v2008",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "OPS2009",
      "display" : "OPS Germany v2009",
      "definition" : "OPS Germany v2009",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "OPS2010",
      "display" : "OPS Germany v2010",
      "definition" : "OPS Germany v2010",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "OPS2011",
      "display" : "OPS Germany v2011",
      "definition" : "OPS Germany v2011",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "country",
          "valueString" : "Germany"
        }
      ]
    },
    {
      "code" : "OPS2012",
      "display" : "OPS Germany v2012",
      "definition" : "OPS Germany v2012",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OPS2013",
      "display" : "OPS Germany v2013",
      "definition" : "OPS Germany v2013",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OPS2014",
      "display" : "OPS Germany v2014",
      "definition" : "OPS Germany v2014",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OPS2015",
      "display" : "OPS Germany v2015",
      "definition" : "OPS Germany v2015",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "OPS2016",
      "display" : "OPS Germany v2016",
      "definition" : "OPS Germany v2016",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PHDSCSOPT",
      "display" : "Source of Payment Typology",
      "definition" : "Source of Payment Typology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PHINQUESTION",
      "display" : "CDC Public Health Information Network (PHIN) Question",
      "definition" : "CDC Public Health Information Network (PHIN) Question",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PLR",
      "display" : "CDC PHLIP Lab result codes that are not covered in SNOMED at the time of this implementation",
      "definition" : "CDC PHLIP Lab result codes that are not covered in SNOMED at the time of this implementation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PLT",
      "display" : "CDC PHLIP Lab test codes, where LOINC concept is too broad or not yet available, especially as needed for ordering and or lab to lab reporting )",
      "definition" : "CDC PHLIP Lab test codes, where LOINC concept is too broad or not yet available, especially as needed for ordering and or lab to lab reporting )",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "POS",
      "display" : "POS Codes",
      "definition" : "POS Codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PRTCPTNMODE",
      "display" : "Paticipation Mode Code",
      "definition" : "Paticipation Mode Code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "RC",
      "display" : "Read Classification",
      "definition" : "Read Classification",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ROLECLASS",
      "display" : "Used initially for contact roles.",
      "definition" : "Used initially for contact roles.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "ROLECODE",
      "display" : "Participation Mode",
      "definition" : "Participation Mode",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "RSPMODE",
      "display" : "Specifies the mode, immediate versus deferred or queued, by which a receiver should communicate its receiver responsibilities.",
      "definition" : "Specifies the mode, immediate versus deferred or queued, by which a receiver should communicate its receiver responsibilities.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "RXNORM",
      "display" : "RxNorm",
      "definition" : "RxNorm",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "SCT",
      "display" : "SNOMED Clinical Terms",
      "definition" : "SNOMED Clinical Terms",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "SCT2",
      "display" : "SNOMED Clinical Terms alphanumeric codes",
      "definition" : "SNOMED Clinical Terms alphanumeric codes",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "SDM",
      "display" : "SNOMED- DICOM Microglossary",
      "definition" : "SNOMED- DICOM Microglossary",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SIC",
      "display" : "Industry (SIC)",
      "definition" : "Industry (SIC)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "SNM",
      "display" : "Systemized Nomenclature of Medicine (SNOMED)",
      "definition" : "Systemized Nomenclature of Medicine (SNOMED)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SNM3",
      "display" : "SNOMED International",
      "definition" : "SNOMED International",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SNT",
      "display" : "SNOMED topology codes (anatomic sites)",
      "definition" : "SNOMED topology codes (anatomic sites)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SOC",
      "display" : "Occupation (SOC 2000)",
      "definition" : "Occupation (SOC 2000)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "UB04FL14",
      "display" : "Priority (Type) of Visit",
      "definition" : "Priority (Type) of Visit",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "UB04FL15",
      "display" : "Point of Origin",
      "definition" : "Point of Origin",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "UB04FL17",
      "display" : "Patient Discharge Status",
      "definition" : "Patient Discharge Status",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "UB04FL31",
      "display" : "Occurrence Code",
      "definition" : "Occurrence Code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "UB04FL35",
      "display" : "Occurrence Span",
      "definition" : "Occurrence Span",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "UB04FL39",
      "display" : "Value Code",
      "definition" : "Value Code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "UC",
      "display" : "UCDS",
      "definition" : "UCDS",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UCUM",
      "display" : "UCUM code set for units of measure(from Regenstrief)",
      "definition" : "UCUM code set for units of measure(from Regenstrief)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "UMD",
      "display" : "MDNS",
      "definition" : "MDNS",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UML",
      "display" : "Unified Medical Language",
      "definition" : "Unified Medical Language",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UPC",
      "display" : "Universal Product Code",
      "definition" : "Universal Product Code",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UPIN",
      "display" : "UPIN",
      "definition" : "UPIN",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "USGSGNIS",
      "display" : "U.S. Board on Geographic Names (USGS - GNIS)",
      "definition" : "U.S. Board on Geographic Names (USGS - GNIS)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "USPS",
      "display" : "United States Postal Service",
      "definition" : "United States Postal Service",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "VIS",
      "display" : "Clinicians are required to track the Vaccine Information Sheet (VIS) that was shared with the recipient of a vaccination.  This code system contains codes that  identify the document type and the owner of the document.",
      "definition" : "Clinicians are required to track the Vaccine Information Sheet (VIS) that was shared with the recipient of a vaccination.  This code system contains codes that  identify the document type and the owner of the document.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "W1",
      "display" : "WHO record # drug codes (6 digit)",
      "definition" : "WHO record # drug codes (6 digit)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "W2",
      "display" : "WHO record # drug codes (8 digit)",
      "definition" : "WHO record # drug codes (8 digit)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "W4",
      "display" : "WHO record # code with ASTM extension",
      "definition" : "WHO record # code with ASTM extension",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "WC",
      "display" : "WHO ATC",
      "definition" : "WHO ATC",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "X12Dennnn",
      "display" : "ASC X12 Code List nnnn",
      "definition" : "ASC X12 Code List nnnn",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "cdcgs1vis",
      "display" : "VIS Bar Codes (IIS)",
      "definition" : "VIS Bar Codes (IIS)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-11-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    }
  ]
}

```
