# Address Type (2.8.2 - 1.5.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Address Type (2.8.2 - 1.5.0)**

## CodeSystem: Address Type (2.8.2 - 1.5.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/addressType | *Version*:1.5.0 |
| Active as of 2026-01-27 | *Computable Name*:AddressType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.101 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.x messaging in the XAD segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSaddressType](ValueSet-hl7VSaddressType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "addressType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0190"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/addressType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.101"
    }
  ],
  "version" : "1.5.0",
  "name" : "AddressType",
  "title" : "Address Type (2.8.2 - 1.5.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying types or kinds of addresses.  Used in HL7 Version 2.x messaging in the XAD segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "Firm/Business",
      "definition" : "Firm/Business",
      "designation" : [
        {
          "language" : "de",
          "value" : "Firma/Geschäft"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "BA",
      "display" : "Bad address",
      "definition" : "Bad address",
      "designation" : [
        {
          "language" : "de",
          "value" : "ungültige Adresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BDL",
      "display" : "Birth delivery location  (address where birth occurred)",
      "definition" : "Birth delivery location  (address where birth occurred)",
      "designation" : [
        {
          "language" : "de",
          "value" : "genauer Geburtsort"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BI",
      "display" : "Billing Address",
      "definition" : "Billing Address",
      "designation" : [
        {
          "language" : "de",
          "value" : "Rechnungsadresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "BR",
      "display" : "Residence at birth (home address at time of birth)",
      "definition" : "Residence at birth (home address at time of birth)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wohnort zum Zeit­punkt der Geburt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Current Or Temporary",
      "definition" : "Current Or Temporary",
      "designation" : [
        {
          "language" : "de",
          "value" : "Derzeitige Adresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Country Of Origin",
      "definition" : "Country Of Origin",
      "designation" : [
        {
          "language" : "de",
          "value" : "Herkunftsland"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "Home",
      "definition" : "Home",
      "designation" : [
        {
          "language" : "de",
          "value" : "Privatadresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Legal Address",
      "definition" : "Legal Address",
      "designation" : [
        {
          "language" : "de",
          "value" : "registrierte Adresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Mailing",
      "definition" : "Mailing",
      "designation" : [
        {
          "language" : "de",
          "value" : "Postalische Adresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Birth (nee) (birth address, not otherwise specified)",
      "definition" : "Birth (nee)  (birth address, not otherwise specified)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Office/Business",
      "definition" : "Office/Business",
      "designation" : [
        {
          "language" : "de",
          "value" : "Büroadresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Permanent",
      "definition" : "Permanent",
      "designation" : [
        {
          "language" : "de",
          "value" : "Dauernder Wohnsitz"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RH",
      "display" : "Registry home",
      "definition" : "Registry home. Refers to the information system, typically managed by a public health agency, that stores patient information such as immunization histories or cancer data, regardless of where the patient obtains services.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Service Location",
      "definition" : "Service Location",
      "designation" : [
        {
          "language" : "de",
          "value" : "Leistungsort"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "SH",
      "display" : "Shipping Address",
      "definition" : "Shipping Address",
      "designation" : [
        {
          "language" : "de",
          "value" : "Versandadresse"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "TM",
      "display" : "Tube Address",
      "definition" : "Tube Address",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "Vacation",
      "definition" : "Vacation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Adresse des Ferienortes"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
