# Specimen Condition (2.8.2 - 1.1.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen Condition (2.8.2 - 1.1.0)**

## CodeSystem: Specimen Condition (2.8.2 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenCondition | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:SpecimenCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.317 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying a mode or state of being that describes the nature of the specimen. Used in HL7 Version 2.x messaging in the SPM segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSspecimenCondition](ValueSet-hl7VSspecimenCondition.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "specimenCondition",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0493"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/specimenCondition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.317"
    }
  ],
  "version" : "1.1.0",
  "name" : "SpecimenCondition",
  "title" : "Specimen Condition (2.8.2 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying a mode or state of being that describes the nature of the specimen.  Used in HL7 Version 2.x messaging in the SPM segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AUT",
      "display" : "Autolyzed",
      "definition" : "Autolyzed",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CFU",
      "display" : "Centrifuged",
      "definition" : "Centrifuged",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "CLOT",
      "display" : "Clotted",
      "definition" : "Clotted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CON",
      "display" : "Contaminated",
      "definition" : "Contaminated",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COOL",
      "display" : "Cool",
      "definition" : "Cool",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FROZ",
      "display" : "Frozen",
      "definition" : "Frozen",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HEM",
      "display" : "Hemolyzed",
      "definition" : "Hemolyzed",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LIVE",
      "display" : "Live",
      "definition" : "Live",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ROOM",
      "display" : "Room temperature",
      "definition" : "Room temperature",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SNR",
      "display" : "Sample not received",
      "definition" : "Sample not received",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
