# Response Flag (2.8.2 - 1.0.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Response Flag (2.8.2 - 1.0.0)**

## CodeSystem: Response Flag (2.8.2 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/responseFlag | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ResponseFlag |
| *Other Identifiers:*OID:2.16.840.1.113883.18.49 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler. Used in HL7 Version 2.x messaging in the ORC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSresponseFlag](ValueSet-hl7VSresponseFlag.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "responseFlag",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0121"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/responseFlag",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.49"
    }
  ],
  "version" : "1.0.0",
  "name" : "ResponseFlag",
  "title" : "Response Flag (2.8.2 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler.  Used in HL7 Version 2.x messaging in the ORC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "D",
      "display" : "Same as R, also other associated segments",
      "definition" : "Same as R, also other associated segments",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wie R, zusätzlich Detail-Segmente (OBR usw.) von nachgeordneten und Ersatzaufträ"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Report exceptions only",
      "definition" : "Report exceptions only",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nur OK oder Fehlercode nach Auftragsprüfung / -bearbeitung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Same as D, plus confirmations explicitly",
      "definition" : "Same as D, plus confirmations explicitly",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wie D, zusätzlich ausdrückliche Bestätigungen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Only the MSA segment is returned",
      "definition" : "Only the MSA segment is returned",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nur Eingangsbestätigung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Same as E, also Replacement and Parent-Child",
      "definition" : "Same as E, also Replacement and Parent-Child",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wie E, zusätzlich ORC-Segmente von nachgeordneten und Ersatzaufträgen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
