# Practitioner ID Number Type (2.8.2 - 1.1.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner ID Number Type (2.8.2 - 1.1.0)**

## CodeSystem: Practitioner ID Number Type (2.8.2 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/practitionerIdNumberType | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:PractitionerIdNumberType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.208 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to specify the type of number used for the practitioner identification. Used in HL7 Version 2.x messaging in the Practitioner License or Other ID Number (PLN) value as well as the Provider Data (PRD) and Contact Data (CTD)segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpractitionerIdNumberType](ValueSet-hl7VSpractitionerIdNumberType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "practitionerIdNumberType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0338"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/practitionerIdNumberType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.208"
    }
  ],
  "version" : "1.1.0",
  "name" : "PractitionerIdNumberType",
  "title" : "Practitioner ID Number Type (2.8.2 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the type of number used for the practitioner identification.  Used in HL7 Version 2.x messaging in the Practitioner License or Other ID Number (PLN) value as well as the Provider Data (PRD) and Contact Data (CTD)segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CY",
      "display" : "County number",
      "definition" : "County number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DEA",
      "display" : "Drug Enforcement Agency no",
      "definition" : "Drug Enforcement Agency no.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "GL",
      "display" : "General ledger number",
      "definition" : "General ledger number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "L&I",
      "display" : "Labor and industries number",
      "definition" : "Labor and industries number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "Labor and industries number",
      "definition" : "Labor and industries number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MCD",
      "display" : "Medicaid number",
      "definition" : "Medicaid number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MCR",
      "display" : "Medicare number",
      "definition" : "Medicare number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "QA",
      "display" : "QA number",
      "definition" : "QA number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SL",
      "display" : "State license number",
      "definition" : "State license number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TAX",
      "display" : "Tax ID number",
      "definition" : "Tax ID number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TRL",
      "display" : "Training license number",
      "definition" : "Training license number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UPIN",
      "display" : "Unique physician ID no",
      "definition" : "Unique physician ID no",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
