# Patient Condition Code (2.8.2 - 1.0.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Condition Code (2.8.2 - 1.0.0)**

## CodeSystem: Patient Condition Code (2.8.2 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/patientCondition | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:PatientCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.275 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc. Used in HL7 Version 2.x messaging in the PV2 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpatientConditionCode](ValueSet-hl7VSpatientConditionCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "patientCondition",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0434"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/patientCondition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.275"
    }
  ],
  "version" : "1.0.0",
  "name" : "PatientCondition",
  "title" : "Patient Condition Code (2.8.2 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc.  Used in HL7 Version 2.x messaging in the PV2 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Satisfactory",
      "definition" : "Satisfactory",
      "designation" : [
        {
          "language" : "de",
          "value" : "zufriedenstellend"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Critical",
      "definition" : "Critical",
      "designation" : [
        {
          "language" : "de",
          "value" : "kritisch"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "sonstiges"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Poor",
      "definition" : "Poor",
      "designation" : [
        {
          "language" : "de",
          "value" : "schlecht"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Stable",
      "definition" : "Stable",
      "designation" : [
        {
          "language" : "de",
          "value" : "stabil"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "designation" : [
        {
          "language" : "de",
          "value" : "unbekannt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
