# Order Control Codes (2.8.2 - 1.7.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Order Control Codes (2.8.2 - 1.7.0)**

## CodeSystem: Order Control Codes (2.8.2 - 1.7.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/orderControlCodes | *Version*:1.7.0 |
| Active as of 2026-01-27 | *Computable Name*:OrderControlCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.48 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which are used to determine the function of the order segment. Depending on the message, the action specified by one of these control codes may refer to an order or an individual service. Used in Version 2.x messaging of orders in the ORC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSorderControl](ValueSet-hl7VSorderControl.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "orderControlCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0119"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/orderControlCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.48"
    }
  ],
  "version" : "1.7.0",
  "name" : "OrderControlCodes",
  "title" : "Order Control Codes (2.8.2 - 1.7.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which are used to determine the function of the order segment.  Depending on the message, the action specified by one of these control codes may refer to an order or an individual service.  Used in Version 2.x messaging of orders in the ORC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "application",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#application",
      "description" : "application",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "AF",
      "display" : "Order/service refill request approval",
      "definition" : "Order/service refill request approval",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CA",
      "display" : "Cancel order/service request",
      "definition" : "Cancel order/service request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag stornieren"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CH",
      "display" : "Child order/service",
      "definition" : "Child order/service",
      "designation" : [
        {
          "language" : "de",
          "value" : "nachgeordneter Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CN",
      "display" : "Combined result",
      "definition" : "Combined result",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kumulatives Ergebnis (zu mehreren Aufträgen)"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "Cancel process step",
      "definition" : "Cancel process step",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "CR",
      "display" : "Canceled as requested",
      "definition" : "Canceled as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag anweisungsgemäß storniert"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "DC",
      "display" : "Discontinue order/service request",
      "definition" : "Discontinue order/service request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsausführung abbrechen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "DE",
      "display" : "Data errors",
      "definition" : "Data errors",
      "designation" : [
        {
          "language" : "de",
          "value" : "Datenfehler"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "DF",
      "display" : "Order/service refill request denied",
      "definition" : "Order/service refill request denied",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DR",
      "display" : "Discontinued as requested",
      "definition" : "Discontinued as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsausführung anweisungsgemäß abgebrochen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "FU",
      "display" : "Order/service refilled, unsolicited",
      "definition" : "Order/service refilled, unsolicited",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "HD",
      "display" : "Hold order request",
      "definition" : "Hold order request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung aussetzen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "HR",
      "display" : "On hold as requested",
      "definition" : "On hold as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung anweisungsgemäß ausgesetzt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "Link order/service to patient care problem or goal",
      "definition" : "Link order/service to patient care problem or goal",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MC",
      "display" : "Miscellaneous Charge - not associated with an order",
      "definition" : "Miscellaneous Charge - not associated with an order",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "NA",
      "display" : "Number assigned",
      "definition" : "Number assigned",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nummer zugewiesen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "NW",
      "display" : "New order/service",
      "definition" : "New order/service",
      "designation" : [
        {
          "language" : "de",
          "value" : "Neuer Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "OC",
      "display" : "Order/service canceled",
      "definition" : "Order/service canceled",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag storniert"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OD",
      "display" : "Order/service discontinued",
      "definition" : "Order/service discontinued",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsausführung abgebrochen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "OE",
      "display" : "Order/service released",
      "definition" : "Order/service released",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OF",
      "display" : "Order/service refilled as requested",
      "definition" : "Order/service refilled as requested",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OH",
      "display" : "Order/service held",
      "definition" : "Order/service held",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung ausgesetzt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OK",
      "display" : "Order/service accepted & OK",
      "definition" : "Order/service accepted & OK",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag akzeptiert"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "OP",
      "display" : "Notification of order for outside dispense",
      "definition" : "Notification of order for outside dispense",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OR",
      "display" : "Released as requested",
      "definition" : "Released as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung anweisungsgemäß wiederaufgenommen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "Parent order/service",
      "definition" : "Parent order/service",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hauptauftrag"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "PR",
      "display" : "Previous Results with new order/service",
      "definition" : "Previous Results with new order/service",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PY",
      "display" : "Notification of replacement order for outside dispense",
      "definition" : "Notification of replacement order for outside dispense",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RE",
      "display" : "Observations/Performed Service to follow",
      "definition" : "Observations/Performed Service to follow",
      "designation" : [
        {
          "language" : "de",
          "value" : "Untersuchungsergebnisse folgen (in späteren Segmenten dieser Nachricht)"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RF",
      "display" : "Refill order/service request",
      "definition" : "Refill order/service request",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RL",
      "display" : "Release previous hold",
      "definition" : "Release previous hold",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsberabeitung wiederaufnehmen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RO",
      "display" : "Replacement order",
      "definition" : "Replacement order",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ersatzauftrag"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RP",
      "display" : "Order/service replace request",
      "definition" : "Order/service replace request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag ersetzen"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RQ",
      "display" : "Replaced as requested",
      "definition" : "Replaced as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag anweisungsgemäß ersetzt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RR",
      "display" : "Request received",
      "definition" : "Request received",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung erhalten"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RU",
      "display" : "Replaced unsolicited",
      "definition" : "Replaced unsolicited",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag ersetzt (ohne Anweisung)"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "SC",
      "display" : "Status changed",
      "definition" : "Status changed",
      "designation" : [
        {
          "language" : "de",
          "value" : "Statusänderung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SN",
      "display" : "Send order/service number",
      "definition" : "Send order/service number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrags- bzw. Bearbeitungsnummer zuweisen / übermitteln"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "SR",
      "display" : "Response to send order/service status request",
      "definition" : "Response to send order/service status request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsstatus (Antwort)"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SS",
      "display" : "Send order/service status request",
      "definition" : "Send order/service status request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsstatus senden"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "UA",
      "display" : "Unable to accept order/service",
      "definition" : "Unable to accept order/service",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsannahme nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UC",
      "display" : "Unable to cancel",
      "definition" : "Unable to cancel",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsstornierung nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "UD",
      "display" : "Unable to discontinue",
      "definition" : "Unable to discontinue",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abbrechen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "UF",
      "display" : "Unable to refill",
      "definition" : "Unable to refill",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UH",
      "display" : "Unable to put on hold",
      "definition" : "Unable to put on hold",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aussetzen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "UM",
      "display" : "Unable to replace",
      "definition" : "Unable to replace",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ersetzen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "UN",
      "display" : "Unlink order/service from patient care problem or goal",
      "definition" : "Unlink order/service from patient care problem or goal",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "UR",
      "display" : "Unable to release",
      "definition" : "Unable to release",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wiederaufnahme nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "UX",
      "display" : "Unable to change",
      "definition" : "Unable to change",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "XO",
      "display" : "Change order/service request",
      "definition" : "Change order/service request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag ändern"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "XR",
      "display" : "Changed as requested",
      "definition" : "Changed as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag anweisungsgemäß geändert"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "XX",
      "display" : "Order/service changed, unsol.",
      "definition" : "Order/service changed, unsol.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag geändert (ohne Anweisung)"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
