# Living Dependency (2.8.2 - 2.0.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Living Dependency (2.8.2 - 2.0.0)**

## CodeSystem: Living Dependency (2.8.2 - 2.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/livingDependency2 | *Version*:2.0.0 |
| Active as of 2026-01-27 | *Computable Name*:LivingDependency2 |
| *Other Identifiers:*OID:2.16.840.1.113883.18.124 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient’s healthcare needs. This information can be used for discharge planning. Examples might include Spouse Dependent, Medical Supervision Required, Small Children Dependent. Used in Version 2.s messaging in the NK1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSlivingDependency](ValueSet-hl7VSlivingDependency.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "livingDependency2",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0223"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/livingDependency2",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.124"
    }
  ],
  "version" : "2.0.0",
  "name" : "LivingDependency2",
  "title" : "Living Dependency (2.8.2 - 2.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient’s healthcare needs.  This information can be used for discharge planning.  Examples might include Spouse Dependent, Medical Supervision Required, Small Children Dependent.  Used in Version 2.s messaging in the NK1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "Small Children Dependent",
      "definition" : "Small Children Dependent",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Medical Supervision Required",
      "definition" : "Medical Supervision Required",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Spouse Dependent",
      "definition" : "Spouse Dependent",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
