# Limitation Type Codes (2.8.2 - 1.0.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Limitation Type Codes (2.8.2 - 1.0.0)**

## CodeSystem: Limitation Type Codes (2.8.2 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/limitationTypeCode | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:LimitationTypeCode |
| *Other Identifiers:*OID:2.16.840.1.113883.18.443 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the type of limitation. Used in HL7 Version 2.x messaging in the DPS segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSVS-limitationTypeCode](ValueSet-hl7VSVS-limitationTypeCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "limitationTypeCode",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0940"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/limitationTypeCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.443"
    }
  ],
  "version" : "1.0.0",
  "name" : "LimitationTypeCode",
  "title" : "Limitation Type Codes (2.8.2 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the type of limitation.  Used in HL7 Version 2.x messaging in the DPS segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "FLDP",
      "display" : "Frequency Limited Diagnostics Procedure",
      "definition" : "Frequency Limited Diagnostics Procedure",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "LCP",
      "display" : "Limited Coverage Policy",
      "definition" : "Limited Coverage Policy",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "NFDA",
      "display" : "Non-FDA Approved Diagnositic Procedure",
      "definition" : "Non-FDA Approved Diagnositic Procedure",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "NT",
      "display" : "New Test - Limited Diagnostic History",
      "definition" : "New Test - Limited Diagnostic History",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    }
  ]
}

```
