# Confidentiality (2.8.2 - 1.0.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Confidentiality (2.8.2 - 1.0.0)**

## CodeSystem: Confidentiality (2.8.2 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/confidentiality | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Confidentiality |
| *Other Identifiers:*OID:2.16.840.1.113883.18.418 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the confidentiality for the shipment. Used in HL7 Version 2.x messaging in the SHP segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSconfidentiality](ValueSet-hl7VSconfidentiality.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "confidentiality",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0907"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/confidentiality",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.418"
    }
  ],
  "version" : "1.0.0",
  "name" : "Confidentiality",
  "title" : "Confidentiality (2.8.2 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the confidentiality for the shipment.  Used in HL7 Version 2.x messaging in the SHP segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "Business - Since the service class can represent knowledge structures that may be considered a trade or business secret, there is sometimes (though rarely) the need to flag those items as of business level confidentiality.  However, no patient related inf",
      "definition" : "Business – Since the service class can represent knowledge structures that may be considered a trade or business secret, there is sometimes (though rarely) the need to flag those items as of business level confidentiality.  However, no patient related information may ever be of this confidentiality level.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Celebrity - Celebrities are people of public interest (VIP) including employees, whose information require special protection.",
      "definition" : "Celebrity - Celebrities are people of public interest (VIP) including employees, whose information require special protection.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Clinician - Only clinicians may see this item, billing and administration persons can not access this item without special permission.",
      "definition" : "Clinician - Only clinicians may see this item, billing and administration persons can not access this item without special permission.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "ETH",
      "display" : "Substance abuse related - Alcohol/drug-abuse related item",
      "definition" : "Substance abuse related - Alcohol/drug-abuse related item",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "HIV",
      "display" : "HIV Related - HIV and AIDS related item",
      "definition" : "HIV Related - HIV and AIDS related item",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Individual - Access only to individual persons who are mentioned explicitly as actors of this service and whose actor type warrants that access (cf. to actor typed code).",
      "definition" : "Individual - Access only to individual persons who are mentioned explicitly as actors of this service and whose actor type warrants that access (cf. to actor typed code).",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Low - No patient record item can be of low confidentiality.  However, some service objects are not patient related and therefore may have low confidentiality.",
      "definition" : "Low - No patient record item can be of low confidentiality.  However, some service objects are not patient related and therefore may have low confidentiality.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Normal - Normal confidentiality rules (according to good health care practice) apply, that is, only authorized individuals with a legitimate medical or business need may access this item.",
      "definition" : "Normal - Normal confidentiality rules (according to good health care practice) apply, that is, only authorized individuals with a legitimate medical or business need may access this item.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PSY",
      "display" : "Psychiatry related - Psychiatry related item",
      "definition" : "Psychiatry related - Psychiatry related item",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Restricted - Restricted access, e.g. only to providers having a current care relationship to the patient.",
      "definition" : "Restricted - Restricted access, e.g. only to providers having a current care relationship to the patient.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Sensitive - Information for which the patient seeks heightened confidentiality.  Sensitive information is not to be shared with family members.  Information reported by the patient about family members is sensitive by default.  Flag can be set or cleared",
      "definition" : "Sensitive – Information for which the patient seeks heightened confidentiality.  Sensitive information is not to be shared with family members.  Information reported by the patient about family members is sensitive by default.  Flag can be set or cleared on patient's request.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "SDV",
      "display" : "Sexual and domestic violence related - Sexual assault / domestic violence related item",
      "definition" : "Sexual and domestic violence related - Sexual assault / domestic violence related item",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Taboo - Information not to be disclosed or discussed with patient except through physician assigned to patient in this case.  This is usually a temporary constraint only; example use is a new fatal diagnosis or finding, such as malignancy or HIV.",
      "definition" : "Taboo - Information not to be disclosed or discussed with patient except through physician assigned to patient in this case.  This is usually a temporary constraint only; example use is a new fatal diagnosis or finding, such as malignancy or HIV.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "Very restricted - Very restricted access as declared by the Privacy Officer of the record holder.",
      "definition" : "Very restricted - Very restricted access as declared by the Privacy Officer of the record holder.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    }
  ]
}

```
