# Manufacturers of Vaccines (code=MVX) (2.8.2 - 1.3.0) - HL7 v2.8.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Manufacturers of Vaccines (code=MVX) (2.8.2 - 1.3.0)**

## CodeSystem: Manufacturers of Vaccines (code=MVX) (2.8.2 - 1.3.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/PH_ManufacturersOfVaccinesMVX_CDC_NIP | *Version*:1.3.0 |
| Active as of 2026-01-27 | *Computable Name*:PH_ManufacturersOfVaccinesMVX_CDC_NIP |
| *Other Identifiers:*OID:2.16.840.1.113883.12.227 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Table of codes specifying the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control. Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed at URL: https://phinvads.cdc.gov/vads/SearchCodeSystems_search.action?searchOptions.searchText=PH_ManufacturersOfVaccinesMVX_CDC_NIP. The value set is also maintained by the CDC, and may be accessed at URL: https://phinvads.cdc.gov/vads/SearchValueSets_search.action?searchOptions.searchText=PHVS_ManufacturersOfVaccinesMVX_CDC_NIP 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PHVS_ManufacturersOfVaccinesMVX_CDC_NIP](ValueSet-PHVS_ManufacturersOfVaccinesMVX_CDC_NIP.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "PH_ManufacturersOfVaccinesMVX_CDC_NIP",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0227"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/PH_ManufacturersOfVaccinesMVX_CDC_NIP",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.12.227"
    }
  ],
  "version" : "1.3.0",
  "name" : "PH_ManufacturersOfVaccinesMVX_CDC_NIP",
  "title" : "Manufacturers of Vaccines (code=MVX) (2.8.2 - 1.3.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:47:37+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Table of codes specifying the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control.  Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed at URL: https://phinvads.cdc.gov/vads/SearchCodeSystems_search.action?searchOptions.searchText=PH_ManufacturersOfVaccinesMVX_CDC_NIP.  The value set is also maintained by the CDC, and may be accessed at URL: https://phinvads.cdc.gov/vads/SearchValueSets_search.action?searchOptions.searchText=PHVS_ManufacturersOfVaccinesMVX_CDC_NIP",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AB",
      "display" : "Abbott Laboratories",
      "definition" : "Abbott Laboratories",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AD",
      "display" : "Adams Laboratories, Inc.",
      "definition" : "Adams Laboratories, Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ALP",
      "display" : "Alpha Therapeutic Corporation",
      "definition" : "Alpha Therapeutic Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "Armour",
      "definition" : "Armour",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AVB",
      "display" : "Aventis Behring L.L.C.",
      "definition" : "Aventis Behring L.L.C.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AVI",
      "display" : "Aviron",
      "definition" : "Aviron",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BA",
      "display" : "Baxter Healthcare Corporation",
      "definition" : "Baxter Healthcare Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BAH",
      "display" : "Baxter Healthcare Corporation",
      "definition" : "Baxter Healthcare Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BAY",
      "display" : "Bayer Corporation",
      "definition" : "Bayer Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BP",
      "display" : "Berna Products",
      "definition" : "Berna Products",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BPC",
      "display" : "Berna Products Corporation",
      "definition" : "Berna Products Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "CEN",
      "display" : "Centeon L.L.C.",
      "definition" : "Centeon L.L.C.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "CHI",
      "display" : "Chiron Corporation",
      "definition" : "Chiron Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "CMP",
      "display" : "Celltech Medeva Pharmaceuticals",
      "definition" : "Celltech Medeva Pharmaceuticals",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CNJ",
      "display" : "Cangene Corporation",
      "definition" : "Cangene Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "CON",
      "display" : "Connaught",
      "definition" : "Connaught",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DVC",
      "display" : "DynPort Vaccine Company, LLC",
      "definition" : "DynPort Vaccine Company, LLC",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "EVN",
      "display" : "Evans Medical Limited",
      "definition" : "Evans Medical Limited",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "GEO",
      "display" : "GeoVax Labs, Inc.",
      "definition" : "GeoVax Labs, Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "GRE",
      "display" : "Greer Laboratories, Inc.",
      "definition" : "Greer Laboratories, Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IAG",
      "display" : "Immuno International AG",
      "definition" : "Immuno International AG",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "IM",
      "display" : "Merieux",
      "definition" : "Merieux",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IUS",
      "display" : "Immuno-U.S., Inc.",
      "definition" : "Immuno-U.S., Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "JPN",
      "display" : "The Research Foundation for Microbial Diseases of Osaka University",
      "definition" : "The Research Foundation for Microbial Diseases of Osaka University",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "KGC",
      "display" : "Korea Green Cross Corporation",
      "definition" : "Korea Green Cross Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LED",
      "display" : "Lederle",
      "definition" : "Lederle",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MA",
      "display" : "Massachusetts Public Health Biologic Laboratories",
      "definition" : "Massachusetts Public Health Biologic Laboratories",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MBL",
      "display" : "Massachusetts Biologic Laboratories",
      "definition" : "Massachusetts Biologic Laboratories",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MED",
      "display" : "MedImmune, Inc.",
      "definition" : "MedImmune, Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MIL",
      "display" : "Miles",
      "definition" : "Miles",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MIP",
      "display" : "Bioport Corporation",
      "definition" : "Bioport Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MSD",
      "display" : "Merck & Co., Inc.",
      "definition" : "Merck & Co., Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NAB",
      "display" : "NABI",
      "definition" : "NABI",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NAV",
      "display" : "North American Vaccine, Inc.",
      "definition" : "North American Vaccine, Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NOV",
      "display" : "Novartis Pharmaceutical Corporation",
      "definition" : "Novartis Pharmaceutical Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NVX",
      "display" : "Novavax, Inc.",
      "definition" : "Novavax, Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "NYB",
      "display" : "New York Blood Center",
      "definition" : "New York Blood Center",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ORT",
      "display" : "Ortho-Clinical Diagnostics",
      "definition" : "Ortho-Clinical Diagnostics",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OTC",
      "display" : "Organon Teknika Corporation",
      "definition" : "Organon Teknika Corporation",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OTH",
      "display" : "Other manufacturer",
      "definition" : "Other manufacturer",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PD",
      "display" : "Parkedale Pharmaceuticals",
      "definition" : "Parkedale Pharmaceuticals",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PMC",
      "display" : "sanofi pasteur",
      "definition" : "sanofi pasteur",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "PRX",
      "display" : "Praxis Biologics",
      "definition" : "Praxis Biologics",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PWJ",
      "display" : "PowderJect Pharmaceuticals",
      "definition" : "PowderJect Pharmaceuticals",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SCL",
      "display" : "Sclavo, Inc.",
      "definition" : "Sclavo, Inc.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SI",
      "display" : "Swiss Serum and Vaccine Inst.",
      "definition" : "Swiss Serum and Vaccine Inst.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SKB",
      "display" : "GlaxoSmithKline",
      "definition" : "GlaxoSmithKline",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SOL",
      "display" : "Solvay Pharmaceuticals",
      "definition" : "Solvay Pharmaceuticals",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "TAL",
      "display" : "Talecris Biotherapeutics",
      "definition" : "Talecris Biotherapeutics",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "UNK",
      "display" : "Unknown manufacturer",
      "definition" : "Unknown manufacturer",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "USA",
      "display" : "United States Army Medical Research and Material Command",
      "definition" : "United States Army Medical Research and Material Command",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "VXG",
      "display" : "VaxGen",
      "definition" : "VaxGen",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "WA",
      "display" : "Wyeth-Ayerst",
      "definition" : "Wyeth-Ayerst",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "WAL",
      "display" : "Wyeth-Ayerst",
      "definition" : "Wyeth-Ayerst",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ZLB",
      "display" : "ZLB Behring",
      "definition" : "ZLB Behring",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
