# Homepage - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Homepage**

## Homepage

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/ImplementationGuide/hl7.v2.uv.terminology.v281 | *Version*:0.1.0 |
| Draft as of 2026-01-27 | *Computable Name*:HL7v2TerminologyV281 |

# HL7 v2.8.1 Vocabulary

This is the main page for the **HL7 v2.8.1 reconciled vocabulary**.

The content is still undergoing improvements and contains a huge amount of errors due to the updated generation process. Also, the canonicals do not resolve yet and are causing errors. It can be expected that they will be resolved soon.

**This implementation guide does NOT provide any explanatory details.** **These can be found [here](https://www.hl7.eu/v2plusvocab).**

> The identifier for the package is still under development and may change.

## Here are the links to all v2.x Vocabulary Guides per Version

* [v2.1](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v21)
* [v2.2](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v22)
* [v2.3](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v23)
* [v2.3.1](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v231)
* [v2.4](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v24)
* [v2.5](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v25)
* [v2.5.1](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v251)
* [v2.6](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v26)
* [v2.7](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v27)
* [v2.7.1](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v271)
* [v2.8](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v28)
* [v2.8.1](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v281)
* [v2.8.2](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v282)
* [v2.9](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v29)
* [v2.9.1](https://build.fhir.org/ig/frankoemig/hl7.v2.terminology.v291)



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.v2.uv.terminology.v281",
  "url" : "http://terminology.hl7.org/v2plusvocab/ImplementationGuide/hl7.v2.uv.terminology.v281",
  "version" : "0.1.0",
  "name" : "HL7v2TerminologyV281",
  "title" : "HL7 v2.8.1 Vocabulary",
  "status" : "draft",
  "date" : "2026-01-27",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "IG providing the HL7 v2.8.1 vocabulary as FHIR resource instances",
  "packageId" : "hl7.v2.uv.terminology.v281",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2026+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org/v2plusvocab/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2026+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org/v2plusvocab/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/accept-applicationAcknowledgmentConditions"
        },
        "name" : "Accept/Application Acknowledgment Conditions (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. Used in HL7 Versions 2 messaging in the MSH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSaccept-applicationAcknowledgmentConditions"
        },
        "name" : "Accept/Application Acknowledgment Conditions (2.8.1 - 1.0.0)",
        "description" : "Concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/accessRestrictionReason"
        },
        "name" : "Access Restriction Reason Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the reason for the restricted access.  Used in HL7 Version 2.x messaging in the ARV segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSaccessRestrictionReasonCode"
        },
        "name" : "Access Restriction Reason Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the reason for the restricted access.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/accessRestrictionValue"
        },
        "name" : "Access Restriction Value (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the information to which access is restricted.  Used in HL7 Version 2.x messaging in the ARV segment.  Note that these new codes as of November 2018 have been temporarily loaded into this V2 code system pending availability of the currently unavailable new tooling, at which time this code systrem will be retired and a value set of codes from the HL7 V3 ActCode code system will be used instead for this table.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSaccessRestrictionValue"
        },
        "name" : "Access Restriction Value (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the information to which access is restricted.  Note that the new codes as of November 2018 have been temporarily loaded into the underlying V2 code system pending availability of the currently unavailable new tooling, at which time this value set will be retired and a value set based on the HL7 V3 ActCode code system will be used instead for this table, and the rendered URL will be valid at terminology.hl7.org.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/acknowledgmentCodes"
        },
        "name" : "Acknowledgment Code (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts specifying acknowledgment codes.  For details of usage, see message processing rules in the published Standard.  Used in HL7 Version 2.x messaging in the MSA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSacknowledgmentCode"
        },
        "name" : "Acknowledgment Code (2.8.1 - 1.2.0)",
        "description" : "Concepts specifying acknowledgment codes used in Version 2.x message.  For details of usage, see message processing rules in the published Standard.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/actionTakenInResponseToTheEvent"
        },
        "name" : "Action Taken in Response to the Event (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to define the action taken as a result of an event related to a product issue.  Used in HL7 Version 2.x messaging in the PCR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSactionTakenInResponseToTheEvent"
        },
        "name" : "Action Taken in Response to the Event (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define the action taken as a result of an event related to a product issue.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/active-inactive"
        },
        "name" : "Active/Inactive (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying whether a person is currently a valid staff member.  Used in HL7 Version 2.x messaging in the STF segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSactive-inactive"
        },
        "name" : "Active/Inactive (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether a person is currently a valid staff member.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/actpriority"
        },
        "name" : "ActPriority (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the priority for the shipment.  Used in HL7 Version 2.x messaging in the SHP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSactpriority"
        },
        "name" : "ActPriority (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the priority for a shipment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/additivePreservative"
        },
        "name" : "Additive/Preservative (2.8.1 - 2.0.0)",
        "description" : "HL7-defined code system of concepts specifying any additive introduced to the specimen before or at the time of collection.  These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen.  Used in HL7 Version 2.x messaging in the SPM and SAC segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadditivePreservative"
        },
        "name" : "Additive/Preservative (2.8.1 - 2.0.0)",
        "description" : "Concepts specifying any additive introduced to the specimen before or at the time of collection.  These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen.  Used in Version 2 messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/addressExpirationReason"
        },
        "name" : "Address Expiration Reason (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the reason this address was marked as \"ended\".  Used in HL7 Version 2.x messaging in the XAD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSaddressExpirationReason"
        },
        "name" : "Address Expiration Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the reason this address was marked as \"ended\".",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/addressType"
        },
        "name" : "Address Type (2.8.1 - 1.5.0)",
        "description" : "HL7-defined code system of concepts specifying types or kinds of addresses.  Used in HL7 Version 2.x messaging in the XAD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSaddressType"
        },
        "name" : "Address Type (2.8.1 - 1.5.0)",
        "description" : "Concepts specifying types or kinds of addresses.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/addressUsage"
        },
        "name" : "Address Usage (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying how an address is intended to be used.  Used in HL7 Version 2.x messaging in the XAD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSaddressUsage"
        },
        "name" : "Address Usage (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify how an address is intended to be used.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adjustmentAction"
        },
        "name" : "Adjustment Action (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the action requested of the party that receives an adjustment.  Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadjustmentAction"
        },
        "name" : "Adjustment Action (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used to specify the action requested of a party that receives an adjustment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adjustmentCategory"
        },
        "name" : "Adjustment Category Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason.  Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadjustmentCategoryCode"
        },
        "name" : "Adjustment Category Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/administrationDevice"
        },
        "name" : "Administration Device (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  which specify the mechanical device used to aid in the administration of the drug or other treatment.  Common examples are IV-sets of different types.  Used in HL7 Version 2.x messaging in the RXR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadministrationDevice"
        },
        "name" : "Administration Device (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the mechanical device used to aid in the administration of the drug or other treatment.  Common examples are IV-sets of different types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/administrationMethod"
        },
        "name" : "Administration Method (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  which specify the specific method requested for the administration of the drug or treatment to the patient.  Used in HL7 Version 2.x messaging in the RXR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadministrationMethod"
        },
        "name" : "Administration Method (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the specific method requested for the administration of the drug or treatment to the patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/administrativeSex"
        },
        "name" : "Administrative Sex (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying a patient's sex for administrative purposes.  Used in HL7 Version 2.x messages in the PID segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadministrativeSex"
        },
        "name" : "Administrative Sex (2.8.1 - 1.0.0)",
        "description" : "Concepts specifying a patient's sex for administrative purposes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/admissionLevelOfCare"
        },
        "name" : "Admission Level of Care Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  specifying the acuity level assigned to the patient at the time of admission.  Used in HL7 Version 2.x messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadmissionLevelOfCareCode"
        },
        "name" : "Admission Level of Care Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the acuity level assigned to the patient at the time of admission.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/admissionType"
        },
        "name" : "Admission Type (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts specifying the circumstances under which the patient was or will be admitted.  Used in HL7 Version 2.x messaging in the PV1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadmissionType"
        },
        "name" : "Admission Type (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the circumstances under which the patient was or will be admitted.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/advancedBeneficiaryNotice"
        },
        "name" : "Advanced Beneficiary Notice Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service.  Used in HL7 Version 2.x messaging in the ORC and FT1 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadvancedBeneficiaryNoticeCode"
        },
        "name" : "Advanced Beneficiary Notice Code (2.8.1 - 1.0.0)",
        "description" : "Status codes specifying a patient's or a patient's representative's consent for responsibility to pay for potentially uninsured services.  Note that this set of codes is generally used in the US only.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/alertDevice"
        },
        "name" : "Alert Device Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying any type of allergy alert device the patient may be carrying or wearing.  Used in HL7 Version 2.x messaging in the IAM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSalertDeviceCode"
        },
        "name" : "Alert Device Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying any type of allergy alert device the patient may be carrying or wearing.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/alertLevel"
        },
        "name" : "Alert Level (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event).  Used in the Equipment Detail (EQU) and Notification Detail (NDS) segments in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSalertLevel"
        },
        "name" : "Alert Level (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergenType"
        },
        "name" : "Allergen Type (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts speciying a classification of general allergy categories (drug, food, pollen, etc.).  Used in HL7 Version 2.x messaging in the AL1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSallergyType"
        },
        "name" : "Allergen Type (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify  classification of general allergy categories (drug, food, pollen, etc.).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergyClinicalStatus"
        },
        "name" : "Allergy Clinical Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the verification status for the allergy.  Used in HL7 Version 2.x messaging in the IAM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSallergyClinicalStatus"
        },
        "name" : "Allergy Clinical Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the verification status for the allergy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergySeverity"
        },
        "name" : "Allergy Severity (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts which specify the general severity of an allergy.  Used in HL7 Version 2.x messaging in the AL1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSallergySeverity"
        },
        "name" : "Allergy Severity (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the general severity of an allergy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSallowSubstitution"
        },
        "name" : "Allow Substitution (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether substitutions are allowed and, if so, the type of substitutions allowed.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allowSubstitution"
        },
        "name" : "Allow Substitution Codes (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment.  Used in HL7 Version 2.x messaging in the AIS and AIG segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSallowSubstitutionCodes"
        },
        "name" : "Allow Substitution Codes (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/alternateCharacterSetHandlingScheme"
        },
        "name" : "Alternate Character Set Handling Scheme (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concept that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed.  Used in HL7 Version 2.x messaging in the MSH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSalternateCharacterSetHandlingScheme"
        },
        "name" : "Alternate Character Set Handling Scheme (2.8.1 - 1.1.0)",
        "description" : "Concepts that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/alternateCharacterSets"
        },
        "name" : "Alternate Character Sets (2.8.1 - 1.4.0)",
        "description" : "HL7-defined code system of concepts used to specify the character set(s) in use.  Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSalternateCharacterSets"
        },
        "name" : "Alternate Character Sets (2.8.1 - 1.4.0)",
        "description" : "Value Set of codes that identify one of a number of possible standard alternate character sets for a message, either single-byte or double-byte.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ambulatoryPaymentClassification"
        },
        "name" : "Ambulatory Payment Classification Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the derived Ambulatory Payment Classification (APC) code.  Used in HL7 Version 2.x messaging in the GP2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSambulatoryPaymentClassificationCode"
        },
        "name" : "Ambulatory Payment Classification Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the derived Ambulatory Payment Classification (APC) code.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ambulatoryStatus"
        },
        "name" : "Ambulatory Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying permanent or transient handicapped conditions of a person.  Used in HL7 Version 2.x messaging in the PV1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSambulatoryStatus"
        },
        "name" : "Ambulatory Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify permanent or transient handicapped conditions of a person.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/amountClass"
        },
        "name" : "Amount Class (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the amount quantity class.  Used in HL7 Version 2.x messaging in the PTA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSamountClass"
        },
        "name" : "Amount Class (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the amount quantity class.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/amountType"
        },
        "name" : "Amount Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  which specify amount quantity type.  Used in HL7 Version 2.x messaging in the RMC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSamountType"
        },
        "name" : "Amount Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify amount quantity type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/analyteRepeatStatus"
        },
        "name" : "Analyte Repeat Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex).  The following are assumptions regarding the table values:\r\nRepeated without dilution — performed usually to confirm correctness of results (e.g., in case of results flagged as \"Panic\" or mechanical failures).\r\nRepeated with dilution — performed usually in the case the original result exceeded the measurement range (technical limits).\r\nReflex test — this test is performed as the consequence of rules triggered based on other test result(s).  Used in HL7 Version 2.x messaging in the Test Code Detail (TCD) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSanalyteRepeatStatus"
        },
        "name" : "Analyte Repeat Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex).  The following are assumptions regarding the table values: Repeated without dilution — performed usually to confirm correctness of r",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/annotations"
        },
        "name" : "Annotations (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the coded entry associated with a given point in time during the waveform recording.  Used in HL7 Version 2.x messaging in the Observation Result (OBX) Another Observation (ANO) segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSannotations"
        },
        "name" : "Annotations (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the coded entry associated with a given point in time during the waveform recording.  Note codes beyond 9903 may exist; extensions to this table may be done by incrementing the code value.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/appointmentReason"
        },
        "name" : "Appointment Reason Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to describe the kind of appointment or the reason why an appointment has been scheduled.  Used in HL7 Version 2.x messaging in the ARQ segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSappointmentReasonCodes"
        },
        "name" : "Appointment Reason Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that describe the kind of appointment or the reason why an appointment has been scheduled.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/appointmentType"
        },
        "name" : "Appointment Type Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used in an appointment request to describe the kind of appointment.  Used in HL7 Version 2.x messaging in the ARQ segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSappointmentTypeCodes"
        },
        "name" : "Appointment Type Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that an appointment request to describe the kind of appointment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/armStick"
        },
        "name" : "Arm Stick (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the arm(s) receiving the stick.  Used in HL7 Version 2.x messaging in the DON segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSarmStick"
        },
        "name" : "Arm Stick (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the arm(s) receiving a stick.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/artificialBlood"
        },
        "name" : "Artificial Blood (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that identify the artificial blood identifier associated with the specimen.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSartificialBlood"
        },
        "name" : "Artificial Blood (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the artificial blood identifier associated with the specimen.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/assignmentOfBenefits"
        },
        "name" : "Assignment of Benefits (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts which indicate whether an insured person agreed to assign the insurance benefits to the healthcare provider.  If so, the insurance will pay the provider directly.  Used in HL7 Version 2.x messaging in the IN1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSassignmentOfBenefits"
        },
        "name" : "Assignment of Benefits (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes which indicate whether an insured person agreed to assign the insurance benefits to a healthcare provider.  If so, the insurance will pay the provider directly.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/authorizationMode"
        },
        "name" : "Authorization Mode (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts of forms of authorization a recorder may receive from the responsible practitioner to create or change an order.  Used in HL7 Version 2.x messaging in the ORC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSauthorizationMode"
        },
        "name" : "Authorization Mode (2.8.1 - 1.0.0)",
        "description" : "Concepts of forms of authorization a recorder may receive from the responsible practitioner to create or change an order.  Used in Version 2 messaging for orders in the ORC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bedStatus"
        },
        "name" : "Bed Status (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts which specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not.  Used in HL7 Version 2.x messaging in the DLD and PV1 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbedStatus"
        },
        "name" : "Bed Status (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bloodProduct"
        },
        "name" : "Blood Product Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a type of blood product.  Used in HL7 Version 2 messaging in the BLC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbloodProductCode"
        },
        "name" : "Blood Product Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the blood product code.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bloodProductDispenseStatus"
        },
        "name" : "Blood Product Dispense Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the filler or placer.  For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it first becomes linked to a patient and is ready to dispense. The placer system may use the Blood Product Dispense Status Message to request the transfusion service to dispense the product.  When the blood product is delivered or issued to a patient, the status of the blood product would be changed to indicate that it has now been \"dispensed\".  Used in the Blood Product Dispense Status (BPX) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbloodProductDispenseStatus"
        },
        "name" : "Blood Product Dispense Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the current status of the specified blood product as indicated by the filler or placer.  For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it fir",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bloodProductProcessingRequirements"
        },
        "name" : "Blood Product Processing Requirements (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify additional information about the blood component class associated with the Universal Service ID.  The placer of the order can specify any required processing of the blood product that must be completed prior to transfusion to the intended recipient.  Used in the Blood Product Order (BPO) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbloodProductProcessingRequirements"
        },
        "name" : "Blood Product Processing Requirements (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify additional information about the blood component class associated with the Universal Service ID.  The placer of the order can specify any required processing of the blood product that must be completed prior to t",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bloodProductTransfusion-dispositionStatus"
        },
        "name" : "Blood Product Transfusion/Disposition Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the placer.  For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been \"transfused.\"  Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbloodProductTransfusion-dispositionStatus"
        },
        "name" : "Blood Product Transfusion/Disposition Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the current status of the specified blood product as indicated by the placer.  For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood co",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bloodUnitType"
        },
        "name" : "Blood Unit Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the type of blood unit.  Used in the Blood Unit Information (BUI) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbloodUnitType"
        },
        "name" : "Blood Unit Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used to specify the type of blood unit",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bodyParts"
        },
        "name" : "Body Parts (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts specifying the part of the body.  Used in HL7 Version 2 messaging in the RXR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbodyParts"
        },
        "name" : "Body Parts (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the part of the body.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bodySite"
        },
        "name" : "Body Site (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts that specify a body site from which a specimen is obtained.  Used in HL7 Version 2.x messaging in the OBX and CH7 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSadministriveSite"
        },
        "name" : "Body Site (2.8.1 - 1.2.0)",
        "description" : "Concepts that specify a body site from which a specimen is obtained.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bodySiteModifier"
        },
        "name" : "Body Site Modifier (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the modifier for the body site.  Used in HL7 Version 2.x messaging in the RXR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbodySiteModifier"
        },
        "name" : "Body Site Modifier (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the modifier for the body site.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bolusType"
        },
        "name" : "Bolus Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the type of bolus.  Used in HL7 Version 2.x messaging in the RXV segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbolusType"
        },
        "name" : "Bolus Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying a type of bolus.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/bpObservationStatusCodesInterpretation"
        },
        "name" : "BP Observation Status Codes Interpretation (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the interpretation for the blood product observation status codes.  A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first cross-matched and a status message is sent, it would be considered preliminary. When the product is dispensed to the patient, that status would also be considered preliminary.  However, once the product is transfused, the status would be considered final.  Used in the Blood Product Dispense Status (BPX) and Blood Product Transfusion/Disposition (BTX) segments in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSbpObservationStatusCodesInterpretation"
        },
        "name" : "BP Observation Status Codes Interpretation (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the interpretation for the blood product observation status codes.  A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first c",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/calendarAlignment"
        },
        "name" : "Calendar Alignment (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify an alignment of the repetition to a calendar (e.g., to distinguish every 30 days from \"the 5th of every month\").  Used in HL7 Version 2 messaging in the RPT segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScalendarAlignment"
        },
        "name" : "Calendar Alignment (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify an alignment of the repetition to a calendar (e.g., to distinguish every  30 days from \"the 5th of every month\").",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/causalityObservations"
        },
        "name" : "Causality Observations (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event.  Used in HL7 Version 2.x messaging in the PCR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScausalityObservations"
        },
        "name" : "Causality Observations (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that record event observations regarding what may have caused a product related event.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cclValue"
        },
        "name" : "CCL Value (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the clinical complexity level (CCL) value for the determined diagnosis related group (DRG) for this diagnosis.  US Realm.  Used in HL7 Version 2.x messaging in the DG1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScclValue"
        },
        "name" : "CCL Value (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the clinical complexity level (CCL) value for the determined diagnosis related group (DRG) for this diagnosis.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certificateStatus"
        },
        "name" : "Certificate Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of the certificate held by the health professional.  Used in HL7 Version 2 messaging in the CER segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScertificateStatus"
        },
        "name" : "Certificate Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of the certificate held by a health professional.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certificationCategory"
        },
        "name" : "Certification Category Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the code for the certification category.  Used in HL7 Version 2.x messaging in the IN3 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScertificationCategoryCode"
        },
        "name" : "Certification Category Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the code for a certification category.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certificationPatientType"
        },
        "name" : "Certification Patient Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  which specify the category or type of patient for which this certification is requested.  Used in HL7 Version 2.x messaging in the ICD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprecertificationPatientType"
        },
        "name" : "Certification Patient Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the category or type of patient for which this certification is requested.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certificationStatus"
        },
        "name" : "Certification Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the status of the practitioner's speciality certification.  Used in HL7 Version 2.x messaging in the Specialty Description (SPD) value and Practitioner Detail (PRA) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScertificationStatus"
        },
        "name" : "Certification Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of the practitioner's speciality certification.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certificationType"
        },
        "name" : "Certification Type Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the code for the certification type.  Used in HL7 Version 2.x messaging in the IN3 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScertificationTypeCode"
        },
        "name" : "Certification Type Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the code for a certification type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/chargeOnIndicator"
        },
        "name" : "Charge On Indicator (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to define the event upon which a charge should be generated.  Used in HL7 Version 2.x messaging in the PRC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSchargeOnIndicator"
        },
        "name" : "Charge On Indicator (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define the event upon which a charge should be generated.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/chargeType"
        },
        "name" : "Charge Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service.  Used in HL7 Version 2.x messaging in the BLG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSchargeType"
        },
        "name" : "Charge Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify someone or something other than the patient to be billed for a service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/chargeTypeReason"
        },
        "name" : "Charge Type Reason (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the choice of, and providing the clinical rationale for, a selected charge type.  Used in HL7 Version 2.x messaging in the BLG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSchargeTypeReason"
        },
        "name" : "Charge Type Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the choice of, and providing the clinical rationale for, a selected charge type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/checkDigitScheme"
        },
        "name" : "Check Digit Scheme (2.8.1 - 1.3.0)",
        "description" : "HL7-defined code system of concepts specifying the check digit scheme employed.   Used in HL7 Version 2.x messaging in PPN, XCN and XON segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScheckDigitScheme"
        },
        "name" : "Check Digit Scheme (2.8.1 - 1.3.0)",
        "description" : "Concepts used to identify the check digit scheme employed when a check digit is used in various HL7 Version 2.x datatypes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/codingSystem"
        },
        "name" : "Coding System (2.8.1 - 1.7.0)",
        "description" : "HL7-defined code system of concepts specifying the coding system.  This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm.  Used in HL7 Version 2.x messaging in the CWE segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScodingSystem"
        },
        "name" : "Coding System (2.8.1 - 1.7.0)",
        "description" : "Names of coding systems. Each coding system is assigned a unique identifier, which is generally a short mnemonic derived from the full name of the coding system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/commandResponse"
        },
        "name" : "Command Response (2.8.1 - 1.0.1)",
        "description" : "Code system of concepts identifying the response of the previously issued command.  Used in HL7 Version 2.x messaging in the Equipment Command Response (ECR) and Interaction Status Detail (ISD) segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScommandResponse"
        },
        "name" : "Command Response (2.8.1 - 1.0.1)",
        "description" : "Value Set of codes identifying the response of the previously issued command.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/commentType"
        },
        "name" : "Comment Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that identify the type of comment text being sent in the specific comment record.  Used in the Notes and Comments (NTE) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScommentType"
        },
        "name" : "Comment Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the type of comment text being sent in the specific comment record.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/completionStatus"
        },
        "name" : "Completion Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the status of the treatment administration event segment.  Used in HL7 Version 2.x messaging in the Pharmacy Order Administration (RXA) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScompletionStatus"
        },
        "name" : "Completion Status (2.8.1 - 1.0.0)",
        "description" : "Status codes used in the workflow of treatment administration events.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/computationType"
        },
        "name" : "Computation Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify if the change is computed as a percent change or as an absolute change.  Used in the Delta (DLT) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScomputationType"
        },
        "name" : "Computation Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify if the change is computed as a percent change or as an absolute change.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/confidentiality"
        },
        "name" : "Confidentiality (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the confidentiality for the shipment.  Used in HL7 Version 2.x messaging in the SHP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSconfidentiality"
        },
        "name" : "Confidentiality (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the confidentiality for a shipment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/confidentialityCodes"
        },
        "name" : "Confidentiality Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the degree to which special confidentiality protection should be applied to the observation.  Used in HL7 Version 2.x messaging in the OM1 and ORC segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSconfidentialityCode"
        },
        "name" : "Confidentiality Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the degree to which special confidentiality protection should be applied to the observation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentBypassReason"
        },
        "name" : "Consent Bypass Reason (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the reason the subject's consent was not sought.  Used in HL7 Version 2.x messaging in the CON segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSconsentBypassReason"
        },
        "name" : "Consent Bypass Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the reason the subject's consent was not sought.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentDisclosureLevel"
        },
        "name" : "Consent Disclosure Level (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying how much information was disclosed to the subject as part of the informed consent process.  Used in HL7 Version 2.x messaging in the CON segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSconsentDisclosureLevel"
        },
        "name" : "Consent Disclosure Level (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify how much information was disclosed to the subject as part of the informed consent process.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentMode"
        },
        "name" : "Consent Mode (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the method in which a subject provides consent.  Used in HL7 Version 2.x messaging in the TXA and CON segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSconsentMode"
        },
        "name" : "Consent Mode (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the method in which a subject provides consent.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentNon-disclosureReason"
        },
        "name" : "Consent Non-Disclosure Reason (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify a reason the subject did not receive full disclosure.  Used in the Consent (CON) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSconsentNon-disclosureReason"
        },
        "name" : "Consent Non-Disclosure Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a reason the subject did not receive full disclosure.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentStatus"
        },
        "name" : "Consent Status (2.8.1 - 1.0.0)",
        "description" : "HL7-code system of concepts specifying whether the consent has been sought and granted.  Used in HL7 Version 2.x messaging in the TXA and CON segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSconsentStatus"
        },
        "name" : "Consent Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether the consent has been sought and granted.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentType"
        },
        "name" : "Consent Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event.  Used in HL7 Version 2.x messaging in the TXA and CON segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSconsentType"
        },
        "name" : "Consent Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contactRole2"
        },
        "name" : "Contact Role (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral. Used in HL7 Version 2 messaging in the NK1 and CTD segments after 2.5, when it replace 2.16.840.1.113883.18.57.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScontactRole2"
        },
        "name" : "Contact Role (2.8.1 - 1.0.0)",
        "description" : "Concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Built on the updated code system.  Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/containerCondition"
        },
        "name" : "Container Condition (2.8.1 - 1.0.0)",
        "description" : "HL7-defined  code system of concepts used to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab.  If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons.  Used in the Specimen (SPM), Shipment (SHP) and Shipment Package (PAC) segments in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScontainerCondition"
        },
        "name" : "Container Condition (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab.  If the container is compromised in any way (seal broken, container",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/containerStatus"
        },
        "name" : "Container Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined  code system of concepts that identify the status of the unique container in which the specimen resides at the time the transaction was initiated.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScontainerStatus"
        },
        "name" : "Container Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the status of the unique container in which the specimen resides at the time the transaction was initiated.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/continuationStyle"
        },
        "name" : "Continuation Style Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts identifying whether it is a fragmented message or part of an interactive continuation message.  Used in HL7 Version 2.x messaging in the Continuation Pointer (DSC) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScontinuationStyleCode"
        },
        "name" : "Continuation Style Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes identifying whether it is a fragmented message or part of an interactive continuation message.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/controlledSubstanceSchedule"
        },
        "name" : "Controlled Substance Schedule (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the class of the drug or other substance if its usage is controlled by legislation.  In the USA, such legislation includes the federal Controlled Substance Act (CSA) or a State Uniform Controlled Substance Act. Other countries should create their own versions of this table.  Used in HL7 Version 2.x messaging in the RXE segment.  The name of the table is taken from the Pharmacy Law Digest July 1988.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScontrolledSubstanceSchedule"
        },
        "name" : "Controlled Substance Schedule (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the class of the drug or other substance if its usage is controlled by legislation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coordinationOfBenefits"
        },
        "name" : "Coordination of Benefits (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient.  Used in HL7 Version 2.x messaging in the IN1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScoordinationOfBenefits"
        },
        "name" : "Coordination of Benefits (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coverageType"
        },
        "name" : "Coverage Type (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts specifying the type of insurance coverage or what types of services are covered for the purposes of a billing system.  For example, a physician billing system will only want to receive insurance information for plans that cover physician/professional charges.  Used in HL7 Version 2.x messaging in the Insurance (IN1) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScoverageType"
        },
        "name" : "Coverage Type (2.8.1 - 1.1.0)",
        "description" : "Note that this set of codes is used generally in the US only.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cpRangeType"
        },
        "name" : "CP Range Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to define a type of range used in composite pricing in financial transacxtions.  Used in HL7 Version 2 messaging in the CP datatype.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrangeType"
        },
        "name" : "CP Range Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether a composite price range is experssed as a flat rate or a percentage.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cumulativeDosageLimitUom"
        },
        "name" : "Cumulative Dosage Limit UoM (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the unit of measure (UoM) for the cumulative dosage limit.  Used in HL7 Version 2.x messaging in the CDO segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScumulativeDosageLimitUom"
        },
        "name" : "Cumulative Dosage Limit UoM (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the unit of measure (UoM) for the cumulative dosage limit.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cweStatuses"
        },
        "name" : "CWE statuses (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of comcepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended).  These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in HL7 Version 2.x messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScweStatuses"
        },
        "name" : "CWE statuses (2.8.1 - 1.0.0)",
        "description" : "Concepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended).  These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in Version 2 messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cycleType"
        },
        "name" : "Cycle Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  specifying the type of cycle that is being executed.  A cycle type is a specific sterilization method used for a specific type of supply item.  Used in HL7 Version 2.x messaging in the SCD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScycleType"
        },
        "name" : "Cycle Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of cycle that is being executed.  A cycle type is a specific sterilization method used for a specific type of supply item.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cyclicEntryExitIndicator"
        },
        "name" : "Cyclic Entry/Exit Indicator (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify if this service request is the first or last service request in a cyclic series of service requests.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VScyclicEntryExitIndicator"
        },
        "name" : "Cyclic Entry/Exit Indicator (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify if this service request is the first or last service request in a cyclic series of service requests.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dataTypes"
        },
        "name" : "Data Types (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts specifying the format of the observation value in the Observation Result (OBX).   Used in HL7 Version 2.x messaging in the OBX, OM1, OM3 and OMC segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdataTypes"
        },
        "name" : "Data Types (2.8.1 - 1.2.0)",
        "description" : "Value Set of codes specifying the data type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dateFormat"
        },
        "name" : "Date Format (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that identify the date format for a decontamination/sterilization instance. Used in HL7 Version 2.x messaging in the SCP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdateFormat"
        },
        "name" : "Date Format (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the date format for a decontamination/sterilization instance.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dayType"
        },
        "name" : "Day Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  which specify whether the days are denied, pending or approved.  Used in HL7 Version 2.x messaging in the DTN segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdayType"
        },
        "name" : "Day Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether the days are denied, pending or approved.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/daysOfTheWeek"
        },
        "name" : "Days of the Week (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to identify the day(s) of the week when a location may be scheduled for appointments.  Used in HL7 Version 2.x messaging in the UVC and LDP segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdaysOfTheWeek"
        },
        "name" : "Days of the Week (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the day(s) of the week when a location may be scheduled for appointments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/degreeLicenseCertificate"
        },
        "name" : "Degree/License/Certificate (2.8.1 - 2.1.0)",
        "description" : "Code system of concepts specifying an educational degree (e.g., MD).  Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging.  Used in HL7 Version 2.x messaging in the CNN segment; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdegreeLicenseCertificate"
        },
        "name" : "Degree/License/Certificate (2.8.1 - 2.1.0)",
        "description" : "Concepts specifying an educational degree (e.g., MD).  Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging.  Used in Version 2 messaging; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/denialOrRejectionType"
        },
        "name" : "Denial or Rejection Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the OCE status of the line item.  Used in HL7 Version 2.x messaging in the GP2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdenialOrRejectionCode"
        },
        "name" : "Denial or Rejection Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the OCE status of the line item.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/derivedSpecimen"
        },
        "name" : "Derived Specimen (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts  which specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture).  The process also produces new \"specimens\" (e.g., pure culture of staphylococcus, and E. coli), and these are studied by a second order process (bacterial sensitivities). The parents (e.g., blood culture) and children (e.g., penicillin MIC) are identified in such cases.  Used in HL7 Version 2.x messaging in the OM4 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSderivedSpecimen"
        },
        "name" : "Derived Specimen (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture).  The pro",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/deviceDataState"
        },
        "name" : "Device Data State (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that define the state of the data as provided from a device. Used in HL7 Version 2.x messaging in the SDD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdeviceDataState"
        },
        "name" : "Device Data State (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the state of the data as provided from a device.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/deviceStatus"
        },
        "name" : "Device Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that communicate the state of a device. Used in HL7 Version 2.x messaging in the SCD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdeviceStatus"
        },
        "name" : "Device Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the state of a device.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/diagnosisClassification"
        },
        "name" : "Diagnosis Classification (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to classify whether a patient visit can be related to a diagnosis.  Used in HL7 Version 2.x messaging in the DG1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdiagnosisClassification"
        },
        "name" : "Diagnosis Classification (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that classify whether a patient visit can be related to a diagnosis.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/diagnosisPriority"
        },
        "name" : "Diagnosis Priority (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that identify the significance or priority of the diagnosis code.  Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis.  Used in the DG1 segment in HL7 Version 2.x messaging. The predefined codes are the most common, and just a starter set, as the codes are an unbounded list; additional ranked procedures may be signified by incrementing the code value as needed.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdiagnosisPriority"
        },
        "name" : "Diagnosis Priority (2.8.1 - 1.0.0)",
        "description" : "Concepts that identify the significance or priority of the diagnosis code.  Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis.  Used in the DG1 segment in Version 2 messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/diagnosisType"
        },
        "name" : "Diagnosis Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying a type of diagnosis being sent.  Used in HL7 Version 2.x messaging in the DG1 segment..",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdiagnosisType"
        },
        "name" : "Diagnosis Type (2.8.1 - 1.0.0)",
        "description" : "Concepts specifying a type of diagnosis being sent in HL7 Version 2.x messages.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/diagnosticServiceSectionId"
        },
        "name" : "Diagnostic Service Section ID (2.8.1 - 1.4.0)",
        "description" : "HL7-defined code system of concepts which specify a section of a diagnostic service where the observation may be performed.  Used in HL7 Version 2.x messaging in the OBR and OM4 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdiagnosticServiceSectionId"
        },
        "name" : "Diagnostic Service Section ID (2.8.1 - 1.4.0)",
        "description" : "Concepts which specify a section of a diagnostic service where the observation may be performed.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dietCodeSpecificationType"
        },
        "name" : "Diet Code Specification Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts  which specify whether the type of diet.    Used in HL7 Version 2.x messaging in the ODS segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdietType"
        },
        "name" : "Diet Code Specification Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of diet.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/disabilityInformationRelationship"
        },
        "name" : "Disabled Person Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify to which person the disability information relates in the message.  For example, if the value is PT, the disability information relates to the patient.  Used in HL7 Version 2.x messaging in the Disability (DB1) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdisabledPerson"
        },
        "name" : "Disabled Person Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify to which person the disability information relates in the message.  For example, if the value is PT, the disability information relates to the patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dispenseMethod"
        },
        "name" : "Dispense Method (2.8.1 - 1.0.0)",
        "description" : "HL7-definde code system of concepts specifying the method by which treatment is dispensed.  Used in HL7 Version 2.x messaging in the Pharmacy/Treatment Encoded order (RXE) and Pharmacy/Treatment dispense (RXD) segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdispenseMethod"
        },
        "name" : "Dispense Method (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the method by which treatment is dispensed.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dispenseType"
        },
        "name" : "Dispense Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the type of dispensing event that occurred.  Used in HL7 Version 2.x messaging in the RXD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdispenseType"
        },
        "name" : "Dispense Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of dispensing event that occurred.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/documentAvailabilityStatus"
        },
        "name" : "Document Availability Status (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts used to define whether a patient document is appropriate or available for use in patient care.  Used in HL7 Version 2.x messaging in the TXA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdocumentAvailabilityStatus"
        },
        "name" : "Document Availability Status (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that define whether a patient document is appropriate or available for use in patient care.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/documentCompletionStatus"
        },
        "name" : "Document Completion Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to record the state of a document in a workflow.  Used in HL7 Version 2.x messaging in the TXA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdocumentCompletionStatus"
        },
        "name" : "Document Completion Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that record the state of a document in a workflow.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/documentConfidentialityStatus2"
        },
        "name" : "Document Confidentiality Status (2.8.1 - 2.0.0)",
        "description" : "HL7-defined code system of concetps used to identify the degree to which special confidentiality protection should be applied to this information.  Used in HL7 Version 2.x messaging in the TXA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdocumentConfidentialityStatus"
        },
        "name" : "Document Confidentiality Status (2.8.1 - 2.0.0)",
        "description" : "Value Set of codes that specify the degree to which special confidentiality protection should be applied to  information.  The assignment of data elements to these categories is left to the discretion of the healthcare organization.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/documentStorageStatus"
        },
        "name" : "Document Storage Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to describe the availability of a document in relation to the type of storage.  Used in HL7 Version 2.x messaging in the TXA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdocumentStorageStatus"
        },
        "name" : "Document Storage Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that describe the availability of a document in relation to the type of storage.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/documentType"
        },
        "name" : "Document Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to identify the kind of patient document.  Used in HL7 Version 2.x messaging in the TXA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreportTypeCode"
        },
        "name" : "Document Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the kind of patient document.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgDiagnosisDeterminationStatus"
        },
        "name" : "DRG Diagnosis Determination Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined cCode system of concepts specifying the status of a diagnosis for a diagnosis related group (DRG) determination.  US Realm. Used in HL7 Version 2.x messaging in the DG1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdrgDiagnosisDeterminationStatus"
        },
        "name" : "DRG Diagnosis Determination Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of a diagnosis for a diagnosis related group (DRG) determination.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgGroupingStatus"
        },
        "name" : "DRG Grouping Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of the use of the gender information for diagnosis related group (DRG) determination.  US Realm. Used in HL7 Version 2.x messaging in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdrgGroupingStatus"
        },
        "name" : "DRG Grouping Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of the use of the gender information for diagnosis related group (DRG) determination.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgProcedureDeterminationStatus"
        },
        "name" : "DRG Procedure Determination Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of the use of this particular procedure for the diagnosis related group (DRG) determination.  US Realm. Used in HL7 Version 2.x messaging in the PR1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdrgProcedureDeterminationStatus"
        },
        "name" : "DRG Procedure Determination Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of the use of this particular procedure for the diagnosis related group (DRG) determination.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgProcedureRelevance"
        },
        "name" : "DRG Procedure Relevance (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the relevance of this particular procedure for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the PR1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdrgProcedureRelevance"
        },
        "name" : "DRG Procedure Relevance (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the relevance of this particular procedure for the diagnosis related group (DRG) determination.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgStatusFinancialCalculation"
        },
        "name" : "DRG Status Financial Calculation (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of the diagnosis related group (DRG) calculation regarding the financial aspects.  US Realm. Used in HL7 Version 2.x messaging in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdrgStatusFinancialCalculation"
        },
        "name" : "DRG Status Financial Calculation (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of the diagnosis related group (DRG) calculation regarding the financial aspects.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgStatusPatient"
        },
        "name" : "DRG Status Patient (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying whether the length of stay is normal or respectively shorter or longer than normal. Used in HL7 Version 2.x messaging in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSstatusPatient"
        },
        "name" : "DRG Status Patient (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether the length of stay is normal or respectively shorter or longer than normal.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgStatusRespirationMinutes"
        },
        "name" : "DRG Status Respiration Minutes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of the use of the respiration minutes information for diagnosis related group (DRG) determination.  US Realm. Used in HL7 Version 2.x messaging in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSstatusRespirationMinutes"
        },
        "name" : "DRG Status Respiration Minutes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of the use of the respiration minutes information for diagnosis related group (DRG) determination.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/durationCategories"
        },
        "name" : "Duration Categories (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts used to classify an observation definition as intended to measure a patient's state at a point in time.  Used in HL7 Version 2.x messaging in the OM1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdurationCategories"
        },
        "name" : "Duration Categories (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that classify an observation definition as intended to measure a patient's state at a point in time.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eligibilitySource"
        },
        "name" : "Eligibility Source (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  which specify the source of information about the insured's eligibility for benefits.  Used in HL7 Version 2.x messaging in the IN2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeligibilitySource"
        },
        "name" : "Eligibility Source (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the source of information about the insured's eligibility for benefits.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/employmentStatus"
        },
        "name" : "Employment Status (2.8.1 - 2.0.0)",
        "description" : "HL7-defined code system of concepts which specify an employment status of a person. Used in HL7 Version 2 messaging in the GT1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSemploymentStatus"
        },
        "name" : "Employment Status (2.8.1 - 2.0.0)",
        "description" : "Value Set of codes that specify the guarantor's employment status.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/encoding"
        },
        "name" : "Encoding (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concept identifying the type of encoding used to represent successive octets of binary data as displayable ASCII characters.  These are defined by IETF; more information may be found at https://www.ietf.org/rfc/rfc1521.txt.  Used in HL7 Version 2.x messaging in the ED datatypes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSencoding"
        },
        "name" : "Encoding (2.8.1 - 1.0.0)",
        "description" : "Concept identifying the type of IETF encoding used to represent successive octets of binary data as displayable ASCII characters.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/equipmentState"
        },
        "name" : "Equipment State (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts that identify the status the equipment was in at the time the transaction was initiated.  Used in HL7 Version 2.x messaging in the EQU segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSequipmentState"
        },
        "name" : "Equipment State (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that identify the status the equipment was in at the time the transaction was initiated.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/errorSeverity"
        },
        "name" : "Error Severity (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts specifying the severity of an application error as reported during acknowledgment of messages. Knowing if something is Error, Warning or Information is intrinsic to how an application handles the content and the information flow.  Used in HL7 Version 2.x messaging acknowledgment in the ERR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSerrorSeverity"
        },
        "name" : "Error Severity (2.8.1 - 1.1.0)",
        "description" : "Concepts documenting the severity of an application error as reported during acknowledgment of messages.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/escortRequired"
        },
        "name" : "Escort Required (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts defining whether patient transportation preparations are in place.  Used in HL7 Version 2.x messaging in the OBR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSescortRequired"
        },
        "name" : "Escort Required (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes indicating whether a patient must be accompanied while travelling to a diagnostic service department.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/event"
        },
        "name" : "Event (2.8.1 - 1.9.0)",
        "description" : "HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages.  Used in HL7 Version 2.x messaging in the MSH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSevent"
        },
        "name" : "Event (2.8.1 - 1.9.0)",
        "description" : "Concepts specifying the trigger event for Version 2.x interface messages.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eventConsequence"
        },
        "name" : "Event Consequence (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to describe the impact of an event on a patient.  Used in HL7 Version 2.x messaging in the PEO segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeventConsequence"
        },
        "name" : "Event Consequence (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that describe the impact of an event on a patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eventExpected"
        },
        "name" : "Event Expected (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to communicate whether an event has been judged to be expected or unexpected.  Used in HL7 Version 2.x messaging in the PEO segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeventExpected"
        },
        "name" : "Event Expected (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that communicate whether an event has been judged to be expected or unexpected.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eventQualification"
        },
        "name" : "Event Qualification (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to qualify an event related to a product experience.  Used in HL7 Version 2.x messaging in the PEO segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeventQualification"
        },
        "name" : "Event Qualification (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that qualify an event related to a product experience.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eventReason"
        },
        "name" : "Event Reason (2.8.1 - 1.3.0)",
        "description" : "Code system of concepts which specify the reason for an event.  Used in HL7 Version 2.x messaging in the EVN segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeventReason"
        },
        "name" : "Event Reason (2.8.1 - 1.3.0)",
        "description" : "Value Set of codes that specify the reason for an event.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eventRelatedPeriod"
        },
        "name" : "Event Related Period (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying a common (periodical) activity of daily living.  Used in HL7 Version 2 messaging in the RPT segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeventRelatedPeriod"
        },
        "name" : "Event Related Period (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a common (periodical) activity of daily living.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eventReportedTo"
        },
        "name" : "Event Reported To (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to identify the type of entity to which the even has been reported.  Used in HL7 Version 2.x messaging in the PES segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeventReportedTo"
        },
        "name" : "Event Reported To (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the type of entity to which the event has been reported.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eventSeriousness"
        },
        "name" : "Event Seriousness (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used by a sender to designate an event as serious or significant.  Used in HL7 Version 2.x messaging in the PEO segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeventSeriousness"
        },
        "name" : "Event Seriousness (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that a sender to designate an event as serious or significant.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/eventType"
        },
        "name" : "Event Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the type of event of the message.  Used in HL7 Version 2.x messaging in the EQP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSeventType"
        },
        "name" : "Event Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the type of event of the message.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/exclusiveTest"
        },
        "name" : "Exclusive Test (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts that define if a test should be a specific event with no other tests to be performed with this test, or not, or other special circumstances.  Used in HL7 Version 2.x messaging in Master Files (OM1 segment) to characterize observations in a master of such orderables.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSexclusiveTest"
        },
        "name" : "Exclusive Test (2.8.1 - 1.0.0)",
        "description" : "Concepts that define if a test should be a specific event with no other tests to be performed with this test, or not, or other special circumstances.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/expandedYes-NoIndicator"
        },
        "name" : "Expanded Yes/no Indicator (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify an expansion on the original Yes/No indicator table by including \"flavors of null\".  It is intended to be applied to fields where the response is not limited to \"yes\" or \"no\".  Used in numerous locations in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSexpandedYes-NoIndicator"
        },
        "name" : "Expanded Yes/no Indicator (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify an expansion on the original Yes/No indicator table by including \"flavors of null\".  It is intended to be applied to fields where the response is not limited to \"yes\" or \"no\".",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/extendedPriorityCodes"
        },
        "name" : "Extended Priority Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts describing the urgency of a request carried in an order.  Used in HL7 Version 2.x messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSextendedPriorityCodes"
        },
        "name" : "Extended Priority Codes (2.8.1 - 1.0.0)",
        "description" : "Concepts describing the urgency of a request carried in an order.  Used in Version 2 messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn).  Many of the codes are widely recognized values used in healthcare settings in the english-speaking world.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/facilityType"
        },
        "name" : "Facility Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the type of facility.   Used in HL7 Version 2.x messaging in the Facility (FAC) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSfacilityType"
        },
        "name" : "Facility Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of facility.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/file-levelEvent"
        },
        "name" : "File Level Event Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying file-level events for master files.  Used in HL7 Version 2 messaging in the MFI segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSfile-levelEventCode"
        },
        "name" : "File Level Event Code (2.8.1 - 1.0.0)",
        "description" : "Concepts specifying file-level events for master files.  Used in HL7 Version 2 messaging in the MFI segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/fillerStatus"
        },
        "name" : "Filler Status Codes (2.8.1 - 1.2.0)",
        "description" : "Code system of concepts used to describe an appointment status from the perspective of the entity assigned to fulfill the appointment.  Used in HL7 Version 2.x messaging in the SCH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSfillerStatusCodes"
        },
        "name" : "Filler Status Codes (2.8.1 - 1.2.0)",
        "description" : "Value Set of codes that describe an appointment status from the perspective of the entity assigned to fulfill the appointment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/formularyStatus"
        },
        "name" : "Formulary Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying whether or not the pharmaceutical substance is part of the local formulary.  Used in HL7 Version 2.x messaging in the RXE segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSformularyStatus"
        },
        "name" : "Formulary Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether or not the pharmaceutical substance is part of the local formulary.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/gestationCategory"
        },
        "name" : "Gestation Category Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify the status of a birth in relation to the gestation.  Used in HL7 Version 2 messaging in the ABS segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSgestationCategoryCode"
        },
        "name" : "Gestation Category Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the status of the birth in relation to the gestation",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/grouperStatus"
        },
        "name" : "Grouper Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of a grouper in general.  US Realm. Used in HL7 Version 2.x messaging in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSgrouperStatus"
        },
        "name" : "Grouper Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of a grouper in general.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/healthCareProviderAreaOfSpecialization"
        },
        "name" : "Health Care Provider Area of Specialization (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the more specific service or occupation within the healthcare provider type of the practitioner at a specific organization unit. Used in HL7 Version 2.x messaging in the ORG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VShealthCareProviderAreaOfSpecialization"
        },
        "name" : "Health Care Provider Area of Specialization (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the segment of the population that a health care provider chooses to service, a specific medical service, a specialization in treating a specific disease, or any other descriptive characteristic about a provider’s practic",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/healthCareProviderClassification"
        },
        "name" : "Health Care Provider Classification (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the more specific service or occupation within the healthcare provider type of the practitioner at a specific organization unit. Used in HL7 Version 2.x messaging in the ORG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VShealthCareProviderClassification"
        },
        "name" : "Health Care Provider Classification (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the more specific service or occupation within the healthcare provider type of the practitioner at a specific organization unit.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/healthCareProviderTypeCode"
        },
        "name" : "Health Care Provider Type Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the major grouping of the service or occupation of the practitioner at a specific organization unit.  Used in HL7 Version 2.x messaging in the ORG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VShealthCareProviderTypeCode"
        },
        "name" : "Health Care Provider Type Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the major grouping of the service or occupation of a practitioner at a specific organization unit.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/identifierType"
        },
        "name" : "Identifier Type (2.8.1 - 1.5.0)",
        "description" : "HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSidentifierType"
        },
        "name" : "Identifier Type (2.8.1 - 1.5.0)",
        "description" : "Concepts specifying types of identififiers, as used in person and organization identification datatypes in HL7 Version 2 standards.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/identityMayBeDivulged"
        },
        "name" : "Identity May Be Divulged (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to define whether the primary observer has given permission for their identification information to be provided to a product manufacturer.  Used in HL7 Version 2.x messaging in the PEO segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSidentityMayBeDivulged"
        },
        "name" : "Identity May Be Divulged (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define whether the primary observer has given permission for their identification information to be provided to a product manufacturer.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/identityReliability"
        },
        "name" : "Identity Reliability Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the reliability of patient/person identifying data transmitted via a transaction.  Used in HL7 Version 2.x messaging in the PID segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSidentityReliabilityCode"
        },
        "name" : "Identity Reliability Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the reliability of patient/person identifying data transmitted via a transaction.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/immunizationRegistryStatus"
        },
        "name" : "Immunization Registry Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the immunization registry status of the patient.  Used in HL7 Version 2.x messaging in the PD1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSimmunizationRegistryStatus"
        },
        "name" : "Immunization Registry Status (2.8.1 - 1.0.0)",
        "description" : "Immunization registry status codes of a patient.  Used in Version 2 messaging in the PD1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/inactiveReason"
        },
        "name" : "Inactive Reason Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the reason the staff member is inactive.  Used in HL7 Version 2 messaging in the STF segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSinactiveReasonCode"
        },
        "name" : "Inactive Reason Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the reason the staff member is inactive.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/incidentType"
        },
        "name" : "Incident Type Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a classification of types of incidents.  Used in HL7 Version 2 messaging in the RMI segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSincidentTypeCode"
        },
        "name" : "Incident Type Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying a classification of the incident type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/indirectExposureMechanism"
        },
        "name" : "Indirect Exposure Mechanism (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to identify the mechanism of product transmission when the product has not been directly applied to the patient.  Used in HL7 Version 2.x messaging in the PCR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSindirectExposureMechanism"
        },
        "name" : "Indirect Exposure Mechanism (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the mechanism of product transmission when the product has not been directly applied to the patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/informInstructions"
        },
        "name" : "Inform Person Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying who (if anyone) should or should not be informed of an error.  Used in the Error (ERR) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSinformPersonCode"
        },
        "name" : "Inform Person Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify who (if anyone) shouldor should not be informed of an error.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/institutionRelationshipType"
        },
        "name" : "Institution Relationship Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the relationship the staff person has with the institution for whom he/she provides services.  Used in HL7 Version 2 messaging in the STF segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSinstitutionRelationshipType"
        },
        "name" : "Institution Relationship Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the relationship the staff person has with the institution for whom he/she provides services.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/intendedProcedureType"
        },
        "name" : "Intended Procedure Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the type of intended procedure.  Used in HL7 Version 2.x messaging in the DON segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSintendedProcedureType"
        },
        "name" : "Intended Procedure Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the type of intended procedure.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/observationInterpretation"
        },
        "name" : "Interpretation Codes (2.8.1 - 2.1.0)",
        "description" : "HL7-defined code system of concepts which specify a categorical assessment of an observation value.  Used in HL7 Version 2.x messaging in the OBX segment.\r\nNotes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSinterpretationCode"
        },
        "name" : "Interpretation Codes (2.8.1 - 2.1.0)",
        "description" : "A categorical assessment, providing a rough qualitative interpretation of the observation value, such as “normal”/ “abnormal”,”low” / “high”, “better” / “worse”, “susceptible” / “resistant”, “expected”/ “not expected”. The value set is intended to be for ANY use where coded representation of an interpretation is needed.   Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. Historically these values come from the laboratory domain, and these codes are extensively used. The value set binding is extensible, so codes outside the value set that are needed for interpretation concepts  (i.e. particular meanings) that are not included in the value set can be used, and these new codes may also be added to the value set and published in a future version.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/invocationEvent"
        },
        "name" : "Invocation Event (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify codes for an event precipitating/triggering a charge activity.  Used in HL7 Version 2.x messaging in the CCD and BLG segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSwhenToCharge"
        },
        "name" : "Invocation Event (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify codes for an event precipitating/triggering a charge activity.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/invoiceControl"
        },
        "name" : "Invoice Control Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify what action is being performed by this message.  Used in the Invoice (IVC) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSinvoiceControlCode"
        },
        "name" : "Invoice Control Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify what invoice action is being performed by this message.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/invoiceProcessingResultsStatus"
        },
        "name" : "Invoice Processing Results Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the processing status for an Invoice Processing Result.  Used in the Invoice Processing Result (IPR) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSinvoiceProcessingResultsStatus"
        },
        "name" : "Invoice Processing Results Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used to specify the processing status for an Invoice Processing Result.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/invoiceReason"
        },
        "name" : "Invoice Reason Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the reason for this invoice.  Used in the Invoice (IVC) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSinvoiceReasonCodes"
        },
        "name" : "Invoice Reason Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the reason for an invoice.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/invoiceType"
        },
        "name" : "Invoice Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the type of invoice.  Used in the Invoice (IVC) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSinvoiceType"
        },
        "name" : "Invoice Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of invoice.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/itemStatus"
        },
        "name" : "Item Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status (useful for reporting and item usage purposes) that applies to an item. Used in HL7 Version 2.x messaging in the ITM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSitemStatus"
        },
        "name" : "Item Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status (useful for reporting and item usage purposes) that applies to an item.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSitemStatusCodes"
        },
        "name" : "Item Status Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the state of an inventory item within the context of an inventory location.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/itemType"
        },
        "name" : "Item Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying a classification of material items into like groups as defined and utilized within an operating room setting for charting procedures.  Used in HL7 Version 2.x messaging in the ITM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSitemType"
        },
        "name" : "Item Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a classification of material items into like groups as defined and utilized within an operating room setting for charting procedures.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/jobStatus"
        },
        "name" : "Job Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the next of kin/associated party's job status.  Used in HL7 Version 2.x messaging in the Next of Kin/Associated Parties (NK1) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSjobStatus"
        },
        "name" : "Job Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a next of kin/associated party's job status.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/jurisdictionalBreadth"
        },
        "name" : "Jurisdictional Breadth (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the breadth/extent of the jurisdiction where the qualification is valid.  Used in HL7 Version 2 messaging in the CER segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSjurisdictionalBreadth"
        },
        "name" : "Jurisdictional Breadth (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the breadth/extent of the jurisdiction where the qualification is valid.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/kindOfQuantity"
        },
        "name" : "Kind of Quantity (2.8.1 - 1.0.0)",
        "description" : "HL7 published code system of concepts that describe categories of an underlying kind of property represented by an observation.  These are intended to distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth.  These are discussed more fully in the LOINC Users’ Manual.   These defined categories are derived from the approach described in 1995 edition of the IUPAC Silver Book.  These distinctions are used in IUPAC and LOINC standard codes.  Needs review by OO and HTA to determined if this is a value set built on LOINC part codes or some other external vocabulary.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSkindOfQuantity"
        },
        "name" : "Kind of Quantity (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that describe the underlying kind of property represented by an observation.  The categories distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/laborCalculationType"
        },
        "name" : "Labor Calculation Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that identify the method used to calculate employee labor and measure employee productivity. Used in HL7 Version 2.x messaging in the SCP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlaborCalculationType"
        },
        "name" : "Labor Calculation Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the method used to calculate employee labor and measure employee productivity.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/languageAbility"
        },
        "name" : "Language Ability (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts which specify codes that indicate the ability that a Staff Member possesses with respect to the language. Used in HL7 Version 2.x messaging in the LAN segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlanguageAbility"
        },
        "name" : "Language Ability (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify codes that indicate the ability that a Staff Member possesses with respect to the language.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/languageProficiency"
        },
        "name" : "Language Proficiency (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a level of knowledge that a Staff Member possesses with respect to their language ability.  Used in HL7 Version 2 messaging in the LAN segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlanguageProficiency"
        },
        "name" : "Language Proficiency (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes which specify the level of knowledge a person possesses with respect to a language ability identified.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/levelOfCare"
        },
        "name" : "Level of Care (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to identify the level of care a patient may be afforded when assigned to this location definition.  Used in HL7 Version 2.x messaging in the LCH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlevelOfCare"
        },
        "name" : "Level of Care (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the level of care a patient may be afforded when assigned to this location definition.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/livingArrangement"
        },
        "name" : "Living Arrangement (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts characterizing the situation that patient-associated parties live in at their residential address.  Used in HL7 Version 2.x messaging in the NK1 and PD1 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlivingArrangement"
        },
        "name" : "Living Arrangement (2.8.1 - 1.1.0)",
        "description" : "Concepts characterizing the situation that patient-associated parties live in at their residential address.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/livingDependency2"
        },
        "name" : "Living Dependency (2.8.1 - 2.0.0)",
        "description" : "HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient’s healthcare needs.  This information can be used for discharge planning.  Examples might include Spouse Dependent, Medical Supervision Required, Small Children Dependent.  Used in Version 2.s messaging in the NK1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlivingDependency"
        },
        "name" : "Living Dependency (2.8.1 - 2.0.0)",
        "description" : "Value Set of codes identifying specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient's healthcare needs.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/livingWillCodes"
        },
        "name" : "Living Will Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility.  If the patient does not have a living will, the value of this field indicates whether the patient was provided information on living wills.  Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlivingWill"
        },
        "name" : "Living Will Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility.  If the patient does not have a living will, the value of this field indicates whether the",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/loadStatus"
        },
        "name" : "Load Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to define the status of the information provided in a device sterilization or decontamination cycle. Used in HL7 Version 2.x messaging in the SDD segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSloadStatus"
        },
        "name" : "Load Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of the information provided in a device sterilization or decontamination cycle.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/local-remoteControlState"
        },
        "name" : "Local/Remote Control State (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts that identify the current state of control associated with the equipment.   Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state).  Used in the Equipment Detail (EQU) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlocal-remoteControlState"
        },
        "name" : "Local/Remote Control State (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the current state of control associated with the equipment.   Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/locationCharacteristic"
        },
        "name" : "Location Characteristic ID (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying an identifier code to show which characteristic is being communicated with the segment.  Used in HL7 Version 2.x messaging in the Location Characteristic (LCH) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlocationCharacteristicId"
        },
        "name" : "Location Characteristic ID (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify an identifier code to show which characteristic is being communicated with the segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/locationEquipment"
        },
        "name" : "Location Equipment (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to identify the equipment available in a location definition identified as a room or bed.  Used in HL7 Version 2.x messaging in the LOC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlocationEquipment"
        },
        "name" : "Location Equipment (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the equipment available in a location definition identified as a room or bed.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/locationRelationship"
        },
        "name" : "Location Relationship ID (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying an identifier code to show which relationship is being communicated with the segment.  Used in HL7 Version 2.x messaging in the Location Relationship (LRL) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlocationRelationshipId"
        },
        "name" : "Location Relationship ID (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify an identifier code to show which relationship is being communicated with the segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/locationServiceType"
        },
        "name" : "Location Service Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  specifying the types of services provided by the location.  Used in HL7 Version 2.x messaging in the LOC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlocationServiceCode"
        },
        "name" : "Location Service Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the types of services provided by the location.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/lotControl"
        },
        "name" : "Lot Control (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that define whether the sterilization load for a device is built in the sub-sterile area adjacent to an Operating Room or the Central Processing Department. Used in HL7 Version 2.x messaging in the SCP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSlotControl"
        },
        "name" : "Lot Control (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether the sterilization load for a device is built in the sub-sterile area adjacent to an Operating Room or the Central Processing Department.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/mailClaimParty"
        },
        "name" : "Mail Claim Party (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts which specify a party to which a claim should be mailed when claims are sent by mail.  Used in HL7 Version 2.x messaging in the IN2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmailClaimParty"
        },
        "name" : "Mail Claim Party (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a party to which a claim should be mailed when claims are sent by mail.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PH_ManufacturersOfVaccinesMVX_CDC_NIP"
        },
        "name" : "Manufacturers of Vaccines (code=MVX) (2.8.1 - 1.3.0)",
        "description" : "Table of codes specifying the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control.  Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed at URL: https://phinvads.cdc.gov/vads/SearchCodeSystems_search.action?searchOptions.searchText=PH_ManufacturersOfVaccinesMVX_CDC_NIP.  The value set is also maintained by the CDC, and may be accessed at URL: https://phinvads.cdc.gov/vads/SearchValueSets_search.action?searchOptions.searchText=PHVS_ManufacturersOfVaccinesMVX_CDC_NIP",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PHVS_ManufacturersOfVaccinesMVX_CDC_NIP"
        },
        "name" : "Manufacturers of Vaccines (code=MVX) (2.8.1 - 1.3.0)",
        "description" : "Value Set of codes that specify the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control.  Note that the source of truth for these code values are maintained by the CDC, and the code system may be acce",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/maritalStatus"
        },
        "name" : "Marital Status (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts specifying a person's marital (civil/legal) status.  Used in HL7 Version 2.x messages in the PID segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmaritalStatus"
        },
        "name" : "Marital Status (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify a person's marital (civil/legal) status.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/marketingBasis"
        },
        "name" : "Marketing Basis (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the basis for marketing approval.   Used in HL7 Version 2.x messaging in the Product Detail Country (PDC) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmarketingBasis"
        },
        "name" : "Marketing Basis (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the basis for marketing approval.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/masterFileIdentifierCodes"
        },
        "name" : "Master File Identifier Code (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files.  Used in HL7 Version 2.x messaging in the MFI segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmasterFileIdentifierCode"
        },
        "name" : "Master File Identifier Code (2.8.1 - 1.2.0)",
        "description" : "Concepts which are represented by codes identifying HL7Versions 2.x Master Files.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/matchReason"
        },
        "name" : "Match Reason (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels.  It provides a method for passing a descriptive indication of the reason a particular record was found.  Used in HL7 Version 2.x messaging in the Query Response Instance (QRI) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmatchReason"
        },
        "name" : "Match Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels.  It",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicalRoleExecutingPhysician"
        },
        "name" : "Medical Role Executing Physician (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the role of the physician (\"self-employed\" or \"employed\").  Used in HL7 Version 2.x messaging in the PSL segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmedicalRoleExecutingPhysician"
        },
        "name" : "Medical Role Executing Physician (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the role of the physician (\"self-employed\" or \"employed\").",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/messageErrorCondition"
        },
        "name" : "Message Error Condition Codes (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts specifying the HL7 (communications) error code.  Used in the ERR segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmessageErrorConditionCodes"
        },
        "name" : "Message Error Condition Codes (2.8.1 - 1.1.0)",
        "description" : "HL7 (communications) error codes, as transmitted in a message acknowledgement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/messageStructure"
        },
        "name" : "Message Structure (2.8.1 - 7.2.0)",
        "description" : "HL7-defined code system of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard.  Used in HL7 Version 2.x messaging in the MSH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmessageStructure"
        },
        "name" : "Message Structure (2.8.1 - 7.2.0)",
        "description" : "HL7 abstract message structure codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/messageType"
        },
        "name" : "Message Type (2.8.1 - 1.8.0)",
        "description" : "HL7-defined code system of concepts which specify message types.  Used in HL7 Version 2.x messaging in the MSH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmessageType"
        },
        "name" : "Message Type (2.8.1 - 1.8.0)",
        "description" : "Concepts which specify message types for HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/messageWaitingPriority"
        },
        "name" : "Message Waiting Priority (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify the disposition of the patient at time of discharge (i.e., discharged to home, expired, etc.).  Used in HL7 Version 2.x messaging in the MSA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmessageWaitingPriority"
        },
        "name" : "Message Waiting Priority (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify how important the most important waiting mesasge is.  For example, if there are 3 low priority messages, 1 medium priority message and 1 high priority message, the message waiting priority would be \"high\", because",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/mfnRecord-levelErrorReturn"
        },
        "name" : "MFN Record-level Error Return (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of the requested update.  Site-defined table, specific to each master file being updated via this transaction.  Used in HL7 Version 2.x messaging in the MFA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmfnRecode-levelErrorReturn"
        },
        "name" : "MFN Record-level Error Return (2.8.1 - 1.0.0)",
        "description" : "Concepts which code status values for requested master file record update operations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/militaryRank-Grade"
        },
        "name" : "Military Rank/Grade (2.8.1 - 2.0.0)",
        "description" : "Code system of concepts which specify the military rank/grade of the patient.  Used in HL7 Version 2.x messaging in the PD1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmilitaryRank-Grade"
        },
        "name" : "Military Rank/Grade (2.8.1 - 2.0.0)",
        "description" : "Value Set of codes that specify the military rank/grade of the patient.\r\nAustralia: https://en.wikipedia.org/wiki/Australian_Defence_Force_ranks\r\nCanada: http://www.forces.gc.ca/en/honours-history-badges-insignia/rank.page\r\nUnited States: published in t",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/militaryService"
        },
        "name" : "Military Service (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts which specify the military branch.  This field is defined by CMS or other regulatory agencies.  Used in HL7 Version 2.x messaging in the PD1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmilitaryService"
        },
        "name" : "Military Service (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the military branch.  This field is defined by CMS or other regulatory agencies.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/militaryStatus"
        },
        "name" : "Military Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  which specify the military status of the patient.  This field is defined by CMS or other regulatory agencies.  Used in HL7 Version 2.x messaging in the PD1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmilitaryStatus"
        },
        "name" : "Military Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the military status of the patient.  This field is defined by CMS or other regulatory agencies.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/mimeTypes"
        },
        "name" : "MIME Types (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the general type of data.  Used in HL7 Version 2.x messaging in the RP and ED datatypes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmimeTypes"
        },
        "name" : "MIME Types (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the general type of data.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/modality"
        },
        "name" : "Modality (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to define the imaging apparatus expected to be used to acquire an observation.  This table has been removed from the standard as of 2.7 in favor of table 0910.  Used in HL7 Version 2.x messaging in the OM1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmodality"
        },
        "name" : "Modality (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define the imaging apparatus expected to be used to acquire an observation.  This table has been removed from the standard as of 2.7 in favor of table 0910.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/arrivalMode"
        },
        "name" : "Mode of Arrival Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying how the patient was brought to the healthcare facility.  Used in HL7 Version 2.x messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmodeOfArrivalCode"
        },
        "name" : "Mode of Arrival Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying how the patient was brought to the healthcare facility.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cms-OCEModifierEditCode-cs"
        },
        "name" : "Modifier Edit Code (2.8.1 - 1.0.0)",
        "description" : "The OPPS functionality of the Integrated Outpatient Code Editor (I/OCE) software was developed for the implementation of the Medicare outpatient prospective payment system mandated by the 1997 Balanced Budget Act. CMS released the proposed OPPS rules using the Ambulatory Payment Classification (APC) system in the September 8, 1998 Federal Register. Final regulations were published in the April 7, 2000 Federal Register and the system became effective for Medicare on August 1, 2000.  Used in HL7 Version 2.x messaging in the GP1 segment.\r\n\r\nThe APC-based OPPS developed by CMS is the outpatient equivalent of the inpatient, DRG-based PPS. The APC system establishes groups of covered services so that the services within each group are comparable clinically and with respect to the use of resources.\r\n\r\nHospitals are required to use HCPCS when billing for outpatient services.\r\n\r\nThe OCE not only identifies individual errors but also indicates what actions should be taken and the reasons why these actions are necessary. In order to accommodate this functionality, the OCE is structured to return lists of edit numbers. This structure facilitates the linkage between the actions being taken, the reasons for the actions and the information on the claim (e.g., a specific diagnosis) that caused the action. \r\n\r\nIn general, the OCE performs all functions that require specific reference to HCPCS codes, HCPCS modifiers and ICD-10-CM diagnosis codes (ICD-9-CM diagnosis codes for historical claims with From Dates prior to 10/1/2015). Since these coding systems are complex and annually updated, the centralization of the direct reference to these codes and modifiers in a single program reduces effort and reduces the chance of inconsistent processing.\r\n\r\nThis is a CMS maintained list of edits: Please see the following for additional information: \r\n•\thttps://www.cms.gov/Medicare/Coding/OutpatientCodeEdit/index.html\r\n•\thttps://www.cms.gov/Medicare/Coding/OutpatientCodeEdit/Background.htmlC\r\n•\thttps://www.cms.gov/Medicare/Coding/OutpatientCodeEdit/OCEQtrReleaseSpecs.html",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmodifierEditCode"
        },
        "name" : "Modifier Edit Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the edits of the modifiers for each line or HCPCS/CPT.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/modifyIndicator"
        },
        "name" : "Modify Indicator (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts identifying whether the subscription is new or is being modified.  Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmodifyIndicator"
        },
        "name" : "Modify Indicator (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes identifying whether the subscription is new or is being modified.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/moneyOrPercentageIndicator"
        },
        "name" : "Money or Percentage Indicator (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts  which specify whether the amount is currency or a percentage.  Used in HL7 Version 2.x messaging in the MOP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpenaltyType"
        },
        "name" : "Money or Percentage Indicator (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether the amount is currency or a percentage.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/moodCodes"
        },
        "name" : "Mood Codes (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts that represent the functional state of an order.  Used in HL7 Version 2.x messaging in the RXO and OBX segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmoodCodes"
        },
        "name" : "Mood Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the functional state of an order.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nameAssemblyOrder"
        },
        "name" : "Name Assembly Order (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the preferred display order of the components of this person name.  Used in HL7 Version 2.x messaging in the PPN, XCN and XPN segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnameAssemblyOrder"
        },
        "name" : "Name Assembly Order (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the preferred display order of the components of this person name.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nameType2"
        },
        "name" : "Name Type (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts for types of names for persons.  Used in HL7 Version 2.x messaging in the XPN, PPN, XCN, PID and MRG segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnameType"
        },
        "name" : "Name Type (2.8.1 - 1.1.0)",
        "description" : "Concepts for types of names for persons.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/name-addressRepresentation"
        },
        "name" : "Name/Address Representation (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying an indication of the representation provided by the data item.  Used in HL7 Version 2.x messaging in the PPN, XAD, XCN and XON segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSname-addressRepresentation"
        },
        "name" : "Name/Address Representation (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify an indication of the representation provided by the data item.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/natureOfAbnormalTesting"
        },
        "name" : "Nature of Abnormal Testing (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts specifying the nature of an abnormal test.  Used in HL7 Version 2.x messaging in the OBX segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnatureOfAbnormalTesting"
        },
        "name" : "Nature of Abnormal Testing (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the nature of an abnormal test.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/natureOfChallenge"
        },
        "name" : "Nature of Challenge (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation.  Used in HL7 Version 2.x messaging in the OM1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnatureOfChallenge"
        },
        "name" : "Nature of Challenge (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that further describe an observation definition that is characterized as a challenge observation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/natureOfServiceTestObservation"
        },
        "name" : "Nature of Service/Test/Observation (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files.  Used in HL7 Version 2.x messaging in the OM1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnatureOfServiceTestObservation"
        },
        "name" : "Nature of Service/Test/Observation (2.8.1 - 1.1.0)",
        "description" : "Concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/newbornType"
        },
        "name" : "Newborn Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify whether the baby was born in or out of a specified facility.  Used in HL7 Version 2 messaging in the ABS segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnewbornCode"
        },
        "name" : "Newborn Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying whether the baby was born in or out of the facility.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/non-subjectConsenterReason"
        },
        "name" : "Non-Subject Consenter Reason (2.8.1 - 1.0.0)",
        "description" : "HL7-defined  code system of concepts used to specify a reason consent was granted by a person other than the subject of the consent.  Used in the Consent (CON) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnon-subjectConsenterReason"
        },
        "name" : "Non-Subject Consenter Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a reason consent was granted by a person other than the subject of the consent.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/clergyNotificationType"
        },
        "name" : "Notify Clergy Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying whether the clergy should be notified.  Used in HL7 Version 2 messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnotifyClergyCode"
        },
        "name" : "Notify Clergy Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether the clergy should be notified.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/observationResultHandling"
        },
        "name" : "Observation Result Handling (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts regarding the handling of a result.  For example, an order may specify that the result (e.g., an x-ray film) should be given to the patient for return to the requestor.   Used in HL7 Version 2.x messaging in the OBR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSobservationResultHandling"
        },
        "name" : "Observation Result Handling (2.8.1 - 1.1.0)",
        "description" : "Concepts regarding the handling of a result.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/observationResultStatusCodesInterpretation"
        },
        "name" : "Observation Result Status Codes Interpretation (2.8.1 - 1.3.0)",
        "description" : "HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier.  Used in HL7 Version 2.x messaging in the OBX segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSobservationResultStatus"
        },
        "name" : "Observation Result Status Codes Interpretation (2.8.1 - 1.3.0)",
        "description" : "Concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cms-OCEEditCode-cs"
        },
        "name" : "OCE Edit Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the action to be taken during reimbursement calculations.  Used in HL7 Version 2.x messaging in the GP2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSOCEEditCode"
        },
        "name" : "OCE Edit Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the edits that result from processing the HCPCS/CPT procedures for a record after evaluating all the codes, revenue codes, and modifiers.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/orderControlCodes"
        },
        "name" : "Order Control Codes (2.8.1 - 1.7.0)",
        "description" : "HL7-defined code system of concepts which are used to determine the function of the order segment.  Depending on the message, the action specified by one of these control codes may refer to an order or an individual service.  Used in Version 2.x messaging of orders in the ORC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSorderControl"
        },
        "name" : "Order Control Codes (2.8.1 - 1.7.0)",
        "description" : "Concepts which are used to determine the function of the order segment.  Depending on the message, the action specifies by one of these control codes may refer to an order or an individual service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/orderStatus"
        },
        "name" : "Order Status (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action.  It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent.  Only the filler can originate these values.  Used in HL7 Version 2.x messaging in the ORC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSorderStatus"
        },
        "name" : "Order Status (2.8.1 - 1.2.0)",
        "description" : "Value Set of codes that specify the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action.  It is as",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/orderType"
        },
        "name" : "Order Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying whether the order is to be executed in an inpatient setting or an outpatient setting.  Used in HL7 Version 2.x messaging in the ORC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSorderType"
        },
        "name" : "Order Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether the order is to be executed in an inpatient setting or an outpatient setting.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organDonorCodes"
        },
        "name" : "Organ Donor Code (2.8.1 - 1.2.0)",
        "description" : "Code system of concepts specifying whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization.   Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSorganDonor"
        },
        "name" : "Organ Donor Code (2.8.1 - 1.2.0)",
        "description" : "Value Set of codes that specify whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organizationalNameType"
        },
        "name" : "Organizational Name Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the type of name for an organization i.e., legal name, display name.   Used in HL7 Version 2.x messaging in the XON and PD1 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSorganizationalNameType"
        },
        "name" : "Organizational Name Type (2.8.1 - 1.0.0)",
        "description" : "Concepts used to specify the type of name for an organization i.e., legal name, display name.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/outlierType"
        },
        "name" : "Outlier Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid.   Used in HL7 Vesrion 2.x messaghing in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSoutlierType"
        },
        "name" : "Outlier Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/overallClaimDisposition"
        },
        "name" : "Overall Claim Disposition Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the final status of the claim.  Used in HL7 Version 2.x messaging in the GP1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSoverallClaimDispositionCode"
        },
        "name" : "Overall Claim Disposition Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the final status of the claim.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/override"
        },
        "name" : "Override (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to define whether a Charge Description Master description may be overridden or if it must be overridden.  Used in HL7 Version 2.x messaging in the CDM and PRC segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSoverride"
        },
        "name" : "Override (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define whether a Charge Description Master description may be overridden or if it must be overridden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/overrideType"
        },
        "name" : "Override Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify what type of override can be used to override the specific error identified.   Used in HL7 Version 2 messaging in the ERR and OVR segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSoverrideType"
        },
        "name" : "Override Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify what type of override can be used to override the specific error identified.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/package"
        },
        "name" : "Package (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the packaging unit in which this inventory supply item can be ordered or issued when purchased from the vendor in the related vendor segment.  Used in HL7 Version 2.x messaging in the PKG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpackage"
        },
        "name" : "Package (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the packaging unit in which this inventory supply item can be ordered or issued when purchased from the vendor in the related vendor segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/packagingStatus"
        },
        "name" : "Packaging Status Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the packaging status of the service.  Used in HL7 Version 2.x messaging in the GP2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpackagingStatusCode"
        },
        "name" : "Packaging Status Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the packaging status of the service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSorganizationUnitType"
        },
        "name" : "Participant Organization Unit Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the environment in which the provider acts in the role associated with the provider type, and inludes codes for venues outside of formal organized healthcare settings, such as Home. The provider environment is no",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/participation"
        },
        "name" : "Participation (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).  Used in HL7 Version 2.x messaging in the PRT segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSparticipation"
        },
        "name" : "Participation (2.8.1 - 1.1.0)",
        "description" : "Concepts that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/patientClass"
        },
        "name" : "Patient Class (2.8.1 - 1.2.0)",
        "description" : "Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpatientClass"
        },
        "name" : "Patient Class (2.8.1 - 1.2.0)",
        "description" : "Concepts used by systems to categorize patients by sites.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/patientCondition"
        },
        "name" : "Patient Condition Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc.  Used in HL7 Version 2.x messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpatientConditionCode"
        },
        "name" : "Patient Condition Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/patientLocationType"
        },
        "name" : "Patient Location Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to identify the kind of location described in the location definition.  Used in HL7 Version 2.x messaging in the LOC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpatientLocationType"
        },
        "name" : "Patient Location Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the kind of location described in the location definition.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/patientOutcome"
        },
        "name" : "Patient Outcome (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to describe the overall state of a patient as a result of patient care.  Used in HL7 Version 2.x messaging in the PEO segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpatientOutcome"
        },
        "name" : "Patient Outcome (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that describe the overall state of a patient as a result of patient care.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/patientResultsReleaseCategorizationScheme"
        },
        "name" : "Patient Results Release Categorization Scheme (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the scheme for the patient results release categorization.  Used in HL7 Version 2.x messaging in the OBX segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpatientResultsReleaseCategorizationScheme"
        },
        "name" : "Patient Results Release Categorization Scheme (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the scheme for the patient results release categorization.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/patientsRelationshipToInsured"
        },
        "name" : "Patient's Relationship to Insured (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies.  Used in HL7 Version 2.x messaging in the Insurance Additional Information (IN2) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpatient_sRelationshipToInsured"
        },
        "name" : "Patient's Relationship to Insured (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/payeeRelationshipToInvoice"
        },
        "name" : "Payee Relationship to Invoice (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the relationship to the invoice for Person Payee Types.  Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpayeeRelationshipToInvoice"
        },
        "name" : "Payee Relationship to Invoice (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used to specify the relationship to the invoice for Person Payee Types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/payeeType"
        },
        "name" : "Payee Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the type of payee (e.g., organization, person).  Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpayeeType"
        },
        "name" : "Payee Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of payee (e.g., organization, person).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/paymentAdjustmentInformation"
        },
        "name" : "Payment Adjustment Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying any payment adjustment due to drugs or medical devices.  Used in HL7 Version 2.x messaging in the GP2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpaymentAdjustmentCode"
        },
        "name" : "Payment Adjustment Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify any payment adjustment due to drugs or medical devices.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/paymentMethod"
        },
        "name" : "Payment Method Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the method for the movement of payment.  Used in the Payment Information (PMT) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpaymentMethodCode"
        },
        "name" : "Payment Method Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used to specify the method for the movement of payment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/pcaType"
        },
        "name" : "PCA Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the type of PCA.  Used in HL7 Version 2.x messaging in the RXV segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpcaType"
        },
        "name" : "PCA Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying a type of PCA.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/personLocationType"
        },
        "name" : "Person Location Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the categorization of the person's location.  Used in HL7 Version 2.x messaging datatypes that contain location identifiers such as Person Location (PL), Location with address variation (LA) and Name with date and location (NDL).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpersonLocationType"
        },
        "name" : "Person Location Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the categorization of the person's location.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/pharmacyOrderTypes"
        },
        "name" : "Pharmacy Order Types (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the general category of pharmacy order which may be used to determine the processing path the order will take.  Used in HL7 Version 2.x messaging in the RXO, RXE, RXD, RXG and RXA segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpharmacyOrderTypes"
        },
        "name" : "Pharmacy Order Types (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the general category of pharmacy order which may be used to determine the processing path the order will take.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/phlebotomyIssue"
        },
        "name" : "Phlebotomy Issue (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the phlebotomy issue.  Used in HL7 Version 2.x messaging in the DON segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSphlebotomyIssue"
        },
        "name" : "Phlebotomy Issue (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying a phlebotomy issue.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/phlebotomyStatus"
        },
        "name" : "Phlebotomy Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the status of the phlebotomy.  Used in HL7 Version 2.x messaging in the DON segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSphlebotomyStatus"
        },
        "name" : "Phlebotomy Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the status of a phlebotomy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/policyType"
        },
        "name" : "Policy Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts which specify the policy type.  Used in HL7 Version 2.x messaging in the PTA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpolicyType"
        },
        "name" : "Policy Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the policy type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/practitionerIdNumberType"
        },
        "name" : "Practitioner ID Number Type (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts used to specify the type of number used for the practitioner identification.  Used in HL7 Version 2.x messaging in the Practitioner License or Other ID Number (PLN) value as well as the Provider Data (PRD) and Contact Data (CTD)segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpractitionerIdNumberType"
        },
        "name" : "Practitioner ID Number Type (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the type of number used for the practitioner identification.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organizationUnitType"
        },
        "name" : "Practitioner Organization Unit Type (2.8.1 - 2.0.0)",
        "description" : "Code system of concepts specifying the classification of the organization unit.  Used in HL7 Version 2.x messaging in the ORG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSorganizationUnitType-Org"
        },
        "name" : "Practitioner Organization Unit Type (2.8.1 - 2.0.0)",
        "description" : "Value Set of codes that specify the classification of the organization unit.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/precaution"
        },
        "name" : "Precaution Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  specifying non-clincal precautions that need to be taken with the patient.  Used in HL7 Version 2.x messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprecautionCode"
        },
        "name" : "Precaution Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying non-clincal precautions that need to be taken with the patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/preferredMethodOfContact"
        },
        "name" : "Preferred Method of Contact (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the preferred method of contact for this person.  Used in HL7 Version 2.x messaging in the STF, PRD, and CTD segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpreferredMethodOfContrct"
        },
        "name" : "Preferred Method of Contact (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify which of a group of multiple phone numbers is the preferred method of contact for this person.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/preferredSpecimen-AttributeStatus"
        },
        "name" : "Preferred Specimen/Attribute Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a particular specimen.  Used in HL7 Version 2.x messaging in Master Files (OM4 segment) to characterize information about specimens that are associated with certain observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpreferredSpecimen-AttributeStatus"
        },
        "name" : "Preferred Specimen/Attribute Status (2.8.1 - 1.0.0)",
        "description" : "Concepts that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a particular specimen.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nubc-PresentOnAdmission-cs"
        },
        "name" : "Present On Admission (POA) Indicator (2.8.1 - 1.0.0)",
        "description" : "National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 67, Present on Admission (POA) Indicator. Code identifying a diagnosis that  was present at the time the order for inpatient admission occurs. POA indicator is assigned to all diagnoses as defined in Appendix I of the \"ICD-9-CM Official Guidelines for Coding and Reporting\" or \"ICD-10-CM Official Guidelines for Coding and Reporting (appropriate to the ICD revision used).\r\n \r\nThe UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the DG1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpresentOnAdmission_poa_Indicator"
        },
        "name" : "Present On Admission (POA) Indicator (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the present on admission indicator for this particular diagnosis.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/priceType"
        },
        "name" : "Price Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to identify the intent for the dollar amount on a pricing transaction.  Used in HL7 Version 2.x messaging in the CP datatype.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpriceType"
        },
        "name" : "Price Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the intent for the dollar amount on a pricing transaction.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/primaryKeyValueType"
        },
        "name" : "Primary Key Value Type (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts used to specify the type for the master file record identifier.  Used in HL7 Version 2.x messaging in the Master File Entry (MFE) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprimaryKeyValueType"
        },
        "name" : "Primary Key Value Type (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the type for the master file record identifier.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/primaryObserverQualification"
        },
        "name" : "Primary Observer's Qualification (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to provide a general description of the kind of health care professional who provided the primary observation.  Used in HL7 Version 2.x messaging in the PEO and PCR segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprimaryObserver_sQualification"
        },
        "name" : "Primary Observer's Qualification (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that provide a general description of the kind of health care professional who provided the primary observation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/priority"
        },
        "name" : "Priority (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen.  Used in HL7 Version 2.x messaging in the OM4 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpriority"
        },
        "name" : "Priority (2.8.1 - 1.2.0)",
        "description" : "Value Set of codes that specify the allowed priorities for obtaining the specimen.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/privacyLevel"
        },
        "name" : "Privacy Level (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to identify the level of privacy a patient will be afforded when assigned to this location definition.  Used in HL7 Version 2.x messaging in the LCH segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprivacyLevel"
        },
        "name" : "Privacy Level (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the level of privacy a patient will be afforded when assigned to this location definition.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/problem-goalAction"
        },
        "name" : "Problem/Goal Action Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal.  Used in HL7 Version 2.x messaging in the GOL, ROL, PRB and PTH segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSactionCode"
        },
        "name" : "Problem/Goal Action Code (2.8.1 - 1.0.0)",
        "description" : "Concepts used in Patient Care for the intent of a problem or goal.  Used in Version 2 messaging in the GOL segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/procedureDrgType"
        },
        "name" : "Procedure DRG Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a procedure’s priority ranking relative to its DRG.  Used in HL7 Version 2 messaging in the PR1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocedureDrgType"
        },
        "name" : "Procedure DRG Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a procedure's priority ranking relative to its DRG.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/procedureFunctionalType"
        },
        "name" : "Procedure Functional Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to classify a procedure.  Used in HL7 Version 2.x messaging in the PR1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocedureFunctionalType"
        },
        "name" : "Procedure Functional Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that classify a procedure.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/procedurePriority"
        },
        "name" : "Procedure Priority (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts which specify the significance or priority of a procedure code.  Used in HL7 Version 2 messaging in the PR1 segment.  Note that this is a post-coordinated code system, where additional ordinal priorities are created by incrementing the numericinteger code value as needed.  Only the first 2 ordinal values are predefined in the code system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocedurePriority"
        },
        "name" : "Procedure Priority (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes specifying a number that identifies the significance or priority of the procedure code.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/processInterruptionReason"
        },
        "name" : "Process Interruption Reason (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the reason for the process interruption.  Used in HL7 Version 2.x messaging in the DON segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocessInterruptionReason"
        },
        "name" : "Process Interruption Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the reason for a process interruption.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/processingConsideration"
        },
        "name" : "Processing Consideration Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer).  Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocessingConsiderationCodes"
        },
        "name" : "Processing Consideration Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/processingId"
        },
        "name" : "Processing ID (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify whether the message is part of a production, training or debugging system.  Used in HL7 Version 2.x messaging in the PT datatype.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocessingId"
        },
        "name" : "Processing ID (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify whether the message is part of a production, training or debugging system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/processingMode"
        },
        "name" : "Processing Mode (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts that indicate an archival process or an initial load process.  Used in HL7 Version 2.x messaging in the PT datatype.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocessingMode"
        },
        "name" : "Processing Mode (2.8.1 - 1.1.0)",
        "description" : "Concepts that indicate an archival process or an initial load process.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/processingPriority"
        },
        "name" : "Processing Priority (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts  which specify one or more available priorities for performing the observation or test.  Used in HL7 Version 2.x messaging in the OM1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocessingPriority"
        },
        "name" : "Processing Priority (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify one or more available priorities for performing the observation or test.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/processingType"
        },
        "name" : "Processing Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts identifying the processing type that applies to the test code.  If this attribute is omitted, then regular production is the default.  Used in HL7 Version 2.x messaging in the Test Code Configuration (TCC) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprocessingType"
        },
        "name" : "Processing Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes identifying the processing type that applies to the test code.  If this attribute is omitted, then regular production is the default.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/productSource"
        },
        "name" : "Product Source (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to describe the evaluation state of a product identified in an incident.  Used in HL7 Version 2.x messaging in the PCR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSproductSource"
        },
        "name" : "Product Source (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that describe the evaluation state of a product identified in an incident.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/product-serviceStatus"
        },
        "name" : "Product/Service Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the processing status for the Product/Service Code.  Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSproduct-serviceStatus"
        },
        "name" : "Product/Service Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the processing status for the Product/Service Code.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/product-servicesClarification"
        },
        "name" : "Product/Services Clarification Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the Product/Service Code.  Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSproduct-servicesClarification"
        },
        "name" : "Product/Services Clarification Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the Product/Service Code.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/productionClass"
        },
        "name" : "Production Class Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  specifying the code and/or text indicating the primary use for which the living subject was bred or grown.  Used in HL7 Version 2.x messaging in the PID segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSproductionClassCode"
        },
        "name" : "Production Class Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the code and/or text indicating the primary use for which the living subject was bred or grown.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/protection"
        },
        "name" : "Protection Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying that an address needs to be treated with special care or sensitivity. Used in HL7 Version 2.x messaging in the XAD and XTN segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSprotectionCode"
        },
        "name" : "Protection Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify that an address needs to be treated with special care or sensitivity.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/providerAdjustmentReason"
        },
        "name" : "Provider Adjustment Reason Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the reason for this adjustment.  Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSproviderAdjustmentReasonCode"
        },
        "name" : "Provider Adjustment Reason Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used to specify the reason for this adjustment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/providerBilling"
        },
        "name" : "Provider Billing (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying how provider services are billed.  Used in HL7 Version 2.x messaging in the PRA segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSproviderBilling"
        },
        "name" : "Provider Billing (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify how provider services are billed.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/providerRole"
        },
        "name" : "Provider Role (2.8.1 - 1.2.0)",
        "description" : "Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).  Used in HL7 Version 2.x messaging in the ROL segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSproviderRole"
        },
        "name" : "Provider Role (2.8.1 - 1.2.0)",
        "description" : "Value Set of codes that specify the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/purgeStatus"
        },
        "name" : "Purge Status Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to define the state of a visit relative to its place in a purge workflow.  Used in HL7 Version 2.x messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSpurgeStatus"
        },
        "name" : "Purge Status Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define the state of a visit relative to its place in a purge workflow.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/quantityLimitedRequest"
        },
        "name" : "Quantity Limited Request (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects.  Used in HL7 Version 2.x messaging in the RCP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSquantityLimitedRequest"
        },
        "name" : "Quantity Limited Request (2.8.1 - 1.1.0)",
        "description" : "Concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/quantityMethod"
        },
        "name" : "Quantity Method (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the method by which the quantity distributed is measured.   Used in HL7 Version 2.x messaging in the Product Summary Header (PSH) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSquantityMethod"
        },
        "name" : "Quantity Method (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the method by which the quantity distributed is measured.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/queryPriority"
        },
        "name" : "Query Priority (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a time frame in which a querry response is expected.  Used in HL7 Verson 2.x messaging in the RCP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSqueryPriority"
        },
        "name" : "Query Priority (2.8.1 - 1.0.0)",
        "description" : "Concepts which specify a time frame in which a querry response is expected.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/queryResponseStatus"
        },
        "name" : "Query Response Status (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts defining precise response status concepts in support of HL7 Version 2 query messaging.  It is commonly used to indicate no data is found that matches the query parameters, but no error.   Used in HL7 Version 2.x messaging in the QAK segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSqueryResponseStatus"
        },
        "name" : "Query Response Status (2.8.1 - 1.1.0)",
        "description" : "Concepts defining precise response status concepts in support of HL7 Version 2 query messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/masterfileActionCode"
        },
        "name" : "Record-level Event Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying an action for a master file record. Used in HL7 Version 2.x messaging in the MFE segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSmasterfileActionCode"
        },
        "name" : "Record-level Event Code (2.8.1 - 1.0.0)",
        "description" : "Concepts specifying an action for a master file record.  Used in HL7 V2.x messaging in the MFE segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/recreationalDrugType"
        },
        "name" : "Recreational Drug Use Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying what recreational drugs the patient uses.  Used in HL7 Version 2.x messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrecreationalDrugUseCode"
        },
        "name" : "Recreational Drug Use Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying what recreational drugs the patient uses.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/referralCategory"
        },
        "name" : "Referral Category (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to describe the patient care setting where a referral should take place.  Used in HL7 Version 2.x messaging in the RF1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreferralCategory"
        },
        "name" : "Referral Category (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that describe the patient care setting where a referral should take place.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/referralDisposition"
        },
        "name" : "Referral Disposition (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to identify the expected response from the healthcare professional receiving a referral.  Used in HL7 Version 2.x messaging in the RF1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreferralDisposition"
        },
        "name" : "Referral Disposition (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the expected response from the healthcare professional receiving a referral.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/referralPriority"
        },
        "name" : "Referral Priority (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to designate the urgency of a  referral.  Used in HL7 Version 2.x messaging in the RF1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreferralPriority"
        },
        "name" : "Referral Priority (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that designate the urgency of a  referral.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/referralReason"
        },
        "name" : "Referral Reason (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the reason for which the referral will take place.  Used in HL7 Version 2.x messaging in the Referral Information (RF1) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreferralReason"
        },
        "name" : "Referral Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the reason for which the referral will take place.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/referralStatus"
        },
        "name" : "Referral Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to define the state of a  referral.  Used in HL7 Version 2.x messaging in the RF1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreferralStatus"
        },
        "name" : "Referral Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define the state of a  referral.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/referralType"
        },
        "name" : "Referral Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to identify the general category of healthcare professional desired to satisfy a referral.  Used in HL7 Version 2.x messaging in the RF1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreferralType"
        },
        "name" : "Referral Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the general category of healthcare professional desired to satisfy a referral.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/reimbursementAction"
        },
        "name" : "Reimbursement Action Code (2.8.1 - 1.0.0)",
        "description" : "Code specifying the action to be taken during reimbursement calculations.  In the US, this field is defined by CMS or other regulatory agencies.   Used in HL7 Version 2.x messaging in the GP2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreimbursementActionCode"
        },
        "name" : "Reimbursement Action Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the action to be taken during reimbursement calculations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/reimbursementType"
        },
        "name" : "Reimbursement Type Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the fee schedule reimbursement type applied to the line item.  Used in HL7 Version 2.x messaging in the GP2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreimbursementTypeCode"
        },
        "name" : "Reimbursement Type Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the fee schedule reimbursement type applied to a line item.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/relatednessAssessment"
        },
        "name" : "Relatedness Assessment (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to provide an estimate of whether an issue with a  product was the cause of an event.  Used in HL7 Version 2.x messaging in the PCR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrelatednessAssessment"
        },
        "name" : "Relatedness Assessment (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that provide an estimate of whether an issue with a  product was the cause of an event.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/relationalConjunction"
        },
        "name" : "Relational Conjunction (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used with relationalOperator values to group more than one segment field name.   Used in HL7 Version 2.x messaging in the QSC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrelationalConjunction"
        },
        "name" : "Relational Conjunction (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used with relational operator values to group more than one segment field name.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/relationalOperator"
        },
        "name" : "Relational Operator (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to define the relationship between HL7 segment field names identified in a query construct.  Used in HL7 Version 2.x messaging in the QSC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrelationalOperator"
        },
        "name" : "Relational Operator (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define the relationship between HL7 segment field names identified in a query construct.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/relationship"
        },
        "name" : "Relationship (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying an actual personal relationship that the next of kin/associated party has to a patient.  Used in HL7 Version 2.x messaging in the NK1 and IN1 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrelationship"
        },
        "name" : "Relationship (2.8.1 - 1.0.0)",
        "description" : "Concepts specifying an actual personal relationship that the next of kin/associated party has to a patient.  Used in HL7 Version 2.x messaging in the NK1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/relationshipModifier"
        },
        "name" : "Relationship Modifier (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used in an observation definition to describe the subject of an observation in relation to a patient.  Used in HL7 Version 2.x messaging in the OM1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrelationshipModifier"
        },
        "name" : "Relationship Modifier (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that an observation definition to describe the subject of an observation in relation to a patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/relevantClincialInformation"
        },
        "name" : "Relevant Clinicial Information (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies. Used in HL7 Version 2.x messaging in the OBR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrelevantClincialInformation"
        },
        "name" : "Relevant Clinicial Information (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/religion2"
        },
        "name" : "Religion (2.8.1 - 2.1.0)",
        "description" : "Code system of concepts specifying a person's religion.    Used in HL7 Version 2.x messaging in the PID segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreligion2"
        },
        "name" : "Religion (2.8.1 - 2.1.0)",
        "description" : "Value Set of codes that specify a person's religion.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/remoteControlCommand"
        },
        "name" : "Remote Control Command (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts that identify the comment the component is to initiate.  Used in the Equipment Command (ECD) and Interaction Status Detail (ISD) segments in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSremoteControlCommand"
        },
        "name" : "Remote Control Command (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that identify the comment the component is to initiate.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/reorderTheory"
        },
        "name" : "Reorder Theory Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that identify the calculation method used to determine the resupply schedule. Used in HL7 Version 2.x messaging in the IVT segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreorderTheoryCodes"
        },
        "name" : "Reorder Theory Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the calculation method used to determine the resupply schedule.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/repeatPattern"
        },
        "name" : "Repeat Pattern (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts used to specify the interval between repeated services.  Used in HL7 Version 2.x messaging in the RI datatype and RPT segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrepeatPattern"
        },
        "name" : "Repeat Pattern (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the interval between repeated services. See the Comment/Usage Note in the table below, as the table contains both precoordinated codes that may be used in an HL7 field or component and also explanatory patterns i",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/reportSource"
        },
        "name" : "Report Source (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to identify where a report sender learned about an event.  Used in HL7 Version 2.x messaging in the PES segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreportSource"
        },
        "name" : "Report Source (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify where a report sender learned about an event.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/reportTiming"
        },
        "name" : "Report Timing (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to identify the time span of a report or the reason for a report sent to a regulatory agency.  Used in HL7 Version 2.x messaging in the PES segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreportTiming"
        },
        "name" : "Report Timing (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the time span of a report or the reason for a report sent to a regulatory agency.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/reportingPriority"
        },
        "name" : "Reporting Priority (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts  which specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority.  Used in HL7 Version 2.x messaging in the OM1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSreportingPriority"
        },
        "name" : "Reporting Priority (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/responseFlag"
        },
        "name" : "Response Flag (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler.  Used in HL7 Version 2.x messaging in the ORC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSresponseFlag"
        },
        "name" : "Response Flag (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes allowing the placer (sending) application to determine the amount of information to be returned from the filler.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/responseLevel"
        },
        "name" : "Response Level (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message.  Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions.  Used in HL7 Version 2.x messaging in the MFI segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSresponseLevel"
        },
        "name" : "Response Level (2.8.1 - 1.0.0)",
        "description" : "Concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message.  Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/responseModality"
        },
        "name" : "Response Modality (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts identifying the timing and grouping of the response message(s).  Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSresponseModality"
        },
        "name" : "Response Modality (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes identifying the timing and grouping of the response message(s).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/resultStatus"
        },
        "name" : "Result Status (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts which specify a status of results for an order.  Used in HL7 Version 2.x messaging in the OBR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSresultStatus-Obr"
        },
        "name" : "Result Status (2.8.1 - 1.2.0)",
        "description" : "Concepts which specify a status of results for an order.  Used in HL7 Version 2.x messaging in the OBR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/risks"
        },
        "name" : "Risk Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient.  Used in HL7 Version 2.x messaging in the SPM and PAC segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSriskCodes"
        },
        "name" : "Risk Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/riskManagementIncident"
        },
        "name" : "Risk Management Incident Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s stay.  Used in HL7 Version 2 messaging in the RMI segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSriskManagementIncidentCode"
        },
        "name" : "Risk Management Incident Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the incident that occurred during a patient's stay.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/roleExecutingPhysician"
        },
        "name" : "Role Executing Physician (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the account role of the physician, for example, only billing for the professional part, the technical part or both.  Used in HL7 Version 2.x messaging in the PSL segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSroleExecutingPhysician"
        },
        "name" : "Role Executing Physician (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the account role of the physician, for example, only billing for the professional part, the technical part or both.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/roomType"
        },
        "name" : "Room Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts  which specify the room type.  Used in HL7 Version 2.x messaging in the RMC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSroomType"
        },
        "name" : "Room Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the room type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/rootCause"
        },
        "name" : "Root Cause (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the root cause.  Used in HL7 Version 2.x messaging in the OBX segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrootCause"
        },
        "name" : "Root Cause (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying a root cause.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/routeOfAdministration"
        },
        "name" : "Route of Administration (2.8.1 - 3.0.3)",
        "description" : "Code system of concepts  which specify the route of administration.  Used in HL7 Version 2.x messaging in the RXR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrouteOfAdministration"
        },
        "name" : "Route of Administration (2.8.1 - 3.0.3)",
        "description" : "Value Set of codes that specify the route of administration.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/rxComponentType"
        },
        "name" : "RX Component Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts  which specify the RX component type.  Used in HL7 Version 2.x messaging in the RXC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSrxComponentType"
        },
        "name" : "RX Component Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the RX component type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/securityCheckScheme"
        },
        "name" : "Security Check Scheme (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the scheme for the security check.  Used in HL7 Version 2.x messaging in the CX datatypes and PPN and XCN segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsecurityCheckScheme"
        },
        "name" : "Security Check Scheme (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the scheme for a security check.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/segmentAction"
        },
        "name" : "Segment Action Code (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in \"action code mode\" (a kind of update mode in the Standard).  Used in HL7 Version 2.x messaging in the RXA, RXV, LCH, IAM, ARV, IN1 and OH1 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsegmentActionCode"
        },
        "name" : "Segment Action Code (2.8.1 - 1.1.0)",
        "description" : "Concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in \"action code mode\" (a kind of update mode in the Standard).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/segmentGroup"
        },
        "name" : "Segment Group (2.8.1 - 8.0.0)",
        "description" : "HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response.  This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included.  Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsegmentGroup"
        },
        "name" : "Segment Group (2.8.1 - 8.0.0)",
        "description" : "Value Set of codes that specify the optional segment groups which are to be included in a response.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sensitivityToCausativeAgent"
        },
        "name" : "Sensitivity to Causative Agent Code (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts specifying the reason the patient should not be exposed to a substance.  Used in HL7 Version 2.x messaging in the IAM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsensitivityToCausativeAgentCode"
        },
        "name" : "Sensitivity to Causative Agent Code (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes specifying the reason the patient should not be exposed to a substance.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sequenceCondition"
        },
        "name" : "Sequence Condition Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the relationship between the start/end of the related service request(s) (from TQ2-3, TQ2-4 or TQ2-5) and the current service request from ORC-2, 3 or 4.  Used in HL7 Version 2.x messaging in the TQ2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsequenceConditionCode"
        },
        "name" : "Sequence Condition Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the relationship between the start/end of the related service request(s) and the current service request.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sequenceResultsFlag"
        },
        "name" : "Sequence/Results Flag (2.8.1 - 1.0.0)",
        "description" : "HL7-defined  code system of concepts used to specify the sequencing relationship between the current service request and the related service request(s) specified in this TQ2 segment.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsequenceResultsFlag"
        },
        "name" : "Sequence/Results Flag (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the sequencing relationship between the current service request and a related service request(s) specified in the same information model structure.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sequencing"
        },
        "name" : "Sequencing (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not.  Used in HL7 Version 2.x messaging in the Sort Order (SRT) value.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsequencing"
        },
        "name" : "Sequencing (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/serviceRequestRelationship"
        },
        "name" : "Service Request Relationship (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify an additional or alternate relationship between this service request and other service requests.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSserviceRequestRelationship"
        },
        "name" : "Service Request Relationship (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify an additional or alternate relationship between this service request and other service requests.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/severityOfIllness"
        },
        "name" : "Severity of Illness Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify the ranking of a patient’s illness.  Used in HL7 Version 2 messaging in the ABS segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSseverityOfIllnessCode"
        },
        "name" : "Severity of Illness Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the severity ranking of a patient's illness.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/shipmentStatus"
        },
        "name" : "Shipment Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the status of the shipment.  Used in HL7 Version 2.x messaging in the SHP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSshipmentStatus"
        },
        "name" : "Shipment Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the status of a shipment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sideOfBody"
        },
        "name" : "Side of body (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the side of the body (\"left\" or \"right\").  Used in HL7 Version 2.x messaging in the PSL segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsideOfBody"
        },
        "name" : "Side of body (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the side of the body (\"left\" or \"right\").",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/signatorysRelationshipToSubject"
        },
        "name" : "Signatory's Relationship to Subject (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the relationship of the consenter to the subject.  Used in HL7 Version 2 messaging in the CON segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsignatory_sRelationshipToSubject"
        },
        "name" : "Signatory's Relationship to Subject (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the relationship of the consenter to the subject.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/signatureType"
        },
        "name" : "Signature Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that indicate how a patient/subscriber authorization signature is obtained and how it is being retained by a provider.  Used in HL7 Version 2.x messaging in the IN1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsignatureCode"
        },
        "name" : "Signature Code (2.8.1 - 1.0.0)",
        "description" : "Concepts that indicate how a patient/subscriber authorization signature is obtained and how it is being retained by a provider.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sourceOfComment"
        },
        "name" : "Source of Comment (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts which are used to specify the source of a comment.  Used in HL7 Version 2.x messaging in the NTE segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsourceOfComment"
        },
        "name" : "Source of Comment (2.8.1 - 1.1.0)",
        "description" : "Concepts which are used to specify the source of a comment, as used in HL7 Version 2.x messaging in the NTE segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sourceType"
        },
        "name" : "Source Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to specify the type of facility.   Used in HL7 Version 2.x messaging in the Facility (FAC) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSnetworkSourceType"
        },
        "name" : "Source Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that indicate (in certain systems) whether a lower level source identifier is an initiate or accept type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specialHandling"
        },
        "name" : "Special Handling Code (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing.  Used in HL7 Version 2.x messaging in the SPM, SAC, PAC and OM4 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecialHandlingConsiderations"
        },
        "name" : "Special Handling Code (2.8.1 - 1.1.0)",
        "description" : "Concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing.  Used in Version 2 messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specialtyType"
        },
        "name" : "Specialty Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to identify the specialty of the care professional who is supported when using this location definition.  Used in HL7 Version 2.x messaging in the LDP segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecialtyType"
        },
        "name" : "Specialty Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the specialty of the care professional who is supported when using this location definition.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenAction"
        },
        "name" : "Specimen Action Code (2.8.1 - 2.1.0)",
        "description" : "HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order.  The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx).  Used in HL7 Version 2.x messaging in the OBR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenAppropriateness"
        },
        "name" : "Specimen Appropriateness (2.8.1 - 2.0.0)",
        "description" : "Code system of concepts specifying the suitability of the specimen for the particular planned use as determined by the filler.  Used in HL7 Version 2.x messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenAppropriateness"
        },
        "name" : "Specimen Appropriateness (2.8.1 - 2.0.0)",
        "description" : "Value Set of codes that specify the suitability of the specimen for the particular planned use as determined by the filler.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenChildRole"
        },
        "name" : "Specimen Child Role (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying for child specimens the relationship between this specimen and the parent specimen.  Used in HL7 Version 2.x messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenChildRole"
        },
        "name" : "Specimen Child Role (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify for child specimens the relationship between this specimen and the parent specimen.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenCollectionMethod"
        },
        "name" : "Specimen Collection Method (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying the specimen collection method.  Used in HL7 Version 2.x messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenCollectionMethod"
        },
        "name" : "Specimen Collection Method (2.8.1 - 1.0.0)",
        "description" : "Concepts to document procedures or processes by which a specimen may be collected.  This is one of two code systems that are used instead of table 0070 (code system xxxx) which conflated specimen types and specimen collection methods.   Used in Version 2 messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenComponent"
        },
        "name" : "Specimen Component (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that identify the specimen component, e.g., supernatant, sediment, etc.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenComponent"
        },
        "name" : "Specimen Component (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the specimen component, e.g., supernatant, sediment, etc.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenCondition"
        },
        "name" : "Specimen Condition (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts specifying a mode or state of being that describes the nature of the specimen.  Used in HL7 Version 2.x messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenCondition"
        },
        "name" : "Specimen Condition (2.8.1 - 1.1.0)",
        "description" : "Concepts of modes or states of being that describe the nature of a specimen.  Used in Version 2 messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenQuality"
        },
        "name" : "Specimen Quality (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the degree or grade of excellence of the specimen at receipt.  Used in HL7 Version 2.x messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenQuality"
        },
        "name" : "Specimen Quality (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the degree or grade of excellence of the specimen at receipt.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenRejectReason"
        },
        "name" : "Specimen Reject Reason (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of reasons a specimen may be rejected for a specified observation/result/analysis.  Used in HL7 Version 2.x messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenRejectReason"
        },
        "name" : "Specimen Reject Reason (2.8.1 - 1.0.0)",
        "description" : "Reasons a specimen may be rejected for a specified observation/result/analysis.  Used in Version 2 messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenRole"
        },
        "name" : "Specimen Role (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts that identify the role of a sample.  Used in HL7 Version 2.x messaging in the Specimen (SPM) and Observation Request (OBR) segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenRole"
        },
        "name" : "Specimen Role (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that identify the role of a sample.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specimenType"
        },
        "name" : "Specimen Type (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts that describe the precise nature of an entity that may be used as the source material for an observation.  This is one of two code systems that are used instead of table 0070 (code system 2.16.840.1.113883.18.28) which conflated specimen types and specimen collection methods.   Used in HL7 Version 2.x messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSspecimenType"
        },
        "name" : "Specimen Type (2.8.1 - 1.1.0)",
        "description" : "Concepts that describe the precise nature of an entity that may be used as the source material for an observation.  This is one of two code systems that are used instead of table 0070 (code system xxxx) which conflated specimen types and specimen collection methods.   Used in Version 2 messaging in the SPM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgstatusAdmission"
        },
        "name" : "Status Admission (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the admission status for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSstatusAdmission"
        },
        "name" : "Status Admission (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the admission status for the diagnosis related group (DRG) determination.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/statusOfEvaluation"
        },
        "name" : "Status of Evaluation (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts that describes the status of product evaluation.  Used in HL7 Version 2.x messaging in the PCR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSstartOfEvaluation"
        },
        "name" : "Status of Evaluation (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that describes the status of product evaluation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgstatusWeightAtBirth"
        },
        "name" : "Status Weight At Birth (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the status of the use of the weight at birth for diagnosis related group (DRG) determination.  US Realm.  Used in HL7 Version 2.x messaging in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSstatusWeightAtBirth"
        },
        "name" : "Status Weight At Birth (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the status of the use of the weight at birth for diagnosis related group (DRG) determination.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sterilizationType"
        },
        "name" : "Sterilization Type (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the type of sterilization used for sterilizing the inventory supply item in the ITM segment.  Used in HL7 Version 2.x messaging in the  STZ segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsterilizationType"
        },
        "name" : "Sterilization Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the type of sterilization used for sterilizing the inventory supply item in the ITM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/studentStatus"
        },
        "name" : "Student Status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to designate whether a guarantor is a full or part time student.  Used in HL7 Version 2.x messaging in the GT1, NK1 and PD1 segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSstudentStatus"
        },
        "name" : "Student Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that designate whether a guarantor is a full or part time student.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/substanceStatus"
        },
        "name" : "Substance Status (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts identifying the status of the inventoried item.  The status indicates the current status of the substance.  Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsubstanceStatus"
        },
        "name" : "Substance Status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes identifying the status of the inventoried item.  The status indicates the current status of the substance.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/substanceType"
        },
        "name" : "Substance Type (2.8.1 - 1.0.1)",
        "description" : "HL7-defined  code system of concepts identifying the type of substance.  Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsubstanceType"
        },
        "name" : "Substance Type (2.8.1 - 1.0.1)",
        "description" : "Value Set of codes identifying the type of substance.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/substitutionStatus"
        },
        "name" : "Substitution Status (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts  which specify the substitution status.  Used in HL7 Version 2.x messaging in the RXE, RXD, and RXG segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsubstitutionStatus"
        },
        "name" : "Substitution Status (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify the substitution status.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/subtypeOfReferencedData"
        },
        "name" : "Subtype of Referenced Data (2.8.1 - 1.2.1)",
        "description" : "Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream.  Used in Version 2 messaging  ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes.   More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsubtypeOfReferencedData"
        },
        "name" : "Subtype of Referenced Data (2.8.1 - 1.2.1)",
        "description" : "A subset of the IANA media subtypes of binary data that are encoded in an ascii structure or stream.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/supplyRisk"
        },
        "name" : "Supply Risk Codes (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying any known or suspected hazard associated with this material item.  Used in HL7 Version 2.x messaging in the ITM segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSsupplyRiskCodes"
        },
        "name" : "Supply Risk Codes (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying any known or suspected hazard associated with this material item.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/taxStatus"
        },
        "name" : "Tax status (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the tax status of the provider.  Used in the Invoice (IVC) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStaxStatus"
        },
        "name" : "Tax status (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes used to specify the tax status of a provider.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/telecommunicationEquipmentType"
        },
        "name" : "Telecommunication Equipment Type (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts  for specifying a type of telecommunication equipment.  Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified.  Used in HL7 Version 2.x messaging in the XTN segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStelecommunicationEquipmentType"
        },
        "name" : "Telecommunication Equipment Type (2.8.1 - 1.2.0)",
        "description" : "Concepts  for specifying a type of telecommunication equipment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/telecommunicationExpirationReason"
        },
        "name" : "Telecommunication Expiration Reason (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the reason this contact number/email was marked as \"ended\".  Used in HL7 Version 2.x messaging in the XTN segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStelecommunicationExpirationReason"
        },
        "name" : "Telecommunication Expiration Reason (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying the reason this contact number/email was marked as \"ended\".",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/telecommunicationUse"
        },
        "name" : "Telecommunication Use Code (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of concepts for specifying a specific use of a telecommunication number.  Best practice is to use this concept whenever a telecommunication number or access string is specified.  Used in HL7 Version 2.x messaging in the XTN segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStelecommunicationUseCode"
        },
        "name" : "Telecommunication Use Code (2.8.1 - 1.2.0)",
        "description" : "Concepts for specifying a specific use of a telecommunication number.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/timeDelayPostChallenge"
        },
        "name" : "Time Delay Post Challenge (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts used to classify an observation definition as being a component of a challenge test.  Used in HL7 Version 2.x messaging in the OM1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStimeDelayPostChallenge"
        },
        "name" : "Time Delay Post Challenge (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that classify an observation definition as being a component of a challenge test.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/timeSelectionCriteriaParameterClass"
        },
        "name" : "Time Selection Criteria Parameter Class Codes (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts used to describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling.  Used in HL7 Version 2.x messaging in the SCV and APR segments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStimeSelectionCriteriaParameterClassCodes"
        },
        "name" : "Time Selection Criteria Parameter Class Codes (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/tissueType"
        },
        "name" : "Tissue Type Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a type of tissue removed from a patient during a procedure. Used in HL7 Version 2 messaging in the PR1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStissueTypeCode"
        },
        "name" : "Tissue Type Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of tissue removed from a patient during a procedure.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/tqConjunctionId"
        },
        "name" : "TQ Conjunction ID (2.8.1 - 1.1.0)",
        "description" : "HL7-defined code system of concepts specifying that a second timing specification is to follow using the repeat delimiter.  Used in HL7 Version 2.x messaging in the TQ1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStqConjunctionId"
        },
        "name" : "TQ Conjunction ID (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify that a second timing specification is to follow using the repeat delimiter.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/transactionType"
        },
        "name" : "Transaction Type (2.8.1 - 1.1.0)",
        "description" : "Code system of concepts specifying a type of financial transaction.  Used in HL7 Version 2.x messaging in the FT1 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStransactionType"
        },
        "name" : "Transaction Type (2.8.1 - 1.1.0)",
        "description" : "Value Set of codes that specify a type of financial transaction.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drgTransferType"
        },
        "name" : "Transfer Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG’s), for example, exempt or non-exempt.  Used in HL7 Version 2 messaging in the DRG segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSdrgTransferType"
        },
        "name" : "Transfer Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG's), for example, exempt or non-exempt.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/transfusionAdverseReaction"
        },
        "name" : "Transfusion Adverse Reaction (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to specify the type of adverse reaction that the recipient of the blood product experienced.  Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStransfusionAdverseReaction"
        },
        "name" : "Transfusion Adverse Reaction (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of adverse reaction that the recipient of the blood product experienced.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/transportArranged"
        },
        "name" : "Transport Arranged (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts defining whether patient transportation preparations are in place.  Used in HL7 Version 2.x messaging in the OBR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStransportArranged"
        },
        "name" : "Transport Arranged (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes defining whether patient transportation preparations are in place.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/transportationMode"
        },
        "name" : "Transportation Mode (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify how (or whether) to transport a patient, when applicable, for an ordered service.  Used in HL7 Version 2.x messaging in the OBR segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStransportationMode"
        },
        "name" : "Transportation Mode (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify how (or whether) to transport a patient, when applicable, for an ordered service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/trayType"
        },
        "name" : "Tray Type (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts  which specify whether the type of diet.    Used in HL7 Version 2.x messaging in the ODT segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStrayType"
        },
        "name" : "Tray Type (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the type of dietary tray.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/treatment"
        },
        "name" : "Treatment (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts that identify the specimen treatment performed during lab processing.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStreatment"
        },
        "name" : "Treatment (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that identify the specimen treatment performed during lab processing.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/triageType"
        },
        "name" : "Triage Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts which specify a patient’s prioritization within the context of a transmitted abstract. Used in HL7 Version 2 messaging in the ABS segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStriageCode"
        },
        "name" : "Triage Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes specifying a patient's prioritization within the context of this abstract.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/typeOfReferencedData"
        },
        "name" : "Type of Referenced Data (2.8.1 - 1.3.0)",
        "description" : "HL7-defined code system of concepts declaring the general type of media data that is encoded.  Used in v2.5.1 interfaces and earlier, and replaced with the full set of IANA media types as a standard coding system for this after HL7 version 2.6 (see value set 2.16.840.1.113883.21.425 hl7VS-mimeTypes for HL7 table 0834 built on MIME types).  More information may be found at http://www.iana.org/assignments/media-types/media-types.xhtml",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VStypeOfData"
        },
        "name" : "Type of Referenced Data (2.8.1 - 1.3.0)",
        "description" : "Concepts declaring the general type of media data that is encoded.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/universalIdType"
        },
        "name" : "Universal ID Type (2.8.1 - 1.2.0)",
        "description" : "HL7-defined code system of types of UID (Universal Identifiers).   Used in HL7 Version 2.x messaging HD and EI datatypes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSuniversalIdType"
        },
        "name" : "Universal ID Type (2.8.1 - 1.2.0)",
        "description" : "Types of UID (Universal Identifiers).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/userAuthenticationCredentialType"
        },
        "name" : "User Authentication Credential Type Code (2.8.1 - 1.0.0)",
        "description" : "HL7-defined code system of concepts specifying a type of user authentication credential.  Used in HL7 Version 2.x messaging in the UAC segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSuserAuthenticationCredentialTypeCode"
        },
        "name" : "User Authentication Credential Type Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify a type of user authentication credential.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/V2CodeSystem"
        },
        "name" : "V2CodeSystem",
        "description" : "Profile for CodeSystem instances generated in this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PH_VaccinesAdministeredCVX_CDC_NIP"
        },
        "name" : "Vaccines Administered (2.8.1 - 1.5.0)",
        "description" : "Table of codes specifying the administered vaccines.   The values are maintained by the US Centers of Disease Control.  The code system is maintained by the CDC, and may be found at URL;  https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.292\r\nThe value set is maintained by the CDC and may be found at URL: https://phinvads.cdc.gov/vads/ViewValueSet.action?id=ABDEE003-77C3-48E7-B941-EBF92B6B81FC",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PHVS_VaccinesAdministeredCVX_CDC_NIP"
        },
        "name" : "Vaccines Administered (2.8.1 - 1.5.0)",
        "description" : "Value Set of codes that specify the administered vaccines.   The values are maintained by the US Centers of Disease Control..  The code system is maintained by the CDC, and may be found at URL;  https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.1",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/versionId"
        },
        "name" : "Version ID (2.8.1 - 1.11.0)",
        "description" : "HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards.  Used in HL7 Version 2.x messaging in the VID segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSversionControlTable"
        },
        "name" : "Version ID (2.8.1 - 1.11.0)",
        "description" : "Concepts which are used to identify an HL7 version in the Version 2.x family of published standards.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/visitIndicator"
        },
        "name" : "Visit Indicator (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts specifying the level on which data are being sent.  It is the indicator used to send data at two levels, visit and account.  HL7 recommends sending an \"A\" or no value when the data in the message are at the account level or \"V\" to indicate that the data sent in the message are at the visit level.  Used in HL7 Version 2.x messaging in the Patient Visit (PV1) segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSvisitIndicator"
        },
        "name" : "Visit Indicator (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify the level on which data are being sent.  It is the indicator used to send data at two levels, visit and account.  HL7 recommends sending an \"A\" or no value when the data in the message are at the account level or \"V\" to i",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/visitPriority"
        },
        "name" : "Visit Priority Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts used to define a relative level of urgency applied to a patient visit.  Used in HL7 Version 2.x messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSvisitPriorityCode"
        },
        "name" : "Visit Priority Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that define a relative level of urgency applied to a patient visit.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/visitUserCodes"
        },
        "name" : "Visit User Code (2.8.1 - 1.0.0)",
        "description" : "Code system of concepts which specify categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis.  Used in HL7 Version 2.x messaging in the PV2 segment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSvisitUserCode"
        },
        "name" : "Visit User Code (2.8.1 - 1.0.0)",
        "description" : "Value Set of codes that specify categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7VSyes-no-Indicator"
        },
        "name" : "Yes/No Indicator (2.8.1 - 1.0.0)",
        "description" : "Codes specifying either Yes or No used in fields containing binary answers generally user-specified.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Homepage",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "download.html"
            }
          ],
          "nameUrl" : "download.html",
          "title" : "Downloads",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
