# Segment Group (2.8.1 - 8.0.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Segment Group (2.8.1 - 8.0.0)**

## CodeSystem: Segment Group (2.8.1 - 8.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/segmentGroup | *Version*:8.0.0 |
| Active as of 2026-01-27 | *Computable Name*:SegmentGroup |
| *Other Identifiers:*OID:2.16.840.1.113883.18.242 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response. This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included. Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSsegmentGroup](ValueSet-hl7VSsegmentGroup.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "segmentGroup",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0391"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/segmentGroup",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.242"
    }
  ],
  "version" : "8.0.0",
  "name" : "SegmentGroup",
  "title" : "Segment Group (2.8.1 - 8.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response.  This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included.  Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VShl7VSmessageStructure"
        }
      ],
      "code" : "msgstruct",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#msgstruct",
      "description" : "msgstruct",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "ACCESSION_DETAIL",
      "display" : "ACCESSION_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        }
      ]
    },
    {
      "code" : "ADDITIONAL_DEMOGRAPHICS",
      "display" : "ADDITIONAL_DEMOGRAPHICS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        }
      ]
    },
    {
      "code" : "ADJUSTMENT_PAYEE",
      "display" : "ADJUSTMENT_PAYEE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E15"
        }
      ]
    },
    {
      "code" : "ADMINISTRATION",
      "display" : "ADMINISTRATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        }
      ]
    },
    {
      "code" : "ADVERSE_REACTION_GROUP",
      "display" : "ADVERSE_REACTION_GROUP",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A60"
        }
      ]
    },
    {
      "code" : "ALLERGY",
      "display" : "ALLERGY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "ANTI-MICROBIAL_DEVICE_CYCLE_DA",
      "display" : "ANTI-MICROBIAL_DEVICE_CYCLE_DA",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SDR_S32"
        }
      ]
    },
    {
      "code" : "ANTI-MICROBIAL_DEVICE_DATA",
      "display" : "ANTI-MICROBIAL_DEVICE_DATA",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SDR_S31"
        }
      ]
    },
    {
      "code" : "APPOINTMENT_HISTORY",
      "display" : "APPOINTMENT_HISTORY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "APP_STATS",
      "display" : "APP_STATS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMD_N02"
        }
      ]
    },
    {
      "code" : "APP_STATUS",
      "display" : "APP_STATUS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMD_N02"
        }
      ]
    },
    {
      "code" : "ASSOCIATED_OBSERVATION",
      "display" : "ASSOCIATED_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "ASSOCIATED_PERSON",
      "display" : "ASSOCIATED_PERSON",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "ASSOCIATED_RX_ADMIN",
      "display" : "ASSOCIATED_RX_ADMIN",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "ASSOCIATED_RX_ORDER",
      "display" : "ASSOCIATED_RX_ORDER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "AUTHORIZATION",
      "display" : "AUTHORIZATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        }
      ]
    },
    {
      "code" : "AUTHORIZATION_CONTACT",
      "display" : "AUTHORIZATION_CONTACT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AUTHORIZATION_CONTACT2",
      "display" : "AUTHORIZATION_CONTACT2",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        }
      ]
    },
    {
      "code" : "AUTHORIZATION_INFO",
      "display" : "AUTHORIZATION_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_E22"
        }
      ]
    },
    {
      "code" : "AUTHORIZATION_REQUEST",
      "display" : "AUTHORIZATION_REQUEST",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E21"
        }
      ]
    },
    {
      "code" : "AUTHORIZATION_RESPONSE_INFO",
      "display" : "AUTHORIZATION_RESPONSE_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E24"
        }
      ]
    },
    {
      "code" : "BLOOD_UNIT",
      "display" : "BLOOD_UNIT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DPR_O48"
        }
      ]
    },
    {
      "code" : "CERTIFICATE",
      "display" : "CERTIFICATE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PMU_B07"
        }
      ]
    },
    {
      "code" : "CHOICE",
      "display" : "CHOICE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "CLINICAL_HISTORY",
      "display" : "CLINICAL_HISTORY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "CLINICAL_HISTORY_DETAIL",
      "display" : "CLINICAL_HISTORY_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "CLINICAL_HISTORY_OBJECT",
      "display" : "CLINICAL_HISTORY_OBJECT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "CLINICAL_HISTORY_OBSERVATION",
      "display" : "CLINICAL_HISTORY_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "CLINICAL_ORDER",
      "display" : "CLINICAL_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        }
      ]
    },
    {
      "code" : "CLINICAL_ORDER_DETAIL",
      "display" : "CLINICAL_ORDER_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        }
      ]
    },
    {
      "code" : "CLINICAL_ORDER_OBJECT",
      "display" : "CLINICAL_ORDER_OBJECT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        }
      ]
    },
    {
      "code" : "CLINICAL_ORDER_OBSERVATION",
      "display" : "CLINICAL_ORDER_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        }
      ]
    },
    {
      "code" : "CLINICAL_ORDER_TIMING",
      "display" : "CLINICAL_ORDER_TIMING",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        }
      ]
    },
    {
      "code" : "CLOCK",
      "display" : "CLOCK",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMD_N02"
        }
      ]
    },
    {
      "code" : "CLOCK_AND_STATISTICS",
      "display" : "CLOCK_AND_STATISTICS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CLOCK_AND_STATS_WITH_NOTES",
      "display" : "CLOCK_AND_STATS_WITH_NOTES",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMD_N02"
        }
      ]
    },
    {
      "code" : "CLOCK_AND_STATS_WITH_NOTES_ALT",
      "display" : "CLOCK_AND_STATS_WITH_NOTES_ALT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7.1"
        }
      ]
    },
    {
      "code" : "COMMAND",
      "display" : "COMMAND",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EAC_U07"
        }
      ]
    },
    {
      "code" : "COMMAND_RESPONSE",
      "display" : "COMMAND_RESPONSE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EAR_U08"
        }
      ]
    },
    {
      "code" : "COMMON_ORDER",
      "display" : "COMMON_ORDER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        }
      ]
    },
    {
      "code" : "COMPONENT",
      "display" : "COMPONENT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "COMPONENTS",
      "display" : "COMPONENTS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        }
      ]
    },
    {
      "code" : "CONTAINER",
      "display" : "CONTAINER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        }
      ]
    },
    {
      "code" : "CONTAINER_OBSERVATION",
      "display" : "CONTAINER_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        }
      ]
    },
    {
      "code" : "DEFINITION",
      "display" : "DEFINITION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        }
      ]
    },
    {
      "code" : "DIAGNOSIS",
      "display" : "DIAGNOSIS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E20"
        }
      ]
    },
    {
      "code" : "DIET",
      "display" : "DIET",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        }
      ]
    },
    {
      "code" : "DISPENSE",
      "display" : "DISPENSE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        }
      ]
    },
    {
      "code" : "DONATION",
      "display" : "DONATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DPR_O48"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_O34"
        }
      ]
    },
    {
      "code" : "DONATION_OBSERVATION",
      "display" : "DONATION_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DEO_O45"
        }
      ]
    },
    {
      "code" : "DONATION_ORDER",
      "display" : "DONATION_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DEO_O45"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DER_O44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DPR_O48"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DRC_O47"
        }
      ]
    },
    {
      "code" : "DONOR",
      "display" : "DONOR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DBC_O41"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DBC_O42"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DEL_O46"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DEO_O45"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DER_O44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DPR_O48"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DRC_O47"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DRG_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_O34"
        }
      ]
    },
    {
      "code" : "DONOR_REGISTRATION",
      "display" : "DONOR_REGISTRATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DEL_O46"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DEO_O45"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DER_O44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DPR_O48"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DRC_O47"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DRG_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_O34"
        }
      ]
    },
    {
      "code" : "ENCODED_ORDER",
      "display" : "ENCODED_ORDER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        }
      ]
    },
    {
      "code" : "ENCODING",
      "display" : "ENCODING",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        }
      ]
    },
    {
      "code" : "EXPERIENCE",
      "display" : "EXPERIENCE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "FINANCIAL",
      "display" : "FINANCIAL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_COMMON_ORDER",
      "display" : "FINANCIAL_COMMON_ORDER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_INSURANCE",
      "display" : "FINANCIAL_INSURANCE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_OBSERVATION",
      "display" : "FINANCIAL_OBSERVATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_ORDER",
      "display" : "FINANCIAL_ORDER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_PROCEDURE",
      "display" : "FINANCIAL_PROCEDURE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_TIMING_QUANTITY",
      "display" : "FINANCIAL_TIMING_QUANTITY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "GENERAL_RESOURCE",
      "display" : "GENERAL_RESOURCE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "GIVE",
      "display" : "GIVE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        }
      ]
    },
    {
      "code" : "GOAL",
      "display" : "GOAL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "GOAL_OBSERVATION",
      "display" : "GOAL_OBSERVATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "GOAL_PATHWAY",
      "display" : "GOAL_PATHWAY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "GOAL_ROLE",
      "display" : "GOAL_ROLE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "GUARANTOR",
      "display" : "GUARANTOR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        }
      ]
    },
    {
      "code" : "GUARANTOR_INSURANCE",
      "display" : "GUARANTOR_INSURANCE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        }
      ]
    },
    {
      "code" : "INSURANCE",
      "display" : "INSURANCE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMB_O27"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMI_O23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXU_V04"
        }
      ]
    },
    {
      "code" : "INVOICE_INFORMATION_CANCEL",
      "display" : "INVOICE_INFORMATION_CANCEL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E02"
        }
      ]
    },
    {
      "code" : "INVOICE_INFORMATION_SUBMIT",
      "display" : "INVOICE_INFORMATION_SUBMIT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E01"
        }
      ]
    },
    {
      "code" : "INVOICE_PROCESSING_RESULTS_INF",
      "display" : "INVOICE_PROCESSING_RESULTS_INF",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E10"
        }
      ]
    },
    {
      "code" : "LOCATION_RESOURCE",
      "display" : "LOCATION_RESOURCE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "MATERIAL_ITEM_RECORD",
      "display" : "MATERIAL_ITEM_RECORD",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M16"
        }
      ]
    },
    {
      "code" : "MATERIAL_LOCATION",
      "display" : "MATERIAL_LOCATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M16"
        }
      ]
    },
    {
      "code" : "MEDICATION_ADMINISTRATION_DETA",
      "display" : "MEDICATION_ADMINISTRATION_DETA",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "MEDICATION_ADMINISTRATION_OBSE",
      "display" : "MEDICATION_ADMINISTRATION_OBSE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "MEDICATION_ENCODING_DETAIL",
      "display" : "MEDICATION_ENCODING_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "MEDICATION_ENCODING_OBSERVATIO",
      "display" : "MEDICATION_ENCODING_OBSERVATIO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "MEDICATION_HISTORY",
      "display" : "MEDICATION_HISTORY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "MEDICATION_ORDER_DETAIL",
      "display" : "MEDICATION_ORDER_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "MEDICATION_ORDER_OBSERVATION",
      "display" : "MEDICATION_ORDER_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "MERGE_INFO",
      "display" : "MERGE_INFO",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A45"
        }
      ]
    },
    {
      "code" : "MF",
      "display" : "MF",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MF_CDM",
      "display" : "MF_CDM",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M04"
        }
      ]
    },
    {
      "code" : "MF_CLIN_STUDY",
      "display" : "MF_CLIN_STUDY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M06"
        }
      ]
    },
    {
      "code" : "MF_CLIN_STUDY_SCHED",
      "display" : "MF_CLIN_STUDY_SCHED",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M07"
        }
      ]
    },
    {
      "code" : "MF_DRG",
      "display" : "MF_DRG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M17"
        }
      ]
    },
    {
      "code" : "MF_INV_ITEM",
      "display" : "MF_INV_ITEM",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M15"
        }
      ]
    },
    {
      "code" : "MF_LOCATION",
      "display" : "MF_LOCATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M05"
        }
      ]
    },
    {
      "code" : "MF_LOC_DEPT",
      "display" : "MF_LOC_DEPT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M05"
        }
      ]
    },
    {
      "code" : "MF_OBS_ATTRIBUTES",
      "display" : "MF_OBS_ATTRIBUTES",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M12"
        }
      ]
    },
    {
      "code" : "MF_OBS_OTHER_ATTRIBUTES",
      "display" : "MF_OBS_OTHER_ATTRIBUTES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M12"
        }
      ]
    },
    {
      "code" : "MF_PHASE_SCHED_DETAIL",
      "display" : "MF_PHASE_SCHED_DETAIL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M06"
        }
      ]
    },
    {
      "code" : "MF_QUERY",
      "display" : "MF_QUERY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MF_SITE_DEFINED",
      "display" : "MF_SITE_DEFINED",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_Znn"
        }
      ]
    },
    {
      "code" : "MF_STAFF",
      "display" : "MF_STAFF",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M02"
        }
      ]
    },
    {
      "code" : "MF_TEST",
      "display" : "MF_TEST",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MF_TEST_BATTERIES",
      "display" : "MF_TEST_BATTERIES",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M10"
        }
      ]
    },
    {
      "code" : "MF_TEST_BATT_DETAIL",
      "display" : "MF_TEST_BATT_DETAIL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M10"
        }
      ]
    },
    {
      "code" : "MF_TEST_CALCULATED",
      "display" : "MF_TEST_CALCULATED",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M11"
        }
      ]
    },
    {
      "code" : "MF_TEST_CALC_DETAIL",
      "display" : "MF_TEST_CALC_DETAIL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M11"
        }
      ]
    },
    {
      "code" : "MF_TEST_CATEGORICAL",
      "display" : "MF_TEST_CATEGORICAL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M09"
        }
      ]
    },
    {
      "code" : "MF_TEST_CAT_DETAIL",
      "display" : "MF_TEST_CAT_DETAIL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M09"
        }
      ]
    },
    {
      "code" : "MF_TEST_NUMERIC",
      "display" : "MF_TEST_NUMERIC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M08"
        }
      ]
    },
    {
      "code" : "NK1_TIMING_QTY",
      "display" : "NK1_TIMING_QTY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "NOTIFICATION",
      "display" : "NOTIFICATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EAN_U09"
        }
      ]
    },
    {
      "code" : "OBSERVATION",
      "display" : "OBSERVATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMB_O27"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMI_O23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R30"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXU_V04"
        }
      ]
    },
    {
      "code" : "OBSERVATIONS_ON_PATIENT",
      "display" : "OBSERVATIONS_ON_PATIENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        }
      ]
    },
    {
      "code" : "OBSERVATION_GROUP",
      "display" : "OBSERVATION_GROUP",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        }
      ]
    },
    {
      "code" : "OBSERVATION_PRIOR",
      "display" : "OBSERVATION_PRIOR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        }
      ]
    },
    {
      "code" : "OBSERVATION_REQUEST",
      "display" : "OBSERVATION_REQUEST",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPR_O38"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O34"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O36"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O41"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O42"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        }
      ]
    },
    {
      "code" : "OBSERVATION_RESULT_GROUP",
      "display" : "OBSERVATION_RESULT_GROUP",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        }
      ]
    },
    {
      "code" : "OMSERVATION",
      "display" : "OMSERVATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "ORDER",
      "display" : "ORDER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BPS_O29"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BRP_O30"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BRT_O32"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BTS_O31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMB_O27"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMI_O23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPR_O38"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORB_O28"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORI_O24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O34"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O36"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O41"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O42"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORN_O08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORS_O06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORX_O58"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXU_V04"
        }
      ]
    },
    {
      "code" : "ORDER_CHOICE",
      "display" : "ORDER_CHOICE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ORDER_DETAIL",
      "display" : "ORDER_DETAIL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "ORDER_DETAIL_SUPPLEMENT",
      "display" : "ORDER_DETAIL_SUPPLEMENT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        }
      ]
    },
    {
      "code" : "ORDER_DIET",
      "display" : "ORDER_DIET",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        }
      ]
    },
    {
      "code" : "ORDER_DOCUMENT",
      "display" : "ORDER_DOCUMENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        }
      ]
    },
    {
      "code" : "ORDER_ENCODED",
      "display" : "ORDER_ENCODED",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "ORDER_OBSERVATION",
      "display" : "ORDER_OBSERVATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "ORDER_PRIOR",
      "display" : "ORDER_PRIOR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        }
      ]
    },
    {
      "code" : "ORDER_RELATED_OBSERVATION",
      "display" : "ORDER_RELATED_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        }
      ]
    },
    {
      "code" : "ORDER_STATUS",
      "display" : "ORDER_STATUS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSU_O51"
        }
      ]
    },
    {
      "code" : "ORDER_TRAY",
      "display" : "ORDER_TRAY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        }
      ]
    },
    {
      "code" : "PACKAGE",
      "display" : "PACKAGE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        }
      ]
    },
    {
      "code" : "PACKAGING",
      "display" : "PACKAGING",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M16"
        }
      ]
    },
    {
      "code" : "PATHWAY",
      "display" : "PATHWAY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "PATHWAY_OBSERVATION",
      "display" : "PATHWAY_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "PATHWAY_ROLE",
      "display" : "PATHWAY_ROLE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        }
      ]
    },
    {
      "code" : "PATIENT",
      "display" : "PATIENT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BPS_O29"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BRP_O30"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BTS_O31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMB_O27"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMI_O23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORB_O28"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORI_O24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O41"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O42"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORN_O08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORS_O06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORX_O58"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "PATIENT_INFO",
      "display" : "PATIENT_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E01"
        }
      ]
    },
    {
      "code" : "PATIENT_INFORMATION",
      "display" : "PATIENT_INFORMATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        }
      ]
    },
    {
      "code" : "PATIENT_OBSERVATION",
      "display" : "PATIENT_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R30"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        }
      ]
    },
    {
      "code" : "PATIENT_PRIOR",
      "display" : "PATIENT_PRIOR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        }
      ]
    },
    {
      "code" : "PATIENT_RESULT",
      "display" : "PATIENT_RESULT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        }
      ]
    },
    {
      "code" : "PATIENT_VISIT",
      "display" : "PATIENT_VISIT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BPS_O29"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BTS_O31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMB_O27"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMI_O23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXU_V04"
        }
      ]
    },
    {
      "code" : "PATIENT_VISITS",
      "display" : "PATIENT_VISITS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "PATIENT_VISIT_OBSERVATION",
      "display" : "PATIENT_VISIT_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        }
      ]
    },
    {
      "code" : "PATIENT_VISIT_PRIOR",
      "display" : "PATIENT_VISIT_PRIOR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        }
      ]
    },
    {
      "code" : "PAT_INFO",
      "display" : "PAT_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E20"
        }
      ]
    },
    {
      "code" : "PAYMENT_REMITTANCE_DETAIL_INFO",
      "display" : "PAYMENT_REMITTANCE_DETAIL_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E15"
        }
      ]
    },
    {
      "code" : "PAYMENT_REMITTANCE_HEADER_INFO",
      "display" : "PAYMENT_REMITTANCE_HEADER_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E15"
        }
      ]
    },
    {
      "code" : "PERSONNEL_RESOURCE",
      "display" : "PERSONNEL_RESOURCE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "PERSON_OBSERVATION",
      "display" : "PERSON_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXU_V04"
        }
      ]
    },
    {
      "code" : "PEX_CAUSE",
      "display" : "PEX_CAUSE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "PEX_OBSERVATION",
      "display" : "PEX_OBSERVATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "PHARMACY_TREATMENT_INFUSION_OR",
      "display" : "PHARMACY_TREATMENT_INFUSION_OR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        }
      ]
    },
    {
      "code" : "PRIOR_RESULT",
      "display" : "PRIOR_RESULT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        }
      ]
    },
    {
      "code" : "PROBLEM",
      "display" : "PROBLEM",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "PROBLEM_OBSERVATION",
      "display" : "PROBLEM_OBSERVATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "PROBLEM_PATHWAY",
      "display" : "PROBLEM_PATHWAY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PROBLEM_ROLE",
      "display" : "PROBLEM_ROLE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "PROCEDURE",
      "display" : "PROCEDURE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        }
      ]
    },
    {
      "code" : "PRODUCT",
      "display" : "PRODUCT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BPS_O29"
        }
      ]
    },
    {
      "code" : "PRODUCT_SERVICE_GROUP",
      "display" : "PRODUCT_SERVICE_GROUP",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E15"
        }
      ]
    },
    {
      "code" : "PRODUCT_SERVICE_LINE_INFO",
      "display" : "PRODUCT_SERVICE_LINE_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E10"
        }
      ]
    },
    {
      "code" : "PRODUCT_SERVICE_LINE_ITEM",
      "display" : "PRODUCT_SERVICE_LINE_ITEM",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E01"
        }
      ]
    },
    {
      "code" : "PRODUCT_SERVICE_SECTION",
      "display" : "PRODUCT_SERVICE_SECTION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E15"
        }
      ]
    },
    {
      "code" : "PRODUCT_STATUS",
      "display" : "PRODUCT_STATUS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BTS_O31"
        }
      ]
    },
    {
      "code" : "PROVIDER",
      "display" : "PROVIDER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPL_I02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPR_I03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQP_I04"
        }
      ]
    },
    {
      "code" : "PROVIDER_CONTACT",
      "display" : "PROVIDER_CONTACT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCQ_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        }
      ]
    },
    {
      "code" : "PSG",
      "display" : "PSG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E02"
        }
      ]
    },
    {
      "code" : "PSL_ITEM_INFO",
      "display" : "PSL_ITEM_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_E22"
        }
      ]
    },
    {
      "code" : "PURCHASING_VENDOR",
      "display" : "PURCHASING_VENDOR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M16"
        }
      ]
    },
    {
      "code" : "QBP",
      "display" : "QBP",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QBP_Q11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QVR_Q17"
        }
      ]
    },
    {
      "code" : "QRY_WITH_DETAIL",
      "display" : "QRY_WITH_DETAIL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "QUERY",
      "display" : "QUERY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QBP_E22"
        }
      ]
    },
    {
      "code" : "QUERY_ACK",
      "display" : "QUERY_ACK",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_E22"
        }
      ]
    },
    {
      "code" : "QUERY_ACK_IPR",
      "display" : "QUERY_ACK_IPR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_E03"
        }
      ]
    },
    {
      "code" : "QUERY_INFORMATION",
      "display" : "QUERY_INFORMATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QBP_E03"
        }
      ]
    },
    {
      "code" : "QUERY_RESPONSE",
      "display" : "QUERY_RESPONSE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K32"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        }
      ]
    },
    {
      "code" : "QUERY_RESULT_CLUSTER",
      "display" : "QUERY_RESULT_CLUSTER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "REASSESSMENT_REQUEST_INFO",
      "display" : "REASSESSMENT_REQUEST_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E04"
        }
      ]
    },
    {
      "code" : "REQUEST",
      "display" : "REQUEST",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E13"
        }
      ]
    },
    {
      "code" : "RESOURCE",
      "display" : "RESOURCE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "RESOURCES",
      "display" : "RESOURCES",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "RESOURCE_DETAIL",
      "display" : "RESOURCE_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "RESOURCE_OBJECT",
      "display" : "RESOURCE_OBJECT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "RESOURCE_OBSERVATION",
      "display" : "RESOURCE_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "RESPONSE",
      "display" : "RESPONSE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BRP_O30"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BRT_O32"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EHC_E13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPR_O38"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORB_O28"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORI_O24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O34"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O36"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O41"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O42"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORN_O08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORS_O06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORX_O58"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        }
      ]
    },
    {
      "code" : "RESULT",
      "display" : "RESULT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        }
      ]
    },
    {
      "code" : "RESULTS",
      "display" : "RESULTS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        }
      ]
    },
    {
      "code" : "RESULTS_NOTES",
      "display" : "RESULTS_NOTES",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        }
      ]
    },
    {
      "code" : "ROLE_CLINICAL_HISTORY",
      "display" : "ROLE_CLINICAL_HISTORY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "ROLE_CLINICAL_HISTORY_OBJECT",
      "display" : "ROLE_CLINICAL_HISTORY_OBJECT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "ROLE_GOAL",
      "display" : "ROLE_GOAL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "ROLE_GOAL_OBJECT",
      "display" : "ROLE_GOAL_OBJECT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "ROLE_OBSERVATION",
      "display" : "ROLE_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        }
      ]
    },
    {
      "code" : "ROLE_PATHWAY",
      "display" : "ROLE_PATHWAY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "ROLE_PATHWAY_OBJECT",
      "display" : "ROLE_PATHWAY_OBJECT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "ROLE_PROBLEM",
      "display" : "ROLE_PROBLEM",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "ROLE_PROBLEM_OBJECT",
      "display" : "ROLE_PROBLEM_OBJECT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCI_I22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCM_I21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCR_I16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CCU_I20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CQU_I19"
        }
      ]
    },
    {
      "code" : "ROW_DEFINITION",
      "display" : "ROW_DEFINITION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z84"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RTB_K13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RTB_Z74"
        }
      ]
    },
    {
      "code" : "RX_ADMIN",
      "display" : "RX_ADMIN",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "RX_ADMINISTRATION",
      "display" : "RX_ADMINISTRATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "RX_ORDER",
      "display" : "RX_ORDER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "SCHEDULE",
      "display" : "SCHEDULE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "SEGMENT_PATTERN",
      "display" : "SEGMENT_PATTERN",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K11"
        }
      ]
    },
    {
      "code" : "SERVICE",
      "display" : "SERVICE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "SHIPMENT",
      "display" : "SHIPMENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        }
      ]
    },
    {
      "code" : "SHIPMENT_OBSERVATION",
      "display" : "SHIPMENT_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        }
      ]
    },
    {
      "code" : "SHIPPING_OBSERVATION",
      "display" : "SHIPPING_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        }
      ]
    },
    {
      "code" : "SPECIMEN",
      "display" : "SPECIMEN",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPR_O38"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O34"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O36"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O41"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O42"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SSU_U03"
        }
      ]
    },
    {
      "code" : "SPECIMEN_CONTAINER",
      "display" : "SPECIMEN_CONTAINER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EAC_U07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EAR_U08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O36"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SSR_U04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SSU_U03"
        }
      ]
    },
    {
      "code" : "SPECIMEN_CONTAINER_IN_PACKAGE",
      "display" : "SPECIMEN_CONTAINER_IN_PACKAGE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        }
      ]
    },
    {
      "code" : "SPECIMEN_IN_PACKAGE",
      "display" : "SPECIMEN_IN_PACKAGE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        }
      ]
    },
    {
      "code" : "SPECIMEN_OBSERVATION",
      "display" : "SPECIMEN_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPR_O38"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O34"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O36"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O42"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        }
      ]
    },
    {
      "code" : "SPECIMEN_SHIPMENT",
      "display" : "SPECIMEN_SHIPMENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        }
      ]
    },
    {
      "code" : "STAFF",
      "display" : "STAFF",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K25"
        }
      ]
    },
    {
      "code" : "STERILIZATION",
      "display" : "STERILIZATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M16"
        }
      ]
    },
    {
      "code" : "STUDY",
      "display" : "STUDY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "STUDY_OBSERVATION",
      "display" : "STUDY_OBSERVATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "STUDY_OBSERVATION_ORDER",
      "display" : "STUDY_OBSERVATION_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "STUDY_PHARM",
      "display" : "STUDY_PHARM",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "STUDY_PHASE",
      "display" : "STUDY_PHASE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "STUDY_SCHEDULE",
      "display" : "STUDY_SCHEDULE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "SUBJECT_PERSON_OR_ANIMAL_IDENT",
      "display" : "SUBJECT_PERSON_OR_ANIMAL_IDENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        }
      ]
    },
    {
      "code" : "SUBJECT_POPULATION_OR_LOCATION",
      "display" : "SUBJECT_POPULATION_OR_LOCATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSM_R26"
        }
      ]
    },
    {
      "code" : "TEST_CONFIGURATION",
      "display" : "TEST_CONFIGURATION",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "TCU_U10"
        }
      ]
    },
    {
      "code" : "TIMING",
      "display" : "TIMING",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BPS_O29"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BRP_O30"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BRT_O32"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BTS_O31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMB_O27"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMI_O23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPL_O37"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPR_O38"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORB_O28"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORI_O24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O34"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O36"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O40"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O41"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O42"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O44"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORN_O08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORS_O06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXU_V04"
        }
      ]
    },
    {
      "code" : "TIMING_DIET",
      "display" : "TIMING_DIET",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        }
      ]
    },
    {
      "code" : "TIMING_ENCODED",
      "display" : "TIMING_ENCODED",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K31"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "TIMING_GIVE",
      "display" : "TIMING_GIVE",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        }
      ]
    },
    {
      "code" : "TIMING_PRIOR",
      "display" : "TIMING_PRIOR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O33"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O35"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMQ_O57"
        }
      ]
    },
    {
      "code" : "TIMING_QTY",
      "display" : "TIMING_QTY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OPU_R25"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R30"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "TIMING_QUANTITY",
      "display" : "TIMING_QUANTITY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "TIMING_TRAY",
      "display" : "TIMING_TRAY",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        }
      ]
    },
    {
      "code" : "TREATMENT",
      "display" : "TREATMENT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        }
      ]
    },
    {
      "code" : "VISIT",
      "display" : "VISIT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A60"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R30"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R23"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R24"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        }
      ]
    }
  ]
}

```
