# Mail Claim Party (2.8.1 - 1.0.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mail Claim Party (2.8.1 - 1.0.0)**

## CodeSystem: Mail Claim Party (2.8.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/mailClaimParty | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:MailClaimParty |
| *Other Identifiers:*OID:2.16.840.1.113883.18.61 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify a party to which a claim should be mailed when claims are sent by mail. Used in HL7 Version 2.x messaging in the IN2 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmailClaimParty](ValueSet-hl7VSmailClaimParty.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "mailClaimParty",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0137"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/mailClaimParty",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.61"
    }
  ],
  "version" : "1.0.0",
  "name" : "MailClaimParty",
  "title" : "Mail Claim Party (2.8.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts which specify a party to which a claim should be mailed when claims are sent by mail.  Used in HL7 Version 2.x messaging in the IN2 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "E",
      "display" : "Employer",
      "definition" : "Employer",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arbeitgeber"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "G",
      "display" : "Guarantor",
      "definition" : "Guarantor",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zahlungspflichtiger"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Insurance Company",
      "definition" : "Insurance company",
      "designation" : [
        {
          "language" : "de",
          "value" : "Versicherung / Krankenkasse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "andere"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Patient",
      "definition" : "Patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient / Selbstzahler"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
