# Location Characteristic ID (2.8.1 - 1.0.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Location Characteristic ID (2.8.1 - 1.0.0)**

## CodeSystem: Location Characteristic ID (2.8.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/locationCharacteristic | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:LocationCharacteristic |
| *Other Identifiers:*OID:2.16.840.1.113883.18.197 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying an identifier code to show which characteristic is being communicated with the segment. Used in HL7 Version 2.x messaging in the Location Characteristic (LCH) segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSlocationCharacteristicId](ValueSet-hl7VSlocationCharacteristicId.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "locationCharacteristic",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0324"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/locationCharacteristic",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.197"
    }
  ],
  "version" : "1.0.0",
  "name" : "LocationCharacteristic",
  "title" : "Location Characteristic ID (2.8.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying an identifier code to show which characteristic is being communicated with the segment.  Used in HL7 Version 2.x messaging in the Location Characteristic (LCH) segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "GEN",
      "display" : "Gender of patient(s)",
      "definition" : "Gender of patient(s)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IMP",
      "display" : "Implant: can be used for radiation implant patients",
      "definition" : "Implant: can be used for radiation implant patients",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "INF",
      "display" : "Infectious disease: this location can be used for isolation",
      "definition" : "Infectious disease: this location can be used for isolation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LCR",
      "display" : "Level of care",
      "definition" : "Level of care",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LIC",
      "display" : "Licensed",
      "definition" : "Licensed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OVR",
      "display" : "Overflow",
      "definition" : "Overflow",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PRL",
      "display" : "Privacy level: indicating the level of private versus non-private room",
      "definition" : "Privacy level: indicating the level of private versus non-private room",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SET",
      "display" : "Bed is set up",
      "definition" : "Bed is set up",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SHA",
      "display" : "Shadow: a temporary holding location that does not physically exist",
      "definition" : "Shadow: a temporary holding location that does not physically exist",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SMK",
      "display" : "Smoking",
      "definition" : "Smoking",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "STF",
      "display" : "Bed is staffed",
      "definition" : "Bed is staffed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TEA",
      "display" : "Teaching location",
      "definition" : "Teaching location",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
