# Intended Procedure Type (2.8.1 - 1.0.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Intended Procedure Type (2.8.1 - 1.0.0)**

## CodeSystem: Intended Procedure Type (2.8.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/intendedProcedureType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:IntendedProcedureType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.434 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the type of intended procedure. Used in HL7 Version 2.x messaging in the DON segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSintendedProcedureType](ValueSet-hl7VSintendedProcedureType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "intendedProcedureType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0933"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/intendedProcedureType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.434"
    }
  ],
  "version" : "1.0.0",
  "name" : "IntendedProcedureType",
  "title" : "Intended Procedure Type (2.8.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the type of intended procedure.  Used in HL7 Version 2.x messaging in the DON segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "2RC",
      "display" : "Double Red Cells",
      "definition" : "Double Red Cells",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GRN",
      "display" : "Granulocytes",
      "definition" : "Granulocytes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "HEM",
      "display" : "Hemachromatosis",
      "definition" : "Hemachromatosis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "HPC",
      "display" : "Hematopoietic Progenitor Cells",
      "definition" : "Hematopoietic Progenitor Cells",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Stem Cells and other cells classified as Hematopoietic"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "LYM",
      "display" : "Lymphocytes",
      "definition" : "Lymphocytes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "PLS",
      "display" : "Plasma",
      "definition" : "Plasma",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "PLT",
      "display" : "Platelets",
      "definition" : "Platelets",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "PNP",
      "display" : "Platelets and Plasma",
      "definition" : "Platelets and Plasma",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "PNR",
      "display" : "Platelets and Red Cells",
      "definition" : "Platelets and Red Cells",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "PPR",
      "display" : "Platelets, Plasma, and Red Cells",
      "definition" : "Platelets, Plasma, and Red Cells",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "THA",
      "display" : "Therapeutic Apheresis",
      "definition" : "Therapeutic Apheresis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "THW",
      "display" : "Therapeutic Whole Blood",
      "definition" : "Therapeutic Whole Blood",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "WBL",
      "display" : "Whole Blood",
      "definition" : "Whole Blood",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    }
  ]
}

```
