# Date Format (2.8.1 - 1.0.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Date Format (2.8.1 - 1.0.0)**

## CodeSystem: Date Format (2.8.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/dateFormat | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:DateFormat |
| *Other Identifiers:*OID:2.16.840.1.113883.18.381 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts that identify the date format for a decontamination/sterilization instance. Used in HL7 Version 2.x messaging in the SCP segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSdateFormat](ValueSet-hl7VSdateFormat.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "dateFormat",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0653"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/dateFormat",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.381"
    }
  ],
  "version" : "1.0.0",
  "name" : "DateFormat",
  "title" : "Date Format (2.8.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts that identify the date format for a decontamination/sterilization instance. Used in HL7 Version 2.x messaging in the SCP segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "1",
      "display" : "mm/dd/yy",
      "definition" : "mm/dd/yy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "USA standard"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "yy.mm.dd",
      "definition" : "yy.mm.dd",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "ANSI standard"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "3",
      "display" : "dd/mm/yy",
      "definition" : "dd/mm/yy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Britain/France standard"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "4",
      "display" : "dd.mm.yy",
      "definition" : "dd.mm.yy",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Germany standard"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "5",
      "display" : "yy/mm/dd",
      "definition" : "yy/mm/dd",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Japan standard"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "6",
      "display" : "Yymmdd",
      "definition" : "Yymmdd",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "ISO standard"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
