# Telecommunication Use Code (2.8.1 - 1.2.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Telecommunication Use Code (2.8.1 - 1.2.0)**

## CodeSystem: Telecommunication Use Code (2.8.1 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/telecommunicationUse | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:TelecommunicationUse |
| *Other Identifiers:*OID:2.16.840.1.113883.18.106 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts for specifying a specific use of a telecommunication number. Best practice is to use this concept whenever a telecommunication number or access string is specified. Used in HL7 Version 2.x messaging in the XTN segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStelecommunicationUseCode](ValueSet-hl7VStelecommunicationUseCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "telecommunicationUse",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0201"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/telecommunicationUse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.106"
    }
  ],
  "version" : "1.2.0",
  "name" : "TelecommunicationUse",
  "title" : "Telecommunication Use Code (2.8.1 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts for specifying a specific use of a telecommunication number.  Best practice is to use this concept whenever a telecommunication number or access string is specified.  Used in HL7 Version 2.x messaging in the XTN segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ASN",
      "display" : "Answering Service Number",
      "definition" : "Answering Service Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsdienst"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BPN",
      "display" : "Beeper Number",
      "definition" : "Beeper Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Pagernummer (Cityruf o.ä.)"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Retained for backward compatibility as of v 2.6"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "EMR",
      "display" : "Emergency Number",
      "definition" : "Emergency Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Notfallnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NET",
      "display" : "Network (email) Address",
      "definition" : "Network (email) Address",
      "designation" : [
        {
          "language" : "de",
          "value" : "Netzwerkadresse (E-Mail)"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Retained for backward compatibility as of v 2.6"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ORN",
      "display" : "Other Residence Number",
      "definition" : "Other Residence Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nebenwohnsitznummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PRN",
      "display" : "Primary Residence Number",
      "definition" : "Primary Residence Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hauptwohnsitznummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PRS",
      "display" : "Personal",
      "definition" : "Personal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Not tied to a location or role"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "VHN",
      "display" : "Vacation Home Number",
      "definition" : "Vacation Home Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ferienwohnsitznummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "WPN",
      "display" : "Work Number",
      "definition" : "Work Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Dienstnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
