# Risk Codes (2.8.1 - 1.0.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Codes (2.8.1 - 1.0.0)**

## CodeSystem: Risk Codes (2.8.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/risks | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Risks |
| *Other Identifiers:*OID:2.16.840.1.113883.18.313 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient. Used in HL7 Version 2.x messaging in the SPM and PAC segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSriskCodes](ValueSet-hl7VSriskCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "risks",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0489"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/risks",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.313"
    }
  ],
  "version" : "1.0.0",
  "name" : "Risks",
  "title" : "Risk Codes (2.8.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient.  Used in HL7 Version 2.x messaging in the SPM and PAC segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AGG",
      "display" : "Aggressive",
      "definition" : "Aggressive",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "A danger that can be associated with certain living subjects, including humans."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BHZ",
      "display" : "Biohazard",
      "definition" : "Biohazard",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Material contains microorganisms that are an environmental hazard.  Must be handled with special care."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BIO",
      "display" : "Biological",
      "definition" : "Biological",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The dangers associated with normal biological materials. I.e. potential risk of unknown infections.  Routine biological materials from living subjects."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COR",
      "display" : "Corrosive",
      "definition" : "Corrosive",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Material is corrosive and may cause severe injury to skin, mucous membranes and eyes. Avoid any unprotected contact."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ESC",
      "display" : "Escape Risk",
      "definition" : "Escape Risk",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The entity is at risk for escaping from containment or control."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EXP",
      "display" : "Explosive",
      "definition" : "Explosive",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Material is an explosive mixture.  Keep away from fire, sparks, and heat."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "IFL",
      "display" : "MaterialDangerInflammable",
      "definition" : "MaterialDangerInflammable",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Material is highly inflammable and in certain mixtures (with air) may lead to explosions.  Keep away from fire, sparks and excessive heat."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INF",
      "display" : "MaterialDangerInfectious",
      "definition" : "MaterialDangerInfectious",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Material known to be infectious with human pathogenic microorganisms.  Those who handle this material must take precautions for their protection."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INJ",
      "display" : "Injury Hazard",
      "definition" : "Injury Hazard",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Material is solid and sharp (e.g., cannulas.)  Dispose in hard container."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "POI",
      "display" : "Poison",
      "definition" : "Poison",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Material is poisonous to humans and/or animals.  Special care must be taken to avoid incorporation, even of small amounts."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RAD",
      "display" : "Radioactive",
      "definition" : "Radioactive",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Material is a source for ionizing radiation and must be handled with special care to avoid injury of those who handle it and to avoid environmental hazards."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
