# Reimbursement Type Code (2.8.1 - 1.0.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Reimbursement Type Code (2.8.1 - 1.0.0)**

## CodeSystem: Reimbursement Type Code (2.8.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/reimbursementType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ReimbursementType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.299 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the fee schedule reimbursement type applied to the line item. Used in HL7 Version 2.x messaging in the GP2 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSreimbursementTypeCode](ValueSet-hl7VSreimbursementTypeCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "reimbursementType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0470"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/reimbursementType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.299"
    }
  ],
  "version" : "1.0.0",
  "name" : "ReimbursementType",
  "title" : "Reimbursement Type Code (2.8.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the fee schedule reimbursement type applied to the line item.  Used in HL7 Version 2.x messaging in the GP2 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "Crnl",
      "display" : "Corneal Tissue APC",
      "definition" : "Corneal Tissue APC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DME",
      "display" : "Durable Medical Equipment",
      "definition" : "Durable Medical Equipment",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "EPO",
      "display" : "Epotein",
      "definition" : "Epotein",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Lab",
      "display" : "Clinical Laboratory APC",
      "definition" : "Clinical Laboratory APC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Mamm",
      "display" : "Screening Mammography APC",
      "definition" : "Screening Mammography APC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NoPay",
      "display" : "This APC is not paid",
      "definition" : "This APC is not paid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OPPS",
      "display" : "Outpatient Prospective Payment System",
      "definition" : "Outpatient Prospective Payment System",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PartH",
      "display" : "Partial Hospitalization APC",
      "definition" : "Partial Hospitalization APC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Pckg",
      "display" : "Packaged APC",
      "definition" : "Packaged APC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "Thrpy",
      "display" : "Therapy APC",
      "definition" : "Therapy APC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
