# Filler Status Codes (2.8.1 - 1.2.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Filler Status Codes (2.8.1 - 1.2.0)**

## CodeSystem: Filler Status Codes (2.8.1 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/fillerStatus | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:FillerStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.171 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to describe an appointment status from the perspective of the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the SCH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSfillerStatusCodes](ValueSet-hl7VSfillerStatusCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "fillerStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0278"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/fillerStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.171"
    }
  ],
  "version" : "1.2.0",
  "name" : "FillerStatus",
  "title" : "Filler Status Codes (2.8.1 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to describe an appointment status from the perspective of the entity assigned to fulfill the appointment.  Used in HL7 Version 2.x messaging in the SCH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : false,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "Blocked",
      "display" : "Blocked",
      "definition" : "The indicated time slot(s) is(are) blocked",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Booked",
      "display" : "Booked",
      "definition" : "The indicated appointment is booked",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Cancelled",
      "display" : "Cancelled",
      "definition" : "The indicated appointment was stopped from occurring (canceled prior to starting)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Complete",
      "display" : "Complete",
      "definition" : "The indicated appointment has completed normally (was not discontinued, canceled, or deleted)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Deleted",
      "display" : "Deleted",
      "definition" : "The indicated appointment was deleted from the filler application",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Discontinued",
      "display" : "Discontinued",
      "definition" : "The indicated appointment was discontinued (DC'ed while in progress, discontinued parent appointment, or discontinued child appointment)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-10"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "Noshow",
      "display" : "Noshow",
      "definition" : "The patient did not show up for the appointment",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "Overbook",
      "display" : "Overbook",
      "definition" : "The appointment has been confirmed; however it is confirmed in an overbooked state",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Pending",
      "display" : "Pending",
      "definition" : "Appointment has not yet been confirmed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Started",
      "display" : "Started",
      "definition" : "The indicated appointment has begun and is currently in progress",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "Waitlist",
      "display" : "Waitlist",
      "definition" : "Appointment has been placed on a waiting list for a particular slot, or set of slots",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
