# Check Digit Scheme (2.8.1 - 1.3.0) - HL7 v2.8.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Check Digit Scheme (2.8.1 - 1.3.0)**

## CodeSystem: Check Digit Scheme (2.8.1 - 1.3.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/checkDigitScheme | *Version*:1.3.0 |
| Active as of 2026-01-27 | *Computable Name*:CheckDigitScheme |
| *Other Identifiers:*OID:2.16.840.1.113883.18.22 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the check digit scheme employed. Used in HL7 Version 2.x messaging in PPN, XCN and XON segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScheckDigitScheme](ValueSet-hl7VScheckDigitScheme.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "checkDigitScheme",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0061"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/checkDigitScheme",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.22"
    }
  ],
  "version" : "1.3.0",
  "name" : "CheckDigitScheme",
  "title" : "Check Digit Scheme (2.8.1 - 1.3.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:45:38+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the check digit scheme employed.   Used in HL7 Version 2.x messaging in PPN, XCN and XON segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "BCV",
      "display" : "Bank Card Validation Number",
      "definition" : "Bank Card Validation Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "A non-embossed number included on bank cards and used to validate authenticity of the card and the person presenting the card"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "ISO",
      "display" : "ISO 7064: 1983",
      "definition" : "ISO 7064: 1983",
      "designation" : [
        {
          "language" : "de",
          "value" : "ISO 7064: 1983"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "M10",
      "display" : "Mod 10 algorithm",
      "definition" : "Mod 10 algorithm",
      "designation" : [
        {
          "language" : "de",
          "value" : "Modulo10-Verfahren"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "M11",
      "display" : "Mod 11 algorithm",
      "definition" : "Mod 11 algorithm",
      "designation" : [
        {
          "language" : "de",
          "value" : "Modulo11-Verfahren"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "NPI",
      "display" : "Check digit algorithm in the US National Provider Identifier",
      "definition" : "Check digit algorithm in the US National Provider Identifier",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
