# Downloads - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

You can also download:

* [this entire guide](full-ig.zip),

The expanded value sets can be found:

* [Expansion in XML](expansions.xml.zip)
* [Expansion in JSON](expansions.json.zip)

The source code for this Implementation Guide will be found shortly on [IHE GitHub](https://github.com/IHE/ITI.PDQm)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.v2.uv.terminology.v28.r4)](package.r4.tgz) and [R4B (hl7.v2.uv.terminology.v28.r4b)](package.r4b.tgz) are available.

#### Dependency Table



#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* HL7 Inc., 2026

* [Manufacturers of Vaccines (code=MVX) (2.8 - 1.3.0)](CodeSystem-PH_ManufacturersOfVaccinesMVX_CDC_NIP.md): [PHVS_ManufacturersOfVaccinesMVX_CDC_NIP](ValueSet-PHVS_ManufacturersOfVaccinesMVX_CDC_NIP.md)
* [Vaccines Administered (2.8 - 1.5.0)](CodeSystem-PH_VaccinesAdministeredCVX_CDC_NIP.md): [PHVS_VaccinesAdministeredCVX_CDC_NIP](ValueSet-PHVS_VaccinesAdministeredCVX_CDC_NIP.md)
* [Accept/Application Acknowledgment Conditions (2.8 - 1.0.0)](CodeSystem-accept-applicationAcknowledgmentConditions.md): [Hl7VSaccept-applicationAcknowledgmentConditions](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md)
* [Access Restriction Reason Code (2.8 - 1.0.0)](CodeSystem-accessRestrictionReason.md): [Hl7VSaccessRestrictionReasonCode](ValueSet-hl7VSaccessRestrictionReasonCode.md)
* [Access Restriction Value (2.8 - 1.0.0)](CodeSystem-accessRestrictionValue.md): [Hl7VSaccessRestrictionValue](ValueSet-hl7VSaccessRestrictionValue.md)
* [Acknowledgment Code (2.8 - 1.2.0)](CodeSystem-acknowledgmentCodes.md): [Hl7VSacknowledgmentCode](ValueSet-hl7VSacknowledgmentCode.md)
* [Action Taken in Response to the Event (2.8 - 1.0.0)](CodeSystem-actionTakenInResponseToTheEvent.md): [Hl7VSactionTakenInResponseToTheEvent](ValueSet-hl7VSactionTakenInResponseToTheEvent.md)
* [Active/Inactive (2.8 - 1.0.0)](CodeSystem-active-inactive.md): [Hl7VSactive-inactive](ValueSet-hl7VSactive-inactive.md)
* [ActPriority (2.8 - 1.0.0)](CodeSystem-actpriority.md): [Hl7VSactpriority](ValueSet-hl7VSactpriority.md)
* [Additive/Preservative (2.8 - 2.0.0)](CodeSystem-additivePreservative.md): [Hl7VSadditivePreservative](ValueSet-hl7VSadditivePreservative.md)
* [Address Expiration Reason (2.8 - 1.0.0)](CodeSystem-addressExpirationReason.md): [Hl7VSaddressExpirationReason](ValueSet-hl7VSaddressExpirationReason.md)
* [Address Type (2.8 - 1.5.0)](CodeSystem-addressType.md): [Hl7VSaddressType](ValueSet-hl7VSaddressType.md)
* [Address Usage (2.8 - 1.0.0)](CodeSystem-addressUsage.md): [Hl7VSaddressUsage](ValueSet-hl7VSaddressUsage.md)
* [Adjustment Action (2.8 - 1.0.0)](CodeSystem-adjustmentAction.md): [Hl7VSadjustmentAction](ValueSet-hl7VSadjustmentAction.md)
* [Adjustment Category Code (2.8 - 1.0.0)](CodeSystem-adjustmentCategory.md): [Hl7VSadjustmentCategoryCode](ValueSet-hl7VSadjustmentCategoryCode.md)
* [Administration Device (2.8 - 1.0.0)](CodeSystem-administrationDevice.md): [Hl7VSadministrationDevice](ValueSet-hl7VSadministrationDevice.md)
* [Administration Method (2.8 - 1.0.0)](CodeSystem-administrationMethod.md): [Hl7VSadministrationMethod](ValueSet-hl7VSadministrationMethod.md)
* [Administrative Sex (2.8 - 1.0.0)](CodeSystem-administrativeSex.md): [Hl7VSadministrativeSex](ValueSet-hl7VSadministrativeSex.md)
* [Admission Level of Care Code (2.8 - 1.0.0)](CodeSystem-admissionLevelOfCare.md): [Hl7VSadmissionLevelOfCareCode](ValueSet-hl7VSadmissionLevelOfCareCode.md)
* [Admission Type (2.8 - 1.1.0)](CodeSystem-admissionType.md): [Hl7VSadmissionType](ValueSet-hl7VSadmissionType.md)
* [Advanced Beneficiary Notice Code (2.8 - 1.0.0)](CodeSystem-advancedBeneficiaryNotice.md): [Hl7VSadvancedBeneficiaryNoticeCode](ValueSet-hl7VSadvancedBeneficiaryNoticeCode.md)
* [Alert Device Code (2.8 - 1.0.0)](CodeSystem-alertDevice.md): [Hl7VSalertDeviceCode](ValueSet-hl7VSalertDeviceCode.md)
* [Alert Level (2.8 - 1.0.0)](CodeSystem-alertLevel.md): [Hl7VSalertLevel](ValueSet-hl7VSalertLevel.md)
* [Allergen Type (2.8 - 1.1.0)](CodeSystem-allergenType.md): [Hl7VSallergyType](ValueSet-hl7VSallergyType.md)
* [Allergy Clinical Status (2.8 - 1.0.0)](CodeSystem-allergyClinicalStatus.md): [Hl7VSallergyClinicalStatus](ValueSet-hl7VSallergyClinicalStatus.md)
* [Allergy Severity (2.8 - 1.1.0)](CodeSystem-allergySeverity.md): [Hl7VSallergySeverity](ValueSet-hl7VSallergySeverity.md)
* [Allow Substitution Codes (2.8 - 1.1.0)](CodeSystem-allowSubstitution.md): [Hl7VSallowSubstitution](ValueSet-hl7VSallowSubstitution.md) and [Hl7VSallowSubstitutionCodes](ValueSet-hl7VSallowSubstitutionCodes.md)
* [Alternate Character Set Handling Scheme (2.8 - 1.1.0)](CodeSystem-alternateCharacterSetHandlingScheme.md): [Hl7VSalternateCharacterSetHandlingScheme](ValueSet-hl7VSalternateCharacterSetHandlingScheme.md)
* [Alternate Character Sets (2.8 - 1.4.0)](CodeSystem-alternateCharacterSets.md): [Hl7VSalternateCharacterSets](ValueSet-hl7VSalternateCharacterSets.md)
* [Ambulatory Payment Classification Code (2.8 - 1.0.0)](CodeSystem-ambulatoryPaymentClassification.md): [Hl7VSambulatoryPaymentClassificationCode](ValueSet-hl7VSambulatoryPaymentClassificationCode.md)
* [Ambulatory Status (2.8 - 1.0.0)](CodeSystem-ambulatoryStatus.md): [Hl7VSambulatoryStatus](ValueSet-hl7VSambulatoryStatus.md)
* [Amount Class (2.8 - 1.0.0)](CodeSystem-amountClass.md): [Hl7VSamountClass](ValueSet-hl7VSamountClass.md)
* [Amount Type (2.8 - 1.0.0)](CodeSystem-amountType.md): [Hl7VSamountType](ValueSet-hl7VSamountType.md)
* [Analyte Repeat Status (2.8 - 1.0.0)](CodeSystem-analyteRepeatStatus.md): [Hl7VSanalyteRepeatStatus](ValueSet-hl7VSanalyteRepeatStatus.md)
* [Annotations (2.8 - 1.0.0)](CodeSystem-annotations.md): [Hl7VSannotations](ValueSet-hl7VSannotations.md)
* [Appointment Reason Codes (2.8 - 1.0.0)](CodeSystem-appointmentReason.md): [Hl7VSappointmentReasonCodes](ValueSet-hl7VSappointmentReasonCodes.md)
* [Appointment Type Codes (2.8 - 1.0.0)](CodeSystem-appointmentType.md): [Hl7VSappointmentTypeCodes](ValueSet-hl7VSappointmentTypeCodes.md)
* [Arm Stick (2.8 - 1.0.0)](CodeSystem-armStick.md): [Hl7VSarmStick](ValueSet-hl7VSarmStick.md)
* [Mode of Arrival Code (2.8 - 1.0.0)](CodeSystem-arrivalMode.md): [Hl7VSmodeOfArrivalCode](ValueSet-hl7VSmodeOfArrivalCode.md)
* [Artificial Blood (2.8 - 1.0.0)](CodeSystem-artificialBlood.md): [Hl7VSartificialBlood](ValueSet-hl7VSartificialBlood.md)
* [Assignment of Benefits (2.8 - 1.0.0)](CodeSystem-assignmentOfBenefits.md): [Hl7VSassignmentOfBenefits](ValueSet-hl7VSassignmentOfBenefits.md)
* [Authorization Mode (2.8 - 1.0.0)](CodeSystem-authorizationMode.md): [Hl7VSauthorizationMode](ValueSet-hl7VSauthorizationMode.md)
* [Bed Status (2.8 - 1.1.0)](CodeSystem-bedStatus.md): [Hl7VSbedStatus](ValueSet-hl7VSbedStatus.md)
* [Blood Product Code (2.8 - 1.0.0)](CodeSystem-bloodProduct.md): [Hl7VSbloodProductCode](ValueSet-hl7VSbloodProductCode.md)
* [Blood Product Dispense Status (2.8 - 1.0.0)](CodeSystem-bloodProductDispenseStatus.md): [Hl7VSbloodProductDispenseStatus](ValueSet-hl7VSbloodProductDispenseStatus.md)
* [Blood Product Processing Requirements (2.8 - 1.0.0)](CodeSystem-bloodProductProcessingRequirements.md): [Hl7VSbloodProductProcessingRequirements](ValueSet-hl7VSbloodProductProcessingRequirements.md)
* [Blood Product Transfusion/Disposition Status (2.8 - 1.0.0)](CodeSystem-bloodProductTransfusion-dispositionStatus.md): [Hl7VSbloodProductTransfusion-dispositionStatus](ValueSet-hl7VSbloodProductTransfusion-dispositionStatus.md)
* [Blood Unit Type (2.8 - 1.0.0)](CodeSystem-bloodUnitType.md): [Hl7VSbloodUnitType](ValueSet-hl7VSbloodUnitType.md)
* [Body Parts (2.8 - 1.1.0)](CodeSystem-bodyParts.md): [Hl7VSbodyParts](ValueSet-hl7VSbodyParts.md)
* [Body Site (2.8 - 1.2.0)](CodeSystem-bodySite.md): [Hl7VSadministriveSite](ValueSet-hl7VSadministriveSite.md)
* [Body Site Modifier (2.8 - 1.0.0)](CodeSystem-bodySiteModifier.md): [Hl7VSbodySiteModifier](ValueSet-hl7VSbodySiteModifier.md)
* [Bolus Type (2.8 - 1.0.0)](CodeSystem-bolusType.md): [Hl7VSbolusType](ValueSet-hl7VSbolusType.md)
* [BP Observation Status Codes Interpretation (2.8 - 1.0.0)](CodeSystem-bpObservationStatusCodesInterpretation.md): [Hl7VSbpObservationStatusCodesInterpretation](ValueSet-hl7VSbpObservationStatusCodesInterpretation.md)
* [Calendar Alignment (2.8 - 1.0.0)](CodeSystem-calendarAlignment.md): [Hl7VScalendarAlignment](ValueSet-hl7VScalendarAlignment.md)
* [Causality Observations (2.8 - 1.0.0)](CodeSystem-causalityObservations.md): [Hl7VScausalityObservations](ValueSet-hl7VScausalityObservations.md)
* [CCL Value (2.8 - 1.0.0)](CodeSystem-cclValue.md): [Hl7VScclValue](ValueSet-hl7VScclValue.md)
* [Certificate Status (2.8 - 1.0.0)](CodeSystem-certificateStatus.md): [Hl7VScertificateStatus](ValueSet-hl7VScertificateStatus.md)
* [Certification Category Code (2.8 - 1.0.0)](CodeSystem-certificationCategory.md): [Hl7VScertificationCategoryCode](ValueSet-hl7VScertificationCategoryCode.md)
* [Certification Patient Type (2.8 - 1.0.0)](CodeSystem-certificationPatientType.md): [Hl7VSprecertificationPatientType](ValueSet-hl7VSprecertificationPatientType.md)
* [Certification Status (2.8 - 1.0.0)](CodeSystem-certificationStatus.md): [Hl7VScertificationStatus](ValueSet-hl7VScertificationStatus.md)
* [Certification Type Code (2.8 - 1.0.0)](CodeSystem-certificationType.md): [Hl7VScertificationTypeCode](ValueSet-hl7VScertificationTypeCode.md)
* [Charge On Indicator (2.8 - 1.0.0)](CodeSystem-chargeOnIndicator.md): [Hl7VSchargeOnIndicator](ValueSet-hl7VSchargeOnIndicator.md)
* [Charge Type (2.8 - 1.0.0)](CodeSystem-chargeType.md): [Hl7VSchargeType](ValueSet-hl7VSchargeType.md)
* [Charge Type Reason (2.8 - 1.0.0)](CodeSystem-chargeTypeReason.md): [Hl7VSchargeTypeReason](ValueSet-hl7VSchargeTypeReason.md)
* [Check Digit Scheme (2.8 - 1.3.0)](CodeSystem-checkDigitScheme.md): [Hl7VScheckDigitScheme](ValueSet-hl7VScheckDigitScheme.md)
* [Notify Clergy Code (2.8 - 1.0.0)](CodeSystem-clergyNotificationType.md): [Hl7VSnotifyClergyCode](ValueSet-hl7VSnotifyClergyCode.md)
* [OCE Edit Code (2.8 - 1.0.0)](CodeSystem-cms-OCEEditCode-cs.md): [Hl7VSOCEEditCode](ValueSet-hl7VSOCEEditCode.md)
* [Modifier Edit Code (2.8 - 1.0.0)](CodeSystem-cms-OCEModifierEditCode-cs.md): [Hl7VSmodifierEditCode](ValueSet-hl7VSmodifierEditCode.md)
* [Coding System (2.8 - 1.6.0)](CodeSystem-codingSystem.md): [Hl7VScodingSystem](ValueSet-hl7VScodingSystem.md)
* [Command Response (2.8 - 1.0.1)](CodeSystem-commandResponse.md): [Hl7VScommandResponse](ValueSet-hl7VScommandResponse.md)
* [Comment Type (2.8 - 1.0.0)](CodeSystem-commentType.md): [Hl7VScommentType](ValueSet-hl7VScommentType.md)
* [Completion Status (2.8 - 1.0.0)](CodeSystem-completionStatus.md): [Hl7VScompletionStatus](ValueSet-hl7VScompletionStatus.md)
* [Computation Type (2.8 - 1.0.0)](CodeSystem-computationType.md): [Hl7VScomputationType](ValueSet-hl7VScomputationType.md)
* [Confidentiality (2.8 - 1.0.0)](CodeSystem-confidentiality.md): [Hl7VSconfidentiality](ValueSet-hl7VSconfidentiality.md)
* [Confidentiality Code (2.8 - 1.0.0)](CodeSystem-confidentialityCodes.md): [Hl7VSconfidentialityCode](ValueSet-hl7VSconfidentialityCode.md)
* [Consent Bypass Reason (2.8 - 1.0.0)](CodeSystem-consentBypassReason.md): [Hl7VSconsentBypassReason](ValueSet-hl7VSconsentBypassReason.md)
* [Consent Disclosure Level (2.8 - 1.0.0)](CodeSystem-consentDisclosureLevel.md): [Hl7VSconsentDisclosureLevel](ValueSet-hl7VSconsentDisclosureLevel.md)
* [Consent Mode (2.8 - 1.0.0)](CodeSystem-consentMode.md): [Hl7VSconsentMode](ValueSet-hl7VSconsentMode.md)
* [Consent Non-Disclosure Reason (2.8 - 1.0.0)](CodeSystem-consentNon-disclosureReason.md): [Hl7VSconsentNon-disclosureReason](ValueSet-hl7VSconsentNon-disclosureReason.md)
* [Consent Status (2.8 - 1.0.0)](CodeSystem-consentStatus.md): [Hl7VSconsentStatus](ValueSet-hl7VSconsentStatus.md)
* [Consent Type (2.8 - 1.0.0)](CodeSystem-consentType.md): [Hl7VSconsentType](ValueSet-hl7VSconsentType.md)
* [Contact Role (2.8 - 1.0.0)](CodeSystem-contactRole2.md): [Hl7VScontactRole2](ValueSet-hl7VScontactRole2.md)
* [Container Condition (2.8 - 1.0.0)](CodeSystem-containerCondition.md): [Hl7VScontainerCondition](ValueSet-hl7VScontainerCondition.md)
* [Container Status (2.8 - 1.0.0)](CodeSystem-containerStatus.md): [Hl7VScontainerStatus](ValueSet-hl7VScontainerStatus.md)
* [Continuation Style Code (2.8 - 1.0.0)](CodeSystem-continuationStyle.md): [Hl7VScontinuationStyleCode](ValueSet-hl7VScontinuationStyleCode.md)
* [Controlled Substance Schedule (2.8 - 1.0.0)](CodeSystem-controlledSubstanceSchedule.md): [Hl7VScontrolledSubstanceSchedule](ValueSet-hl7VScontrolledSubstanceSchedule.md)
* [Coordination of Benefits (2.8 - 1.0.0)](CodeSystem-coordinationOfBenefits.md): [Hl7VScoordinationOfBenefits](ValueSet-hl7VScoordinationOfBenefits.md)
* [Coverage Type (2.8 - 1.1.0)](CodeSystem-coverageType.md): [Hl7VScoverageType](ValueSet-hl7VScoverageType.md)
* [CP Range Type (2.8 - 1.0.0)](CodeSystem-cpRangeType.md): [Hl7VSrangeType](ValueSet-hl7VSrangeType.md)
* [Cumulative Dosage Limit UoM (2.8 - 1.0.0)](CodeSystem-cumulativeDosageLimitUom.md): [Hl7VScumulativeDosageLimitUom](ValueSet-hl7VScumulativeDosageLimitUom.md)
* [CWE statuses (2.8 - 1.0.0)](CodeSystem-cweStatuses.md): [Hl7VScweStatuses](ValueSet-hl7VScweStatuses.md)
* [Cycle Type (2.8 - 1.0.0)](CodeSystem-cycleType.md): [Hl7VScycleType](ValueSet-hl7VScycleType.md)
* [Cyclic Entry/Exit Indicator (2.8 - 1.0.0)](CodeSystem-cyclicEntryExitIndicator.md): [Hl7VScyclicEntryExitIndicator](ValueSet-hl7VScyclicEntryExitIndicator.md)
* [Data Types (2.8 - 1.2.0)](CodeSystem-dataTypes.md): [Hl7VSdataTypes](ValueSet-hl7VSdataTypes.md)
* [Date Format (2.8 - 1.0.0)](CodeSystem-dateFormat.md): [Hl7VSdateFormat](ValueSet-hl7VSdateFormat.md)
* [Day Type (2.8 - 1.0.0)](CodeSystem-dayType.md): [Hl7VSdayType](ValueSet-hl7VSdayType.md)
* [Days of the Week (2.8 - 1.0.0)](CodeSystem-daysOfTheWeek.md): [Hl7VSdaysOfTheWeek](ValueSet-hl7VSdaysOfTheWeek.md)
* [Degree/License/Certificate (2.8 - 2.1.0)](CodeSystem-degreeLicenseCertificate.md): [Hl7VSdegreeLicenseCertificate](ValueSet-hl7VSdegreeLicenseCertificate.md)
* [Denial or Rejection Code (2.8 - 1.0.0)](CodeSystem-denialOrRejectionType.md): [Hl7VSdenialOrRejectionCode](ValueSet-hl7VSdenialOrRejectionCode.md)
* [Derived Specimen (2.8 - 1.0.0)](CodeSystem-derivedSpecimen.md): [Hl7VSderivedSpecimen](ValueSet-hl7VSderivedSpecimen.md)
* [Device Data State (2.8 - 1.0.0)](CodeSystem-deviceDataState.md): [Hl7VSdeviceDataState](ValueSet-hl7VSdeviceDataState.md)
* [Device Status (2.8 - 1.0.0)](CodeSystem-deviceStatus.md): [Hl7VSdeviceStatus](ValueSet-hl7VSdeviceStatus.md)
* [Diagnosis Classification (2.8 - 1.0.0)](CodeSystem-diagnosisClassification.md): [Hl7VSdiagnosisClassification](ValueSet-hl7VSdiagnosisClassification.md)
* [Diagnosis Priority (2.8 - 1.0.0)](CodeSystem-diagnosisPriority.md): [Hl7VSdiagnosisPriority](ValueSet-hl7VSdiagnosisPriority.md)
* [Diagnosis Type (2.8 - 1.0.0)](CodeSystem-diagnosisType.md): [Hl7VSdiagnosisType](ValueSet-hl7VSdiagnosisType.md)
* [Diagnostic Service Section ID (2.8 - 1.4.0)](CodeSystem-diagnosticServiceSectionId.md): [Hl7VSdiagnosticServiceSectionId](ValueSet-hl7VSdiagnosticServiceSectionId.md)
* [Diet Code Specification Type (2.8 - 1.0.0)](CodeSystem-dietCodeSpecificationType.md): [Hl7VSdietType](ValueSet-hl7VSdietType.md)
* [Disabled Person Code (2.8 - 1.0.0)](CodeSystem-disabilityInformationRelationship.md): [Hl7VSdisabledPerson](ValueSet-hl7VSdisabledPerson.md)
* [Dispense Method (2.8 - 1.0.0)](CodeSystem-dispenseMethod.md): [Hl7VSdispenseMethod](ValueSet-hl7VSdispenseMethod.md)
* [Dispense Type (2.8 - 1.0.0)](CodeSystem-dispenseType.md): [Hl7VSdispenseType](ValueSet-hl7VSdispenseType.md)
* [Document Availability Status (2.8 - 1.1.0)](CodeSystem-documentAvailabilityStatus.md): [Hl7VSdocumentAvailabilityStatus](ValueSet-hl7VSdocumentAvailabilityStatus.md)
* [Document Completion Status (2.8 - 1.0.0)](CodeSystem-documentCompletionStatus.md): [Hl7VSdocumentCompletionStatus](ValueSet-hl7VSdocumentCompletionStatus.md)
* [Document Confidentiality Status (2.8 - 2.0.0)](CodeSystem-documentConfidentialityStatus2.md): [Hl7VSdocumentConfidentialityStatus](ValueSet-hl7VSdocumentConfidentialityStatus.md)
* [Document Storage Status (2.8 - 1.0.0)](CodeSystem-documentStorageStatus.md): [Hl7VSdocumentStorageStatus](ValueSet-hl7VSdocumentStorageStatus.md)
* [Document Type (2.8 - 1.0.0)](CodeSystem-documentType.md): [Hl7VSreportTypeCode](ValueSet-hl7VSreportTypeCode.md)
* [DRG Diagnosis Determination Status (2.8 - 1.0.0)](CodeSystem-drgDiagnosisDeterminationStatus.md): [Hl7VSdrgDiagnosisDeterminationStatus](ValueSet-hl7VSdrgDiagnosisDeterminationStatus.md)
* [DRG Grouping Status (2.8 - 1.0.0)](CodeSystem-drgGroupingStatus.md): [Hl7VSdrgGroupingStatus](ValueSet-hl7VSdrgGroupingStatus.md)
* [DRG Procedure Determination Status (2.8 - 1.0.0)](CodeSystem-drgProcedureDeterminationStatus.md): [Hl7VSdrgProcedureDeterminationStatus](ValueSet-hl7VSdrgProcedureDeterminationStatus.md)
* [DRG Procedure Relevance (2.8 - 1.0.0)](CodeSystem-drgProcedureRelevance.md): [Hl7VSdrgProcedureRelevance](ValueSet-hl7VSdrgProcedureRelevance.md)
* [DRG Status Financial Calculation (2.8 - 1.0.0)](CodeSystem-drgStatusFinancialCalculation.md): [Hl7VSdrgStatusFinancialCalculation](ValueSet-hl7VSdrgStatusFinancialCalculation.md)
* [DRG Status Patient (2.8 - 1.0.0)](CodeSystem-drgStatusPatient.md): [Hl7VSstatusPatient](ValueSet-hl7VSstatusPatient.md)
* [DRG Status Respiration Minutes (2.8 - 1.0.0)](CodeSystem-drgStatusRespirationMinutes.md): [Hl7VSstatusRespirationMinutes](ValueSet-hl7VSstatusRespirationMinutes.md)
* [Transfer Type (2.8 - 1.0.0)](CodeSystem-drgTransferType.md): [Hl7VSdrgTransferType](ValueSet-hl7VSdrgTransferType.md)
* [Status Admission (2.8 - 1.0.0)](CodeSystem-drgstatusAdmission.md): [Hl7VSstatusAdmission](ValueSet-hl7VSstatusAdmission.md)
* [Status Weight At Birth (2.8 - 1.0.0)](CodeSystem-drgstatusWeightAtBirth.md): [Hl7VSstatusWeightAtBirth](ValueSet-hl7VSstatusWeightAtBirth.md)
* [Duration Categories (2.8 - 1.1.0)](CodeSystem-durationCategories.md): [Hl7VSdurationCategories](ValueSet-hl7VSdurationCategories.md)
* [Eligibility Source (2.8 - 1.0.0)](CodeSystem-eligibilitySource.md): [Hl7VSeligibilitySource](ValueSet-hl7VSeligibilitySource.md)
* [Employment Status (2.8 - 2.0.0)](CodeSystem-employmentStatus.md): [Hl7VSemploymentStatus](ValueSet-hl7VSemploymentStatus.md)
* [Encoding (2.8 - 1.0.0)](CodeSystem-encoding.md): [Hl7VSencoding](ValueSet-hl7VSencoding.md)
* [Equipment State (2.8 - 1.1.0)](CodeSystem-equipmentState.md): [Hl7VSequipmentState](ValueSet-hl7VSequipmentState.md)
* [Error Severity (2.8 - 1.1.0)](CodeSystem-errorSeverity.md): [Hl7VSerrorSeverity](ValueSet-hl7VSerrorSeverity.md)
* [Escort Required (2.8 - 1.0.0)](CodeSystem-escortRequired.md): [Hl7VSescortRequired](ValueSet-hl7VSescortRequired.md)
* [Event (2.8 - 1.9.0)](CodeSystem-event.md): [Hl7VSevent](ValueSet-hl7VSevent.md)
* [Event Consequence (2.8 - 1.0.0)](CodeSystem-eventConsequence.md): [Hl7VSeventConsequence](ValueSet-hl7VSeventConsequence.md)
* [Event Expected (2.8 - 1.0.0)](CodeSystem-eventExpected.md): [Hl7VSeventExpected](ValueSet-hl7VSeventExpected.md)
* [Event Qualification (2.8 - 1.0.0)](CodeSystem-eventQualification.md): [Hl7VSeventQualification](ValueSet-hl7VSeventQualification.md)
* [Event Reason (2.8 - 1.3.0)](CodeSystem-eventReason.md): [Hl7VSeventReason](ValueSet-hl7VSeventReason.md)
* [Event Related Period (2.8 - 1.0.0)](CodeSystem-eventRelatedPeriod.md): [Hl7VSeventRelatedPeriod](ValueSet-hl7VSeventRelatedPeriod.md)
* [Event Reported To (2.8 - 1.0.0)](CodeSystem-eventReportedTo.md): [Hl7VSeventReportedTo](ValueSet-hl7VSeventReportedTo.md)
* [Event Seriousness (2.8 - 1.0.0)](CodeSystem-eventSeriousness.md): [Hl7VSeventSeriousness](ValueSet-hl7VSeventSeriousness.md)
* [Event Type (2.8 - 1.0.0)](CodeSystem-eventType.md): [Hl7VSeventType](ValueSet-hl7VSeventType.md)
* [Exclusive Test (2.8 - 1.0.0)](CodeSystem-exclusiveTest.md): [Hl7VSexclusiveTest](ValueSet-hl7VSexclusiveTest.md)
* [Expanded Yes/no Indicator (2.8 - 1.0.0)](CodeSystem-expandedYes-NoIndicator.md): [Hl7VSexpandedYes-NoIndicator](ValueSet-hl7VSexpandedYes-NoIndicator.md) and [Hl7VSyes-no-Indicator](ValueSet-hl7VSyes-no-Indicator.md)
* [Extended Priority Codes (2.8 - 1.0.0)](CodeSystem-extendedPriorityCodes.md): [Hl7VSextendedPriorityCodes](ValueSet-hl7VSextendedPriorityCodes.md)
* [Facility Type (2.8 - 1.0.0)](CodeSystem-facilityType.md): [Hl7VSfacilityType](ValueSet-hl7VSfacilityType.md)
* [File Level Event Code (2.8 - 1.0.0)](CodeSystem-file-levelEvent.md): [Hl7VSfile-levelEventCode](ValueSet-hl7VSfile-levelEventCode.md)
* [Filler Status Codes (2.8 - 1.2.0)](CodeSystem-fillerStatus.md): [Hl7VSfillerStatusCodes](ValueSet-hl7VSfillerStatusCodes.md)
* [Formulary Status (2.8 - 1.0.0)](CodeSystem-formularyStatus.md): [Hl7VSformularyStatus](ValueSet-hl7VSformularyStatus.md)
* [Gestation Category Code (2.8 - 1.0.0)](CodeSystem-gestationCategory.md): [Hl7VSgestationCategoryCode](ValueSet-hl7VSgestationCategoryCode.md)
* [Grouper Status (2.8 - 1.0.0)](CodeSystem-grouperStatus.md): [Hl7VSgrouperStatus](ValueSet-hl7VSgrouperStatus.md)
* [Health Care Provider Area of Specialization (2.8 - 1.0.0)](CodeSystem-healthCareProviderAreaOfSpecialization.md): [Hl7VShealthCareProviderAreaOfSpecialization](ValueSet-hl7VShealthCareProviderAreaOfSpecialization.md)
* [Health Care Provider Classification (2.8 - 1.0.0)](CodeSystem-healthCareProviderClassification.md): [Hl7VShealthCareProviderClassification](ValueSet-hl7VShealthCareProviderClassification.md)
* [Health Care Provider Type Code (2.8 - 1.0.0)](CodeSystem-healthCareProviderTypeCode.md): [Hl7VShealthCareProviderTypeCode](ValueSet-hl7VShealthCareProviderTypeCode.md)
* [Identifier Type (2.8 - 1.5.0)](CodeSystem-identifierType.md): [Hl7VSidentifierType](ValueSet-hl7VSidentifierType.md)
* [Identity May Be Divulged (2.8 - 1.0.0)](CodeSystem-identityMayBeDivulged.md): [Hl7VSidentityMayBeDivulged](ValueSet-hl7VSidentityMayBeDivulged.md)
* [Identity Reliability Code (2.8 - 1.0.0)](CodeSystem-identityReliability.md): [Hl7VSidentityReliabilityCode](ValueSet-hl7VSidentityReliabilityCode.md)
* [Immunization Registry Status (2.8 - 1.0.0)](CodeSystem-immunizationRegistryStatus.md): [Hl7VSimmunizationRegistryStatus](ValueSet-hl7VSimmunizationRegistryStatus.md)
* [Inactive Reason Code (2.8 - 1.0.0)](CodeSystem-inactiveReason.md): [Hl7VSinactiveReasonCode](ValueSet-hl7VSinactiveReasonCode.md)
* [Incident Type Code (2.8 - 1.0.0)](CodeSystem-incidentType.md): [Hl7VSincidentTypeCode](ValueSet-hl7VSincidentTypeCode.md)
* [Indirect Exposure Mechanism (2.8 - 1.0.0)](CodeSystem-indirectExposureMechanism.md): [Hl7VSindirectExposureMechanism](ValueSet-hl7VSindirectExposureMechanism.md)
* [Inform Person Code (2.8 - 1.0.0)](CodeSystem-informInstructions.md): [Hl7VSinformPersonCode](ValueSet-hl7VSinformPersonCode.md)
* [Institution Relationship Type (2.8 - 1.0.0)](CodeSystem-institutionRelationshipType.md): [Hl7VSinstitutionRelationshipType](ValueSet-hl7VSinstitutionRelationshipType.md)
* [Intended Procedure Type (2.8 - 1.0.0)](CodeSystem-intendedProcedureType.md): [Hl7VSintendedProcedureType](ValueSet-hl7VSintendedProcedureType.md)
* [Invocation Event (2.8 - 1.0.0)](CodeSystem-invocationEvent.md): [Hl7VSwhenToCharge](ValueSet-hl7VSwhenToCharge.md)
* [Invoice Control Code (2.8 - 1.0.0)](CodeSystem-invoiceControl.md): [Hl7VSinvoiceControlCode](ValueSet-hl7VSinvoiceControlCode.md)
* [Invoice Processing Results Status (2.8 - 1.0.0)](CodeSystem-invoiceProcessingResultsStatus.md): [Hl7VSinvoiceProcessingResultsStatus](ValueSet-hl7VSinvoiceProcessingResultsStatus.md)
* [Invoice Reason Codes (2.8 - 1.0.0)](CodeSystem-invoiceReason.md): [Hl7VSinvoiceReasonCodes](ValueSet-hl7VSinvoiceReasonCodes.md)
* [Invoice Type (2.8 - 1.0.0)](CodeSystem-invoiceType.md): [Hl7VSinvoiceType](ValueSet-hl7VSinvoiceType.md)
* [Item Status (2.8 - 1.0.0)](CodeSystem-itemStatus.md): [Hl7VSitemStatus](ValueSet-hl7VSitemStatus.md) and [Hl7VSitemStatusCodes](ValueSet-hl7VSitemStatusCodes.md)
* [Item Type (2.8 - 1.0.0)](CodeSystem-itemType.md): [Hl7VSitemType](ValueSet-hl7VSitemType.md)
* [Job Status (2.8 - 1.0.0)](CodeSystem-jobStatus.md): [Hl7VSjobStatus](ValueSet-hl7VSjobStatus.md)
* [Jurisdictional Breadth (2.8 - 1.0.0)](CodeSystem-jurisdictionalBreadth.md): [Hl7VSjurisdictionalBreadth](ValueSet-hl7VSjurisdictionalBreadth.md)
* [Kind of Quantity (2.8 - 1.0.0)](CodeSystem-kindOfQuantity.md): [Hl7VSkindOfQuantity](ValueSet-hl7VSkindOfQuantity.md)
* [Labor Calculation Type (2.8 - 1.0.0)](CodeSystem-laborCalculationType.md): [Hl7VSlaborCalculationType](ValueSet-hl7VSlaborCalculationType.md)
* [Language Ability (2.8 - 1.0.0)](CodeSystem-languageAbility.md): [Hl7VSlanguageAbility](ValueSet-hl7VSlanguageAbility.md)
* [Language Proficiency (2.8 - 1.0.0)](CodeSystem-languageProficiency.md): [Hl7VSlanguageProficiency](ValueSet-hl7VSlanguageProficiency.md)
* [Level of Care (2.8 - 1.0.0)](CodeSystem-levelOfCare.md): [Hl7VSlevelOfCare](ValueSet-hl7VSlevelOfCare.md)
* [Living Arrangement (2.8 - 1.1.0)](CodeSystem-livingArrangement.md): [Hl7VSlivingArrangement](ValueSet-hl7VSlivingArrangement.md)
* [Living Dependency (2.8 - 2.0.0)](CodeSystem-livingDependency2.md): [Hl7VSlivingDependency](ValueSet-hl7VSlivingDependency.md)
* [Living Will Code (2.8 - 1.0.0)](CodeSystem-livingWillCodes.md): [Hl7VSlivingWill](ValueSet-hl7VSlivingWill.md)
* [Load Status (2.8 - 1.0.0)](CodeSystem-loadStatus.md): [Hl7VSloadStatus](ValueSet-hl7VSloadStatus.md)
* [Local/Remote Control State (2.8 - 1.0.0)](CodeSystem-local-remoteControlState.md): [Hl7VSlocal-remoteControlState](ValueSet-hl7VSlocal-remoteControlState.md)
* [Location Characteristic ID (2.8 - 1.0.0)](CodeSystem-locationCharacteristic.md): [Hl7VSlocationCharacteristicId](ValueSet-hl7VSlocationCharacteristicId.md)
* [Location Equipment (2.8 - 1.0.0)](CodeSystem-locationEquipment.md): [Hl7VSlocationEquipment](ValueSet-hl7VSlocationEquipment.md)
* [Location Relationship ID (2.8 - 1.0.0)](CodeSystem-locationRelationship.md): [Hl7VSlocationRelationshipId](ValueSet-hl7VSlocationRelationshipId.md)
* [Location Service Code (2.8 - 1.0.0)](CodeSystem-locationServiceType.md): [Hl7VSlocationServiceCode](ValueSet-hl7VSlocationServiceCode.md)
* [Lot Control (2.8 - 1.0.0)](CodeSystem-lotControl.md): [Hl7VSlotControl](ValueSet-hl7VSlotControl.md)
* [Mail Claim Party (2.8 - 1.0.0)](CodeSystem-mailClaimParty.md): [Hl7VSmailClaimParty](ValueSet-hl7VSmailClaimParty.md)
* [Marital Status (2.8 - 1.1.0)](CodeSystem-maritalStatus.md): [Hl7VSmaritalStatus](ValueSet-hl7VSmaritalStatus.md)
* [Marketing Basis (2.8 - 1.0.0)](CodeSystem-marketingBasis.md): [Hl7VSmarketingBasis](ValueSet-hl7VSmarketingBasis.md)
* [Master File Identifier Code (2.8 - 1.2.0)](CodeSystem-masterFileIdentifierCodes.md): [Hl7VSmasterFileIdentifierCode](ValueSet-hl7VSmasterFileIdentifierCode.md)
* [Record-level Event Code (2.8 - 1.0.0)](CodeSystem-masterfileActionCode.md): [Hl7VSmasterfileActionCode](ValueSet-hl7VSmasterfileActionCode.md)
* [Match Reason (2.8 - 1.0.0)](CodeSystem-matchReason.md): [Hl7VSmatchReason](ValueSet-hl7VSmatchReason.md)
* [Medical Role Executing Physician (2.8 - 1.0.0)](CodeSystem-medicalRoleExecutingPhysician.md): [Hl7VSmedicalRoleExecutingPhysician](ValueSet-hl7VSmedicalRoleExecutingPhysician.md)
* [Message Error Condition Codes (2.8 - 1.1.0)](CodeSystem-messageErrorCondition.md): [Hl7VSmessageErrorConditionCodes](ValueSet-hl7VSmessageErrorConditionCodes.md)
* [Message Structure (2.8 - 7.1.0)](CodeSystem-messageStructure.md): [Hl7VSmessageStructure](ValueSet-hl7VSmessageStructure.md)
* [Message Type (2.8 - 1.8.0)](CodeSystem-messageType.md): [Hl7VSmessageType](ValueSet-hl7VSmessageType.md)
* [Message Waiting Priority (2.8 - 1.0.0)](CodeSystem-messageWaitingPriority.md): [Hl7VSmessageWaitingPriority](ValueSet-hl7VSmessageWaitingPriority.md)
* [MFN Record-level Error Return (2.8 - 1.0.0)](CodeSystem-mfnRecord-levelErrorReturn.md): [Hl7VSmfnRecode-levelErrorReturn](ValueSet-hl7VSmfnRecode-levelErrorReturn.md)
* [Military Rank/Grade (2.8 - 2.0.0)](CodeSystem-militaryRank-Grade.md): [Hl7VSmilitaryRank-Grade](ValueSet-hl7VSmilitaryRank-Grade.md)
* [Military Service (2.8 - 1.1.0)](CodeSystem-militaryService.md): [Hl7VSmilitaryService](ValueSet-hl7VSmilitaryService.md)
* [Military Status (2.8 - 1.0.0)](CodeSystem-militaryStatus.md): [Hl7VSmilitaryStatus](ValueSet-hl7VSmilitaryStatus.md)
* [MIME Types (2.8 - 1.0.0)](CodeSystem-mimeTypes.md): [Hl7VSmimeTypes](ValueSet-hl7VSmimeTypes.md)
* [Modality (2.8 - 1.0.0)](CodeSystem-modality.md): [Hl7VSmodality](ValueSet-hl7VSmodality.md)
* [Modify Indicator (2.8 - 1.0.0)](CodeSystem-modifyIndicator.md): [Hl7VSmodifyIndicator](ValueSet-hl7VSmodifyIndicator.md)
* [Money or Percentage Indicator (2.8 - 1.0.0)](CodeSystem-moneyOrPercentageIndicator.md): [Hl7VSpenaltyType](ValueSet-hl7VSpenaltyType.md)
* [Mood Codes (2.8 - 1.0.0)](CodeSystem-moodCodes.md): [Hl7VSmoodCodes](ValueSet-hl7VSmoodCodes.md)
* [Name/Address Representation (2.8 - 1.0.0)](CodeSystem-name-addressRepresentation.md): [Hl7VSname-addressRepresentation](ValueSet-hl7VSname-addressRepresentation.md)
* [Name Assembly Order (2.8 - 1.0.0)](CodeSystem-nameAssemblyOrder.md): [Hl7VSnameAssemblyOrder](ValueSet-hl7VSnameAssemblyOrder.md)
* [Name Type (2.8 - 1.1.0)](CodeSystem-nameType2.md): [Hl7VSnameType](ValueSet-hl7VSnameType.md)
* [Nature of Abnormal Testing (2.8 - 1.1.0)](CodeSystem-natureOfAbnormalTesting.md): [Hl7VSnatureOfAbnormalTesting](ValueSet-hl7VSnatureOfAbnormalTesting.md)
* [Nature of Challenge (2.8 - 1.0.0)](CodeSystem-natureOfChallenge.md): [Hl7VSnatureOfChallenge](ValueSet-hl7VSnatureOfChallenge.md)
* [Nature of Service/Test/Observation (2.8 - 1.1.0)](CodeSystem-natureOfServiceTestObservation.md): [Hl7VSnatureOfServiceTestObservation](ValueSet-hl7VSnatureOfServiceTestObservation.md)
* [Newborn Code (2.8 - 1.0.0)](CodeSystem-newbornType.md): [Hl7VSnewbornCode](ValueSet-hl7VSnewbornCode.md)
* [Non-Subject Consenter Reason (2.8 - 1.0.0)](CodeSystem-non-subjectConsenterReason.md): [Hl7VSnon-subjectConsenterReason](ValueSet-hl7VSnon-subjectConsenterReason.md)
* [Present On Admission (POA) Indicator (2.8 - 1.0.0)](CodeSystem-nubc-PresentOnAdmission-cs.md): [Hl7VSpresentOnAdmission_poa_Indicator](ValueSet-hl7VSpresentOnAdmission_poa_Indicator.md)
* [Interpretation Codes (2.8 - 2.1.0)](CodeSystem-observationInterpretation.md): [Hl7VSinterpretationCode](ValueSet-hl7VSinterpretationCode.md)
* [Observation Result Handling (2.8 - 1.1.0)](CodeSystem-observationResultHandling.md): [Hl7VSobservationResultHandling](ValueSet-hl7VSobservationResultHandling.md)
* [Observation Result Status Codes Interpretation (2.8 - 1.3.0)](CodeSystem-observationResultStatusCodesInterpretation.md): [Hl7VSobservationResultStatus](ValueSet-hl7VSobservationResultStatus.md)
* [Order Control Codes (2.8 - 1.7.0)](CodeSystem-orderControlCodes.md): [Hl7VSorderControl](ValueSet-hl7VSorderControl.md)
* [Order Status (2.8 - 1.2.0)](CodeSystem-orderStatus.md): [Hl7VSorderStatus](ValueSet-hl7VSorderStatus.md)
* [Order Type (2.8 - 1.0.0)](CodeSystem-orderType.md): [Hl7VSorderType](ValueSet-hl7VSorderType.md)
* [Organ Donor Code (2.8 - 1.2.0)](CodeSystem-organDonorCodes.md): [Hl7VSorganDonor](ValueSet-hl7VSorganDonor.md)
* [Practitioner Organization Unit Type (2.8 - 2.0.0)](CodeSystem-organizationUnitType.md): [Hl7VSorganizationUnitType](ValueSet-hl7VSorganizationUnitType.md) and [Hl7VSorganizationUnitType-Org](ValueSet-hl7VSorganizationUnitType-Org.md)
* [Organizational Name Type (2.8 - 1.0.0)](CodeSystem-organizationalNameType.md): [Hl7VSorganizationalNameType](ValueSet-hl7VSorganizationalNameType.md)
* [Outlier Type (2.8 - 1.0.0)](CodeSystem-outlierType.md): [Hl7VSoutlierType](ValueSet-hl7VSoutlierType.md)
* [Overall Claim Disposition Code (2.8 - 1.0.0)](CodeSystem-overallClaimDisposition.md): [Hl7VSoverallClaimDispositionCode](ValueSet-hl7VSoverallClaimDispositionCode.md)
* [Override (2.8 - 1.0.0)](CodeSystem-override.md): [Hl7VSoverride](ValueSet-hl7VSoverride.md)
* [Override Type (2.8 - 1.0.0)](CodeSystem-overrideType.md): [Hl7VSoverrideType](ValueSet-hl7VSoverrideType.md)
* [Package (2.8 - 1.0.0)](CodeSystem-package.md): [Hl7VSpackage](ValueSet-hl7VSpackage.md)
* [Packaging Status Code (2.8 - 1.0.0)](CodeSystem-packagingStatus.md): [Hl7VSpackagingStatusCode](ValueSet-hl7VSpackagingStatusCode.md)
* [Participation (2.8 - 1.1.0)](CodeSystem-participation.md): [Hl7VSparticipation](ValueSet-hl7VSparticipation.md)
* [Patient Class (2.8 - 1.2.0)](CodeSystem-patientClass.md): [Hl7VSpatientClass](ValueSet-hl7VSpatientClass.md)
* [Patient Condition Code (2.8 - 1.0.0)](CodeSystem-patientCondition.md): [Hl7VSpatientConditionCode](ValueSet-hl7VSpatientConditionCode.md)
* [Patient Location Type (2.8 - 1.0.0)](CodeSystem-patientLocationType.md): [Hl7VSpatientLocationType](ValueSet-hl7VSpatientLocationType.md)
* [Patient Outcome (2.8 - 1.0.0)](CodeSystem-patientOutcome.md): [Hl7VSpatientOutcome](ValueSet-hl7VSpatientOutcome.md)
* [Patient Results Release Categorization Scheme (2.8 - 1.0.0)](CodeSystem-patientResultsReleaseCategorizationScheme.md): [Hl7VSpatientResultsReleaseCategorizationScheme](ValueSet-hl7VSpatientResultsReleaseCategorizationScheme.md)
* [Patient's Relationship to Insured (2.8 - 1.0.0)](CodeSystem-patientsRelationshipToInsured.md): [Hl7VSpatient_sRelationshipToInsured](ValueSet-hl7VSpatient_sRelationshipToInsured.md)
* [Payee Relationship to Invoice (2.8 - 1.0.0)](CodeSystem-payeeRelationshipToInvoice.md): [Hl7VSpayeeRelationshipToInvoice](ValueSet-hl7VSpayeeRelationshipToInvoice.md)
* [Payee Type (2.8 - 1.0.0)](CodeSystem-payeeType.md): [Hl7VSpayeeType](ValueSet-hl7VSpayeeType.md)
* [Payment Adjustment Code (2.8 - 1.0.0)](CodeSystem-paymentAdjustmentInformation.md): [Hl7VSpaymentAdjustmentCode](ValueSet-hl7VSpaymentAdjustmentCode.md)
* [Payment Method Code (2.8 - 1.0.0)](CodeSystem-paymentMethod.md): [Hl7VSpaymentMethodCode](ValueSet-hl7VSpaymentMethodCode.md)
* [PCA Type (2.8 - 1.0.0)](CodeSystem-pcaType.md): [Hl7VSpcaType](ValueSet-hl7VSpcaType.md)
* [Person Location Type (2.8 - 1.0.0)](CodeSystem-personLocationType.md): [Hl7VSpersonLocationType](ValueSet-hl7VSpersonLocationType.md)
* [Pharmacy Order Types (2.8 - 1.0.0)](CodeSystem-pharmacyOrderTypes.md): [Hl7VSpharmacyOrderTypes](ValueSet-hl7VSpharmacyOrderTypes.md)
* [Phlebotomy Issue (2.8 - 1.0.0)](CodeSystem-phlebotomyIssue.md): [Hl7VSphlebotomyIssue](ValueSet-hl7VSphlebotomyIssue.md)
* [Phlebotomy Status (2.8 - 1.0.0)](CodeSystem-phlebotomyStatus.md): [Hl7VSphlebotomyStatus](ValueSet-hl7VSphlebotomyStatus.md)
* [Policy Type (2.8 - 1.0.0)](CodeSystem-policyType.md): [Hl7VSpolicyType](ValueSet-hl7VSpolicyType.md)
* [Practitioner ID Number Type (2.8 - 1.1.0)](CodeSystem-practitionerIdNumberType.md): [Hl7VSpractitionerIdNumberType](ValueSet-hl7VSpractitionerIdNumberType.md)
* [Precaution Code (2.8 - 1.0.0)](CodeSystem-precaution.md): [Hl7VSprecautionCode](ValueSet-hl7VSprecautionCode.md)
* [Preferred Method of Contact (2.8 - 1.1.0)](CodeSystem-preferredMethodOfContact.md): [Hl7VSpreferredMethodOfContrct](ValueSet-hl7VSpreferredMethodOfContrct.md)
* [Preferred Specimen/Attribute Status (2.8 - 1.0.0)](CodeSystem-preferredSpecimen-AttributeStatus.md): [Hl7VSpreferredSpecimen-AttributeStatus](ValueSet-hl7VSpreferredSpecimen-AttributeStatus.md)
* [Price Type (2.8 - 1.0.0)](CodeSystem-priceType.md): [Hl7VSpriceType](ValueSet-hl7VSpriceType.md)
* [Primary Key Value Type (2.8 - 1.1.0)](CodeSystem-primaryKeyValueType.md): [Hl7VSprimaryKeyValueType](ValueSet-hl7VSprimaryKeyValueType.md)
* [Primary Observer's Qualification (2.8 - 1.0.0)](CodeSystem-primaryObserverQualification.md): [Hl7VSprimaryObserver_sQualification](ValueSet-hl7VSprimaryObserver_sQualification.md)
* [Priority (2.8 - 1.2.0)](CodeSystem-priority.md): [Hl7VSpriority](ValueSet-hl7VSpriority.md)
* [Privacy Level (2.8 - 1.0.0)](CodeSystem-privacyLevel.md): [Hl7VSprivacyLevel](ValueSet-hl7VSprivacyLevel.md)
* [Problem/Goal Action Code (2.8 - 1.0.0)](CodeSystem-problem-goalAction.md): [Hl7VSactionCode](ValueSet-hl7VSactionCode.md)
* [Procedure DRG Type (2.8 - 1.0.0)](CodeSystem-procedureDrgType.md): [Hl7VSprocedureDrgType](ValueSet-hl7VSprocedureDrgType.md)
* [Procedure Functional Type (2.8 - 1.0.0)](CodeSystem-procedureFunctionalType.md): [Hl7VSprocedureFunctionalType](ValueSet-hl7VSprocedureFunctionalType.md)
* [Procedure Priority (2.8 - 1.1.0)](CodeSystem-procedurePriority.md): [Hl7VSprocedurePriority](ValueSet-hl7VSprocedurePriority.md)
* [Process Interruption Reason (2.8 - 1.0.0)](CodeSystem-processInterruptionReason.md): [Hl7VSprocessInterruptionReason](ValueSet-hl7VSprocessInterruptionReason.md)
* [Processing Consideration Codes (2.8 - 1.0.0)](CodeSystem-processingConsideration.md): [Hl7VSprocessingConsiderationCodes](ValueSet-hl7VSprocessingConsiderationCodes.md)
* [Processing ID (2.8 - 1.0.0)](CodeSystem-processingId.md): [Hl7VSprocessingId](ValueSet-hl7VSprocessingId.md)
* [Processing Mode (2.8 - 1.1.0)](CodeSystem-processingMode.md): [Hl7VSprocessingMode](ValueSet-hl7VSprocessingMode.md)
* [Processing Priority (2.8 - 1.0.0)](CodeSystem-processingPriority.md): [Hl7VSprocessingPriority](ValueSet-hl7VSprocessingPriority.md)
* [Processing Type (2.8 - 1.0.0)](CodeSystem-processingType.md): [Hl7VSprocessingType](ValueSet-hl7VSprocessingType.md)
* [Product/Service Status (2.8 - 1.0.0)](CodeSystem-product-serviceStatus.md): [Hl7VSproduct-serviceStatus](ValueSet-hl7VSproduct-serviceStatus.md)
* [Product/Services Clarification Codes (2.8 - 1.0.0)](CodeSystem-product-servicesClarification.md): [Hl7VSproduct-servicesClarification](ValueSet-hl7VSproduct-servicesClarification.md)
* [Product Source (2.8 - 1.0.0)](CodeSystem-productSource.md): [Hl7VSproductSource](ValueSet-hl7VSproductSource.md)
* [Production Class Code (2.8 - 1.0.0)](CodeSystem-productionClass.md): [Hl7VSproductionClassCode](ValueSet-hl7VSproductionClassCode.md)
* [Protection Code (2.8 - 1.0.0)](CodeSystem-protection.md): [Hl7VSprotectionCode](ValueSet-hl7VSprotectionCode.md)
* [Provider Adjustment Reason Code (2.8 - 1.0.0)](CodeSystem-providerAdjustmentReason.md): [Hl7VSproviderAdjustmentReasonCode](ValueSet-hl7VSproviderAdjustmentReasonCode.md)
* [Provider Billing (2.8 - 1.0.0)](CodeSystem-providerBilling.md): [Hl7VSproviderBilling](ValueSet-hl7VSproviderBilling.md)
* [Provider Role (2.8 - 1.2.0)](CodeSystem-providerRole.md): [Hl7VSproviderRole](ValueSet-hl7VSproviderRole.md)
* [Purge Status Code (2.8 - 1.0.0)](CodeSystem-purgeStatus.md): [Hl7VSpurgeStatus](ValueSet-hl7VSpurgeStatus.md)
* [Quantity Limited Request (2.8 - 1.1.0)](CodeSystem-quantityLimitedRequest.md): [Hl7VSquantityLimitedRequest](ValueSet-hl7VSquantityLimitedRequest.md)
* [Quantity Method (2.8 - 1.0.0)](CodeSystem-quantityMethod.md): [Hl7VSquantityMethod](ValueSet-hl7VSquantityMethod.md)
* [Query Priority (2.8 - 1.0.0)](CodeSystem-queryPriority.md): [Hl7VSqueryPriority](ValueSet-hl7VSqueryPriority.md)
* [Query Response Status (2.8 - 1.1.0)](CodeSystem-queryResponseStatus.md): [Hl7VSqueryResponseStatus](ValueSet-hl7VSqueryResponseStatus.md)
* [Recreational Drug Use Code (2.8 - 1.0.0)](CodeSystem-recreationalDrugType.md): [Hl7VSrecreationalDrugUseCode](ValueSet-hl7VSrecreationalDrugUseCode.md)
* [Referral Category (2.8 - 1.0.0)](CodeSystem-referralCategory.md): [Hl7VSreferralCategory](ValueSet-hl7VSreferralCategory.md)
* [Referral Disposition (2.8 - 1.0.0)](CodeSystem-referralDisposition.md): [Hl7VSreferralDisposition](ValueSet-hl7VSreferralDisposition.md)
* [Referral Priority (2.8 - 1.0.0)](CodeSystem-referralPriority.md): [Hl7VSreferralPriority](ValueSet-hl7VSreferralPriority.md)
* [Referral Reason (2.8 - 1.0.0)](CodeSystem-referralReason.md): [Hl7VSreferralReason](ValueSet-hl7VSreferralReason.md)
* [Referral Status (2.8 - 1.0.0)](CodeSystem-referralStatus.md): [Hl7VSreferralStatus](ValueSet-hl7VSreferralStatus.md)
* [Referral Type (2.8 - 1.0.0)](CodeSystem-referralType.md): [Hl7VSreferralType](ValueSet-hl7VSreferralType.md)
* [Reimbursement Action Code (2.8 - 1.0.0)](CodeSystem-reimbursementAction.md): [Hl7VSreimbursementActionCode](ValueSet-hl7VSreimbursementActionCode.md)
* [Reimbursement Type Code (2.8 - 1.0.0)](CodeSystem-reimbursementType.md): [Hl7VSreimbursementTypeCode](ValueSet-hl7VSreimbursementTypeCode.md)
* [Relatedness Assessment (2.8 - 1.0.0)](CodeSystem-relatednessAssessment.md): [Hl7VSrelatednessAssessment](ValueSet-hl7VSrelatednessAssessment.md)
* [Relational Conjunction (2.8 - 1.0.0)](CodeSystem-relationalConjunction.md): [Hl7VSrelationalConjunction](ValueSet-hl7VSrelationalConjunction.md)
* [Relational Operator (2.8 - 1.0.0)](CodeSystem-relationalOperator.md): [Hl7VSrelationalOperator](ValueSet-hl7VSrelationalOperator.md)
* [Relationship (2.8 - 1.0.0)](CodeSystem-relationship.md): [Hl7VSrelationship](ValueSet-hl7VSrelationship.md)
* [Relationship Modifier (2.8 - 1.0.0)](CodeSystem-relationshipModifier.md): [Hl7VSrelationshipModifier](ValueSet-hl7VSrelationshipModifier.md)
* [Relevant Clinicial Information (2.8 - 1.0.0)](CodeSystem-relevantClincialInformation.md): [Hl7VSrelevantClincialInformation](ValueSet-hl7VSrelevantClincialInformation.md)
* [Religion (2.8 - 2.1.0)](CodeSystem-religion2.md): [Hl7VSreligion2](ValueSet-hl7VSreligion2.md)
* [Remote Control Command (2.8 - 1.1.0)](CodeSystem-remoteControlCommand.md): [Hl7VSremoteControlCommand](ValueSet-hl7VSremoteControlCommand.md)
* [Reorder Theory Codes (2.8 - 1.0.0)](CodeSystem-reorderTheory.md): [Hl7VSreorderTheoryCodes](ValueSet-hl7VSreorderTheoryCodes.md)
* [Repeat Pattern (2.8 - 1.1.0)](CodeSystem-repeatPattern.md): [Hl7VSrepeatPattern](ValueSet-hl7VSrepeatPattern.md)
* [Report Source (2.8 - 1.0.0)](CodeSystem-reportSource.md): [Hl7VSreportSource](ValueSet-hl7VSreportSource.md)
* [Report Timing (2.8 - 1.0.0)](CodeSystem-reportTiming.md): [Hl7VSreportTiming](ValueSet-hl7VSreportTiming.md)
* [Reporting Priority (2.8 - 1.0.0)](CodeSystem-reportingPriority.md): [Hl7VSreportingPriority](ValueSet-hl7VSreportingPriority.md)
* [Response Flag (2.8 - 1.0.0)](CodeSystem-responseFlag.md): [Hl7VSresponseFlag](ValueSet-hl7VSresponseFlag.md)
* [Response Level (2.8 - 1.0.0)](CodeSystem-responseLevel.md): [Hl7VSresponseLevel](ValueSet-hl7VSresponseLevel.md)
* [Response Modality (2.8 - 1.0.0)](CodeSystem-responseModality.md): [Hl7VSresponseModality](ValueSet-hl7VSresponseModality.md)
* [Result Status (2.8 - 1.2.0)](CodeSystem-resultStatus.md): [Hl7VSresultStatus-Obr](ValueSet-hl7VSresultStatus-Obr.md)
* [Risk Management Incident Code (2.8 - 1.0.0)](CodeSystem-riskManagementIncident.md): [Hl7VSriskManagementIncidentCode](ValueSet-hl7VSriskManagementIncidentCode.md)
* [Risk Codes (2.8 - 1.0.0)](CodeSystem-risks.md): [Hl7VSriskCodes](ValueSet-hl7VSriskCodes.md)
* [Role Executing Physician (2.8 - 1.0.0)](CodeSystem-roleExecutingPhysician.md): [Hl7VSroleExecutingPhysician](ValueSet-hl7VSroleExecutingPhysician.md)
* [Room Type (2.8 - 1.0.0)](CodeSystem-roomType.md): [Hl7VSroomType](ValueSet-hl7VSroomType.md)
* [Root Cause (2.8 - 1.0.0)](CodeSystem-rootCause.md): [Hl7VSrootCause](ValueSet-hl7VSrootCause.md)
* [Route of Administration (2.8 - 3.0.3)](CodeSystem-routeOfAdministration.md): [Hl7VSrouteOfAdministration](ValueSet-hl7VSrouteOfAdministration.md)
* [RX Component Type (2.8 - 1.0.0)](CodeSystem-rxComponentType.md): [Hl7VSrxComponentType](ValueSet-hl7VSrxComponentType.md)
* [Security Check Scheme (2.8 - 1.0.0)](CodeSystem-securityCheckScheme.md): [Hl7VSsecurityCheckScheme](ValueSet-hl7VSsecurityCheckScheme.md)
* [Segment Action Code (2.8 - 1.1.0)](CodeSystem-segmentAction.md): [Hl7VSsegmentActionCode](ValueSet-hl7VSsegmentActionCode.md)
* [Segment Group (2.8 - 7.0.0)](CodeSystem-segmentGroup.md): [Hl7VSsegmentGroup](ValueSet-hl7VSsegmentGroup.md)
* [Sensitivity to Causative Agent Code (2.8 - 1.1.0)](CodeSystem-sensitivityToCausativeAgent.md): [Hl7VSsensitivityToCausativeAgentCode](ValueSet-hl7VSsensitivityToCausativeAgentCode.md)
* [Sequence Condition Code (2.8 - 1.0.0)](CodeSystem-sequenceCondition.md): [Hl7VSsequenceConditionCode](ValueSet-hl7VSsequenceConditionCode.md)
* [Sequence/Results Flag (2.8 - 1.0.0)](CodeSystem-sequenceResultsFlag.md): [Hl7VSsequenceResultsFlag](ValueSet-hl7VSsequenceResultsFlag.md)
* [Sequencing (2.8 - 1.0.0)](CodeSystem-sequencing.md): [Hl7VSsequencing](ValueSet-hl7VSsequencing.md)
* [Service Request Relationship (2.8 - 1.0.0)](CodeSystem-serviceRequestRelationship.md): [Hl7VSserviceRequestRelationship](ValueSet-hl7VSserviceRequestRelationship.md)
* [Severity of Illness Code (2.8 - 1.0.0)](CodeSystem-severityOfIllness.md): [Hl7VSseverityOfIllnessCode](ValueSet-hl7VSseverityOfIllnessCode.md)
* [Shipment Status (2.8 - 1.0.0)](CodeSystem-shipmentStatus.md): [Hl7VSshipmentStatus](ValueSet-hl7VSshipmentStatus.md)
* [Side of body (2.8 - 1.0.0)](CodeSystem-sideOfBody.md): [Hl7VSsideOfBody](ValueSet-hl7VSsideOfBody.md)
* [Signatory's Relationship to Subject (2.8 - 1.0.0)](CodeSystem-signatorysRelationshipToSubject.md): [Hl7VSsignatory_sRelationshipToSubject](ValueSet-hl7VSsignatory_sRelationshipToSubject.md)
* [Signature Code (2.8 - 1.0.0)](CodeSystem-signatureType.md): [Hl7VSsignatureCode](ValueSet-hl7VSsignatureCode.md)
* [Source of Comment (2.8 - 1.1.0)](CodeSystem-sourceOfComment.md): [Hl7VSsourceOfComment](ValueSet-hl7VSsourceOfComment.md)
* [Source Type (2.8 - 1.0.0)](CodeSystem-sourceType.md): [Hl7VSnetworkSourceType](ValueSet-hl7VSnetworkSourceType.md)
* [Special Handling Code (2.8 - 1.1.0)](CodeSystem-specialHandling.md): [Hl7VSspecialHandlingConsiderations](ValueSet-hl7VSspecialHandlingConsiderations.md)
* [Specialty Type (2.8 - 1.0.0)](CodeSystem-specialtyType.md): [Hl7VSspecialtyType](ValueSet-hl7VSspecialtyType.md)
* [Specimen Appropriateness (2.8 - 2.0.0)](CodeSystem-specimenAppropriateness.md): [Hl7VSspecimenAppropriateness](ValueSet-hl7VSspecimenAppropriateness.md)
* [Specimen Child Role (2.8 - 1.0.0)](CodeSystem-specimenChildRole.md): [Hl7VSspecimenChildRole](ValueSet-hl7VSspecimenChildRole.md)
* [Specimen Collection Method (2.8 - 1.0.0)](CodeSystem-specimenCollectionMethod.md): [Hl7VSspecimenCollectionMethod](ValueSet-hl7VSspecimenCollectionMethod.md)
* [Specimen Component (2.8 - 1.0.0)](CodeSystem-specimenComponent.md): [Hl7VSspecimenComponent](ValueSet-hl7VSspecimenComponent.md)
* [Specimen Condition (2.8 - 1.1.0)](CodeSystem-specimenCondition.md): [Hl7VSspecimenCondition](ValueSet-hl7VSspecimenCondition.md)
* [Specimen Quality (2.8 - 1.0.0)](CodeSystem-specimenQuality.md): [Hl7VSspecimenQuality](ValueSet-hl7VSspecimenQuality.md)
* [Specimen Reject Reason (2.8 - 1.0.0)](CodeSystem-specimenRejectReason.md): [Hl7VSspecimenRejectReason](ValueSet-hl7VSspecimenRejectReason.md)
* [Specimen Role (2.8 - 1.1.0)](CodeSystem-specimenRole.md): [Hl7VSspecimenRole](ValueSet-hl7VSspecimenRole.md)
* [Specimen Type (2.8 - 1.1.0)](CodeSystem-specimenType.md): [Hl7VSspecimenType](ValueSet-hl7VSspecimenType.md)
* [Status of Evaluation (2.8 - 1.0.0)](CodeSystem-statusOfEvaluation.md): [Hl7VSstartOfEvaluation](ValueSet-hl7VSstartOfEvaluation.md)
* [Sterilization Type (2.8 - 1.0.0)](CodeSystem-sterilizationType.md): [Hl7VSsterilizationType](ValueSet-hl7VSsterilizationType.md)
* [Student Status (2.8 - 1.0.0)](CodeSystem-studentStatus.md): [Hl7VSstudentStatus](ValueSet-hl7VSstudentStatus.md)
* [Substance Status (2.8 - 1.0.0)](CodeSystem-substanceStatus.md): [Hl7VSsubstanceStatus](ValueSet-hl7VSsubstanceStatus.md)
* [Substance Type (2.8 - 1.0.1)](CodeSystem-substanceType.md): [Hl7VSsubstanceType](ValueSet-hl7VSsubstanceType.md)
* [Substitution Status (2.8 - 1.1.0)](CodeSystem-substitutionStatus.md): [Hl7VSsubstitutionStatus](ValueSet-hl7VSsubstitutionStatus.md)
* [Subtype of Referenced Data (2.8 - 1.2.1)](CodeSystem-subtypeOfReferencedData.md): [Hl7VSsubtypeOfReferencedData](ValueSet-hl7VSsubtypeOfReferencedData.md)
* [Supply Risk Codes (2.8 - 1.0.0)](CodeSystem-supplyRisk.md): [Hl7VSsupplyRiskCodes](ValueSet-hl7VSsupplyRiskCodes.md)
* [Tax status (2.8 - 1.0.0)](CodeSystem-taxStatus.md): [Hl7VStaxStatus](ValueSet-hl7VStaxStatus.md)
* [Telecommunication Equipment Type (2.8 - 1.2.0)](CodeSystem-telecommunicationEquipmentType.md): [Hl7VStelecommunicationEquipmentType](ValueSet-hl7VStelecommunicationEquipmentType.md)
* [Telecommunication Expiration Reason (2.8 - 1.0.0)](CodeSystem-telecommunicationExpirationReason.md): [Hl7VStelecommunicationExpirationReason](ValueSet-hl7VStelecommunicationExpirationReason.md)
* [Telecommunication Use Code (2.8 - 1.2.0)](CodeSystem-telecommunicationUse.md): [Hl7VStelecommunicationUseCode](ValueSet-hl7VStelecommunicationUseCode.md)
* [Time Delay Post Challenge (2.8 - 1.0.0)](CodeSystem-timeDelayPostChallenge.md): [Hl7VStimeDelayPostChallenge](ValueSet-hl7VStimeDelayPostChallenge.md)
* [Time Selection Criteria Parameter Class Codes (2.8 - 1.1.0)](CodeSystem-timeSelectionCriteriaParameterClass.md): [Hl7VStimeSelectionCriteriaParameterClassCodes](ValueSet-hl7VStimeSelectionCriteriaParameterClassCodes.md)
* [Tissue Type Code (2.8 - 1.0.0)](CodeSystem-tissueType.md): [Hl7VStissueTypeCode](ValueSet-hl7VStissueTypeCode.md)
* [TQ Conjunction ID (2.8 - 1.1.0)](CodeSystem-tqConjunctionId.md): [Hl7VStqConjunctionId](ValueSet-hl7VStqConjunctionId.md)
* [Transaction Type (2.8 - 1.1.0)](CodeSystem-transactionType.md): [Hl7VStransactionType](ValueSet-hl7VStransactionType.md)
* [Transfusion Adverse Reaction (2.8 - 1.0.0)](CodeSystem-transfusionAdverseReaction.md): [Hl7VStransfusionAdverseReaction](ValueSet-hl7VStransfusionAdverseReaction.md)
* [Transport Arranged (2.8 - 1.0.0)](CodeSystem-transportArranged.md): [Hl7VStransportArranged](ValueSet-hl7VStransportArranged.md)
* [Transportation Mode (2.8 - 1.0.0)](CodeSystem-transportationMode.md): [Hl7VStransportationMode](ValueSet-hl7VStransportationMode.md)
* [Tray Type (2.8 - 1.0.0)](CodeSystem-trayType.md): [Hl7VStrayType](ValueSet-hl7VStrayType.md)
* [Treatment (2.8 - 1.0.0)](CodeSystem-treatment.md): [Hl7VStreatment](ValueSet-hl7VStreatment.md)
* [Triage Code (2.8 - 1.0.0)](CodeSystem-triageType.md): [Hl7VStriageCode](ValueSet-hl7VStriageCode.md)
* [Type of Referenced Data (2.8 - 1.3.0)](CodeSystem-typeOfReferencedData.md): [Hl7VStypeOfData](ValueSet-hl7VStypeOfData.md)
* [Universal ID Type (2.8 - 1.2.0)](CodeSystem-universalIdType.md): [Hl7VSuniversalIdType](ValueSet-hl7VSuniversalIdType.md)
* [User Authentication Credential Type Code (2.8 - 1.0.0)](CodeSystem-userAuthenticationCredentialType.md): [Hl7VSuserAuthenticationCredentialTypeCode](ValueSet-hl7VSuserAuthenticationCredentialTypeCode.md)
* [Version ID (2.8 - 1.10.0)](CodeSystem-versionId.md): [Hl7VSversionControlTable](ValueSet-hl7VSversionControlTable.md)
* [Visit Indicator (2.8 - 1.0.0)](CodeSystem-visitIndicator.md): [Hl7VSvisitIndicator](ValueSet-hl7VSvisitIndicator.md)
* [Visit Priority Code (2.8 - 1.0.0)](CodeSystem-visitPriority.md): [Hl7VSvisitPriorityCode](ValueSet-hl7VSvisitPriorityCode.md)
* [Visit User Code (2.8 - 1.0.0)](CodeSystem-visitUserCodes.md): [Hl7VSvisitUserCode](ValueSet-hl7VSvisitUserCode.md)


