# Telecommunication Expiration Reason (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Telecommunication Expiration Reason (2.8 - 1.0.0)**

## CodeSystem: Telecommunication Expiration Reason (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/telecommunicationExpirationReason | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:TelecommunicationExpirationReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.409 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the reason this contact number/email was marked as "ended". Used in HL7 Version 2.x messaging in the XTN segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStelecommunicationExpirationReason](ValueSet-hl7VStelecommunicationExpirationReason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "telecommunicationExpirationReason",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0868"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/telecommunicationExpirationReason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.409"
    }
  ],
  "version" : "1.0.0",
  "name" : "TelecommunicationExpirationReason",
  "title" : "Telecommunication Expiration Reason (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the reason this contact number/email was marked as \"ended\".  Used in HL7 Version 2.x messaging in the XTN segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "Corrected",
      "definition" : "Corrected",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The telecommunication address has been replaced with a corrected version."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Added in error",
      "definition" : "Added in error",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The telecommunication address was incorrect and should never have been associated with the individual."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Moved",
      "definition" : "Moved",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The individual associated with the telecommunication address has moved and is no longer reachable at the address."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "No longer in service",
      "definition" : "No longer in service",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The telecommunication address is no longer connected or available"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "On request",
      "definition" : "On request",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The associated individual requested that the telecommunication address be removed from their record (though it may still be correct)."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
