# Process Interruption Reason (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Process Interruption Reason (2.8 - 1.0.0)**

## CodeSystem: Process Interruption Reason (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/processInterruptionReason | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ProcessInterruptionReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.435 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the reason for the process interruption. Used in HL7 Version 2.x messaging in the DON segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSprocessInterruptionReason](ValueSet-hl7VSprocessInterruptionReason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "processInterruptionReason",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0935"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/processInterruptionReason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.435"
    }
  ],
  "version" : "1.0.0",
  "name" : "ProcessInterruptionReason",
  "title" : "Process Interruption Reason (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the reason for the process interruption.  Used in HL7 Version 2.x messaging in the DON segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ASC",
      "display" : "Apheresis Software Crash",
      "definition" : "Apheresis Software Crash",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "BSC",
      "display" : "Manufacturing Software Crash",
      "definition" : "Manufacturing Software Crash",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "CFT",
      "display" : "Couldn't follow through with donation (scared)",
      "definition" : "Couldn't follow through with donation (scared)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "DBB",
      "display" : "Bathroom",
      "definition" : "Bathroom",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "DCW",
      "display" : "Couldn't wait",
      "definition" : "Couldn't wait",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "DNI",
      "display" : "Phlebotomy Issue",
      "definition" : "Phlebotomy Issue",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "GFE",
      "display" : "General Facility Emergency",
      "definition" : "General Facility Emergency",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Power outage,  natural disaster (tornado, flood, hurricane, etc.), air conditioning failure, etc."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "NRG",
      "display" : "No reason given, donor decided to stop without giving a reason",
      "definition" : "No reason given, donor decided to stop without giving a reason",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "PCD",
      "display" : "Phone Call-Donor",
      "definition" : "Phone Call-Donor",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    }
  ]
}

```
