# Payee Type (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Payee Type (2.8 - 1.0.0)**

## CodeSystem: Payee Type (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/payeeType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:PayeeType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.361 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to specify the type of payee (e.g., organization, person). Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpayeeType](ValueSet-hl7VSpayeeType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "payeeType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0557"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/payeeType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.361"
    }
  ],
  "version" : "1.0.0",
  "name" : "PayeeType",
  "title" : "Payee Type (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the type of payee (e.g., organization, person).  Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "EMPL",
      "display" : "Employer",
      "definition" : "Employer",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "A legal entity that controls and directs a worker under an express or implied contract of employment and a salary or wages in compensation.<p>In worker's compensation cases, the Employer may be the \"organization\" responsible for paying the healthcare char"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "ORG",
      "display" : "Payee Organization",
      "definition" : "Payee Organization",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The payee is not a person/individual/being, but an entity commonly identified as an organization.  Examples could be a country healthcare payer, or an insurance company responsible for payment."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PERS",
      "display" : "Person",
      "definition" : "Person",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "A person/individual/being."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PPER",
      "display" : "Pay Person",
      "definition" : "Pay Person",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Person/individual/being responsible for payment."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
