# Order Control Codes (2.8 - 1.7.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Order Control Codes (2.8 - 1.7.0)**

## CodeSystem: Order Control Codes (2.8 - 1.7.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/orderControlCodes | *Version*:1.7.0 |
| Active as of 2026-01-27 | *Computable Name*:OrderControlCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.48 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which are used to determine the function of the order segment. Depending on the message, the action specified by one of these control codes may refer to an order or an individual service. Used in Version 2.x messaging of orders in the ORC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSorderControl](ValueSet-hl7VSorderControl.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "orderControlCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0119"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/orderControlCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.48"
    }
  ],
  "version" : "1.7.0",
  "name" : "OrderControlCodes",
  "title" : "Order Control Codes (2.8 - 1.7.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which are used to determine the function of the order segment.  Depending on the message, the action specified by one of these control codes may refer to an order or an individual service.  Used in Version 2.x messaging of orders in the ORC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "application",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#application",
      "description" : "application",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "AF",
      "display" : "Order/service refill request approval",
      "definition" : "Order/service refill request approval",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>AF is a response to RF where the placer authorizing a refill or quantity of refills."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CA",
      "display" : "Cancel order/service request",
      "definition" : "Cancel order/service request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag stornieren"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>A cancellation is a request by the placer for the filler, or the filler to the placer, not to do a previously ordered service. Confirmation of the cancellation request is provided by the filler or placer, e.g., a message w"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CH",
      "display" : "Child order/service",
      "definition" : "Child order/service",
      "designation" : [
        {
          "language" : "de",
          "value" : "nachgeordneter Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>Used in conjunction with the PA - Parent order control code. Refer to PA order control code for discussion."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CN",
      "display" : "Combined result",
      "definition" : "Combined result",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kumulatives Ergebnis (zu mehreren Aufträgen)"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>The combined result code provides a mechanism to transmit results that are associated with two or more orders. This situation occurs commonly in radiology reports when the radiologist dictates a single report for two or more exams r"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "Cancel process step",
      "definition" : "Cancel process step",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>The control code CP - Cancel process step should be used in the ORC-1 for communication Filler-to-Filler, e.g., LIS-to-Analyzer, to differentiate from code CA (Placer-to-Filler).<p>The Filler should response with an acceptance of th"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "CR",
      "display" : "Canceled as requested",
      "definition" : "Canceled as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag anweisungsgemäß storniert"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler or Placer Applications.<p>A response by the filler or placer application that a request to cancel (CA by the placer application) was performed successfully."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "DC",
      "display" : "Discontinue order/service request",
      "definition" : "Discontinue order/service request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsausführung abbrechen"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>A request by the placer for the filler, or the filler to the placer,  to discontinue a previously requested service. The differentiation between discontinue and cancel is that discontinue effects the order/service and all.."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "DE",
      "display" : "Data errors",
      "definition" : "Data errors",
      "designation" : [
        {
          "language" : "de",
          "value" : "Datenfehler"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "DF",
      "display" : "Order/service refill request denied",
      "definition" : "Order/service refill request denied",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>In response to a Filler application requesting refill authorization (RF), DF indicates that the placer does not authorize refills for the order. ORC-16 Order Control Code reason may be used to indicate the reason for the request den"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DR",
      "display" : "Discontinued as requested",
      "definition" : "Discontinued as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsausführung anweisungsgemäß abgebrochen"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler or Placer Applications.<p>The filler or placer, in response to a request to discontinue (DC from the placer or filler application), has discontinued the order/service."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "FU",
      "display" : "Order/service refilled, unsolicited",
      "definition" : "Order/service refilled, unsolicited",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>FU notifies the placer that the filler issued a refill for the order at the patient's request."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "HD",
      "display" : "Hold order request",
      "definition" : "Hold order request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung aussetzen"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>Typical responses include, but are not limited to, CR - Cancelled as requested, UC - Unable to Cancel."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "HR",
      "display" : "On hold as requested",
      "definition" : "On hold as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung anweisungsgemäß ausgesetzt"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "Link order/service to patient care problem or goal",
      "definition" : "Link order/service to patient care problem or goal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>Refer to Chapter 12 Patient Care for complete discussion."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MC",
      "display" : "Miscellaneous Charge - not associated with an order",
      "definition" : "Miscellaneous Charge - not associated with an order",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "applies to DFT^P03^DFT_P03 and DFT^P11^DFT_P11"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "NA",
      "display" : "Number assigned",
      "definition" : "Number assigned",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nummer zugewiesen"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>There are three circumstances that involve requesting an order number (ORC-2-placer order number or ORC-3-filler order number):<p>(1) When the filler application needs to request an ORC-3-filler order number from a centralized appli"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "NW",
      "display" : "New order/service",
      "definition" : "New order/service",
      "designation" : [
        {
          "language" : "de",
          "value" : "Neuer Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>See comments for NA - Number Assigned."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "OC",
      "display" : "Order/service canceled",
      "definition" : "Order/service canceled",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag storniert"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OD",
      "display" : "Order/service discontinued",
      "definition" : "Order/service discontinued",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsausführung abgebrochen"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "OE",
      "display" : "Order/service released",
      "definition" : "Order/service released",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OF",
      "display" : "Order/service refilled as requested",
      "definition" : "Order/service refilled as requested",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>OF directly responds to the placer system's request for a refill."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OH",
      "display" : "Order/service held",
      "definition" : "Order/service held",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung ausgesetzt"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OK",
      "display" : "Order/service accepted & OK",
      "definition" : "Order/service accepted & OK",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag akzeptiert"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>See comments for NA - Number Assigned."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "OP",
      "display" : "Notification of order for outside dispense",
      "definition" : "Notification of order for outside dispense",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>These order control codes are used to communicate an order between systems where the order is intended for informational purposes. For example, an order that will be performed by a vendor outside the enterprise of communicating syst"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "OR",
      "display" : "Released as requested",
      "definition" : "Released as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung anweisungsgemäß wiederaufgenommen"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "Parent order/service",
      "definition" : "Parent order/service",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hauptauftrag"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>The parent (PA) and child (CH) order control codes allow the spawning of \"child\" orders from a \"parent\" order without changing the parent (original order). One or more ORC segments with an ORC-1-order control value of PA are followe"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "PR",
      "display" : "Previous Results with new order/service",
      "definition" : "Previous Results with new order/service",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>PR indicates that this ORC is part of an ORU structure containing previous observation, which is embedded in the order.<p>At least two main use cases require that the complete results of the previous observations be transmitted with"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PY",
      "display" : "Notification of replacement order for outside dispense",
      "definition" : "Notification of replacement order for outside dispense",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>See comments for OP - Notification of order for outside dispense."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RE",
      "display" : "Observations/Performed Service to follow",
      "definition" : "Observations/Performed Service to follow",
      "designation" : [
        {
          "language" : "de",
          "value" : "Untersuchungsergebnisse folgen (in späteren Segmenten dieser Nachricht)"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>The observations-to-follow code is used to transmit patient-specific information with an order. An order detail segment (e.g., OBR) can be followed by one or more observation segments (OBX). Any observation that can be tra"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RF",
      "display" : "Refill order/service request",
      "definition" : "Refill order/service request",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>RF accommodates requests by either the filler or the placer. The filler may be requesting refill authorization from the placer. A placer system may be requesting a refill to be done by the filler system.<p>Typical response"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RL",
      "display" : "Release previous hold",
      "definition" : "Release previous hold",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsberabeitung wiederaufnehmen"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RO",
      "display" : "Replacement order",
      "definition" : "Replacement order",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ersatzauftrag"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>A replacement is the substitution of one or more orders for one or more previously ordered services.<p>The replaced orders are treated as though they were canceled. If and when an ordered service can be replaced are local.."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RP",
      "display" : "Order/service replace request",
      "definition" : "Order/service replace request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag ersetzen"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>A replacement is the substitution of one or more orders for one or more previously ordered services. See comment 1 on RO - Replacement Order for further discussion.<p>The order replace request code permits the order filler to replac"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RQ",
      "display" : "Replaced as requested",
      "definition" : "Replaced as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag anweisungsgemäß ersetzt"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>A replacement is the substitution of one or more orders for one or more previously ordered services. See comment 1 on RO - Replacement Order for further discussion.<p>The order replace request code permits the order filler to replac"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RR",
      "display" : "Request received",
      "definition" : "Request received",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung erhalten"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>Left in for backward compatibility. In the current version it is equivalent to an accept acknowledgment. The request-received code indicates that an order message has been received and will be processed later. The order ha"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RU",
      "display" : "Replaced unsolicited",
      "definition" : "Replaced unsolicited",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag ersetzt (ohne Anweisung)"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>A replacement is the substitution of one or more orders for one or more previously ordered services. See comment 1 on RO - Replacement Order for further discussion.<p>The unsolicited replacement code permits the filler application t"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "SC",
      "display" : "Status changed",
      "definition" : "Status changed",
      "designation" : [
        {
          "language" : "de",
          "value" : "Statusänderung"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SN",
      "display" : "Send order/service number",
      "definition" : "Send order/service number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrags- bzw. Bearbeitungsnummer zuweisen / übermitteln"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications.<p>See comments for NA - Number Assigned."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "SR",
      "display" : "Response to send order/service status request",
      "definition" : "Response to send order/service status request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsstatus (Antwort)"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SS",
      "display" : "Send order/service status request",
      "definition" : "Send order/service status request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsstatus senden"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "UA",
      "display" : "Unable to accept order/service",
      "definition" : "Unable to accept order/service",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsannahme nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>An unable-to-accept code is used when a new order cannot be accepted by the filler. Possible reasons include requesting a prescription for a drug which the patient is allergic to or for an order which requires certain equipment reso"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UC",
      "display" : "Unable to cancel",
      "definition" : "Unable to cancel",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsstornierung nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler or Placer Applications.<p>An unable-to-cancel code is used when the ordered service is at a point that it cannot be canceled by the placer or filler or when local rules prevent cancellation by the filler. The use of this code is dependent on the va"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "UD",
      "display" : "Unable to discontinue",
      "definition" : "Unable to discontinue",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abbrechen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler or Placer Applications.<p>An unable-to-discontinue code is used when the ordered service is at a point that it cannot be discontinued by the placer or filler or when local rules prevent discontinuance by the filler. The use of this code is dependen"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "UF",
      "display" : "Unable to refill",
      "definition" : "Unable to refill",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications.<p>Negative response to RF Refill order/service request, indicating that the receiving application was not able to complete the refill request."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UH",
      "display" : "Unable to put on hold",
      "definition" : "Unable to put on hold",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aussetzen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "UM",
      "display" : "Unable to replace",
      "definition" : "Unable to replace",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ersetzen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "UN",
      "display" : "Unlink order/service from patient care problem or goal",
      "definition" : "Unlink order/service from patient care problem or goal",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer or Filler Applications.<p>Refer to Chapter 12 Patient Care for complete discussion."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "UR",
      "display" : "Unable to release",
      "definition" : "Unable to release",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wiederaufnahme nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "UX",
      "display" : "Unable to change",
      "definition" : "Unable to change",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "XO",
      "display" : "Change order/service request",
      "definition" : "Change order/service request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag ändern"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "XR",
      "display" : "Changed as requested",
      "definition" : "Changed as requested",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag anweisungsgemäß geändert"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "XX",
      "display" : "Order/service changed, unsol.",
      "definition" : "Order/service changed, unsol.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag geändert (ohne Anweisung)"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
