# Present On Admission (POA) Indicator (2.8 - 1.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Present On Admission (POA) Indicator (2.8 - 1.0.0)**

## CodeSystem: Present On Admission (POA) Indicator (2.8 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/nubc-PresentOnAdmission-cs | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Nubc-PresentOnAdmission-cs |
| *Other Identifiers:*OID:2.16.840.1.113883.6.301.11 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 67, Present on Admission (POA) Indicator. Code identifying a diagnosis that was present at the time the order for inpatient admission occurs. POA indicator is assigned to all diagnoses as defined in Appendix I of the "ICD-9-CM Official Guidelines for Coding and Reporting" or "ICD-10-CM Official Guidelines for Coding and Reporting (appropriate to the ICD revision used). 
The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the DG1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpresentOnAdmission_poa_Indicator](ValueSet-hl7VSpresentOnAdmission_poa_Indicator.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nubc-PresentOnAdmission-cs",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0895"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/nubc-PresentOnAdmission-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.6.301.11"
    }
  ],
  "version" : "1.0.0",
  "name" : "Nubc-PresentOnAdmission-cs",
  "title" : "Present On Admission (POA) Indicator (2.8 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 67, Present on Admission (POA) Indicator. Code identifying a diagnosis that  was present at the time the order for inpatient admission occurs. POA indicator is assigned to all diagnoses as defined in Appendix I of the \"ICD-9-CM Official Guidelines for Coding and Reporting\" or \"ICD-10-CM Official Guidelines for Coding and Reporting (appropriate to the ICD revision used).\r\n \r\nThe UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the DG1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "E",
      "display" : "Exempt",
      "definition" : "Exempt",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "No",
      "definition" : "No",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "W",
      "display" : "Not applicable",
      "definition" : "Not applicable",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "Y",
      "display" : "Yes",
      "definition" : "Yes",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ja"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    }
  ]
}

```
