# Military Rank/Grade (2.8 - 2.0.0) - HL7 v2.8 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Military Rank/Grade (2.8 - 2.0.0)**

## CodeSystem: Military Rank/Grade (2.8 - 2.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/militaryRank-Grade | *Version*:2.0.0 |
| Active as of 2026-01-27 | *Computable Name*:MilitaryRank-Grade |
| *Other Identifiers:*OID:2.16.840.1.113883.18.63 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify the military rank/grade of the patient. Used in HL7 Version 2.x messaging in the PD1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmilitaryRank-Grade](ValueSet-hl7VSmilitaryRank-Grade.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "militaryRank-Grade",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.8"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0141"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/militaryRank-Grade",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.63"
    }
  ],
  "version" : "2.0.0",
  "name" : "MilitaryRank-Grade",
  "title" : "Military Rank/Grade (2.8 - 2.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:37:03+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts which specify the military rank/grade of the patient.  Used in HL7 Version 2.x messaging in the PD1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "E1",
      "display" : "Enlisted 1",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "E2",
      "display" : "Enlisted 2",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "E3",
      "display" : "Enlisted 3",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "E4",
      "display" : "Enlisted 4",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "E5",
      "display" : "Enlisted 5",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "E6",
      "display" : "Enlisted 6",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "E7",
      "display" : "Enlisted 7",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "E8",
      "display" : "Enlisted 8",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "E9",
      "display" : "Enlisted 9",
      "definition" : "Enlisted",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O1",
      "display" : "Officers 1",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O2",
      "display" : "Officers 2",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O3",
      "display" : "Officers 3",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O4",
      "display" : "Officers 4",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O5",
      "display" : "Officers 5",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O6",
      "display" : "Officers 6",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O7",
      "display" : "Officers 7",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O8",
      "display" : "Officers 8",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O9",
      "display" : "Officers 9",
      "definition" : "Officers",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "W1",
      "display" : "Warrant Officers 1",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "W2",
      "display" : "Warrant Officers 2",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "W3",
      "display" : "Warrant Officers 3",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "W4",
      "display" : "Warrant Officers 4",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-01-04"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
